/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OrtProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.onnxruntime.presets.onnxruntime;

final class OnnxRuntime {
    private static final Logger logger = Logger.getLogger(OnnxRuntime.class.getName());
    private static final int ORT_API_VERSION_1 = 1;
    private static final int ORT_API_VERSION_2 = 2;
    private static final int ORT_API_VERSION_3 = 3;
    private static final int ORT_API_VERSION_7 = 7;
    static final String ONNXRUNTIME_LIBRARY_NAME = "onnxruntime";
    static final String ONNXRUNTIME_JNI_LIBRARY_NAME = "onnxruntime4j_jni";
    static final String ONNXRUNTIME_LIBRARY_SHARED_NAME = "onnxruntime_providers_shared";
    static final String ONNXRUNTIME_LIBRARY_CUDA_NAME = "onnxruntime_providers_cuda";
    private static final String OS_ARCH_STR = OnnxRuntime.initOsArch();
    private static boolean loaded = false;
    static long ortApiHandle;
    static EnumSet<OrtProvider> providers;

    private OnnxRuntime() {
    }

    private static String initOsArch() {
        String detectedOS = null;
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin")) {
            detectedOS = "osx";
        } else if (os.contains("win")) {
            detectedOS = "win";
        } else if (os.contains("nux")) {
            detectedOS = "linux";
        } else if (OnnxRuntime.isAndroid()) {
            detectedOS = "android";
        } else {
            throw new IllegalStateException("Unsupported os:" + os);
        }
        String detectedArch = null;
        String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
            detectedArch = "x64";
        } else if (arch.startsWith("x86")) {
            detectedArch = "x86";
        } else if (arch.startsWith("aarch64")) {
            detectedArch = "aarch64";
        } else if (arch.startsWith("ppc64")) {
            detectedArch = "ppc64";
        } else if (OnnxRuntime.isAndroid()) {
            detectedArch = arch;
        } else {
            throw new IllegalStateException("Unsupported arch:" + arch);
        }
        return detectedOS + '-' + detectedArch;
    }

    static synchronized void init() throws IOException {
        loaded = Loader.load(onnxruntime.class) != null;
        ortApiHandle = OnnxRuntime.initialiseAPIBase(1);
        if (loaded) {
            return;
        }
        Path tempDirectory = OnnxRuntime.isAndroid() ? null : Files.createTempDirectory("onnxruntime-java", new FileAttribute[0]);
        try {
            OnnxRuntime.load(tempDirectory, ONNXRUNTIME_LIBRARY_SHARED_NAME, false);
            OnnxRuntime.load(tempDirectory, ONNXRUNTIME_LIBRARY_CUDA_NAME, false);
            OnnxRuntime.load(tempDirectory, ONNXRUNTIME_LIBRARY_NAME, true);
            OnnxRuntime.load(tempDirectory, ONNXRUNTIME_JNI_LIBRARY_NAME, true);
            ortApiHandle = OnnxRuntime.initialiseAPIBase(7);
            providers = OnnxRuntime.initialiseProviders(ortApiHandle);
            loaded = true;
        }
        finally {
            if (tempDirectory != null) {
                OnnxRuntime.cleanUp(tempDirectory.toFile(), false);
            }
        }
    }

    private static void cleanUp(File file, boolean onExitOnly) {
        if (!file.exists()) {
            return;
        }
        logger.log(Level.FINE, "Deleting " + file);
        if (onExitOnly || !file.delete()) {
            logger.log(Level.FINE, "Deleting " + file + " on exit");
            file.deleteOnExit();
        }
    }

    static boolean isAndroid() {
        return System.getProperty("java.vendor", "generic").equals("The Android Project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void load(Path tempDirectory, String library, boolean systemLoad) throws IOException {
        if (OnnxRuntime.isAndroid()) {
            System.loadLibrary("onnxruntime4j_jni");
            return;
        }
        skip = System.getProperty("onnxruntime.native." + library + ".skip");
        if (Boolean.TRUE.toString().equalsIgnoreCase(skip)) {
            OnnxRuntime.logger.log(Level.FINE, "Skipping load of native library '" + library + "'");
            return;
        }
        libraryPathProperty = System.getProperty("onnxruntime.native." + library + ".path");
        if (libraryPathProperty != null) {
            OnnxRuntime.logger.log(Level.FINE, "Attempting to load native library '" + library + "' from specified path: " + libraryPathProperty);
            libraryFile = new File(libraryPathProperty);
            libraryFilePath = libraryFile.getAbsolutePath();
            if (!libraryFile.exists()) {
                throw new IOException("Native library '" + library + "' not found at " + libraryFilePath);
            }
            System.load(libraryFilePath);
            OnnxRuntime.logger.log(Level.FINE, "Loaded native library '" + library + "' from specified path");
            return;
        }
        libraryFileName = System.mapLibraryName(library).replace("jnilib", "dylib");
        resourcePath = "/ai/onnxruntime/native/" + OnnxRuntime.OS_ARCH_STR + '/' + libraryFileName;
        tempFile = tempDirectory.resolve(libraryFileName).toFile();
        try {
            block37: {
                block38: {
                    block39: {
                        is = OnnxRuntime.class.getResourceAsStream(resourcePath);
                        var9_11 = null;
                        if (is != null) ** GOTO lbl47
                        if (systemLoad) break block37;
                        if (is == null) break block38;
                        if (var9_11 == null) break block39;
                        try {
                            is.close();
                        }
                        catch (Throwable var10_12) {
                            var9_11.addSuppressed(var10_12);
                        }
                        break block38;
                    }
                    is.close();
                }
                OnnxRuntime.cleanUp(tempFile, systemLoad == false);
                return;
            }
            try {
                OnnxRuntime.logger.log(Level.FINE, "Attempting to load native library '" + library + "' from library path");
                System.loadLibrary(library);
                OnnxRuntime.logger.log(Level.FINE, "Loaded native library '" + library + "' from library path");
                break block40;
lbl47:
                // 1 sources

                OnnxRuntime.logger.log(Level.FINE, "Attempting to load native library '" + library + "' from resource path " + resourcePath + " copying to " + tempFile);
                buffer = new byte[1024];
                os = new FileOutputStream(tempFile);
                var13_17 = null;
                try {
                    while ((readBytes = is.read(buffer)) != -1) {
                        os.write(buffer, 0, readBytes);
                    }
                }
                catch (Throwable var14_20) {
                    var13_17 = var14_20;
                    throw var14_20;
                }
                finally {
                    if (os != null) {
                        if (var13_17 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable var14_19) {
                                var13_17.addSuppressed(var14_19);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
                if (systemLoad) {
                    System.load(tempFile.getAbsolutePath());
                    OnnxRuntime.logger.log(Level.FINE, "Loaded native library '" + library + "' from resource path");
                    break block40;
                } else {
                    OnnxRuntime.logger.log(Level.FINE, "Extracted native library '" + library + "' from resource path");
                }
                break block40;
            }
            catch (Throwable var10_15) {
                var9_11 = var10_15;
                throw var10_15;
            }
            catch (Throwable var17_23) {
                throw var17_23;
            }
        }
        catch (Throwable var19_25) {
            OnnxRuntime.cleanUp(tempFile, systemLoad == false);
            throw var19_25;
        }
        {
            block40: {
                finally {
                    if (is != null) {
                        if (var9_11 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable var10_14) {
                                var9_11.addSuppressed(var10_14);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            OnnxRuntime.cleanUp(tempFile, systemLoad == false);
        }
    }

    private static EnumSet<OrtProvider> initialiseProviders(long ortApiHandle) {
        String[] providersArray = OnnxRuntime.getAvailableProviders(ortApiHandle);
        EnumSet<OrtProvider> providers = EnumSet.noneOf(OrtProvider.class);
        for (String provider : providersArray) {
            providers.add(OrtProvider.mapFromName(provider));
        }
        return providers;
    }

    private static native long initialiseAPIBase(int var0);

    private static native String[] getAvailableProviders(long var0);
}

