// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.numpy.global;

import org.bytedeco.numpy.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.cpython.*;
import static org.bytedeco.cpython.global.python.*;

public class numpy extends org.bytedeco.numpy.presets.numpy {
    static { Loader.load(); }

// Parsed from _numpyconfig.h

public static final int NPY_HAVE_ENDIAN_H = 1;
public static native @MemberGetter int NPY_SIZEOF_SHORT();
public static final int NPY_SIZEOF_SHORT = NPY_SIZEOF_SHORT();
public static native @MemberGetter int NPY_SIZEOF_INT();
public static final int NPY_SIZEOF_INT = NPY_SIZEOF_INT();
public static native @MemberGetter int NPY_SIZEOF_LONG();
public static final int NPY_SIZEOF_LONG = NPY_SIZEOF_LONG();
public static final int NPY_SIZEOF_FLOAT = 4;
public static final int NPY_SIZEOF_COMPLEX_FLOAT = 8;
public static final int NPY_SIZEOF_DOUBLE = 8;
public static final int NPY_SIZEOF_COMPLEX_DOUBLE = 16;
public static final int NPY_SIZEOF_LONGDOUBLE = 12;
public static final int NPY_SIZEOF_COMPLEX_LONGDOUBLE = 24;
public static final int NPY_SIZEOF_PY_INTPTR_T = 4;
public static final int NPY_SIZEOF_OFF_T = 8;
public static final int NPY_SIZEOF_PY_LONG_LONG = 8;
public static final int NPY_SIZEOF_LONGLONG = 8;
public static final int NPY_NO_SMP = 0;
// #define NPY_HAVE_DECL_ISNAN
// #define NPY_HAVE_DECL_ISINF
// #define NPY_HAVE_DECL_ISFINITE
// #define NPY_HAVE_DECL_SIGNBIT
public static final int NPY_USE_C99_COMPLEX = 1;
public static final int NPY_HAVE_COMPLEX_DOUBLE = 1;
public static final int NPY_HAVE_COMPLEX_FLOAT = 1;
public static final int NPY_HAVE_COMPLEX_LONG_DOUBLE = 1;
public static final int NPY_RELAXED_STRIDES_CHECKING = 1;
public static final int NPY_USE_C99_FORMATS = 1;
// #define NPY_VISIBILITY_HIDDEN __attribute__((visibility("hidden")))
public static final int NPY_ABI_VERSION = 0x01000009;
public static final int NPY_API_VERSION = 0x0000000E;

// #ifndef __STDC_FORMAT_MACROS
public static final int __STDC_FORMAT_MACROS = 1;
// #endif


// Parsed from numpyconfig.h

// #ifndef _NPY_NUMPYCONFIG_H_
// #define _NPY_NUMPYCONFIG_H_

// #include "_numpyconfig.h"

/*
 * On Mac OS X, because there is only one configuration stage for all the archs
 * in universal builds, any macro which depends on the arch needs to be
 * hardcoded
 */
// #ifdef __APPLE__
//     #undef NPY_SIZEOF_LONG
//     #undef NPY_SIZEOF_PY_INTPTR_T

//     #ifdef __LP64__
//     #else
//     #endif
// #endif

/**
 * To help with the NPY_NO_DEPRECATED_API macro, we include API version
 * numbers for specific versions of NumPy. To exclude all API that was
 * deprecated as of 1.7, add the following before #including any NumPy
 * headers:
 *   #define NPY_NO_DEPRECATED_API  NPY_1_7_API_VERSION
 */
public static final int NPY_1_7_API_VERSION = 0x00000007;
public static final int NPY_1_8_API_VERSION = 0x00000008;
public static final int NPY_1_9_API_VERSION = 0x00000008;
public static final int NPY_1_10_API_VERSION = 0x00000008;
public static final int NPY_1_11_API_VERSION = 0x00000008;
public static final int NPY_1_12_API_VERSION = 0x00000008;
public static final int NPY_1_13_API_VERSION = 0x00000008;
public static final int NPY_1_14_API_VERSION = 0x00000008;
public static final int NPY_1_15_API_VERSION = 0x00000008;
public static final int NPY_1_16_API_VERSION = 0x00000008;
public static final int NPY_1_17_API_VERSION = 0x00000008;
public static final int NPY_1_18_API_VERSION = 0x00000008;
public static final int NPY_1_19_API_VERSION = 0x00000008;
public static final int NPY_1_20_API_VERSION = 0x0000000e;

// #endif


// Parsed from npy_common.h

// #ifndef _NPY_COMMON_H_
// #define _NPY_COMMON_H_

/* need Python.h for npy_intp, npy_uintp */
// #include <Python.h>

/* numpconfig.h is auto-generated */
// #include "numpyconfig.h"
// #ifdef HAVE_NPY_CONFIG_H
// #include <npy_config.h>
// #endif

/*
 * using static inline modifiers when defining npy_math functions
 * allows the compiler to make optimizations when possible
 */
// #if defined(NPY_INTERNAL_BUILD) && NPY_INTERNAL_BUILD
// #endif

/*
 * gcc does not unroll even with -O3
 * use with care, unrolling on modern cpus rarely speeds things up
 */
// #ifdef HAVE_ATTRIBUTE_OPTIMIZE_UNROLL_LOOPS
// #define NPY_GCC_UNROLL_LOOPS
//     __attribute__((optimize("unroll-loops")))
// #else
// #define NPY_GCC_UNROLL_LOOPS
// #endif

/* highest gcc optimization level, enabled autovectorizer */
// #ifdef HAVE_ATTRIBUTE_OPTIMIZE_OPT_3
// #define NPY_GCC_OPT_3 __attribute__((optimize("O3")))
// #else
// #define NPY_GCC_OPT_3
// #endif

/* compile target attributes */
// #if defined HAVE_ATTRIBUTE_TARGET_AVX && defined HAVE_LINK_AVX
// #define NPY_GCC_TARGET_AVX __attribute__((target("avx")))
// #else
// #define NPY_GCC_TARGET_AVX
// #endif

// #if defined HAVE_ATTRIBUTE_TARGET_AVX2_WITH_INTRINSICS
// #define HAVE_ATTRIBUTE_TARGET_FMA
// #define NPY_GCC_TARGET_FMA __attribute__((target("avx2,fma")))
// #endif

// #if defined HAVE_ATTRIBUTE_TARGET_AVX2 && defined HAVE_LINK_AVX2
// #define NPY_GCC_TARGET_AVX2 __attribute__((target("avx2")))
// #else
// #define NPY_GCC_TARGET_AVX2
// #endif

// #if defined HAVE_ATTRIBUTE_TARGET_AVX512F && defined HAVE_LINK_AVX512F
// #define NPY_GCC_TARGET_AVX512F __attribute__((target("avx512f")))
// #elif defined HAVE_ATTRIBUTE_TARGET_AVX512F_WITH_INTRINSICS
// #define NPY_GCC_TARGET_AVX512F __attribute__((target("avx512f")))
// #else
// #define NPY_GCC_TARGET_AVX512F
// #endif

// #if defined HAVE_ATTRIBUTE_TARGET_AVX512_SKX && defined HAVE_LINK_AVX512_SKX
// #define NPY_GCC_TARGET_AVX512_SKX __attribute__((target("avx512f,avx512dq,avx512vl,avx512bw,avx512cd")))
// #elif defined HAVE_ATTRIBUTE_TARGET_AVX512_SKX_WITH_INTRINSICS
// #define NPY_GCC_TARGET_AVX512_SKX __attribute__((target("avx512f,avx512dq,avx512vl,avx512bw,avx512cd")))
// #else
// #define NPY_GCC_TARGET_AVX512_SKX
// #endif
/*
 * mark an argument (starting from 1) that must not be NULL and is not checked
 * DO NOT USE IF FUNCTION CHECKS FOR NULL!! the compiler will remove the check
 */
// #ifdef HAVE_ATTRIBUTE_NONNULL
// #define NPY_GCC_NONNULL(n) __attribute__((nonnull(n)))
// #else
// #define NPY_GCC_NONNULL(n)
// #endif

// #if defined HAVE_XMMINTRIN_H && defined HAVE__MM_LOAD_PS
// #define NPY_HAVE_SSE_INTRINSICS
// #endif

// #if defined HAVE_EMMINTRIN_H && defined HAVE__MM_LOAD_PD
// #define NPY_HAVE_SSE2_INTRINSICS
// #endif

// #if defined HAVE_IMMINTRIN_H && defined HAVE_LINK_AVX2
// #define NPY_HAVE_AVX2_INTRINSICS
// #endif

// #if defined HAVE_IMMINTRIN_H && defined HAVE_LINK_AVX512F
// #define NPY_HAVE_AVX512F_INTRINSICS
// #endif
/*
 * give a hint to the compiler which branch is more likely or unlikely
 * to occur, e.g. rare error cases:
 *
 * if (NPY_UNLIKELY(failure == 0))
 *    return NULL;
 *
 * the double !! is to cast the expression (e.g. NULL) to a boolean required by
 * the intrinsic
 */
// #ifdef HAVE___BUILTIN_EXPECT
// #define NPY_LIKELY(x) __builtin_expect(!!(x), 1)
// #define NPY_UNLIKELY(x) __builtin_expect(!!(x), 0)
// #else
// #define NPY_LIKELY(x) (x)
// #define NPY_UNLIKELY(x) (x)
// #endif

// #ifdef HAVE___BUILTIN_PREFETCH
/* unlike _mm_prefetch also works on non-x86 */
// #define NPY_PREFETCH(x, rw, loc) __builtin_prefetch((x), (rw), (loc))
// #else
// #ifdef HAVE__MM_PREFETCH
/* _MM_HINT_ET[01] (rw = 1) unsupported, only available in gcc >= 4.9 */
// #define NPY_PREFETCH(x, rw, loc) _mm_prefetch((x), loc == 0 ? _MM_HINT_NTA :
//                                              (loc == 1 ? _MM_HINT_T2 :
//                                               (loc == 2 ? _MM_HINT_T1 :
//                                                (loc == 3 ? _MM_HINT_T0 : -1))))
// #else
// #define NPY_PREFETCH(x, rw,loc)
// #endif
// #endif

// #if defined(_MSC_VER)
//         #define NPY_INLINE __inline
// #elif defined(__GNUC__)
//     #if defined(__STRICT_ANSI__)
//          #define NPY_INLINE __inline__
//     #else
//          #define NPY_INLINE inline
//     #endif
// #else
//     #define NPY_INLINE
// #endif

// #ifdef _MSC_VER
//     #define NPY_FINLINE static __forceinline
// #elif defined(__GNUC__)
//     #define NPY_FINLINE static NPY_INLINE __attribute__((always_inline))
// #else
//     #define NPY_FINLINE static
// #endif

// #ifdef HAVE___THREAD
//     #define NPY_TLS __thread
// #else
//     #ifdef HAVE___DECLSPEC_THREAD_
//         #define NPY_TLS __declspec(thread)
//     #else
//         #define NPY_TLS
//     #endif
// #endif

// #ifdef WITH_CPYCHECKER_RETURNS_BORROWED_REF_ATTRIBUTE
//   #define NPY_RETURNS_BORROWED_REF
//     __attribute__((cpychecker_returns_borrowed_ref))
// #else
//   #define NPY_RETURNS_BORROWED_REF
// #endif

// #ifdef WITH_CPYCHECKER_STEALS_REFERENCE_TO_ARG_ATTRIBUTE
//   #define NPY_STEALS_REF_TO_ARG(n)
//    __attribute__((cpychecker_steals_reference_to_arg(n)))
// #else
//  #define NPY_STEALS_REF_TO_ARG(n)
// #endif

/* 64 bit file position support, also on win-amd64. Ticket #1660 */
// #if defined(_MSC_VER) && defined(_WIN64) && (_MSC_VER > 1400) ||
//     defined(__MINGW32__) || defined(__MINGW64__)
// #else
// #ifdef HAVE_FSEEKO
//     #define npy_fseek fseeko
// #else
// #endif
// #ifdef HAVE_FTELLO
//     #define npy_ftell ftello
// #else
// #endif
//     #include <sys/types.h>
//     #define npy_lseek lseek
//     #define npy_off_t off_t

//     #if NPY_SIZEOF_OFF_T == NPY_SIZEOF_SHORT
        public static final String NPY_OFF_T_PYFMT = "h";
//     #elif NPY_SIZEOF_OFF_T == NPY_SIZEOF_INT
//     #elif NPY_SIZEOF_OFF_T == NPY_SIZEOF_LONG
//     #elif NPY_SIZEOF_OFF_T == NPY_SIZEOF_LONGLONG
//     #else
//         #error Unsupported size for type off_t
//     #endif
// #endif

/* enums for detected endianness */
/** enum  */
public static final int
        NPY_CPU_UNKNOWN_ENDIAN = 0,
        NPY_CPU_LITTLE = 1,
        NPY_CPU_BIG = 2;

/*
 * This is to typedef npy_intp to the appropriate pointer size for this
 * platform.  Py_intptr_t, Py_uintptr_t are defined in pyport.h.
 */

/*
 * Define sizes that were not defined in numpyconfig.h.
 */
public static final int NPY_SIZEOF_CHAR = 1;
public static final int NPY_SIZEOF_BYTE = 1;
public static final int NPY_SIZEOF_DATETIME = 8;
public static final int NPY_SIZEOF_TIMEDELTA = 8;
public static final int NPY_SIZEOF_INTP = NPY_SIZEOF_PY_INTPTR_T;
public static final int NPY_SIZEOF_UINTP = NPY_SIZEOF_PY_INTPTR_T;
public static final int NPY_SIZEOF_HALF = 2;
public static final int NPY_SIZEOF_CFLOAT = NPY_SIZEOF_COMPLEX_FLOAT;
public static final int NPY_SIZEOF_CDOUBLE = NPY_SIZEOF_COMPLEX_DOUBLE;
public static final int NPY_SIZEOF_CLONGDOUBLE = NPY_SIZEOF_COMPLEX_LONGDOUBLE;

// #ifdef constchar
// #endif

public static final String NPY_SSIZE_T_PYFMT = "n";
// #define constchar char

/* NPY_INTP_FMT Note:
 *      Unlike the other NPY_*_FMT macros, which are used with PyOS_snprintf,
 *      NPY_INTP_FMT is used with PyErr_Format and PyUnicode_FromFormat. Those
 *      functions use different formatting codes that are portably specified
 *      according to the Python documentation. See issue gh-2388.
 */
// #if NPY_SIZEOF_PY_INTPTR_T == NPY_SIZEOF_INT
// #elif NPY_SIZEOF_PY_INTPTR_T == NPY_SIZEOF_LONG
// #elif defined(PY_LONG_LONG) && (NPY_SIZEOF_PY_INTPTR_T == NPY_SIZEOF_LONGLONG)
        public static native @MemberGetter long NPY_INTP();
        public static final long NPY_INTP = NPY_INTP();
        public static native @MemberGetter long NPY_UINTP();
        public static final long NPY_UINTP = NPY_UINTP();
//         #define PyIntpArrType_Type PyLongLongArrType_Type
//         #define PyUIntpArrType_Type PyULongLongArrType_Type
        public static native @MemberGetter long NPY_MAX_INTP();
        public static final long NPY_MAX_INTP = NPY_MAX_INTP();
        public static native @MemberGetter long NPY_MIN_INTP();
        public static final long NPY_MIN_INTP = NPY_MIN_INTP();
        public static native @MemberGetter long NPY_MAX_UINTP();
        public static final long NPY_MAX_UINTP = NPY_MAX_UINTP();
        public static final String NPY_INTP_FMT = "lld";
// #endif

/*
 * We can only use C99 formats for npy_int_p if it is the same as
 * intp_t, hence the condition on HAVE_UNITPTR_T
 */
// #if (NPY_USE_C99_FORMATS) == 1
//         && (defined HAVE_UINTPTR_T)
//         && (defined HAVE_INTTYPES_H)
//         #include <inttypes.h>
//         #undef NPY_INTP_FMT
// #endif


/*
 * Some platforms don't define bool, long long, or long double.
 * Handle that here.
 */
public static final String NPY_BYTE_FMT = "hhd";
public static final String NPY_UBYTE_FMT = "hhu";
public static final String NPY_SHORT_FMT = "hd";
public static final String NPY_USHORT_FMT = "hu";
public static final String NPY_INT_FMT = "d";
public static final String NPY_UINT_FMT = "u";
public static final String NPY_LONG_FMT = "ld";
public static final String NPY_ULONG_FMT = "lu";
public static final String NPY_HALF_FMT = "g";
public static final String NPY_FLOAT_FMT = "g";
public static final String NPY_DOUBLE_FMT = "g";


// #ifdef PY_LONG_LONG
// #else
// #  define NPY_LONGLONG_SUFFIX(x)  (x##L)
// #  define NPY_ULONGLONG_SUFFIX(x) (x##UL)
// #endif
public static final int NPY_FALSE = 0;
public static final int NPY_TRUE = 1;


// #if NPY_SIZEOF_LONGDOUBLE == NPY_SIZEOF_DOUBLE
        public static final String NPY_LONGDOUBLE_FMT = "g";
// #else
// #endif

// #ifndef Py_USING_UNICODE
// #error Must use Python with unicode enabled.
// #endif

/* These are for completeness */
public static final int NPY_SIZEOF_HASH_T = NPY_SIZEOF_INTP;

/*
 * Disabling C99 complex usage: a lot of C code in numpy/scipy rely on being
 * able to do .real/.imag. Will have to convert code first.
 */
// #if 0
// #endif
// #if NPY_SIZEOF_COMPLEX_DOUBLE != 2 * NPY_SIZEOF_DOUBLE
// #error npy_cdouble definition is not compatible with C99 complex definition !
//         Please contact NumPy maintainers and give detailed information about your
//         compiler and platform
// Targeting ../npy_cdouble.java



// #if NPY_SIZEOF_COMPLEX_FLOAT != 2 * NPY_SIZEOF_FLOAT
// #error npy_cfloat definition is not compatible with C99 complex definition !
//         Please contact NumPy maintainers and give detailed information about your
//         compiler and platform
// Targeting ../npy_cfloat.java



// #if NPY_SIZEOF_COMPLEX_LONGDOUBLE != 2 * NPY_SIZEOF_LONGDOUBLE
// #error npy_clongdouble definition is not compatible with C99 complex definition !
//         Please contact NumPy maintainers and give detailed information about your
//         compiler and platform
// Targeting ../npy_clongdouble.java



/*
 * numarray-style bit-width typedefs
 */
public static final int NPY_MAX_INT8 = 127;
public static final int NPY_MIN_INT8 = -128;
public static final int NPY_MAX_UINT8 = 255;
public static final int NPY_MAX_INT16 = 32767;
public static final int NPY_MIN_INT16 = -32768;
public static final int NPY_MAX_UINT16 = 65535;
public static final int NPY_MAX_INT32 = 2147483647;
public static final int NPY_MIN_INT32 = (-NPY_MAX_INT32 - 1);
public static final long NPY_MAX_UINT32 = 4294967295L;
public static native @MemberGetter long NPY_MAX_INT64();
public static final long NPY_MAX_INT64 = NPY_MAX_INT64();
public static native @MemberGetter long NPY_MIN_INT64();
public static final long NPY_MIN_INT64 = NPY_MIN_INT64();
public static native @MemberGetter long NPY_MAX_UINT64();
public static final long NPY_MAX_UINT64 = NPY_MAX_UINT64();
// #define NPY_MAX_INT128 NPY_LONGLONG_SUFFIX(85070591730234615865843651857942052864L)
// #define NPY_MIN_INT128 (-NPY_MAX_INT128 - NPY_LONGLONG_SUFFIX(1))
// #define NPY_MAX_UINT128 NPY_ULONGLONG_SUFFIX(170141183460469231731687303715884105728L)
// #define NPY_MAX_INT256 NPY_LONGLONG_SUFFIX(57896044618658097711785492504343953926634992332820282019728792003956564819967L)
// #define NPY_MIN_INT256 (-NPY_MAX_INT256 - NPY_LONGLONG_SUFFIX(1))
// #define NPY_MAX_UINT256 NPY_ULONGLONG_SUFFIX(115792089237316195423570985008687907853269984665640564039457584007913129639935L)
public static native @MemberGetter long NPY_MIN_DATETIME();
public static final long NPY_MIN_DATETIME = NPY_MIN_DATETIME();
public static native @MemberGetter long NPY_MAX_DATETIME();
public static final long NPY_MAX_DATETIME = NPY_MAX_DATETIME();
public static native @MemberGetter long NPY_MIN_TIMEDELTA();
public static final long NPY_MIN_TIMEDELTA = NPY_MIN_TIMEDELTA();
public static native @MemberGetter long NPY_MAX_TIMEDELTA();
public static final long NPY_MAX_TIMEDELTA = NPY_MAX_TIMEDELTA();

        /* Need to find the number of bits for each type and
           make definitions accordingly.

           C states that sizeof(char) == 1 by definition

           So, just using the sizeof keyword won't help.

           It also looks like Python itself uses sizeof(char) quite a
           bit, which by definition should be 1 all the time.

           Idea: Make Use of CHAR_BIT which should tell us how many
           BITS per CHARACTER
        */

        /* Include platform definitions -- These are in the C89/90 standard */
// #include <limits.h>
public static native @MemberGetter int NPY_MAX_BYTE();
public static final int NPY_MAX_BYTE = NPY_MAX_BYTE();
public static native @MemberGetter int NPY_MIN_BYTE();
public static final int NPY_MIN_BYTE = NPY_MIN_BYTE();
public static native @MemberGetter int NPY_MAX_UBYTE();
public static final int NPY_MAX_UBYTE = NPY_MAX_UBYTE();
public static native @MemberGetter int NPY_MAX_SHORT();
public static final int NPY_MAX_SHORT = NPY_MAX_SHORT();
public static native @MemberGetter int NPY_MIN_SHORT();
public static final int NPY_MIN_SHORT = NPY_MIN_SHORT();
public static native @MemberGetter int NPY_MAX_USHORT();
public static final int NPY_MAX_USHORT = NPY_MAX_USHORT();
public static native @MemberGetter long NPY_MAX_INT();
public static final long NPY_MAX_INT = NPY_MAX_INT();
// #ifndef INT_MIN
public static native @MemberGetter long INT_MIN();
public static final long INT_MIN = INT_MIN();
// #endif
public static native @MemberGetter long NPY_MIN_INT();
public static final long NPY_MIN_INT = NPY_MIN_INT();
public static native @MemberGetter long NPY_MAX_UINT();
public static final long NPY_MAX_UINT = NPY_MAX_UINT();
public static native @MemberGetter long NPY_MAX_LONG();
public static final long NPY_MAX_LONG = NPY_MAX_LONG();
public static native @MemberGetter long NPY_MIN_LONG();
public static final long NPY_MIN_LONG = NPY_MIN_LONG();
public static native @MemberGetter long NPY_MAX_ULONG();
public static final long NPY_MAX_ULONG = NPY_MAX_ULONG();

public static native @MemberGetter int NPY_BITSOF_BOOL();
public static final int NPY_BITSOF_BOOL = NPY_BITSOF_BOOL();
public static native @MemberGetter int NPY_BITSOF_CHAR();
public static final int NPY_BITSOF_CHAR = NPY_BITSOF_CHAR();
public static native @MemberGetter int NPY_BITSOF_BYTE();
public static final int NPY_BITSOF_BYTE = NPY_BITSOF_BYTE();
public static native @MemberGetter int NPY_BITSOF_SHORT();
public static final int NPY_BITSOF_SHORT = NPY_BITSOF_SHORT();
public static native @MemberGetter int NPY_BITSOF_INT();
public static final int NPY_BITSOF_INT = NPY_BITSOF_INT();
public static native @MemberGetter int NPY_BITSOF_LONG();
public static final int NPY_BITSOF_LONG = NPY_BITSOF_LONG();
public static native @MemberGetter int NPY_BITSOF_LONGLONG();
public static final int NPY_BITSOF_LONGLONG = NPY_BITSOF_LONGLONG();
public static native @MemberGetter int NPY_BITSOF_INTP();
public static final int NPY_BITSOF_INTP = NPY_BITSOF_INTP();
public static native @MemberGetter int NPY_BITSOF_HALF();
public static final int NPY_BITSOF_HALF = NPY_BITSOF_HALF();
public static native @MemberGetter int NPY_BITSOF_FLOAT();
public static final int NPY_BITSOF_FLOAT = NPY_BITSOF_FLOAT();
public static native @MemberGetter int NPY_BITSOF_DOUBLE();
public static final int NPY_BITSOF_DOUBLE = NPY_BITSOF_DOUBLE();
public static native @MemberGetter int NPY_BITSOF_LONGDOUBLE();
public static final int NPY_BITSOF_LONGDOUBLE = NPY_BITSOF_LONGDOUBLE();
public static native @MemberGetter int NPY_BITSOF_CFLOAT();
public static final int NPY_BITSOF_CFLOAT = NPY_BITSOF_CFLOAT();
public static native @MemberGetter int NPY_BITSOF_CDOUBLE();
public static final int NPY_BITSOF_CDOUBLE = NPY_BITSOF_CDOUBLE();
public static native @MemberGetter int NPY_BITSOF_CLONGDOUBLE();
public static final int NPY_BITSOF_CLONGDOUBLE = NPY_BITSOF_CLONGDOUBLE();
public static native @MemberGetter int NPY_BITSOF_DATETIME();
public static final int NPY_BITSOF_DATETIME = NPY_BITSOF_DATETIME();
public static native @MemberGetter int NPY_BITSOF_TIMEDELTA();
public static final int NPY_BITSOF_TIMEDELTA = NPY_BITSOF_TIMEDELTA();

// #if NPY_BITSOF_LONG == 8
// #elif NPY_BITSOF_LONG == 16
// #elif NPY_BITSOF_LONG == 32
// #elif NPY_BITSOF_LONG == 64
public static native @MemberGetter int NPY_INT64();
public static final int NPY_INT64 = NPY_INT64();
public static native @MemberGetter int NPY_UINT64();
public static final int NPY_UINT64 = NPY_UINT64();
// #define PyInt64ScalarObject PyLongScalarObject
// #define PyInt64ArrType_Type PyLongArrType_Type
// #define PyUInt64ScalarObject PyULongScalarObject
// #define PyUInt64ArrType_Type PyULongArrType_Type
public static final String NPY_INT64_FMT = NPY_LONG_FMT;
public static final String NPY_UINT64_FMT = NPY_ULONG_FMT;
// #define MyPyLong_FromInt64 PyLong_FromLong
// #define MyPyLong_AsInt64 PyLong_AsLong
// #elif NPY_BITSOF_LONG == 128
// #endif

// #if NPY_BITSOF_LONGLONG == 8
// #elif NPY_BITSOF_LONGLONG == 16
// #elif NPY_BITSOF_LONGLONG == 32
// #elif NPY_BITSOF_LONGLONG == 64
// #  ifndef NPY_INT64
// #    define PyInt64ScalarObject PyLongLongScalarObject
// #    define PyInt64ArrType_Type PyLongLongArrType_Type
// #    define PyUInt64ScalarObject PyULongLongScalarObject
// #    define PyUInt64ArrType_Type PyULongLongArrType_Type
// #    define MyPyLong_FromInt64 PyLong_FromLongLong
// #    define MyPyLong_AsInt64 PyLong_AsLongLong
// #  endif
public static native @MemberGetter long NPY_MAX_LONGLONG();
public static final long NPY_MAX_LONGLONG = NPY_MAX_LONGLONG();
public static native @MemberGetter long NPY_MIN_LONGLONG();
public static final long NPY_MIN_LONGLONG = NPY_MIN_LONGLONG();
public static native @MemberGetter long NPY_MAX_ULONGLONG();
public static final long NPY_MAX_ULONGLONG = NPY_MAX_ULONGLONG();
// #elif NPY_BITSOF_LONGLONG == 128
// #elif NPY_BITSOF_LONGLONG == 256
// #endif

// #if NPY_BITSOF_INT == 8
// #elif NPY_BITSOF_INT == 16
// #elif NPY_BITSOF_INT == 32
// #ifndef NPY_INT32
public static native @MemberGetter int NPY_INT32();
public static final int NPY_INT32 = NPY_INT32();
public static native @MemberGetter int NPY_UINT32();
public static final int NPY_UINT32 = NPY_UINT32();
// #    define PyInt32ScalarObject PyIntScalarObject
// #    define PyInt32ArrType_Type PyIntArrType_Type
// #    define PyUInt32ScalarObject PyUIntScalarObject
// #    define PyUInt32ArrType_Type PyUIntArrType_Type
public static final String NPY_INT32_FMT = NPY_INT_FMT;
public static final String NPY_UINT32_FMT = NPY_UINT_FMT;
// #endif
// #elif NPY_BITSOF_INT == 64
// #elif NPY_BITSOF_INT == 128
// #endif

// #if NPY_BITSOF_SHORT == 8
// #elif NPY_BITSOF_SHORT == 16
// #ifndef NPY_INT16
public static native @MemberGetter int NPY_INT16();
public static final int NPY_INT16 = NPY_INT16();
public static native @MemberGetter int NPY_UINT16();
public static final int NPY_UINT16 = NPY_UINT16();
// #    define PyInt16ScalarObject PyShortScalarObject
// #    define PyInt16ArrType_Type PyShortArrType_Type
// #    define PyUInt16ScalarObject PyUShortScalarObject
// #    define PyUInt16ArrType_Type PyUShortArrType_Type
public static final String NPY_INT16_FMT = NPY_SHORT_FMT;
public static final String NPY_UINT16_FMT = NPY_USHORT_FMT;
// #endif
// #elif NPY_BITSOF_SHORT == 32
// #elif NPY_BITSOF_SHORT == 64
// #elif NPY_BITSOF_SHORT == 128
// #endif


// #if NPY_BITSOF_CHAR == 8
// #ifndef NPY_INT8
public static native @MemberGetter int NPY_INT8();
public static final int NPY_INT8 = NPY_INT8();
public static native @MemberGetter int NPY_UINT8();
public static final int NPY_UINT8 = NPY_UINT8();
// #    define PyInt8ScalarObject PyByteScalarObject
// #    define PyInt8ArrType_Type PyByteArrType_Type
// #    define PyUInt8ScalarObject PyUByteScalarObject
// #    define PyUInt8ArrType_Type PyUByteArrType_Type
public static final String NPY_INT8_FMT = NPY_BYTE_FMT;
public static final String NPY_UINT8_FMT = NPY_UBYTE_FMT;
// #endif
// #elif NPY_BITSOF_CHAR == 16
// #ifndef NPY_INT16
// #    define PyInt16ScalarObject PyByteScalarObject
// #    define PyInt16ArrType_Type PyByteArrType_Type
// #    define PyUInt16ScalarObject PyUByteScalarObject
// #    define PyUInt16ArrType_Type PyUByteArrType_Type
// #endif
// #elif NPY_BITSOF_CHAR == 32
// #ifndef NPY_INT32
// #    define PyInt32ScalarObject PyByteScalarObject
// #    define PyInt32ArrType_Type PyByteArrType_Type
// #    define PyUInt32ScalarObject PyUByteScalarObject
// #    define PyUInt32ArrType_Type PyUByteArrType_Type
// #endif
// #elif NPY_BITSOF_CHAR == 64
// #ifndef NPY_INT64
// #    define PyInt64ScalarObject PyByteScalarObject
// #    define PyInt64ArrType_Type PyByteArrType_Type
// #    define PyUInt64ScalarObject PyUByteScalarObject
// #    define PyUInt64ArrType_Type PyUByteArrType_Type
// #    define MyPyLong_FromInt64 PyLong_FromLong
// #    define MyPyLong_AsInt64 PyLong_AsLong
// #endif
// #elif NPY_BITSOF_CHAR == 128
// #endif



// #if NPY_BITSOF_DOUBLE == 32
// #ifndef NPY_FLOAT32
// #define NPY_FLOAT32 NPY_DOUBLE
// #define NPY_COMPLEX64 NPY_CDOUBLE
// #    define PyFloat32ScalarObject PyDoubleScalarObject
// #    define PyComplex64ScalarObject PyCDoubleScalarObject
// #    define PyFloat32ArrType_Type PyDoubleArrType_Type
// #    define PyComplex64ArrType_Type PyCDoubleArrType_Type
public static final String NPY_FLOAT32_FMT = NPY_DOUBLE_FMT;
// #define NPY_COMPLEX64_FMT NPY_CDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_DOUBLE == 64
// #ifndef NPY_FLOAT64
// #define NPY_FLOAT64 NPY_DOUBLE
// #define NPY_COMPLEX128 NPY_CDOUBLE
// #    define PyFloat64ScalarObject PyDoubleScalarObject
// #    define PyComplex128ScalarObject PyCDoubleScalarObject
// #    define PyFloat64ArrType_Type PyDoubleArrType_Type
// #    define PyComplex128ArrType_Type PyCDoubleArrType_Type
public static final String NPY_FLOAT64_FMT = NPY_DOUBLE_FMT;
// #define NPY_COMPLEX128_FMT NPY_CDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_DOUBLE == 80
// #ifndef NPY_FLOAT80
// #define NPY_FLOAT80 NPY_DOUBLE
// #define NPY_COMPLEX160 NPY_CDOUBLE
// #    define PyFloat80ScalarObject PyDoubleScalarObject
// #    define PyComplex160ScalarObject PyCDoubleScalarObject
// #    define PyFloat80ArrType_Type PyDoubleArrType_Type
// #    define PyComplex160ArrType_Type PyCDoubleArrType_Type
public static final String NPY_FLOAT80_FMT = NPY_DOUBLE_FMT;
// #define NPY_COMPLEX160_FMT NPY_CDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_DOUBLE == 96
// #ifndef NPY_FLOAT96
// #define NPY_FLOAT96 NPY_DOUBLE
// #define NPY_COMPLEX192 NPY_CDOUBLE
// #    define PyFloat96ScalarObject PyDoubleScalarObject
// #    define PyComplex192ScalarObject PyCDoubleScalarObject
// #    define PyFloat96ArrType_Type PyDoubleArrType_Type
// #    define PyComplex192ArrType_Type PyCDoubleArrType_Type
public static final String NPY_FLOAT96_FMT = NPY_DOUBLE_FMT;
// #define NPY_COMPLEX192_FMT NPY_CDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_DOUBLE == 128
// #ifndef NPY_FLOAT128
// #define NPY_FLOAT128 NPY_DOUBLE
// #define NPY_COMPLEX256 NPY_CDOUBLE
// #    define PyFloat128ScalarObject PyDoubleScalarObject
// #    define PyComplex256ScalarObject PyCDoubleScalarObject
// #    define PyFloat128ArrType_Type PyDoubleArrType_Type
// #    define PyComplex256ArrType_Type PyCDoubleArrType_Type
public static final String NPY_FLOAT128_FMT = NPY_DOUBLE_FMT;
// #define NPY_COMPLEX256_FMT NPY_CDOUBLE_FMT
// #endif
// #endif



// #if NPY_BITSOF_FLOAT == 32
// #ifndef NPY_FLOAT32
// #define NPY_FLOAT32 NPY_FLOAT
// #define NPY_COMPLEX64 NPY_CFLOAT
// #    define PyFloat32ScalarObject PyFloatScalarObject
// #    define PyComplex64ScalarObject PyCFloatScalarObject
// #    define PyFloat32ArrType_Type PyFloatArrType_Type
// #    define PyComplex64ArrType_Type PyCFloatArrType_Type
// #define NPY_COMPLEX64_FMT NPY_CFLOAT_FMT
// #endif
// #elif NPY_BITSOF_FLOAT == 64
// #ifndef NPY_FLOAT64
// #define NPY_FLOAT64 NPY_FLOAT
// #define NPY_COMPLEX128 NPY_CFLOAT
// #    define PyFloat64ScalarObject PyFloatScalarObject
// #    define PyComplex128ScalarObject PyCFloatScalarObject
// #    define PyFloat64ArrType_Type PyFloatArrType_Type
// #    define PyComplex128ArrType_Type PyCFloatArrType_Type
// #define NPY_COMPLEX128_FMT NPY_CFLOAT_FMT
// #endif
// #elif NPY_BITSOF_FLOAT == 80
// #ifndef NPY_FLOAT80
// #define NPY_FLOAT80 NPY_FLOAT
// #define NPY_COMPLEX160 NPY_CFLOAT
// #    define PyFloat80ScalarObject PyFloatScalarObject
// #    define PyComplex160ScalarObject PyCFloatScalarObject
// #    define PyFloat80ArrType_Type PyFloatArrType_Type
// #    define PyComplex160ArrType_Type PyCFloatArrType_Type
// #define NPY_COMPLEX160_FMT NPY_CFLOAT_FMT
// #endif
// #elif NPY_BITSOF_FLOAT == 96
// #ifndef NPY_FLOAT96
// #define NPY_FLOAT96 NPY_FLOAT
// #define NPY_COMPLEX192 NPY_CFLOAT
// #    define PyFloat96ScalarObject PyFloatScalarObject
// #    define PyComplex192ScalarObject PyCFloatScalarObject
// #    define PyFloat96ArrType_Type PyFloatArrType_Type
// #    define PyComplex192ArrType_Type PyCFloatArrType_Type
// #define NPY_COMPLEX192_FMT NPY_CFLOAT_FMT
// #endif
// #elif NPY_BITSOF_FLOAT == 128
// #ifndef NPY_FLOAT128
// #define NPY_FLOAT128 NPY_FLOAT
// #define NPY_COMPLEX256 NPY_CFLOAT
// #    define PyFloat128ScalarObject PyFloatScalarObject
// #    define PyComplex256ScalarObject PyCFloatScalarObject
// #    define PyFloat128ArrType_Type PyFloatArrType_Type
// #    define PyComplex256ArrType_Type PyCFloatArrType_Type
// #define NPY_COMPLEX256_FMT NPY_CFLOAT_FMT
// #endif
// #endif

/* half/float16 isn't a floating-point type in C */
public static native @MemberGetter int NPY_FLOAT16();
public static final int NPY_FLOAT16 = NPY_FLOAT16();

// #if NPY_BITSOF_LONGDOUBLE == 32
// #ifndef NPY_FLOAT32
// #define NPY_FLOAT32 NPY_LONGDOUBLE
// #define NPY_COMPLEX64 NPY_CLONGDOUBLE
// #    define PyFloat32ScalarObject PyLongDoubleScalarObject
// #    define PyComplex64ScalarObject PyCLongDoubleScalarObject
// #    define PyFloat32ArrType_Type PyLongDoubleArrType_Type
// #    define PyComplex64ArrType_Type PyCLongDoubleArrType_Type
// #define NPY_COMPLEX64_FMT NPY_CLONGDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_LONGDOUBLE == 64
// #ifndef NPY_FLOAT64
// #define NPY_FLOAT64 NPY_LONGDOUBLE
// #define NPY_COMPLEX128 NPY_CLONGDOUBLE
// #    define PyFloat64ScalarObject PyLongDoubleScalarObject
// #    define PyComplex128ScalarObject PyCLongDoubleScalarObject
// #    define PyFloat64ArrType_Type PyLongDoubleArrType_Type
// #    define PyComplex128ArrType_Type PyCLongDoubleArrType_Type
// #define NPY_COMPLEX128_FMT NPY_CLONGDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_LONGDOUBLE == 80
// #ifndef NPY_FLOAT80
// #define NPY_FLOAT80 NPY_LONGDOUBLE
// #define NPY_COMPLEX160 NPY_CLONGDOUBLE
// #    define PyFloat80ScalarObject PyLongDoubleScalarObject
// #    define PyComplex160ScalarObject PyCLongDoubleScalarObject
// #    define PyFloat80ArrType_Type PyLongDoubleArrType_Type
// #    define PyComplex160ArrType_Type PyCLongDoubleArrType_Type
// #define NPY_COMPLEX160_FMT NPY_CLONGDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_LONGDOUBLE == 96
// #ifndef NPY_FLOAT96
// #define NPY_FLOAT96 NPY_LONGDOUBLE
// #define NPY_COMPLEX192 NPY_CLONGDOUBLE
// #    define PyFloat96ScalarObject PyLongDoubleScalarObject
// #    define PyComplex192ScalarObject PyCLongDoubleScalarObject
// #    define PyFloat96ArrType_Type PyLongDoubleArrType_Type
// #    define PyComplex192ArrType_Type PyCLongDoubleArrType_Type
// #define NPY_COMPLEX192_FMT NPY_CLONGDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_LONGDOUBLE == 128
// #ifndef NPY_FLOAT128
// #define NPY_FLOAT128 NPY_LONGDOUBLE
// #define NPY_COMPLEX256 NPY_CLONGDOUBLE
// #    define PyFloat128ScalarObject PyLongDoubleScalarObject
// #    define PyComplex256ScalarObject PyCLongDoubleScalarObject
// #    define PyFloat128ArrType_Type PyLongDoubleArrType_Type
// #    define PyComplex256ArrType_Type PyCLongDoubleArrType_Type
// #define NPY_COMPLEX256_FMT NPY_CLONGDOUBLE_FMT
// #endif
// #elif NPY_BITSOF_LONGDOUBLE == 256
// #define NPY_FLOAT256 NPY_LONGDOUBLE
// #define NPY_COMPLEX512 NPY_CLONGDOUBLE
// #    define PyFloat256ScalarObject PyLongDoubleScalarObject
// #    define PyComplex512ScalarObject PyCLongDoubleScalarObject
// #    define PyFloat256ArrType_Type PyLongDoubleArrType_Type
// #    define PyComplex512ArrType_Type PyCLongDoubleArrType_Type
public static final String NPY_FLOAT256_FMT = NPY_LONGDOUBLE_FMT;
// #define NPY_COMPLEX512_FMT NPY_CLONGDOUBLE_FMT
// #endif

/* datetime typedefs */
public static final String NPY_DATETIME_FMT = NPY_INT64_FMT;
public static final String NPY_TIMEDELTA_FMT = NPY_INT64_FMT;

/* End of typedefs for numarray style bit-width names */

// #endif


// Parsed from npy_os.h

// #ifndef _NPY_OS_H_
// #define _NPY_OS_H_

// #if defined(linux) || defined(__linux) || defined(__linux__)
//     #define NPY_OS_LINUX
// #elif defined(__FreeBSD__) || defined(__NetBSD__) ||
//             defined(__OpenBSD__) || defined(__DragonFly__)
//     #define NPY_OS_BSD
//     #ifdef __FreeBSD__
//         #define NPY_OS_FREEBSD
//     #elif defined(__NetBSD__)
//         #define NPY_OS_NETBSD
//     #elif defined(__OpenBSD__)
//         #define NPY_OS_OPENBSD
//     #elif defined(__DragonFly__)
//         #define NPY_OS_DRAGONFLY
//     #endif
// #elif defined(sun) || defined(__sun)
//     #define NPY_OS_SOLARIS
// #elif defined(__CYGWIN__)
//     #define NPY_OS_CYGWIN
// #elif defined(_WIN32) || defined(__WIN32__) || defined(WIN32)
//     #define NPY_OS_WIN32
// #elif defined(__APPLE__)
//     #define NPY_OS_DARWIN
// #else
//     #define NPY_OS_UNKNOWN
// #endif

// #endif


// Parsed from npy_cpu.h

/*
 * This set (target) cpu specific macros:
 *      - Possible values:
 *              NPY_CPU_X86
 *              NPY_CPU_AMD64
 *              NPY_CPU_PPC
 *              NPY_CPU_PPC64
 *              NPY_CPU_PPC64LE
 *              NPY_CPU_SPARC
 *              NPY_CPU_S390
 *              NPY_CPU_IA64
 *              NPY_CPU_HPPA
 *              NPY_CPU_ALPHA
 *              NPY_CPU_ARMEL
 *              NPY_CPU_ARMEB
 *              NPY_CPU_SH_LE
 *              NPY_CPU_SH_BE
 *              NPY_CPU_ARCEL
 *              NPY_CPU_ARCEB
 *              NPY_CPU_RISCV64
 *              NPY_CPU_WASM
 */
// #ifndef _NPY_CPUARCH_H_
// #define _NPY_CPUARCH_H_

// #include "numpyconfig.h"

// #if defined( __i386__ ) || defined(i386) || defined(_M_IX86)
    /*
     * __i386__ is defined by gcc and Intel compiler on Linux,
     * _M_IX86 by VS compiler,
     * i386 by Sun compilers on opensolaris at least
     */
//     #define NPY_CPU_X86
// #elif defined(__x86_64__) || defined(__amd64__) || defined(__x86_64) || defined(_M_AMD64)
    /*
     * both __x86_64__ and __amd64__ are defined by gcc
     * __x86_64 defined by sun compiler on opensolaris at least
     * _M_AMD64 defined by MS compiler
     */
//     #define NPY_CPU_AMD64
// #elif defined(__powerpc64__) && defined(__LITTLE_ENDIAN__)
//     #define NPY_CPU_PPC64LE
// #elif defined(__powerpc64__) && defined(__BIG_ENDIAN__)
//     #define NPY_CPU_PPC64
// #elif defined(__ppc__) || defined(__powerpc__) || defined(_ARCH_PPC)
    /*
     * __ppc__ is defined by gcc, I remember having seen __powerpc__ once,
     * but can't find it ATM
     * _ARCH_PPC is used by at least gcc on AIX
     * As __powerpc__ and _ARCH_PPC are also defined by PPC64 check
     * for those specifically first before defaulting to ppc
     */
//     #define NPY_CPU_PPC
// #elif defined(__sparc__) || defined(__sparc)
    /* __sparc__ is defined by gcc and Forte (e.g. Sun) compilers */
//     #define NPY_CPU_SPARC
// #elif defined(__s390__)
//     #define NPY_CPU_S390
// #elif defined(__ia64)
//     #define NPY_CPU_IA64
// #elif defined(__hppa)
//     #define NPY_CPU_HPPA
// #elif defined(__alpha__)
//     #define NPY_CPU_ALPHA
// #elif defined(__arm__) || defined(__aarch64__)
//     #if defined(__ARMEB__) || defined(__AARCH64EB__)
//         #if defined(__ARM_32BIT_STATE)
//             #define NPY_CPU_ARMEB_AARCH32
//         #elif defined(__ARM_64BIT_STATE)
//             #define NPY_CPU_ARMEB_AARCH64
//         #else
//             #define NPY_CPU_ARMEB
//         #endif
//     #elif defined(__ARMEL__) || defined(__AARCH64EL__)
//         #if defined(__ARM_32BIT_STATE)
//             #define NPY_CPU_ARMEL_AARCH32
//         #elif defined(__ARM_64BIT_STATE)
//             #define NPY_CPU_ARMEL_AARCH64
//         #else
//             #define NPY_CPU_ARMEL
//         #endif
//     #else
//         # error Unknown ARM CPU, please report this to numpy maintainers with
// 	information about your platform (OS, CPU and compiler)
//     #endif
// #elif defined(__sh__) && defined(__LITTLE_ENDIAN__)
//     #define NPY_CPU_SH_LE
// #elif defined(__sh__) && defined(__BIG_ENDIAN__)
//     #define NPY_CPU_SH_BE
// #elif defined(__MIPSEL__)
//     #define NPY_CPU_MIPSEL
// #elif defined(__MIPSEB__)
//     #define NPY_CPU_MIPSEB
// #elif defined(__or1k__)
//     #define NPY_CPU_OR1K
// #elif defined(__mc68000__)
//     #define NPY_CPU_M68K
// #elif defined(__arc__) && defined(__LITTLE_ENDIAN__)
//     #define NPY_CPU_ARCEL
// #elif defined(__arc__) && defined(__BIG_ENDIAN__)
//     #define NPY_CPU_ARCEB
// #elif defined(__riscv) && defined(__riscv_xlen) && __riscv_xlen == 64
//     #define NPY_CPU_RISCV64
// #elif defined(__EMSCRIPTEN__)
    /* __EMSCRIPTEN__ is defined by emscripten: an LLVM-to-Web compiler */
//     #define NPY_CPU_WASM
// #else
//     #error Unknown CPU, please report this to numpy maintainers with
//     information about your platform (OS, CPU and compiler)
// #endif

// #if (defined(NPY_CPU_X86) || defined(NPY_CPU_AMD64))
public static final int NPY_CPU_HAVE_UNALIGNED_ACCESS = 1;
// #else
// #endif

// #endif


// Parsed from npy_endian.h

// #ifndef _NPY_ENDIAN_H_
// #define _NPY_ENDIAN_H_

/*
 * NPY_BYTE_ORDER is set to the same value as BYTE_ORDER set by glibc in
 * endian.h
 */

// #if defined(NPY_HAVE_ENDIAN_H) || defined(NPY_HAVE_SYS_ENDIAN_H)
    /* Use endian.h if available */

//     #if defined(NPY_HAVE_ENDIAN_H)
//     #include <endian.h>
//     #elif defined(NPY_HAVE_SYS_ENDIAN_H)
//     #include <sys/endian.h>
//     #endif

//     #if defined(BYTE_ORDER) && defined(BIG_ENDIAN) && defined(LITTLE_ENDIAN)
        public static native @MemberGetter int NPY_BYTE_ORDER();
        public static final int NPY_BYTE_ORDER = NPY_BYTE_ORDER();
        public static native @MemberGetter int NPY_LITTLE_ENDIAN();
        public static final int NPY_LITTLE_ENDIAN = NPY_LITTLE_ENDIAN();
        public static native @MemberGetter int NPY_BIG_ENDIAN();
        public static final int NPY_BIG_ENDIAN = NPY_BIG_ENDIAN();
//     #elif defined(_BYTE_ORDER) && defined(_BIG_ENDIAN) && defined(_LITTLE_ENDIAN)
//     #elif defined(__BYTE_ORDER) && defined(__BIG_ENDIAN) && defined(__LITTLE_ENDIAN)
//     #endif
// #endif

// #ifndef NPY_BYTE_ORDER
    /* Set endianness info using target CPU */
//     #include "npy_cpu.h"

//     #if defined(NPY_CPU_X86)
//             || defined(NPY_CPU_AMD64)
//             || defined(NPY_CPU_IA64)
//             || defined(NPY_CPU_ALPHA)
//             || defined(NPY_CPU_ARMEL)
//             || defined(NPY_CPU_ARMEL_AARCH32)
//             || defined(NPY_CPU_ARMEL_AARCH64)
//             || defined(NPY_CPU_SH_LE)
//             || defined(NPY_CPU_MIPSEL)
//             || defined(NPY_CPU_PPC64LE)
//             || defined(NPY_CPU_ARCEL)
//             || defined(NPY_CPU_RISCV64)
//             || defined(NPY_CPU_WASM)
//     #elif defined(NPY_CPU_PPC)
//             || defined(NPY_CPU_SPARC)
//             || defined(NPY_CPU_S390)
//             || defined(NPY_CPU_HPPA)
//             || defined(NPY_CPU_PPC64)
//             || defined(NPY_CPU_ARMEB)
//             || defined(NPY_CPU_ARMEB_AARCH32)
//             || defined(NPY_CPU_ARMEB_AARCH64)
//             || defined(NPY_CPU_SH_BE)
//             || defined(NPY_CPU_MIPSEB)
//             || defined(NPY_CPU_OR1K)
//             || defined(NPY_CPU_M68K)
//             || defined(NPY_CPU_ARCEB)
//     #else
//         #error Unknown CPU: can not set endianness
//     #endif
// #endif

// #endif


// Parsed from npy_interrupt.h

/*
 * This API is only provided because it is part of publicly exported
 * headers. Its use is considered DEPRECATED, and it will be removed
 * eventually.
 * (This includes the _PyArray_SigintHandler and _PyArray_GetSigintBuf
 * functions which are however, public API, and not headers.)
 *
 * Instead of using these non-threadsafe macros consider periodically
 * querying `PyErr_CheckSignals()` or `PyOS_InterruptOccurred()` will work.
 * Both of these require holding the GIL, although cpython could add a
 * version of `PyOS_InterruptOccurred()` which does not. Such a version
 * actually exists as private API in Python 3.10, and backported to 3.9 and 3.8,
 * see also https://bugs.python.org/issue41037 and
 * https://github.com/python/cpython/pull/20599).
 */

// #ifndef NPY_INTERRUPT_H
// #define NPY_INTERRUPT_H

// #ifndef NPY_NO_SIGNAL

// #include <setjmp.h>
// #include <signal.h>

// #ifndef sigsetjmp

// #define NPY_SIGSETJMP(arg1, arg2) setjmp(arg1)
// #define NPY_SIGLONGJMP(arg1, arg2) longjmp(arg1, arg2)
// #define NPY_SIGJMP_BUF jmp_buf

// #else

// #define NPY_SIGSETJMP(arg1, arg2) sigsetjmp(arg1, arg2)
// #define NPY_SIGLONGJMP(arg1, arg2) siglongjmp(arg1, arg2)
// #define NPY_SIGJMP_BUF sigjmp_buf

// #endif

// #    define NPY_SIGINT_ON {
//                    PyOS_sighandler_t _npy_sig_save;
//                    _npy_sig_save = PyOS_setsig(SIGINT, _PyArray_SigintHandler);
//                    if (NPY_SIGSETJMP(*((NPY_SIGJMP_BUF *)_PyArray_GetSigintBuf()),
//                                  1) == 0) {                             

// #    define NPY_SIGINT_OFF }
//         PyOS_setsig(SIGINT, _npy_sig_save);
//         }

// #else /* NPY_NO_SIGNAL  */

// #define NPY_SIGINT_ON
// #define NPY_SIGINT_OFF

// #endif /* HAVE_SIGSETJMP */

// #endif /* NPY_INTERRUPT_H */


// Parsed from npy_math.h

// #ifndef __NPY_MATH_C99_H_
// #define __NPY_MATH_C99_H_

// #ifdef __cplusplus
// #endif

// #include <numpy/npy_common.h>

// #include <math.h>
// #ifdef __SUNPRO_CC
// #include <sunmath.h>
// #endif

/* By adding static inline specifiers to npy_math function definitions when
   appropriate, compiler is given the opportunity to optimize */
// #if NPY_INLINE_MATH
// #define NPY_INPLACE NPY_INLINE static
// #else
// #define NPY_INPLACE
// #endif


/*
 * NAN and INFINITY like macros (same behavior as glibc for NAN, same as C99
 * for INFINITY)
 *
 * XXX: I should test whether INFINITY and NAN are available on the platform
 */
@NoException public static native float __npy_inff();

@NoException public static native float __npy_nanf();

@NoException public static native float __npy_pzerof();

@NoException public static native float __npy_nzerof();

public static native @MemberGetter int NPY_INFINITYF();
public static final int NPY_INFINITYF = NPY_INFINITYF();
public static native @MemberGetter int NPY_NANF();
public static final int NPY_NANF = NPY_NANF();
public static native @MemberGetter int NPY_PZEROF();
public static final int NPY_PZEROF = NPY_PZEROF();
public static native @MemberGetter int NPY_NZEROF();
public static final int NPY_NZEROF = NPY_NZEROF();

public static native @MemberGetter int NPY_INFINITY();
public static final int NPY_INFINITY = NPY_INFINITY();
public static native @MemberGetter int NPY_NAN();
public static final int NPY_NAN = NPY_NAN();
public static native @MemberGetter int NPY_PZERO();
public static final int NPY_PZERO = NPY_PZERO();
public static native @MemberGetter int NPY_NZERO();
public static final int NPY_NZERO = NPY_NZERO();

public static native @MemberGetter int NPY_INFINITYL();
public static final int NPY_INFINITYL = NPY_INFINITYL();
public static native @MemberGetter int NPY_NANL();
public static final int NPY_NANL = NPY_NANL();
public static native @MemberGetter int NPY_PZEROL();
public static final int NPY_PZEROL = NPY_PZEROL();
public static native @MemberGetter int NPY_NZEROL();
public static final int NPY_NZEROL = NPY_NZEROL();

/*
 * Useful constants
 */
public static final double NPY_E =         2.718281828459045235360287471352662498;  /* e */
public static final double NPY_LOG2E =     1.442695040888963407359924681001892137;  /* log_2 e */
public static final double NPY_LOG10E =    0.434294481903251827651128918916605082;  /* log_10 e */
public static final double NPY_LOGE2 =     0.693147180559945309417232121458176568;  /* log_e 2 */
public static final double NPY_LOGE10 =    2.302585092994045684017991454684364208;  /* log_e 10 */
public static final double NPY_PI =        3.141592653589793238462643383279502884;  /* pi */
public static final double NPY_PI_2 =      1.570796326794896619231321691639751442;  /* pi/2 */
public static final double NPY_PI_4 =      0.785398163397448309615660845819875721;  /* pi/4 */
public static final double NPY_1_PI =      0.318309886183790671537767526745028724;  /* 1/pi */
public static final double NPY_2_PI =      0.636619772367581343075535053490057448;  /* 2/pi */
public static final double NPY_EULER =     0.577215664901532860606512090082402431;  /* Euler constant */
public static final double NPY_SQRT2 =     1.414213562373095048801688724209698079;  /* sqrt(2) */
public static final double NPY_SQRT1_2 =   0.707106781186547524400844362104849039;  /* 1/sqrt(2) */

public static final double NPY_Ef =        2.718281828459045235360287471352662498F; /* e */
public static final double NPY_LOG2Ef =    1.442695040888963407359924681001892137F; /* log_2 e */
public static final double NPY_LOG10Ef =   0.434294481903251827651128918916605082F; /* log_10 e */
public static final double NPY_LOGE2f =    0.693147180559945309417232121458176568F; /* log_e 2 */
public static final double NPY_LOGE10f =   2.302585092994045684017991454684364208F; /* log_e 10 */
public static final double NPY_PIf =       3.141592653589793238462643383279502884F; /* pi */
public static final double NPY_PI_2f =     1.570796326794896619231321691639751442F; /* pi/2 */
public static final double NPY_PI_4f =     0.785398163397448309615660845819875721F; /* pi/4 */
public static final double NPY_1_PIf =     0.318309886183790671537767526745028724F; /* 1/pi */
public static final double NPY_2_PIf =     0.636619772367581343075535053490057448F; /* 2/pi */
public static final double NPY_EULERf =    0.577215664901532860606512090082402431F; /* Euler constant */
public static final double NPY_SQRT2f =    1.414213562373095048801688724209698079F; /* sqrt(2) */
public static final double NPY_SQRT1_2f =  0.707106781186547524400844362104849039F; /* 1/sqrt(2) */

public static final double NPY_El =        2.718281828459045235360287471352662498; /* e */
public static final double NPY_LOG2El =    1.442695040888963407359924681001892137; /* log_2 e */
public static final double NPY_LOG10El =   0.434294481903251827651128918916605082; /* log_10 e */
public static final double NPY_LOGE2l =    0.693147180559945309417232121458176568; /* log_e 2 */
public static final double NPY_LOGE10l =   2.302585092994045684017991454684364208; /* log_e 10 */
public static final double NPY_PIl =       3.141592653589793238462643383279502884; /* pi */
public static final double NPY_PI_2l =     1.570796326794896619231321691639751442; /* pi/2 */
public static final double NPY_PI_4l =     0.785398163397448309615660845819875721; /* pi/4 */
public static final double NPY_1_PIl =     0.318309886183790671537767526745028724; /* 1/pi */
public static final double NPY_2_PIl =     0.636619772367581343075535053490057448; /* 2/pi */
public static final double NPY_EULERl =    0.577215664901532860606512090082402431; /* Euler constant */
public static final double NPY_SQRT2l =    1.414213562373095048801688724209698079; /* sqrt(2) */
public static final double NPY_SQRT1_2l =  0.707106781186547524400844362104849039; /* 1/sqrt(2) */

/*
 * Integer functions.
 */
@NoException public static native @Cast("npy_uint") int npy_gcdu(@Cast("npy_uint") int a, @Cast("npy_uint") int b);
@NoException public static native @Cast("npy_uint") int npy_lcmu(@Cast("npy_uint") int a, @Cast("npy_uint") int b);
@NoException public static native @Cast("npy_ulong") long npy_gcdul(@Cast("npy_ulong") long a, @Cast("npy_ulong") long b);
@NoException public static native @Cast("npy_ulong") long npy_lcmul(@Cast("npy_ulong") long a, @Cast("npy_ulong") long b);
@NoException public static native @Cast("npy_ulonglong") long npy_gcdull(@Cast("npy_ulonglong") long a, @Cast("npy_ulonglong") long b);
@NoException public static native @Cast("npy_ulonglong") long npy_lcmull(@Cast("npy_ulonglong") long a, @Cast("npy_ulonglong") long b);

@NoException public static native @Cast("npy_int") int npy_gcd(@Cast("npy_int") int a, @Cast("npy_int") int b);
@NoException public static native @Cast("npy_int") int npy_lcm(@Cast("npy_int") int a, @Cast("npy_int") int b);
@NoException public static native @Cast("npy_long") long npy_gcdl(@Cast("npy_long") long a, @Cast("npy_long") long b);
@NoException public static native @Cast("npy_long") long npy_lcml(@Cast("npy_long") long a, @Cast("npy_long") long b);
@NoException public static native @Cast("npy_longlong") long npy_gcdll(@Cast("npy_longlong") long a, @Cast("npy_longlong") long b);
@NoException public static native @Cast("npy_longlong") long npy_lcmll(@Cast("npy_longlong") long a, @Cast("npy_longlong") long b);

@NoException public static native @Cast("npy_ubyte") byte npy_rshiftuhh(@Cast("npy_ubyte") byte a, @Cast("npy_ubyte") byte b);
@NoException public static native @Cast("npy_ubyte") byte npy_lshiftuhh(@Cast("npy_ubyte") byte a, @Cast("npy_ubyte") byte b);
@NoException public static native @Cast("npy_ushort") short npy_rshiftuh(@Cast("npy_ushort") short a, @Cast("npy_ushort") short b);
@NoException public static native @Cast("npy_ushort") short npy_lshiftuh(@Cast("npy_ushort") short a, @Cast("npy_ushort") short b);
@NoException public static native @Cast("npy_uint") int npy_rshiftu(@Cast("npy_uint") int a, @Cast("npy_uint") int b);
@NoException public static native @Cast("npy_uint") int npy_lshiftu(@Cast("npy_uint") int a, @Cast("npy_uint") int b);
@NoException public static native @Cast("npy_ulong") long npy_rshiftul(@Cast("npy_ulong") long a, @Cast("npy_ulong") long b);
@NoException public static native @Cast("npy_ulong") long npy_lshiftul(@Cast("npy_ulong") long a, @Cast("npy_ulong") long b);
@NoException public static native @Cast("npy_ulonglong") long npy_rshiftull(@Cast("npy_ulonglong") long a, @Cast("npy_ulonglong") long b);
@NoException public static native @Cast("npy_ulonglong") long npy_lshiftull(@Cast("npy_ulonglong") long a, @Cast("npy_ulonglong") long b);

@NoException public static native @Cast("npy_byte") byte npy_rshifthh(@Cast("npy_byte") byte a, @Cast("npy_byte") byte b);
@NoException public static native @Cast("npy_byte") byte npy_lshifthh(@Cast("npy_byte") byte a, @Cast("npy_byte") byte b);
@NoException public static native @Cast("npy_short") short npy_rshifth(@Cast("npy_short") short a, @Cast("npy_short") short b);
@NoException public static native @Cast("npy_short") short npy_lshifth(@Cast("npy_short") short a, @Cast("npy_short") short b);
@NoException public static native @Cast("npy_int") int npy_rshift(@Cast("npy_int") int a, @Cast("npy_int") int b);
@NoException public static native @Cast("npy_int") int npy_lshift(@Cast("npy_int") int a, @Cast("npy_int") int b);
@NoException public static native @Cast("npy_long") long npy_rshiftl(@Cast("npy_long") long a, @Cast("npy_long") long b);
@NoException public static native @Cast("npy_long") long npy_lshiftl(@Cast("npy_long") long a, @Cast("npy_long") long b);
@NoException public static native @Cast("npy_longlong") long npy_rshiftll(@Cast("npy_longlong") long a, @Cast("npy_longlong") long b);
@NoException public static native @Cast("npy_longlong") long npy_lshiftll(@Cast("npy_longlong") long a, @Cast("npy_longlong") long b);

/*
 * avx function has a common API for both sin & cos. This enum is used to
 * distinguish between the two
 */
/** enum NPY_TRIG_OP */
public static final int
    npy_compute_sin = 0,
    npy_compute_cos = 1;

/*
 * C99 double math funcs
 */
@NoException public static native double npy_sin(double x);
@NoException public static native double npy_cos(double x);
@NoException public static native double npy_tan(double x);
@NoException public static native double npy_sinh(double x);
@NoException public static native double npy_cosh(double x);
@NoException public static native double npy_tanh(double x);

@NoException public static native double npy_asin(double x);
@NoException public static native double npy_acos(double x);
@NoException public static native double npy_atan(double x);

@NoException public static native double npy_log(double x);
@NoException public static native double npy_log10(double x);
@NoException public static native double npy_exp(double x);
@NoException public static native double npy_sqrt(double x);
@NoException public static native double npy_cbrt(double x);

@NoException public static native double npy_fabs(double x);
@NoException public static native double npy_ceil(double x);
@NoException public static native double npy_fmod(double x, double y);
@NoException public static native double npy_floor(double x);

@NoException public static native double npy_expm1(double x);
@NoException public static native double npy_log1p(double x);
@NoException public static native double npy_hypot(double x, double y);
@NoException public static native double npy_acosh(double x);
@NoException public static native double npy_asinh(double xx);
@NoException public static native double npy_atanh(double x);
@NoException public static native double npy_rint(double x);
@NoException public static native double npy_trunc(double x);
@NoException public static native double npy_exp2(double x);
@NoException public static native double npy_log2(double x);

@NoException public static native double npy_atan2(double x, double y);
@NoException public static native double npy_pow(double x, double y);
@NoException public static native double npy_modf(double x, DoublePointer y);
@NoException public static native double npy_modf(double x, DoubleBuffer y);
@NoException public static native double npy_modf(double x, double[] y);
@NoException public static native double npy_frexp(double x, IntPointer y);
@NoException public static native double npy_frexp(double x, IntBuffer y);
@NoException public static native double npy_frexp(double x, int[] y);
@NoException public static native double npy_ldexp(double n, int y);

@NoException public static native double npy_copysign(double x, double y);
@NoException public static native double npy_nextafter(double x, double y);
@NoException public static native double npy_spacing(double x);

/*
 * IEEE 754 fpu handling. Those are guaranteed to be macros
 */

/* use builtins to avoid function calls in tight loops
 * only available if npy_config.h is available (= numpys own build) */
// #if HAVE___BUILTIN_ISNAN
//     #define npy_isnan(x) __builtin_isnan(x)
// #else
//     #ifndef NPY_HAVE_DECL_ISNAN
//         #define npy_isnan(x) ((x) != (x))
//     #else
//     #endif
// #endif


/* only available if npy_config.h is available (= numpys own build) */
// #if HAVE___BUILTIN_ISFINITE
//     #define npy_isfinite(x) __builtin_isfinite(x)
// #else
//     #ifndef NPY_HAVE_DECL_ISFINITE
//         #ifdef _MSC_VER
//             #define npy_isfinite(x) _finite((x))
//         #else
//             #define npy_isfinite(x) !npy_isnan((x) + (-x))
//         #endif
//     #else
//     #endif
// #endif

/* only available if npy_config.h is available (= numpys own build) */
// #if HAVE___BUILTIN_ISINF
//     #define npy_isinf(x) __builtin_isinf(x)
// #else
//     #ifndef NPY_HAVE_DECL_ISINF
//         #define npy_isinf(x) (!npy_isfinite(x) && !npy_isnan(x))
//     #else
//     #endif
// #endif

// #ifndef NPY_HAVE_DECL_SIGNBIT
//     #define npy_signbit(x)
//         (sizeof (x) == sizeof (long double) ? _npy_signbit_ld (x)
//          : sizeof (x) == sizeof (double) ? _npy_signbit_d (x)
//          : _npy_signbit_f (x))
// #else
// #endif

/*
 * float C99 math functions
 */
@NoException public static native float npy_sinf(float x);
@NoException public static native float npy_cosf(float x);
@NoException public static native float npy_tanf(float x);
@NoException public static native float npy_sinhf(float x);
@NoException public static native float npy_coshf(float x);
@NoException public static native float npy_tanhf(float x);
@NoException public static native float npy_fabsf(float x);
@NoException public static native float npy_floorf(float x);
@NoException public static native float npy_ceilf(float x);
@NoException public static native float npy_rintf(float x);
@NoException public static native float npy_truncf(float x);
@NoException public static native float npy_sqrtf(float x);
@NoException public static native float npy_cbrtf(float x);
@NoException public static native float npy_log10f(float x);
@NoException public static native float npy_logf(float x);
@NoException public static native float npy_expf(float x);
@NoException public static native float npy_expm1f(float x);
@NoException public static native float npy_asinf(float x);
@NoException public static native float npy_acosf(float x);
@NoException public static native float npy_atanf(float x);
@NoException public static native float npy_asinhf(float x);
@NoException public static native float npy_acoshf(float x);
@NoException public static native float npy_atanhf(float x);
@NoException public static native float npy_log1pf(float x);
@NoException public static native float npy_exp2f(float x);
@NoException public static native float npy_log2f(float x);

@NoException public static native float npy_atan2f(float x, float y);
@NoException public static native float npy_hypotf(float x, float y);
@NoException public static native float npy_powf(float x, float y);
@NoException public static native float npy_fmodf(float x, float y);

@NoException public static native float npy_modff(float x, FloatPointer y);
@NoException public static native float npy_modff(float x, FloatBuffer y);
@NoException public static native float npy_modff(float x, float[] y);
@NoException public static native float npy_frexpf(float x, IntPointer y);
@NoException public static native float npy_frexpf(float x, IntBuffer y);
@NoException public static native float npy_frexpf(float x, int[] y);
@NoException public static native float npy_ldexpf(float x, int y);

@NoException public static native float npy_copysignf(float x, float y);
@NoException public static native float npy_nextafterf(float x, float y);
@NoException public static native float npy_spacingf(float x);

/*
 * long double C99 math functions
 */
@NoException public static native @Cast("npy_longdouble") double npy_sinl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_cosl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_tanl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_sinhl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_coshl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_tanhl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_fabsl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_floorl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_ceill(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_rintl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_truncl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_sqrtl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_cbrtl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_log10l(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_logl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_expl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_expm1l(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_asinl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_acosl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_atanl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_asinhl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_acoshl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_atanhl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_log1pl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_exp2l(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_log2l(@Cast("npy_longdouble") double x);

@NoException public static native @Cast("npy_longdouble") double npy_atan2l(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_hypotl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_powl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_fmodl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);

@NoException public static native @Cast("npy_longdouble") double npy_modfl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble*") DoublePointer y);
@NoException public static native @Cast("npy_longdouble") double npy_modfl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble*") DoubleBuffer y);
@NoException public static native @Cast("npy_longdouble") double npy_modfl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble*") double[] y);
@NoException public static native @Cast("npy_longdouble") double npy_frexpl(@Cast("npy_longdouble") double x, IntPointer y);
@NoException public static native @Cast("npy_longdouble") double npy_frexpl(@Cast("npy_longdouble") double x, IntBuffer y);
@NoException public static native @Cast("npy_longdouble") double npy_frexpl(@Cast("npy_longdouble") double x, int[] y);
@NoException public static native @Cast("npy_longdouble") double npy_ldexpl(@Cast("npy_longdouble") double x, int y);

@NoException public static native @Cast("npy_longdouble") double npy_copysignl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_nextafterl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_spacingl(@Cast("npy_longdouble") double x);

/*
 * Non standard functions
 */
@NoException public static native double npy_deg2rad(double x);
@NoException public static native double npy_rad2deg(double x);
@NoException public static native double npy_logaddexp(double x, double y);
@NoException public static native double npy_logaddexp2(double x, double y);
@NoException public static native double npy_divmod(double x, double y, DoublePointer modulus);
@NoException public static native double npy_divmod(double x, double y, DoubleBuffer modulus);
@NoException public static native double npy_divmod(double x, double y, double[] modulus);
@NoException public static native double npy_heaviside(double x, double h0);

@NoException public static native float npy_deg2radf(float x);
@NoException public static native float npy_rad2degf(float x);
@NoException public static native float npy_logaddexpf(float x, float y);
@NoException public static native float npy_logaddexp2f(float x, float y);
@NoException public static native float npy_divmodf(float x, float y, FloatPointer modulus);
@NoException public static native float npy_divmodf(float x, float y, FloatBuffer modulus);
@NoException public static native float npy_divmodf(float x, float y, float[] modulus);
@NoException public static native float npy_heavisidef(float x, float h0);

@NoException public static native @Cast("npy_longdouble") double npy_deg2radl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_rad2degl(@Cast("npy_longdouble") double x);
@NoException public static native @Cast("npy_longdouble") double npy_logaddexpl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_logaddexp2l(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
@NoException public static native @Cast("npy_longdouble") double npy_divmodl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y,
                           @Cast("npy_longdouble*") DoublePointer modulus);
@NoException public static native @Cast("npy_longdouble") double npy_divmodl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y,
                           @Cast("npy_longdouble*") DoubleBuffer modulus);
@NoException public static native @Cast("npy_longdouble") double npy_divmodl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y,
                           @Cast("npy_longdouble*") double[] modulus);
@NoException public static native @Cast("npy_longdouble") double npy_heavisidel(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double h0);

// #define npy_degrees npy_rad2deg
// #define npy_degreesf npy_rad2degf
// #define npy_degreesl npy_rad2degl

// #define npy_radians npy_deg2rad
// #define npy_radiansf npy_deg2radf
// #define npy_radiansl npy_deg2radl

/*
 * Complex declarations
 */

/*
 * C99 specifies that complex numbers have the same representation as
 * an array of two elements, where the first element is the real part
 * and the second element is the imaginary part.
 */
// #define __NPY_CPACK_IMP(x, y, type, ctype)
//     union {
//         ctype z;
//         type a[2];
//     } z1;;
// 
//     z1.a[0] = (x);
//     z1.a[1] = (y);
// 
//     return z1.z;

@NoException public static native @ByVal npy_cdouble npy_cpack(double x, double y);

@NoException public static native @ByVal npy_cfloat npy_cpackf(float x, float y);

@NoException public static native @ByVal npy_clongdouble npy_cpackl(@Cast("npy_longdouble") double x, @Cast("npy_longdouble") double y);
// #undef __NPY_CPACK_IMP

/*
 * Same remark as above, but in the other direction: extract first/second
 * member of complex number, assuming a C99-compatible representation
 *
 * Those are defineds as static inline, and such as a reasonable compiler would
 * most likely compile this to one or two instructions (on CISC at least)
 */
// #define __NPY_CEXTRACT_IMP(z, index, type, ctype)
//     union {
//         ctype z;
//         type a[2];
//     } __z_repr;
//     __z_repr.z = z;
// 
//     return __z_repr.a[index];

@NoException public static native double npy_creal(@ByVal npy_cdouble z);

@NoException public static native double npy_cimag(@ByVal npy_cdouble z);

@NoException public static native float npy_crealf(@ByVal npy_cfloat z);

@NoException public static native float npy_cimagf(@ByVal npy_cfloat z);

@NoException public static native @Cast("npy_longdouble") double npy_creall(@ByVal npy_clongdouble z);

@NoException public static native @Cast("npy_longdouble") double npy_cimagl(@ByVal npy_clongdouble z);
// #undef __NPY_CEXTRACT_IMP

/*
 * Double precision complex functions
 */
@NoException public static native double npy_cabs(@ByVal npy_cdouble z);
@NoException public static native double npy_carg(@ByVal npy_cdouble z);

@NoException public static native @ByVal npy_cdouble npy_cexp(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_clog(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_cpow(@ByVal npy_cdouble x, @ByVal npy_cdouble y);

@NoException public static native @ByVal npy_cdouble npy_csqrt(@ByVal npy_cdouble z);

@NoException public static native @ByVal npy_cdouble npy_ccos(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_csin(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_ctan(@ByVal npy_cdouble z);

@NoException public static native @ByVal npy_cdouble npy_ccosh(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_csinh(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_ctanh(@ByVal npy_cdouble z);

@NoException public static native @ByVal npy_cdouble npy_cacos(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_casin(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_catan(@ByVal npy_cdouble z);

@NoException public static native @ByVal npy_cdouble npy_cacosh(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_casinh(@ByVal npy_cdouble z);
@NoException public static native @ByVal npy_cdouble npy_catanh(@ByVal npy_cdouble z);

/*
 * Single precision complex functions
 */
@NoException public static native float npy_cabsf(@ByVal npy_cfloat z);
@NoException public static native float npy_cargf(@ByVal npy_cfloat z);

@NoException public static native @ByVal npy_cfloat npy_cexpf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_clogf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_cpowf(@ByVal npy_cfloat x, @ByVal npy_cfloat y);

@NoException public static native @ByVal npy_cfloat npy_csqrtf(@ByVal npy_cfloat z);

@NoException public static native @ByVal npy_cfloat npy_ccosf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_csinf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_ctanf(@ByVal npy_cfloat z);

@NoException public static native @ByVal npy_cfloat npy_ccoshf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_csinhf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_ctanhf(@ByVal npy_cfloat z);

@NoException public static native @ByVal npy_cfloat npy_cacosf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_casinf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_catanf(@ByVal npy_cfloat z);

@NoException public static native @ByVal npy_cfloat npy_cacoshf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_casinhf(@ByVal npy_cfloat z);
@NoException public static native @ByVal npy_cfloat npy_catanhf(@ByVal npy_cfloat z);


/*
 * Extended precision complex functions
 */
@NoException public static native @Cast("npy_longdouble") double npy_cabsl(@ByVal npy_clongdouble z);
@NoException public static native @Cast("npy_longdouble") double npy_cargl(@ByVal npy_clongdouble z);

@NoException public static native @ByVal npy_clongdouble npy_cexpl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_clogl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_cpowl(@ByVal npy_clongdouble x, @ByVal npy_clongdouble y);

@NoException public static native @ByVal npy_clongdouble npy_csqrtl(@ByVal npy_clongdouble z);

@NoException public static native @ByVal npy_clongdouble npy_ccosl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_csinl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_ctanl(@ByVal npy_clongdouble z);

@NoException public static native @ByVal npy_clongdouble npy_ccoshl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_csinhl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_ctanhl(@ByVal npy_clongdouble z);

@NoException public static native @ByVal npy_clongdouble npy_cacosl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_casinl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_catanl(@ByVal npy_clongdouble z);

@NoException public static native @ByVal npy_clongdouble npy_cacoshl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_casinhl(@ByVal npy_clongdouble z);
@NoException public static native @ByVal npy_clongdouble npy_catanhl(@ByVal npy_clongdouble z);


/*
 * Functions that set the floating point error
 * status word.
 */

/*
 * platform-dependent code translates floating point
 * status to an integer sum of these values
 */
public static final int NPY_FPE_DIVIDEBYZERO =  1;
public static final int NPY_FPE_OVERFLOW =      2;
public static final int NPY_FPE_UNDERFLOW =     4;
public static final int NPY_FPE_INVALID =       8;

@NoException public static native int npy_clear_floatstatus_barrier(@Cast("char*") BytePointer arg0);
@NoException public static native int npy_clear_floatstatus_barrier(@Cast("char*") ByteBuffer arg0);
@NoException public static native int npy_clear_floatstatus_barrier(@Cast("char*") byte[] arg0);
@NoException public static native int npy_get_floatstatus_barrier(@Cast("char*") BytePointer arg0);
@NoException public static native int npy_get_floatstatus_barrier(@Cast("char*") ByteBuffer arg0);
@NoException public static native int npy_get_floatstatus_barrier(@Cast("char*") byte[] arg0);
/*
 * use caution with these - clang and gcc8.1 are known to reorder calls
 * to this form of the function which can defeat the check. The _barrier
 * form of the call is preferable, where the argument is
 * (char*)&local_variable
 */
@NoException public static native int npy_clear_floatstatus();
@NoException public static native int npy_get_floatstatus();

@NoException public static native void npy_set_floatstatus_divbyzero();
@NoException public static native void npy_set_floatstatus_overflow();
@NoException public static native void npy_set_floatstatus_underflow();
@NoException public static native void npy_set_floatstatus_invalid();

// #ifdef __cplusplus
// #endif

// #if NPY_INLINE_MATH
// #include "npy_math_internal.h"
// #endif

// #endif


// Parsed from halffloat.h

// #ifndef __NPY_HALFFLOAT_H__
// #define __NPY_HALFFLOAT_H__

// #include <Python.h>
// #include <numpy/npy_math.h>

// #ifdef __cplusplus
// #endif

/*
 * Half-precision routines
 */

/* Conversions */
@NoException public static native float npy_half_to_float(@Cast("npy_half") short h);
@NoException public static native double npy_half_to_double(@Cast("npy_half") short h);
@NoException public static native @Cast("npy_half") short npy_float_to_half(float f);
@NoException public static native @Cast("npy_half") short npy_double_to_half(double d);
/* Comparisons */
@NoException public static native int npy_half_eq(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_ne(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_le(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_lt(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_ge(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_gt(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
/* faster *_nonan variants for when you know h1 and h2 are not NaN */
@NoException public static native int npy_half_eq_nonan(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_lt_nonan(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
@NoException public static native int npy_half_le_nonan(@Cast("npy_half") short h1, @Cast("npy_half") short h2);
/* Miscellaneous functions */
@NoException public static native int npy_half_iszero(@Cast("npy_half") short h);
@NoException public static native int npy_half_isnan(@Cast("npy_half") short h);
@NoException public static native int npy_half_isinf(@Cast("npy_half") short h);
@NoException public static native int npy_half_isfinite(@Cast("npy_half") short h);
@NoException public static native int npy_half_signbit(@Cast("npy_half") short h);
@NoException public static native @Cast("npy_half") short npy_half_copysign(@Cast("npy_half") short x, @Cast("npy_half") short y);
@NoException public static native @Cast("npy_half") short npy_half_spacing(@Cast("npy_half") short h);
@NoException public static native @Cast("npy_half") short npy_half_nextafter(@Cast("npy_half") short x, @Cast("npy_half") short y);
@NoException public static native @Cast("npy_half") short npy_half_divmod(@Cast("npy_half") short x, @Cast("npy_half") short y, @Cast("npy_half*") ShortPointer modulus);
@NoException public static native @Cast("npy_half") short npy_half_divmod(@Cast("npy_half") short x, @Cast("npy_half") short y, @Cast("npy_half*") ShortBuffer modulus);
@NoException public static native @Cast("npy_half") short npy_half_divmod(@Cast("npy_half") short x, @Cast("npy_half") short y, @Cast("npy_half*") short[] modulus);

/*
 * Half-precision constants
 */

public static final int NPY_HALF_ZERO =   (0x0000);
public static final int NPY_HALF_PZERO =  (0x0000);
public static final int NPY_HALF_NZERO =  (0x8000);
public static final int NPY_HALF_ONE =    (0x3c00);
public static final int NPY_HALF_NEGONE = (0xbc00);
public static final int NPY_HALF_PINF =   (0x7c00);
public static final int NPY_HALF_NINF =   (0xfc00);
public static final int NPY_HALF_NAN =    (0x7e00);

public static final int NPY_MAX_HALF =    (0x7bff);

/*
 * Bit-level conversions
 */

@NoException public static native @Cast("npy_uint16") short npy_floatbits_to_halfbits(@Cast("npy_uint32") int f);
@NoException public static native @Cast("npy_uint16") short npy_doublebits_to_halfbits(@Cast("npy_uint64") long d);
@NoException public static native @Cast("npy_uint32") int npy_halfbits_to_floatbits(@Cast("npy_uint16") short h);
@NoException public static native @Cast("npy_uint64") long npy_halfbits_to_doublebits(@Cast("npy_uint16") short h);

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from utils.h

// #ifndef __NUMPY_UTILS_HEADER__
// #define __NUMPY_UTILS_HEADER__

// #ifndef __COMP_NPY_UNUSED
//     #if defined(__GNUC__)
//         #define __COMP_NPY_UNUSED __attribute__ ((__unused__))
//     #elif defined(__ICC)
//         #define __COMP_NPY_UNUSED __attribute__ ((__unused__))
//     #elif defined(__clang__)
//         #define __COMP_NPY_UNUSED __attribute__ ((unused))
//     #else
//         #define __COMP_NPY_UNUSED
//     #endif
// #endif

// #if defined(__GNUC__) || defined(__ICC) || defined(__clang__)
//     #define NPY_DECL_ALIGNED(x) __attribute__ ((aligned (x)))
// #elif defined(_MSC_VER)
//     #define NPY_DECL_ALIGNED(x) __declspec(align(x))
// #else
//     #define NPY_DECL_ALIGNED(x)
// #endif

/* Use this to tag a variable as not used. It will remove unused variable
 * warning on support platforms (see __COM_NPY_UNUSED) and mangle the variable
 * to avoid accidental use */
// #define NPY_UNUSED(x) (__NPY_UNUSED_TAGGED ## x) __COMP_NPY_UNUSED
// #define NPY_EXPAND(x) x

// #define NPY_STRINGIFY(x) #x
// #define NPY_TOSTRING(x) NPY_STRINGIFY(x)

// #define NPY_CAT__(a, b) a ## b
// #define NPY_CAT_(a, b) NPY_CAT__(a, b)
// #define NPY_CAT(a, b) NPY_CAT_(a, b)

// #endif


// Parsed from arrayobject.h

// #ifndef Py_ARRAYOBJECT_H
// #define Py_ARRAYOBJECT_H

// #include "ndarrayobject.h"
// #include "npy_interrupt.h"

// #ifdef NPY_NO_PREFIX
// #include "noprefix.h"
// #endif

// #endif


// Parsed from arrayscalars.h

// #ifndef _NPY_ARRAYSCALARS_H_
// #define _NPY_ARRAYSCALARS_H_
// Targeting ../PyBoolScalarObject.java


// Targeting ../PyByteScalarObject.java


// Targeting ../PyShortScalarObject.java


// Targeting ../PyIntScalarObject.java


// Targeting ../PyLongScalarObject.java


// Targeting ../PyLongLongScalarObject.java


// Targeting ../PyUByteScalarObject.java


// Targeting ../PyUShortScalarObject.java


// Targeting ../PyUIntScalarObject.java


// Targeting ../PyULongScalarObject.java


// Targeting ../PyULongLongScalarObject.java


// Targeting ../PyHalfScalarObject.java


// Targeting ../PyFloatScalarObject.java


// Targeting ../PyDoubleScalarObject.java


// Targeting ../PyLongDoubleScalarObject.java


// Targeting ../PyCFloatScalarObject.java


// Targeting ../PyCDoubleScalarObject.java


// Targeting ../PyCLongDoubleScalarObject.java


// Targeting ../PyObjectScalarObject.java


// Targeting ../PyDatetimeScalarObject.java


// Targeting ../PyTimedeltaScalarObject.java


// Targeting ../PyScalarObject.java



// #define PyStringScalarObject PyBytesObject
// Targeting ../PyUnicodeScalarObject.java


// Targeting ../PyVoidScalarObject.java



/* Macros
     Py<Cls><bitsize>ScalarObject
     Py<Cls><bitsize>ArrType_Type
   are defined in ndarrayobject.h
*/

// #define PyArrayScalar_False ((PyObject *)(&(_PyArrayScalar_BoolValues[0])))
// #define PyArrayScalar_True ((PyObject *)(&(_PyArrayScalar_BoolValues[1])))
// #define PyArrayScalar_FromLong(i)
//         ((PyObject *)(&(_PyArrayScalar_BoolValues[((i)!=0)])))
// #define PyArrayScalar_RETURN_BOOL_FROM_LONG(i)
//         return Py_INCREF(PyArrayScalar_FromLong(i)),
//                 PyArrayScalar_FromLong(i)
// #define PyArrayScalar_RETURN_FALSE
//         return Py_INCREF(PyArrayScalar_False),
//                 PyArrayScalar_False
// #define PyArrayScalar_RETURN_TRUE
//         return Py_INCREF(PyArrayScalar_True),
//                 PyArrayScalar_True

// #define PyArrayScalar_New(cls)
//         Py##cls##ArrType_Type.tp_alloc(&Py##cls##ArrType_Type, 0)
// #define PyArrayScalar_VAL(obj, cls)
//         ((Py##cls##ScalarObject *)obj)->obval
// #define PyArrayScalar_ASSIGN(obj, cls, val)
//         PyArrayScalar_VAL(obj, cls) = val

// #endif


// Parsed from ndarraytypes.h

// #ifndef NDARRAYTYPES_H
// #define NDARRAYTYPES_H

// #include "npy_common.h"
// #include "npy_endian.h"
// #include "npy_cpu.h"
// #include "utils.h"

// #define NPY_NO_EXPORT NPY_VISIBILITY_HIDDEN

/* Only use thread if configured in config and python supports it */
// #if defined WITH_THREAD && !NPY_NO_SMP
        public static final int NPY_ALLOW_THREADS = 1;
// #else
// #endif

// #ifndef __has_extension
// #define __has_extension(x) 0
// #endif

// #if !defined(_NPY_NO_DEPRECATIONS) &&
//     ((defined(__GNUC__)&& __GNUC__ >= 6) ||
//      __has_extension(attribute_deprecated_with_message))
// #define NPY_ATTR_DEPRECATE(text) __attribute__ ((deprecated (text)))
// #else
// #define NPY_ATTR_DEPRECATE(text)
// #endif

/*
 * There are several places in the code where an array of dimensions
 * is allocated statically.  This is the size of that static
 * allocation.
 *
 * The array creation itself could have arbitrary dimensions but all
 * the places where static allocation is used would need to be changed
 * to dynamic (including inside of several structures)
 */

public static final int NPY_MAXDIMS = 32;
public static final int NPY_MAXARGS = 32;

/* Used for Converter Functions "O&" code in ParseTuple */
public static final int NPY_FAIL = 0;
public static final int NPY_SUCCEED = 1;

/*
 * Binary compatibility version number.  This number is increased
 * whenever the C-API is changed such that binary compatibility is
 * broken, i.e. whenever a recompile of extension modules is needed.
 */
public static final int NPY_VERSION = NPY_ABI_VERSION;

/*
 * Minor API version.  This number is increased whenever a change is
 * made to the C-API -- whether it breaks binary compatibility or not.
 * Some changes, such as adding a function pointer to the end of the
 * function table, can be made without breaking binary compatibility.
 * In this case, only the NPY_FEATURE_VERSION (*not* NPY_VERSION)
 * would be increased.  Whenever binary compatibility is broken, both
 * NPY_VERSION and NPY_FEATURE_VERSION should be increased.
 */
public static final int NPY_FEATURE_VERSION = NPY_API_VERSION;

/** enum NPY_TYPES */
public static final int    NPY_BOOL = 0,
                    NPY_BYTE = 1, NPY_UBYTE = 2,
                    NPY_SHORT = 3, NPY_USHORT = 4,
                    NPY_INT = 5, NPY_UINT = 6,
                    NPY_LONG = 7, NPY_ULONG = 8,
                    NPY_LONGLONG = 9, NPY_ULONGLONG = 10,
                    NPY_FLOAT = 11, NPY_DOUBLE = 12, NPY_LONGDOUBLE = 13,
                    NPY_CFLOAT = 14, NPY_CDOUBLE = 15, NPY_CLONGDOUBLE = 16,
                    NPY_OBJECT = 17,
                    NPY_STRING = 18, NPY_UNICODE = 19,
                    NPY_VOID = 20,
                    /*
                     * New 1.6 types appended, may be integrated
                     * into the above in 2.0.
                     */
                    NPY_DATETIME = 21, NPY_TIMEDELTA = 22, NPY_HALF = 23,

                    NPY_NTYPES = 24,
                    NPY_NOTYPE = 25,
                    NPY_CHAR = 26,
                    NPY_USERDEF = 256,  /* leave room for characters */

                    /* The number of types not including the new 1.6 types */
                    NPY_NTYPES_ABI_COMPATIBLE = 21;
// #ifdef _MSC_VER
// #pragma deprecated(NPY_CHAR)
// #endif

/* basetype array priority */
public static final double NPY_PRIORITY = 0.0;

/* default subtype priority */
public static final double NPY_SUBTYPE_PRIORITY = 1.0;

/* default scalar priority */
public static final double NPY_SCALAR_PRIORITY = -1000000.0;

/* How many floating point types are there (excluding half) */
public static final int NPY_NUM_FLOATTYPE = 3;

/*
 * These characters correspond to the array type and the struct
 * module
 */

/** enum NPY_TYPECHAR */
public static final int
        NPY_BOOLLTR = '?',
        NPY_BYTELTR = 'b',
        NPY_UBYTELTR = 'B',
        NPY_SHORTLTR = 'h',
        NPY_USHORTLTR = 'H',
        NPY_INTLTR = 'i',
        NPY_UINTLTR = 'I',
        NPY_LONGLTR = 'l',
        NPY_ULONGLTR = 'L',
        NPY_LONGLONGLTR = 'q',
        NPY_ULONGLONGLTR = 'Q',
        NPY_HALFLTR = 'e',
        NPY_FLOATLTR = 'f',
        NPY_DOUBLELTR = 'd',
        NPY_LONGDOUBLELTR = 'g',
        NPY_CFLOATLTR = 'F',
        NPY_CDOUBLELTR = 'D',
        NPY_CLONGDOUBLELTR = 'G',
        NPY_OBJECTLTR = 'O',
        NPY_STRINGLTR = 'S',
        NPY_STRINGLTR2 = 'a',
        NPY_UNICODELTR = 'U',
        NPY_VOIDLTR = 'V',
        NPY_DATETIMELTR = 'M',
        NPY_TIMEDELTALTR = 'm',
        NPY_CHARLTR = 'c',

        /*
         * No Descriptor, just a define -- this let's
         * Python users specify an array of integers
         * large enough to hold a pointer on the
         * platform
         */
        NPY_INTPLTR = 'p',
        NPY_UINTPLTR = 'P',

        /*
         * These are for dtype 'kinds', not dtype 'typecodes'
         * as the above are for.
         */
        NPY_GENBOOLLTR = 'b',
        NPY_SIGNEDLTR = 'i',
        NPY_UNSIGNEDLTR = 'u',
        NPY_FLOATINGLTR = 'f',
        NPY_COMPLEXLTR = 'c';

/*
 * Changing this may break Numpy API compatibility
 * due to changing offsets in PyArray_ArrFuncs, so be
 * careful. Here we have reused the mergesort slot for
 * any kind of stable sort, the actual implementation will
 * depend on the data type.
 */
/** enum NPY_SORTKIND */
public static final int
        NPY_QUICKSORT = 0,
        NPY_HEAPSORT = 1,
        NPY_MERGESORT = 2,
        NPY_STABLESORT = 2;
public static final int NPY_NSORTS = (NPY_STABLESORT + 1);


/** enum NPY_SELECTKIND */
public static final int
        NPY_INTROSELECT = 0;
public static final int NPY_NSELECTS = (NPY_INTROSELECT + 1);


/** enum NPY_SEARCHSIDE */
public static final int
        NPY_SEARCHLEFT = 0,
        NPY_SEARCHRIGHT = 1;
public static final int NPY_NSEARCHSIDES = (NPY_SEARCHRIGHT + 1);


/** enum NPY_SCALARKIND */
public static final int
        NPY_NOSCALAR = -1,
        NPY_BOOL_SCALAR = 0,
        NPY_INTPOS_SCALAR = 1,
        NPY_INTNEG_SCALAR = 2,
        NPY_FLOAT_SCALAR = 3,
        NPY_COMPLEX_SCALAR = 4,
        NPY_OBJECT_SCALAR = 5;
public static final int NPY_NSCALARKINDS = (NPY_OBJECT_SCALAR + 1);

/* For specifying array memory layout or iteration order */
/** enum NPY_ORDER */
public static final int
        /* Fortran order if inputs are all Fortran, C otherwise */
        NPY_ANYORDER = -1,
        /* C order */
        NPY_CORDER = 0,
        /* Fortran order */
        NPY_FORTRANORDER = 1,
        /* An order as close to the inputs as possible */
        NPY_KEEPORDER = 2;

/* For specifying allowed casting in operations which support it */
/** enum NPY_CASTING */
public static final int
        _NPY_ERROR_OCCURRED_IN_CAST = -1,
        /* Only allow identical types */
        NPY_NO_CASTING = 0,
        /* Allow identical and byte swapped types */
        NPY_EQUIV_CASTING = 1,
        /* Only allow safe casts */
        NPY_SAFE_CASTING = 2,
        /* Allow safe casts or casts within the same kind */
        NPY_SAME_KIND_CASTING = 3,
        /* Allow any casts */
        NPY_UNSAFE_CASTING = 4,
        /*
         * Flag to allow signalling that a cast is a view, this flag is not
         * valid when requesting a cast of specific safety.
         * _NPY_CAST_IS_VIEW|NPY_EQUIV_CASTING means the same as NPY_NO_CASTING.
         */
        // TODO-DTYPES: Needs to be documented.
        _NPY_CAST_IS_VIEW = 1 << 16;

/** enum NPY_CLIPMODE */
public static final int
        NPY_CLIP = 0,
        NPY_WRAP = 1,
        NPY_RAISE = 2;

/* The special not-a-time (NaT) value */
public static native @MemberGetter long NPY_DATETIME_NAT();
public static final long NPY_DATETIME_NAT = NPY_DATETIME_NAT();

/*
 * Upper bound on the length of a DATETIME ISO 8601 string
 *   YEAR: 21 (64-bit year)
 *   MONTH: 3
 *   DAY: 3
 *   HOURS: 3
 *   MINUTES: 3
 *   SECONDS: 3
 *   ATTOSECONDS: 1 + 3*6
 *   TIMEZONE: 5
 *   NULL TERMINATOR: 1
 */
public static final int NPY_DATETIME_MAX_ISO8601_STRLEN = (21 + 3*5 + 1 + 3*6 + 6 + 1);

/* The FR in the unit names stands for frequency */
/** enum NPY_DATETIMEUNIT */
public static final int
        /* Force signed enum type, must be -1 for code compatibility */
        NPY_FR_ERROR = -1,      /* error or undetermined */

        /* Start of valid units */
        NPY_FR_Y = 0,           /* Years */
        NPY_FR_M = 1,           /* Months */
        NPY_FR_W = 2,           /* Weeks */
        /* Gap where 1.6 NPY_FR_B (value 3) was */
        NPY_FR_D = 4,           /* Days */
        NPY_FR_h = 5,           /* hours */
        NPY_FR_m = 6,           /* minutes */
        NPY_FR_s = 7,           /* seconds */
        NPY_FR_ms = 8,          /* milliseconds */
        NPY_FR_us = 9,          /* microseconds */
        NPY_FR_ns = 10,         /* nanoseconds */
        NPY_FR_ps = 11,         /* picoseconds */
        NPY_FR_fs = 12,         /* femtoseconds */
        NPY_FR_as = 13,         /* attoseconds */
        NPY_FR_GENERIC = 14;     /* unbound units, can convert to anything */

/*
 * NOTE: With the NPY_FR_B gap for 1.6 ABI compatibility, NPY_DATETIME_NUMUNITS
 * is technically one more than the actual number of units.
 */
public static final int NPY_DATETIME_NUMUNITS = (NPY_FR_GENERIC + 1);
public static final int NPY_DATETIME_DEFAULTUNIT = NPY_FR_GENERIC;

/*
 * Business day conventions for mapping invalid business
 * days to valid business days.
 */
/** enum NPY_BUSDAY_ROLL */
public static final int
    /* Go forward in time to the following business day. */
    NPY_BUSDAY_FORWARD = 0,
    NPY_BUSDAY_FOLLOWING = NPY_BUSDAY_FORWARD,
    /* Go backward in time to the preceding business day. */
    NPY_BUSDAY_BACKWARD = NPY_BUSDAY_FORWARD + 1,
    NPY_BUSDAY_PRECEDING = NPY_BUSDAY_BACKWARD,
    /*
     * Go forward in time to the following business day, unless it
     * crosses a month boundary, in which case go backward
     */
    NPY_BUSDAY_MODIFIEDFOLLOWING = NPY_BUSDAY_BACKWARD + 1,
    /*
     * Go backward in time to the preceding business day, unless it
     * crosses a month boundary, in which case go forward.
     */
    NPY_BUSDAY_MODIFIEDPRECEDING = NPY_BUSDAY_BACKWARD + 2,
    /* Produce a NaT for non-business days. */
    NPY_BUSDAY_NAT = NPY_BUSDAY_BACKWARD + 3,
    /* Raise an exception for non-business days. */
    NPY_BUSDAY_RAISE = NPY_BUSDAY_BACKWARD + 4;

/************************************************************
 * NumPy Auxiliary Data for inner loops, sort functions, etc.
 ************************************************************/

/*
 * When creating an auxiliary data struct, this should always appear
 * as the first member, like this:
 *
 * typedef struct {
 *     NpyAuxData base;
 *     double constant;
 * } constant_multiplier_aux_data;
 */
// Targeting ../NpyAuxData_FreeFunc.java


// Targeting ../NpyAuxData_CloneFunc.java


// Targeting ../NpyAuxData.java



/* Macros to use for freeing and cloning auxiliary data */
// #define NPY_AUXDATA_FREE(auxdata)
//     do {
//         if ((auxdata) != NULL) {
//             (auxdata)->free(auxdata);
//         }
//     } while(0)
// #define NPY_AUXDATA_CLONE(auxdata)
//     ((auxdata)->clone(auxdata))

// #define NPY_ERR(str) fprintf(stderr, #str); fflush(stderr);
// #define NPY_ERR2(str) fprintf(stderr, str); fflush(stderr);

  /*
   * Macros to define how array, and dimension/strides data is
   * allocated.
   */

  /* Data buffer - PyDataMem_NEW/FREE/RENEW are in multiarraymodule.c */

public static final int NPY_USE_PYMEM = 1;


// #if NPY_USE_PYMEM == 1
/* use the Raw versions which are safe to call with the GIL released */
// #define PyArray_malloc PyMem_RawMalloc
// #define PyArray_free PyMem_RawFree
// #define PyArray_realloc PyMem_RawRealloc
// #else
// #define PyArray_malloc malloc
// #define PyArray_free free
// #define PyArray_realloc realloc
// #endif

/* Dimensions and strides */
// #define PyDimMem_NEW(size)
//     ((npy_intp *)PyArray_malloc(size*sizeof(npy_intp)))

// #define PyDimMem_FREE(ptr) PyArray_free(ptr)

// #define PyDimMem_RENEW(ptr,size)
//         ((npy_intp *)PyArray_realloc(ptr,size*sizeof(npy_intp)))
// Targeting ../_PyArray_Descr.java


// Targeting ../PyArray_GetItemFunc.java


// Targeting ../PyArray_SetItemFunc.java


// Targeting ../PyArray_CopySwapNFunc.java


// Targeting ../PyArray_CopySwapFunc.java


// Targeting ../PyArray_NonzeroFunc.java


// Targeting ../PyArray_CompareFunc.java


// Targeting ../PyArray_ArgFunc.java


// Targeting ../PyArray_DotFunc.java


// Targeting ../PyArray_VectorUnaryFunc.java


// Targeting ../PyArray_ScanFunc.java


// Targeting ../PyArray_FromStrFunc.java


// Targeting ../PyArray_FillFunc.java


// Targeting ../PyArray_SortFunc.java


// Targeting ../PyArray_ArgSortFunc.java


// Targeting ../PyArray_PartitionFunc.java


// Targeting ../PyArray_ArgPartitionFunc.java


// Targeting ../PyArray_FillWithScalarFunc.java


// Targeting ../PyArray_ScalarKindFunc.java


// Targeting ../PyArray_FastClipFunc.java


// Targeting ../PyArray_FastPutmaskFunc.java


// Targeting ../PyArray_FastTakeFunc.java


// Targeting ../PyArray_Dims.java


// Targeting ../PyArray_ArrFuncs.java



/* The item must be reference counted when it is inserted or extracted. */
public static final int NPY_ITEM_REFCOUNT =   0x01;
/* Same as needing REFCOUNT */
public static final int NPY_ITEM_HASOBJECT =  0x01;
/* Convert to list for pickling */
public static final int NPY_LIST_PICKLE =     0x02;
/* The item is a POINTER  */
public static final int NPY_ITEM_IS_POINTER = 0x04;
/* memory needs to be initialized for this data-type */
public static final int NPY_NEEDS_INIT =      0x08;
/* operations need Python C-API so don't give-up thread. */
public static final int NPY_NEEDS_PYAPI =     0x10;
/* Use f.getitem when extracting elements of this data-type */
public static final int NPY_USE_GETITEM =     0x20;
/* Use f.setitem when setting creating 0-d array from this data-type.*/
public static final int NPY_USE_SETITEM =     0x40;
/* A sticky flag specifically for structured arrays */
public static final int NPY_ALIGNED_STRUCT =  0x80;

/*
 *These are inherited for global data-type if any data-types in the
 * field have them
 */
public static final int NPY_FROM_FIELDS =    (NPY_NEEDS_INIT | NPY_LIST_PICKLE | 
                            NPY_ITEM_REFCOUNT | NPY_NEEDS_PYAPI);

public static final int NPY_OBJECT_DTYPE_FLAGS = (NPY_LIST_PICKLE | NPY_USE_GETITEM | 
                                NPY_ITEM_IS_POINTER | NPY_ITEM_REFCOUNT | 
                                NPY_NEEDS_INIT | NPY_NEEDS_PYAPI);

// #define PyDataType_FLAGCHK(dtype, flag)
//         (((dtype)->flags & (flag)) == (flag))

// #define PyDataType_REFCHK(dtype)
//         PyDataType_FLAGCHK(dtype, NPY_ITEM_REFCOUNT)
// Targeting ../PyArray_Descr.java


// Targeting ../PyArray_ArrayDescr.java


// Targeting ../PyArrayObject.java



/*
 * To hide the implementation details, we only expose
 * the Python struct HEAD.
 */
// #if !defined(NPY_NO_DEPRECATED_API) ||
//     (NPY_NO_DEPRECATED_API < NPY_1_7_API_VERSION)
/*
 * Can't put this in npy_deprecated_api.h like the others.
 * PyArrayObject field access is deprecated as of NumPy 1.7.
 */
// #else
// Targeting ../PyArrayFlagsObject.java


// Targeting ../PyArray_Chunk.java


// Targeting ../PyArray_DatetimeMetaData.java


// Targeting ../PyArray_DatetimeDTypeMetaData.java


// Targeting ../npy_datetimestruct.java


// Targeting ../npy_timedeltastruct.java


// Targeting ../PyArray_FinalizeFunc.java



/*
 * Means c-style contiguous (last index varies the fastest). The data
 * elements right after each other.
 *
 * This flag may be requested in constructor functions.
 * This flag may be tested for in PyArray_FLAGS(arr).
 */
public static final int NPY_ARRAY_C_CONTIGUOUS =    0x0001;

/*
 * Set if array is a contiguous Fortran array: the first index varies
 * the fastest in memory (strides array is reverse of C-contiguous
 * array)
 *
 * This flag may be requested in constructor functions.
 * This flag may be tested for in PyArray_FLAGS(arr).
 */
public static final int NPY_ARRAY_F_CONTIGUOUS =    0x0002;

/*
 * Note: all 0-d arrays are C_CONTIGUOUS and F_CONTIGUOUS. If a
 * 1-d array is C_CONTIGUOUS it is also F_CONTIGUOUS. Arrays with
 * more then one dimension can be C_CONTIGUOUS and F_CONTIGUOUS
 * at the same time if they have either zero or one element.
 * If NPY_RELAXED_STRIDES_CHECKING is set, a higher dimensional
 * array is always C_CONTIGUOUS and F_CONTIGUOUS if it has zero elements
 * and the array is contiguous if ndarray.squeeze() is contiguous.
 * I.e. dimensions for which `ndarray.shape[dimension] == 1` are
 * ignored.
 */

/*
 * If set, the array owns the data: it will be free'd when the array
 * is deleted.
 *
 * This flag may be tested for in PyArray_FLAGS(arr).
 */
public static final int NPY_ARRAY_OWNDATA =         0x0004;

/*
 * An array never has the next four set; they're only used as parameter
 * flags to the various FromAny functions
 *
 * This flag may be requested in constructor functions.
 */

/* Cause a cast to occur regardless of whether or not it is safe. */
public static final int NPY_ARRAY_FORCECAST =       0x0010;

/*
 * Always copy the array. Returned arrays are always CONTIGUOUS,
 * ALIGNED, and WRITEABLE.
 *
 * This flag may be requested in constructor functions.
 */
public static final int NPY_ARRAY_ENSURECOPY =      0x0020;

/*
 * Make sure the returned array is a base-class ndarray
 *
 * This flag may be requested in constructor functions.
 */
public static final int NPY_ARRAY_ENSUREARRAY =     0x0040;

/*
 * Make sure that the strides are in units of the element size Needed
 * for some operations with record-arrays.
 *
 * This flag may be requested in constructor functions.
 */
public static final int NPY_ARRAY_ELEMENTSTRIDES =  0x0080;

/*
 * Array data is aligned on the appropriate memory address for the type
 * stored according to how the compiler would align things (e.g., an
 * array of integers (4 bytes each) starts on a memory address that's
 * a multiple of 4)
 *
 * This flag may be requested in constructor functions.
 * This flag may be tested for in PyArray_FLAGS(arr).
 */
public static final int NPY_ARRAY_ALIGNED =         0x0100;

/*
 * Array data has the native endianness
 *
 * This flag may be requested in constructor functions.
 */
public static final int NPY_ARRAY_NOTSWAPPED =      0x0200;

/*
 * Array data is writeable
 *
 * This flag may be requested in constructor functions.
 * This flag may be tested for in PyArray_FLAGS(arr).
 */
public static final int NPY_ARRAY_WRITEABLE =       0x0400;

/*
 * If this flag is set, then base contains a pointer to an array of
 * the same size that should be updated with the current contents of
 * this array when PyArray_ResolveWritebackIfCopy is called.
 *
 * This flag may be requested in constructor functions.
 * This flag may be tested for in PyArray_FLAGS(arr).
 */
public static final int NPY_ARRAY_UPDATEIFCOPY =    0x1000; /* Deprecated in 1.14 */
public static final int NPY_ARRAY_WRITEBACKIFCOPY = 0x2000;

/*
 * NOTE: there are also internal flags defined in multiarray/arrayobject.h,
 * which start at bit 31 and work down.
 */

public static final int NPY_ARRAY_BEHAVED =      (NPY_ARRAY_ALIGNED | 
                                NPY_ARRAY_WRITEABLE);
public static final int NPY_ARRAY_BEHAVED_NS =   (NPY_ARRAY_ALIGNED | 
                                NPY_ARRAY_WRITEABLE | 
                                NPY_ARRAY_NOTSWAPPED);
public static final int NPY_ARRAY_CARRAY =       (NPY_ARRAY_C_CONTIGUOUS | 
                                NPY_ARRAY_BEHAVED);
public static final int NPY_ARRAY_CARRAY_RO =    (NPY_ARRAY_C_CONTIGUOUS | 
                                NPY_ARRAY_ALIGNED);
public static final int NPY_ARRAY_FARRAY =       (NPY_ARRAY_F_CONTIGUOUS | 
                                NPY_ARRAY_BEHAVED);
public static final int NPY_ARRAY_FARRAY_RO =    (NPY_ARRAY_F_CONTIGUOUS | 
                                NPY_ARRAY_ALIGNED);
public static final int NPY_ARRAY_DEFAULT =      (NPY_ARRAY_CARRAY);
public static final int NPY_ARRAY_IN_ARRAY =     (NPY_ARRAY_CARRAY_RO);
public static final int NPY_ARRAY_OUT_ARRAY =    (NPY_ARRAY_CARRAY);
public static final int NPY_ARRAY_INOUT_ARRAY =  (NPY_ARRAY_CARRAY | 
                                NPY_ARRAY_UPDATEIFCOPY);
public static final int NPY_ARRAY_INOUT_ARRAY2 = (NPY_ARRAY_CARRAY | 
                                NPY_ARRAY_WRITEBACKIFCOPY);
public static final int NPY_ARRAY_IN_FARRAY =    (NPY_ARRAY_FARRAY_RO);
public static final int NPY_ARRAY_OUT_FARRAY =   (NPY_ARRAY_FARRAY);
public static final int NPY_ARRAY_INOUT_FARRAY = (NPY_ARRAY_FARRAY | 
                                NPY_ARRAY_UPDATEIFCOPY);
public static final int NPY_ARRAY_INOUT_FARRAY2 = (NPY_ARRAY_FARRAY | 
                                NPY_ARRAY_WRITEBACKIFCOPY);

public static final int NPY_ARRAY_UPDATE_ALL =   (NPY_ARRAY_C_CONTIGUOUS | 
                                NPY_ARRAY_F_CONTIGUOUS | 
                                NPY_ARRAY_ALIGNED);

/* This flag is for the array interface, not PyArrayObject */
public static final int NPY_ARR_HAS_DESCR =  0x0800;




/*
 * Size of internal buffers used for alignment Make BUFSIZE a multiple
 * of sizeof(npy_cdouble) -- usually 16 so that ufunc buffers are aligned
 */
public static native @MemberGetter int NPY_MIN_BUFSIZE();
public static final int NPY_MIN_BUFSIZE = NPY_MIN_BUFSIZE();
public static native @MemberGetter int NPY_MAX_BUFSIZE();
public static final int NPY_MAX_BUFSIZE = NPY_MAX_BUFSIZE();
public static final int NPY_BUFSIZE = 8192;
/* buffer stress test size: */
/*#define NPY_BUFSIZE 17*/

// #define PyArray_MAX(a,b) (((a)>(b))?(a):(b))
// #define PyArray_MIN(a,b) (((a)<(b))?(a):(b))
// #define PyArray_CLT(p,q) ((((p).real==(q).real) ? ((p).imag < (q).imag) :
//                                ((p).real < (q).real)))
// #define PyArray_CGT(p,q) ((((p).real==(q).real) ? ((p).imag > (q).imag) :
//                                ((p).real > (q).real)))
// #define PyArray_CLE(p,q) ((((p).real==(q).real) ? ((p).imag <= (q).imag) :
//                                ((p).real <= (q).real)))
// #define PyArray_CGE(p,q) ((((p).real==(q).real) ? ((p).imag >= (q).imag) :
//                                ((p).real >= (q).real)))
// #define PyArray_CEQ(p,q) (((p).real==(q).real) && ((p).imag == (q).imag))
// #define PyArray_CNE(p,q) (((p).real!=(q).real) || ((p).imag != (q).imag))

/*
 * C API: consists of Macros and functions.  The MACROS are defined
 * here.
 */


// #define PyArray_ISCONTIGUOUS(m) PyArray_CHKFLAGS((m), NPY_ARRAY_C_CONTIGUOUS)
// #define PyArray_ISWRITEABLE(m) PyArray_CHKFLAGS((m), NPY_ARRAY_WRITEABLE)
// #define PyArray_ISALIGNED(m) PyArray_CHKFLAGS((m), NPY_ARRAY_ALIGNED)

// #define PyArray_IS_C_CONTIGUOUS(m) PyArray_CHKFLAGS((m), NPY_ARRAY_C_CONTIGUOUS)
// #define PyArray_IS_F_CONTIGUOUS(m) PyArray_CHKFLAGS((m), NPY_ARRAY_F_CONTIGUOUS)

/* the variable is used in some places, so always define it */
// #define NPY_BEGIN_THREADS_DEF PyThreadState *_save=NULL;
// #if NPY_ALLOW_THREADS
// #define NPY_BEGIN_ALLOW_THREADS Py_BEGIN_ALLOW_THREADS
// #define NPY_END_ALLOW_THREADS Py_END_ALLOW_THREADS
// #define NPY_BEGIN_THREADS do {_save = PyEval_SaveThread();} while (0);
// #define NPY_END_THREADS   do { if (_save)
//                 { PyEval_RestoreThread(_save); _save = NULL;} } while (0);
// #define NPY_BEGIN_THREADS_THRESHOLDED(loop_size) do { if ((loop_size) > 500)
//                 { _save = PyEval_SaveThread();} } while (0);

// #define NPY_BEGIN_THREADS_DESCR(dtype)
//         do {if (!(PyDataType_FLAGCHK((dtype), NPY_NEEDS_PYAPI)))
//                 NPY_BEGIN_THREADS;} while (0);

// #define NPY_END_THREADS_DESCR(dtype)
//         do {if (!(PyDataType_FLAGCHK((dtype), NPY_NEEDS_PYAPI)))
//                 NPY_END_THREADS; } while (0);

// #define NPY_ALLOW_C_API_DEF  PyGILState_STATE __save__;
// #define NPY_ALLOW_C_API      do {__save__ = PyGILState_Ensure();} while (0);
// #define NPY_DISABLE_C_API    do {PyGILState_Release(__save__);} while (0);
// Targeting ../NpyIter.java


// Targeting ../NpyIter_IterNextFunc.java


// Targeting ../NpyIter_GetMultiIndexFunc.java



/*** Global flags that may be passed to the iterator constructors ***/

/* Track an index representing C order */
public static final int NPY_ITER_C_INDEX =                    0x00000001;
/* Track an index representing Fortran order */
public static final int NPY_ITER_F_INDEX =                    0x00000002;
/* Track a multi-index */
public static final int NPY_ITER_MULTI_INDEX =                0x00000004;
/* User code external to the iterator does the 1-dimensional innermost loop */
public static final int NPY_ITER_EXTERNAL_LOOP =              0x00000008;
/* Convert all the operands to a common data type */
public static final int NPY_ITER_COMMON_DTYPE =               0x00000010;
/* Operands may hold references, requiring API access during iteration */
public static final int NPY_ITER_REFS_OK =                    0x00000020;
/* Zero-sized operands should be permitted, iteration checks IterSize for 0 */
public static final int NPY_ITER_ZEROSIZE_OK =                0x00000040;
/* Permits reductions (size-0 stride with dimension size > 1) */
public static final int NPY_ITER_REDUCE_OK =                  0x00000080;
/* Enables sub-range iteration */
public static final int NPY_ITER_RANGED =                     0x00000100;
/* Enables buffering */
public static final int NPY_ITER_BUFFERED =                   0x00000200;
/* When buffering is enabled, grows the inner loop if possible */
public static final int NPY_ITER_GROWINNER =                  0x00000400;
/* Delay allocation of buffers until first Reset* call */
public static final int NPY_ITER_DELAY_BUFALLOC =             0x00000800;
/* When NPY_KEEPORDER is specified, disable reversing negative-stride axes */
public static final int NPY_ITER_DONT_NEGATE_STRIDES =        0x00001000;
/*
 * If output operands overlap with other operands (based on heuristics that
 * has false positives but no false negatives), make temporary copies to
 * eliminate overlap.
 */
public static final int NPY_ITER_COPY_IF_OVERLAP =            0x00002000;

/*** Per-operand flags that may be passed to the iterator constructors ***/

/* The operand will be read from and written to */
public static final int NPY_ITER_READWRITE =                  0x00010000;
/* The operand will only be read from */
public static final int NPY_ITER_READONLY =                   0x00020000;
/* The operand will only be written to */
public static final int NPY_ITER_WRITEONLY =                  0x00040000;
/* The operand's data must be in native byte order */
public static final int NPY_ITER_NBO =                        0x00080000;
/* The operand's data must be aligned */
public static final int NPY_ITER_ALIGNED =                    0x00100000;
/* The operand's data must be contiguous (within the inner loop) */
public static final int NPY_ITER_CONTIG =                     0x00200000;
/* The operand may be copied to satisfy requirements */
public static final int NPY_ITER_COPY =                       0x00400000;
/* The operand may be copied with WRITEBACKIFCOPY to satisfy requirements */
public static final int NPY_ITER_UPDATEIFCOPY =               0x00800000;
/* Allocate the operand if it is NULL */
public static final int NPY_ITER_ALLOCATE =                   0x01000000;
/* If an operand is allocated, don't use any subtype */
public static final int NPY_ITER_NO_SUBTYPE =                 0x02000000;
/* This is a virtual array slot, operand is NULL but temporary data is there */
public static final int NPY_ITER_VIRTUAL =                    0x04000000;
/* Require that the dimension match the iterator dimensions exactly */
public static final int NPY_ITER_NO_BROADCAST =               0x08000000;
/* A mask is being used on this array, affects buffer -> array copy */
public static final int NPY_ITER_WRITEMASKED =                0x10000000;
/* This array is the mask for all WRITEMASKED operands */
public static final int NPY_ITER_ARRAYMASK =                  0x20000000;
/* Assume iterator order data access for COPY_IF_OVERLAP */
public static final int NPY_ITER_OVERLAP_ASSUME_ELEMENTWISE = 0x40000000;

public static final int NPY_ITER_GLOBAL_FLAGS =               0x0000ffff;
public static final int NPY_ITER_PER_OP_FLAGS =               0xffff0000;


/*****************************
 * Basic iterator object
 *****************************/

/* FWD declaration */
// Targeting ../npy_iter_get_dataptr_t.java


// Targeting ../PyArrayIterObject.java




/* Iterator API */
// #define PyArrayIter_Check(op) PyObject_TypeCheck((op), &PyArrayIter_Type)

// #define _PyAIT(it) ((PyArrayIterObject *)(it))
// #define PyArray_ITER_RESET(it) do {
//         _PyAIT(it)->index = 0;
//         _PyAIT(it)->dataptr = PyArray_BYTES(_PyAIT(it)->ao);
//         memset(_PyAIT(it)->coordinates, 0,
//                (_PyAIT(it)->nd_m1+1)*sizeof(npy_intp));
// } while (0)

// #define _PyArray_ITER_NEXT1(it) do {
//         (it)->dataptr += _PyAIT(it)->strides[0];
//         (it)->coordinates[0]++;
// } while (0)

// #define _PyArray_ITER_NEXT2(it) do {
//         if ((it)->coordinates[1] < (it)->dims_m1[1]) {
//                 (it)->coordinates[1]++;
//                 (it)->dataptr += (it)->strides[1];
//         }
//         else {
//                 (it)->coordinates[1] = 0;
//                 (it)->coordinates[0]++;
//                 (it)->dataptr += (it)->strides[0] -
//                         (it)->backstrides[1];
//         }
// } while (0)

// #define PyArray_ITER_NEXT(it) do {
//         _PyAIT(it)->index++;
//         if (_PyAIT(it)->nd_m1 == 0) {
//                 _PyArray_ITER_NEXT1(_PyAIT(it));
//         }
//         else if (_PyAIT(it)->contiguous)
//                 _PyAIT(it)->dataptr += PyArray_DESCR(_PyAIT(it)->ao)->elsize;
//         else if (_PyAIT(it)->nd_m1 == 1) {
//                 _PyArray_ITER_NEXT2(_PyAIT(it));
//         }
//         else {
//                 int __npy_i;
//                 for (__npy_i=_PyAIT(it)->nd_m1; __npy_i >= 0; __npy_i--) {
//                         if (_PyAIT(it)->coordinates[__npy_i] <
//                             _PyAIT(it)->dims_m1[__npy_i]) {
//                                 _PyAIT(it)->coordinates[__npy_i]++;
//                                 _PyAIT(it)->dataptr +=
//                                         _PyAIT(it)->strides[__npy_i];
//                                 break;
//                         }
//                         else {
//                                 _PyAIT(it)->coordinates[__npy_i] = 0;
//                                 _PyAIT(it)->dataptr -=
//                                         _PyAIT(it)->backstrides[__npy_i];
//                         }
//                 }
//         }
// } while (0)

// #define PyArray_ITER_GOTO(it, destination) do {
//         int __npy_i;
//         _PyAIT(it)->index = 0;
//         _PyAIT(it)->dataptr = PyArray_BYTES(_PyAIT(it)->ao);
//         for (__npy_i = _PyAIT(it)->nd_m1; __npy_i>=0; __npy_i--) {
//                 if (destination[__npy_i] < 0) {
//                         destination[__npy_i] +=
//                                 _PyAIT(it)->dims_m1[__npy_i]+1;
//                 }
//                 _PyAIT(it)->dataptr += destination[__npy_i] *
//                         _PyAIT(it)->strides[__npy_i];
//                 _PyAIT(it)->coordinates[__npy_i] =
//                         destination[__npy_i];
//                 _PyAIT(it)->index += destination[__npy_i] *
//                         ( __npy_i==_PyAIT(it)->nd_m1 ? 1 :
//                           _PyAIT(it)->dims_m1[__npy_i+1]+1) ;
//         }
// } while (0)

// #define PyArray_ITER_GOTO1D(it, ind) do {
//         int __npy_i;
//         npy_intp __npy_ind = (npy_intp)(ind);
//         if (__npy_ind < 0) __npy_ind += _PyAIT(it)->size;
//         _PyAIT(it)->index = __npy_ind;
//         if (_PyAIT(it)->nd_m1 == 0) {
//                 _PyAIT(it)->dataptr = PyArray_BYTES(_PyAIT(it)->ao) +
//                         __npy_ind * _PyAIT(it)->strides[0];
//         }
//         else if (_PyAIT(it)->contiguous)
//                 _PyAIT(it)->dataptr = PyArray_BYTES(_PyAIT(it)->ao) +
//                         __npy_ind * PyArray_DESCR(_PyAIT(it)->ao)->elsize;
//         else {
//                 _PyAIT(it)->dataptr = PyArray_BYTES(_PyAIT(it)->ao);
//                 for (__npy_i = 0; __npy_i<=_PyAIT(it)->nd_m1;
//                      __npy_i++) {
//                         _PyAIT(it)->dataptr +=
//                                 (__npy_ind / _PyAIT(it)->factors[__npy_i])
//                                 * _PyAIT(it)->strides[__npy_i];
//                         __npy_ind %= _PyAIT(it)->factors[__npy_i];
//                 }
//         }
// } while (0)

// #define PyArray_ITER_DATA(it) ((void *)(_PyAIT(it)->dataptr))

// #define PyArray_ITER_NOTDONE(it) (_PyAIT(it)->index < _PyAIT(it)->size)
// Targeting ../PyArrayMultiIterObject.java



// #define _PyMIT(m) ((PyArrayMultiIterObject *)(m))
// #define PyArray_MultiIter_RESET(multi) do {
//         int __npy_mi;
//         _PyMIT(multi)->index = 0;
//         for (__npy_mi=0; __npy_mi < _PyMIT(multi)->numiter;  __npy_mi++) {
//                 PyArray_ITER_RESET(_PyMIT(multi)->iters[__npy_mi]);
//         }
// } while (0)

// #define PyArray_MultiIter_NEXT(multi) do {
//         int __npy_mi;
//         _PyMIT(multi)->index++;
//         for (__npy_mi=0; __npy_mi < _PyMIT(multi)->numiter;   __npy_mi++) {
//                 PyArray_ITER_NEXT(_PyMIT(multi)->iters[__npy_mi]);
//         }
// } while (0)

// #define PyArray_MultiIter_GOTO(multi, dest) do {
//         int __npy_mi;
//         for (__npy_mi=0; __npy_mi < _PyMIT(multi)->numiter; __npy_mi++) {
//                 PyArray_ITER_GOTO(_PyMIT(multi)->iters[__npy_mi], dest);
//         }
//         _PyMIT(multi)->index = _PyMIT(multi)->iters[0]->index;
// } while (0)

// #define PyArray_MultiIter_GOTO1D(multi, ind) do {
//         int __npy_mi;
//         for (__npy_mi=0; __npy_mi < _PyMIT(multi)->numiter; __npy_mi++) {
//                 PyArray_ITER_GOTO1D(_PyMIT(multi)->iters[__npy_mi], ind);
//         }
//         _PyMIT(multi)->index = _PyMIT(multi)->iters[0]->index;
// } while (0)

// #define PyArray_MultiIter_DATA(multi, i)
//         ((void *)(_PyMIT(multi)->iters[i]->dataptr))

// #define PyArray_MultiIter_NEXTi(multi, i)
//         PyArray_ITER_NEXT(_PyMIT(multi)->iters[i])

// #define PyArray_MultiIter_NOTDONE(multi)
//         (_PyMIT(multi)->index < _PyMIT(multi)->size)
// Targeting ../PyArrayMapIterObject.java



/** enum  */
public static final int
    NPY_NEIGHBORHOOD_ITER_ZERO_PADDING = 0,
    NPY_NEIGHBORHOOD_ITER_ONE_PADDING = 1,
    NPY_NEIGHBORHOOD_ITER_CONSTANT_PADDING = 2,
    NPY_NEIGHBORHOOD_ITER_CIRCULAR_PADDING = 3,
    NPY_NEIGHBORHOOD_ITER_MIRROR_PADDING = 4;
// Targeting ../PyArrayNeighborhoodIterObject.java



/*
 * Neighborhood iterator API
 */

/* General: those work for any mode */
@NoException public static native int PyArrayNeighborhoodIter_Reset(PyArrayNeighborhoodIterObject iter);
@NoException public static native int PyArrayNeighborhoodIter_Next(PyArrayNeighborhoodIterObject iter);
// #if 0
// #endif

/*
 * Include inline implementations - functions defined there are not
 * considered public API
 */
// #define _NPY_INCLUDE_NEIGHBORHOOD_IMP
// #include "_neighborhood_iterator_imp.h"
// #undef _NPY_INCLUDE_NEIGHBORHOOD_IMP

/* The default array type */
public static final int NPY_DEFAULT_TYPE = NPY_DOUBLE;

/*
 * All sorts of useful ways to look into a PyArrayObject. It is recommended
 * to use PyArrayObject * objects instead of always casting from PyObject *,
 * for improved type checking.
 *
 * In many cases here the macro versions of the accessors are deprecated,
 * but can't be immediately changed to inline functions because the
 * preexisting macros accept PyObject * and do automatic casts. Inline
 * functions accepting PyArrayObject * provides for some compile-time
 * checking of correctness when working with these objects in C.
 */

// #define PyArray_ISONESEGMENT(m) (PyArray_CHKFLAGS(m, NPY_ARRAY_C_CONTIGUOUS) ||
//                                  PyArray_CHKFLAGS(m, NPY_ARRAY_F_CONTIGUOUS))

// #define PyArray_ISFORTRAN(m) (PyArray_CHKFLAGS(m, NPY_ARRAY_F_CONTIGUOUS) &&
//                              (!PyArray_CHKFLAGS(m, NPY_ARRAY_C_CONTIGUOUS)))

// #define PyArray_FORTRAN_IF(m) ((PyArray_CHKFLAGS(m, NPY_ARRAY_F_CONTIGUOUS) ?
//                                NPY_ARRAY_F_CONTIGUOUS : 0))

// #if (defined(NPY_NO_DEPRECATED_API) && (NPY_1_7_API_VERSION <= NPY_NO_DEPRECATED_API))
/*
 * Changing access macros into functions, to allow for future hiding
 * of the internal memory layout. This later hiding will allow the 2.x series
 * to change the internal representation of arrays without affecting
 * ABI compatibility.
 */

@NoException public static native int PyArray_NDIM(@Const PyArrayObject arr);

@NoException public static native Pointer PyArray_DATA(PyArrayObject arr);

@NoException public static native @Cast("char*") BytePointer PyArray_BYTES(PyArrayObject arr);

@NoException public static native @Cast("npy_intp*") SizeTPointer PyArray_DIMS(PyArrayObject arr);

@NoException public static native @Cast("npy_intp*") SizeTPointer PyArray_STRIDES(PyArrayObject arr);

@NoException public static native @Cast("npy_intp") long PyArray_DIM(@Const PyArrayObject arr, int idim);

@NoException public static native @Cast("npy_intp") long PyArray_STRIDE(@Const PyArrayObject arr, int istride);

@NoException public static native PyObject PyArray_BASE(PyArrayObject arr);

@NoException public static native PyArray_Descr PyArray_DESCR(PyArrayObject arr);

@NoException public static native int PyArray_FLAGS(@Const PyArrayObject arr);

@NoException public static native @Cast("npy_intp") long PyArray_ITEMSIZE(@Const PyArrayObject arr);

@NoException public static native int PyArray_TYPE(@Const PyArrayObject arr);

@NoException public static native int PyArray_CHKFLAGS(@Const PyArrayObject arr, int flags);

@NoException public static native PyObject PyArray_GETITEM(@Const PyArrayObject arr, @Cast("const char*") BytePointer itemptr);
@NoException public static native PyObject PyArray_GETITEM(@Const PyArrayObject arr, String itemptr);

/*
 * SETITEM should only be used if it is known that the value is a scalar
 * and of a type understood by the arrays dtype.
 * Use `PyArray_Pack` if the value may be of a different dtype.
 */
@NoException public static native int PyArray_SETITEM(PyArrayObject arr, @Cast("char*") BytePointer itemptr, PyObject v);
@NoException public static native int PyArray_SETITEM(PyArrayObject arr, @Cast("char*") ByteBuffer itemptr, PyObject v);
@NoException public static native int PyArray_SETITEM(PyArrayObject arr, @Cast("char*") byte[] itemptr, PyObject v);

// #else

/* These macros are deprecated as of NumPy 1.7. */
// #define PyArray_NDIM(obj) (((PyArrayObject_fields *)(obj))->nd)
// #define PyArray_BYTES(obj) (((PyArrayObject_fields *)(obj))->data)
// #define PyArray_DATA(obj) ((void *)((PyArrayObject_fields *)(obj))->data)
// #define PyArray_DIMS(obj) (((PyArrayObject_fields *)(obj))->dimensions)
// #define PyArray_STRIDES(obj) (((PyArrayObject_fields *)(obj))->strides)
// #define PyArray_DIM(obj,n) (PyArray_DIMS(obj)[n])
// #define PyArray_STRIDE(obj,n) (PyArray_STRIDES(obj)[n])
// #define PyArray_BASE(obj) (((PyArrayObject_fields *)(obj))->base)
// #define PyArray_DESCR(obj) (((PyArrayObject_fields *)(obj))->descr)
// #define PyArray_FLAGS(obj) (((PyArrayObject_fields *)(obj))->flags)
// #define PyArray_CHKFLAGS(m, FLAGS)
//         ((((PyArrayObject_fields *)(m))->flags & (FLAGS)) == (FLAGS))
// #define PyArray_ITEMSIZE(obj)
//                     (((PyArrayObject_fields *)(obj))->descr->elsize)
// #define PyArray_TYPE(obj)
//                     (((PyArrayObject_fields *)(obj))->descr->type_num)
// #define PyArray_GETITEM(obj,itemptr)
//         PyArray_DESCR(obj)->f->getitem((char *)(itemptr),
//                                      (PyArrayObject *)(obj))

// #define PyArray_SETITEM(obj,itemptr,v)
//         PyArray_DESCR(obj)->f->setitem((PyObject *)(v),
//                                      (char *)(itemptr),
//                                      (PyArrayObject *)(obj))
// #endif

@NoException public static native PyArray_Descr PyArray_DTYPE(PyArrayObject arr);

@NoException public static native @Cast("npy_intp*") SizeTPointer PyArray_SHAPE(PyArrayObject arr);

/*
 * Enables the specified array flags. Does no checking,
 * assumes you know what you're doing.
 */
@NoException public static native void PyArray_ENABLEFLAGS(PyArrayObject arr, int flags);

/*
 * Clears the specified array flags. Does no checking,
 * assumes you know what you're doing.
 */
@NoException public static native void PyArray_CLEARFLAGS(PyArrayObject arr, int flags);

// #define PyTypeNum_ISBOOL(type) ((type) == NPY_BOOL)

// #define PyTypeNum_ISUNSIGNED(type) (((type) == NPY_UBYTE) ||
//                                  ((type) == NPY_USHORT) ||
//                                  ((type) == NPY_UINT) ||
//                                  ((type) == NPY_ULONG) ||
//                                  ((type) == NPY_ULONGLONG))

// #define PyTypeNum_ISSIGNED(type) (((type) == NPY_BYTE) ||
//                                ((type) == NPY_SHORT) ||
//                                ((type) == NPY_INT) ||
//                                ((type) == NPY_LONG) ||
//                                ((type) == NPY_LONGLONG))

// #define PyTypeNum_ISINTEGER(type) (((type) >= NPY_BYTE) &&
//                                 ((type) <= NPY_ULONGLONG))

// #define PyTypeNum_ISFLOAT(type) ((((type) >= NPY_FLOAT) &&
//                               ((type) <= NPY_LONGDOUBLE)) ||
//                               ((type) == NPY_HALF))

// #define PyTypeNum_ISNUMBER(type) (((type) <= NPY_CLONGDOUBLE) ||
//                                   ((type) == NPY_HALF))

// #define PyTypeNum_ISSTRING(type) (((type) == NPY_STRING) ||
//                                   ((type) == NPY_UNICODE))

// #define PyTypeNum_ISCOMPLEX(type) (((type) >= NPY_CFLOAT) &&
//                                 ((type) <= NPY_CLONGDOUBLE))

// #define PyTypeNum_ISPYTHON(type) (((type) == NPY_LONG) ||
//                                   ((type) == NPY_DOUBLE) ||
//                                   ((type) == NPY_CDOUBLE) ||
//                                   ((type) == NPY_BOOL) ||
//                                   ((type) == NPY_OBJECT ))

// #define PyTypeNum_ISFLEXIBLE(type) (((type) >=NPY_STRING) &&
//                                     ((type) <=NPY_VOID))

// #define PyTypeNum_ISDATETIME(type) (((type) >=NPY_DATETIME) &&
//                                     ((type) <=NPY_TIMEDELTA))

// #define PyTypeNum_ISUSERDEF(type) (((type) >= NPY_USERDEF) &&
//                                    ((type) < NPY_USERDEF+
//                                     NPY_NUMUSERTYPES))

// #define PyTypeNum_ISEXTENDED(type) (PyTypeNum_ISFLEXIBLE(type) ||
//                                     PyTypeNum_ISUSERDEF(type))

// #define PyTypeNum_ISOBJECT(type) ((type) == NPY_OBJECT)


// #define PyDataType_ISBOOL(obj) PyTypeNum_ISBOOL(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISUNSIGNED(obj) PyTypeNum_ISUNSIGNED(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISSIGNED(obj) PyTypeNum_ISSIGNED(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISINTEGER(obj) PyTypeNum_ISINTEGER(((PyArray_Descr*)(obj))->type_num )
// #define PyDataType_ISFLOAT(obj) PyTypeNum_ISFLOAT(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISNUMBER(obj) PyTypeNum_ISNUMBER(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISSTRING(obj) PyTypeNum_ISSTRING(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISCOMPLEX(obj) PyTypeNum_ISCOMPLEX(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISPYTHON(obj) PyTypeNum_ISPYTHON(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISFLEXIBLE(obj) PyTypeNum_ISFLEXIBLE(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISDATETIME(obj) PyTypeNum_ISDATETIME(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISUSERDEF(obj) PyTypeNum_ISUSERDEF(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISEXTENDED(obj) PyTypeNum_ISEXTENDED(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_ISOBJECT(obj) PyTypeNum_ISOBJECT(((PyArray_Descr*)(obj))->type_num)
// #define PyDataType_HASFIELDS(obj) (((PyArray_Descr *)(obj))->names != NULL)
// #define PyDataType_HASSUBARRAY(dtype) ((dtype)->subarray != NULL)
// #define PyDataType_ISUNSIZED(dtype) ((dtype)->elsize == 0 &&
//                                       !PyDataType_HASFIELDS(dtype))
// #define PyDataType_MAKEUNSIZED(dtype) ((dtype)->elsize = 0)

// #define PyArray_ISBOOL(obj) PyTypeNum_ISBOOL(PyArray_TYPE(obj))
// #define PyArray_ISUNSIGNED(obj) PyTypeNum_ISUNSIGNED(PyArray_TYPE(obj))
// #define PyArray_ISSIGNED(obj) PyTypeNum_ISSIGNED(PyArray_TYPE(obj))
// #define PyArray_ISINTEGER(obj) PyTypeNum_ISINTEGER(PyArray_TYPE(obj))
// #define PyArray_ISFLOAT(obj) PyTypeNum_ISFLOAT(PyArray_TYPE(obj))
// #define PyArray_ISNUMBER(obj) PyTypeNum_ISNUMBER(PyArray_TYPE(obj))
// #define PyArray_ISSTRING(obj) PyTypeNum_ISSTRING(PyArray_TYPE(obj))
// #define PyArray_ISCOMPLEX(obj) PyTypeNum_ISCOMPLEX(PyArray_TYPE(obj))
// #define PyArray_ISPYTHON(obj) PyTypeNum_ISPYTHON(PyArray_TYPE(obj))
// #define PyArray_ISFLEXIBLE(obj) PyTypeNum_ISFLEXIBLE(PyArray_TYPE(obj))
// #define PyArray_ISDATETIME(obj) PyTypeNum_ISDATETIME(PyArray_TYPE(obj))
// #define PyArray_ISUSERDEF(obj) PyTypeNum_ISUSERDEF(PyArray_TYPE(obj))
// #define PyArray_ISEXTENDED(obj) PyTypeNum_ISEXTENDED(PyArray_TYPE(obj))
// #define PyArray_ISOBJECT(obj) PyTypeNum_ISOBJECT(PyArray_TYPE(obj))
// #define PyArray_HASFIELDS(obj) PyDataType_HASFIELDS(PyArray_DESCR(obj))

    /*
     * FIXME: This should check for a flag on the data-type that
     * states whether or not it is variable length.  Because the
     * ISFLEXIBLE check is hard-coded to the built-in data-types.
     */
// #define PyArray_ISVARIABLE(obj) PyTypeNum_ISFLEXIBLE(PyArray_TYPE(obj))

// #define PyArray_SAFEALIGNEDCOPY(obj) (PyArray_ISALIGNED(obj) && !PyArray_ISVARIABLE(obj))


public static final int NPY_LITTLE = '<';
public static final int NPY_BIG = '>';
public static final int NPY_NATIVE = '=';
public static final int NPY_SWAP = 's';
public static final int NPY_IGNORE = '|';

// #if NPY_BYTE_ORDER == NPY_BIG_ENDIAN
public static final int NPY_NATBYTE = NPY_BIG;
public static final int NPY_OPPBYTE = NPY_LITTLE;
// #else
// #endif

// #define PyArray_ISNBO(arg) ((arg) != NPY_OPPBYTE)
// #define PyArray_IsNativeByteOrder PyArray_ISNBO
// #define PyArray_ISNOTSWAPPED(m) PyArray_ISNBO(PyArray_DESCR(m)->byteorder)
// #define PyArray_ISBYTESWAPPED(m) (!PyArray_ISNOTSWAPPED(m))

// #define PyArray_FLAGSWAP(m, flags) (PyArray_CHKFLAGS(m, flags) &&
//                                     PyArray_ISNOTSWAPPED(m))

// #define PyArray_ISCARRAY(m) PyArray_FLAGSWAP(m, NPY_ARRAY_CARRAY)
// #define PyArray_ISCARRAY_RO(m) PyArray_FLAGSWAP(m, NPY_ARRAY_CARRAY_RO)
// #define PyArray_ISFARRAY(m) PyArray_FLAGSWAP(m, NPY_ARRAY_FARRAY)
// #define PyArray_ISFARRAY_RO(m) PyArray_FLAGSWAP(m, NPY_ARRAY_FARRAY_RO)
// #define PyArray_ISBEHAVED(m) PyArray_FLAGSWAP(m, NPY_ARRAY_BEHAVED)
// #define PyArray_ISBEHAVED_RO(m) PyArray_FLAGSWAP(m, NPY_ARRAY_ALIGNED)


// #define PyDataType_ISNOTSWAPPED(d) PyArray_ISNBO(((PyArray_Descr *)(d))->byteorder)
// #define PyDataType_ISBYTESWAPPED(d) (!PyDataType_ISNOTSWAPPED(d))
// Targeting ../npy_stride_sort_item.java


// Targeting ../PyArrayInterface.java


// Targeting ../PyDataMem_EventHookFunc.java




/*
 * PyArray_DTypeMeta related definitions.
 *
 * As of now, this API is preliminary and will be extended as necessary.
 */
// #if defined(NPY_INTERNAL_BUILD) && NPY_INTERNAL_BUILD

// #endif  /* NPY_INTERNAL_BUILD */


/*
 * Use the keyword NPY_DEPRECATED_INCLUDES to ensure that the header files
 * npy_*_*_deprecated_api.h are only included from here and nowhere else.
 */
// #ifdef NPY_DEPRECATED_INCLUDES
// #error "Do not use the reserved keyword NPY_DEPRECATED_INCLUDES."
// #endif
// #define NPY_DEPRECATED_INCLUDES
// #if !defined(NPY_NO_DEPRECATED_API) ||
//     (NPY_NO_DEPRECATED_API < NPY_1_7_API_VERSION)
// #include "npy_1_7_deprecated_api.h"
// #endif
/*
 * There is no file npy_1_8_deprecated_api.h since there are no additional
 * deprecated API features in NumPy 1.8.
 *
 * Note to maintainers: insert code like the following in future NumPy
 * versions.
 *
 * #if !defined(NPY_NO_DEPRECATED_API) || \
 *     (NPY_NO_DEPRECATED_API < NPY_1_9_API_VERSION)
 * #include "npy_1_9_deprecated_api.h"
 * #endif
 */
// #undef NPY_DEPRECATED_INCLUDES

// #endif /* NPY_ARRAYTYPES_H */


// Parsed from ndarrayobject.h

/*
 * DON'T INCLUDE THIS DIRECTLY.
 */

// #ifndef NPY_NDARRAYOBJECT_H
// #define NPY_NDARRAYOBJECT_H
// #ifdef __cplusplus
// #endif

// #include <Python.h>
// #include "ndarraytypes.h"

/* Includes the "function" C-API -- these are all stored in a
   list of pointers --- one for each file
   The two lists are concatenated into one in multiarray.

   They are available as import_array()
*/

// #include "__multiarray_api.h"


/* C-API that requires previous API to be defined */

// #define PyArray_DescrCheck(op) PyObject_TypeCheck(op, &PyArrayDescr_Type)

// #define PyArray_Check(op) PyObject_TypeCheck(op, &PyArray_Type)
// #define PyArray_CheckExact(op) (((PyObject*)(op))->ob_type == &PyArray_Type)

// #define PyArray_HasArrayInterfaceType(op, type, context, out)
//         ((((out)=PyArray_FromStructInterface(op)) != Py_NotImplemented) ||
//          (((out)=PyArray_FromInterface(op)) != Py_NotImplemented) ||
//          (((out)=PyArray_FromArrayAttr(op, type, context)) !=
//           Py_NotImplemented))

// #define PyArray_HasArrayInterface(op, out)
//         PyArray_HasArrayInterfaceType(op, NULL, NULL, out)

// #define PyArray_IsZeroDim(op) (PyArray_Check(op) &&
//                                (PyArray_NDIM((PyArrayObject *)op) == 0))

// #define PyArray_IsScalar(obj, cls)
//         (PyObject_TypeCheck(obj, &Py##cls##ArrType_Type))

// #define PyArray_CheckScalar(m) (PyArray_IsScalar(m, Generic) ||
//                                 PyArray_IsZeroDim(m))
// #define PyArray_IsPythonNumber(obj)
//         (PyFloat_Check(obj) || PyComplex_Check(obj) ||
//          PyLong_Check(obj) || PyBool_Check(obj))
// #define PyArray_IsIntegerScalar(obj) (PyLong_Check(obj)
//               || PyArray_IsScalar((obj), Integer))
// #define PyArray_IsPythonScalar(obj)
//         (PyArray_IsPythonNumber(obj) || PyBytes_Check(obj) ||
//          PyUnicode_Check(obj))

// #define PyArray_IsAnyScalar(obj)
//         (PyArray_IsScalar(obj, Generic) || PyArray_IsPythonScalar(obj))

// #define PyArray_CheckAnyScalar(obj) (PyArray_IsPythonScalar(obj) ||
//                                      PyArray_CheckScalar(obj))


// #define PyArray_GETCONTIGUOUS(m) (PyArray_ISCONTIGUOUS(m) ?
//                                   Py_INCREF(m), (m) :
//                                   (PyArrayObject *)(PyArray_Copy(m)))

// #define PyArray_SAMESHAPE(a1,a2) ((PyArray_NDIM(a1) == PyArray_NDIM(a2)) &&
//                                   PyArray_CompareLists(PyArray_DIMS(a1),
//                                                        PyArray_DIMS(a2),
//                                                        PyArray_NDIM(a1)))

// #define PyArray_SIZE(m) PyArray_MultiplyList(PyArray_DIMS(m), PyArray_NDIM(m))
// #define PyArray_NBYTES(m) (PyArray_ITEMSIZE(m) * PyArray_SIZE(m))
// #define PyArray_FROM_O(m) PyArray_FromAny(m, NULL, 0, 0, 0, NULL)

// #define PyArray_FROM_OF(m,flags) PyArray_CheckFromAny(m, NULL, 0, 0, flags,
//                                                       NULL)

// #define PyArray_FROM_OT(m,type) PyArray_FromAny(m,
//                                 PyArray_DescrFromType(type), 0, 0, 0, NULL)

// #define PyArray_FROM_OTF(m, type, flags)
//         PyArray_FromAny(m, PyArray_DescrFromType(type), 0, 0,
//                         (((flags) & NPY_ARRAY_ENSURECOPY) ?
//                          ((flags) | NPY_ARRAY_DEFAULT) : (flags)), NULL)

// #define PyArray_FROMANY(m, type, min, max, flags)
//         PyArray_FromAny(m, PyArray_DescrFromType(type), min, max,
//                         (((flags) & NPY_ARRAY_ENSURECOPY) ?
//                          (flags) | NPY_ARRAY_DEFAULT : (flags)), NULL)

// #define PyArray_ZEROS(m, dims, type, is_f_order)
//         PyArray_Zeros(m, dims, PyArray_DescrFromType(type), is_f_order)

// #define PyArray_EMPTY(m, dims, type, is_f_order)
//         PyArray_Empty(m, dims, PyArray_DescrFromType(type), is_f_order)

// #define PyArray_FILLWBYTE(obj, val) memset(PyArray_DATA(obj), val,
//                                            PyArray_NBYTES(obj))
// #ifndef PYPY_VERSION
// #define PyArray_REFCOUNT(obj) (((PyObject *)(obj))->ob_refcnt)
// #define NPY_REFCOUNT PyArray_REFCOUNT
// #endif
public static final int NPY_MAX_ELSIZE = (2 * NPY_SIZEOF_LONGDOUBLE);

// #define PyArray_ContiguousFromAny(op, type, min_depth, max_depth)
//         PyArray_FromAny(op, PyArray_DescrFromType(type), min_depth,
//                               max_depth, NPY_ARRAY_DEFAULT, NULL)

// #define PyArray_EquivArrTypes(a1, a2)
//         PyArray_EquivTypes(PyArray_DESCR(a1), PyArray_DESCR(a2))

// #define PyArray_EquivByteorders(b1, b2)
//         (((b1) == (b2)) || (PyArray_ISNBO(b1) == PyArray_ISNBO(b2)))

// #define PyArray_SimpleNew(nd, dims, typenum)
//         PyArray_New(&PyArray_Type, nd, dims, typenum, NULL, NULL, 0, 0, NULL)

// #define PyArray_SimpleNewFromData(nd, dims, typenum, data)
//         PyArray_New(&PyArray_Type, nd, dims, typenum, NULL,
//                     data, 0, NPY_ARRAY_CARRAY, NULL)

// #define PyArray_SimpleNewFromDescr(nd, dims, descr)
//         PyArray_NewFromDescr(&PyArray_Type, descr, nd, dims,
//                              NULL, NULL, 0, NULL)

// #define PyArray_ToScalar(data, arr)
//         PyArray_Scalar(data, PyArray_DESCR(arr), (PyObject *)arr)


/* These might be faster without the dereferencing of obj
   going on inside -- of course an optimizing compiler should
   inline the constants inside a for loop making it a moot point
*/

// #define PyArray_GETPTR1(obj, i) ((void *)(PyArray_BYTES(obj) +
//                                          (i)*PyArray_STRIDES(obj)[0]))

// #define PyArray_GETPTR2(obj, i, j) ((void *)(PyArray_BYTES(obj) +
//                                             (i)*PyArray_STRIDES(obj)[0] +
//                                             (j)*PyArray_STRIDES(obj)[1]))

// #define PyArray_GETPTR3(obj, i, j, k) ((void *)(PyArray_BYTES(obj) +
//                                             (i)*PyArray_STRIDES(obj)[0] +
//                                             (j)*PyArray_STRIDES(obj)[1] +
//                                             (k)*PyArray_STRIDES(obj)[2]))

// #define PyArray_GETPTR4(obj, i, j, k, l) ((void *)(PyArray_BYTES(obj) +
//                                             (i)*PyArray_STRIDES(obj)[0] +
//                                             (j)*PyArray_STRIDES(obj)[1] +
//                                             (k)*PyArray_STRIDES(obj)[2] +
//                                             (l)*PyArray_STRIDES(obj)[3]))

/* Move to arrayobject.c once PyArray_XDECREF_ERR is removed */
@NoException public static native void PyArray_DiscardWritebackIfCopy(PyArrayObject arr);

// #define PyArray_DESCR_REPLACE(descr) do {
//                 PyArray_Descr *_new_;
//                 _new_ = PyArray_DescrNew(descr);
//                 Py_XDECREF(descr);
//                 descr = _new_;
//         } while(0)

/* Copy should always return contiguous array */
// #define PyArray_Copy(obj) PyArray_NewCopy(obj, NPY_CORDER)

// #define PyArray_FromObject(op, type, min_depth, max_depth)
//         PyArray_FromAny(op, PyArray_DescrFromType(type), min_depth,
//                               max_depth, NPY_ARRAY_BEHAVED |
//                                          NPY_ARRAY_ENSUREARRAY, NULL)

// #define PyArray_ContiguousFromObject(op, type, min_depth, max_depth)
//         PyArray_FromAny(op, PyArray_DescrFromType(type), min_depth,
//                               max_depth, NPY_ARRAY_DEFAULT |
//                                          NPY_ARRAY_ENSUREARRAY, NULL)

// #define PyArray_CopyFromObject(op, type, min_depth, max_depth)
//         PyArray_FromAny(op, PyArray_DescrFromType(type), min_depth,
//                         max_depth, NPY_ARRAY_ENSURECOPY |
//                                    NPY_ARRAY_DEFAULT |
//                                    NPY_ARRAY_ENSUREARRAY, NULL)

// #define PyArray_Cast(mp, type_num)
//         PyArray_CastToType(mp, PyArray_DescrFromType(type_num), 0)

// #define PyArray_Take(ap, items, axis)
//         PyArray_TakeFrom(ap, items, axis, NULL, NPY_RAISE)

// #define PyArray_Put(ap, items, values)
//         PyArray_PutTo(ap, items, values, NPY_RAISE)

/* Compatibility with old Numeric stuff -- don't use in new code */

// #define PyArray_FromDimsAndData(nd, d, type, data)
//         PyArray_FromDimsAndDataAndDescr(nd, d, PyArray_DescrFromType(type),
//                                         data)


/*
   Check to see if this key in the dictionary is the "title"
   entry of the tuple (i.e. a duplicate dictionary entry in the fields
   dict).
*/

@NoException public static native int NPY_TITLE_KEY_check(PyObject key, PyObject value);

/* Macro, for backward compat with "if NPY_TITLE_KEY(key, value) { ..." */
// #define NPY_TITLE_KEY(key, value) (NPY_TITLE_KEY_check((key), (value)))

// #define DEPRECATE(msg) PyErr_WarnEx(PyExc_DeprecationWarning,msg,1)
// #define DEPRECATE_FUTUREWARNING(msg) PyErr_WarnEx(PyExc_FutureWarning,msg,1)

// #if !defined(NPY_NO_DEPRECATED_API) ||
//     (NPY_NO_DEPRECATED_API < NPY_1_14_API_VERSION)
@NoException public static native void PyArray_XDECREF_ERR(PyArrayObject arr);
// #endif


// #ifdef __cplusplus
// #endif


// #endif /* NPY_NDARRAYOBJECT_H */


// Parsed from __multiarray_api.h


// #if defined(_MULTIARRAYMODULE) || defined(WITH_CPYCHECKER_STEALS_REFERENCE_TO_ARG_ATTRIBUTE)



public static native @ByRef PyBoolScalarObject _PyArrayScalar_BoolValues(int i); public static native void _PyArrayScalar_BoolValues(int i, PyBoolScalarObject setter);
@MemberGetter public static native PyBoolScalarObject _PyArrayScalar_BoolValues();

@NoException public static native @Cast("unsigned int") int PyArray_GetNDArrayCVersion();
public static native @ByRef PyTypeObject PyBigArray_Type(); public static native void PyBigArray_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyArray_Type(); public static native void PyArray_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyArrayDescr_Type(); public static native void PyArrayDescr_Type(PyTypeObject setter);
// #define PyArrayDescr_Type (*(PyTypeObject *)(&PyArrayDescr_TypeFull))

public static native @ByRef PyTypeObject PyArrayFlags_Type(); public static native void PyArrayFlags_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyArrayIter_Type(); public static native void PyArrayIter_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyArrayMultiIter_Type(); public static native void PyArrayMultiIter_Type(PyTypeObject setter);

public static native int NPY_NUMUSERTYPES(); public static native void NPY_NUMUSERTYPES(int setter);

public static native @ByRef PyTypeObject PyBoolArrType_Type(); public static native void PyBoolArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyGenericArrType_Type(); public static native void PyGenericArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyNumberArrType_Type(); public static native void PyNumberArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyIntegerArrType_Type(); public static native void PyIntegerArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PySignedIntegerArrType_Type(); public static native void PySignedIntegerArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyUnsignedIntegerArrType_Type(); public static native void PyUnsignedIntegerArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyInexactArrType_Type(); public static native void PyInexactArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyFloatingArrType_Type(); public static native void PyFloatingArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyComplexFloatingArrType_Type(); public static native void PyComplexFloatingArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyFlexibleArrType_Type(); public static native void PyFlexibleArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyCharacterArrType_Type(); public static native void PyCharacterArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyByteArrType_Type(); public static native void PyByteArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyShortArrType_Type(); public static native void PyShortArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyIntArrType_Type(); public static native void PyIntArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyLongArrType_Type(); public static native void PyLongArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyLongLongArrType_Type(); public static native void PyLongLongArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyUByteArrType_Type(); public static native void PyUByteArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyUShortArrType_Type(); public static native void PyUShortArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyUIntArrType_Type(); public static native void PyUIntArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyULongArrType_Type(); public static native void PyULongArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyULongLongArrType_Type(); public static native void PyULongLongArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyFloatArrType_Type(); public static native void PyFloatArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyDoubleArrType_Type(); public static native void PyDoubleArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyLongDoubleArrType_Type(); public static native void PyLongDoubleArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyCFloatArrType_Type(); public static native void PyCFloatArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyCDoubleArrType_Type(); public static native void PyCDoubleArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyCLongDoubleArrType_Type(); public static native void PyCLongDoubleArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyObjectArrType_Type(); public static native void PyObjectArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyStringArrType_Type(); public static native void PyStringArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyUnicodeArrType_Type(); public static native void PyUnicodeArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyVoidArrType_Type(); public static native void PyVoidArrType_Type(PyTypeObject setter);

@NoException public static native int PyArray_SetNumericOps(PyObject arg0);
@NoException public static native PyObject PyArray_GetNumericOps();
@NoException public static native int PyArray_INCREF(PyArrayObject arg0);
@NoException public static native int PyArray_XDECREF(PyArrayObject arg0);
@NoException public static native void PyArray_SetStringFunction(PyObject arg0, int arg1);
@NoException public static native PyArray_Descr PyArray_DescrFromType(int arg0);
@NoException public static native PyObject PyArray_TypeObjectFromType(int arg0);
@NoException public static native @Cast("char*") BytePointer PyArray_Zero(PyArrayObject arg0);
@NoException public static native @Cast("char*") BytePointer PyArray_One(PyArrayObject arg0);
@NoException public static native PyObject PyArray_CastToType(PyArrayObject arg0, PyArray_Descr arg1, int arg2);
@NoException public static native int PyArray_CastTo(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native int PyArray_CastAnyTo(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native int PyArray_CanCastSafely(int arg0, int arg1);
@NoException public static native @Cast("npy_bool") byte PyArray_CanCastTo(PyArray_Descr arg0, PyArray_Descr arg1);
@NoException public static native int PyArray_ObjectType(PyObject arg0, int arg1);
@NoException public static native PyArray_Descr PyArray_DescrFromObject(PyObject arg0, PyArray_Descr arg1);
@NoException public static native @Cast("PyArrayObject**") PointerPointer PyArray_ConvertToCommonType(PyObject arg0, IntPointer arg1);
@NoException public static native @ByPtrPtr PyArrayObject PyArray_ConvertToCommonType(PyObject arg0, IntBuffer arg1);
@NoException public static native @ByPtrPtr PyArrayObject PyArray_ConvertToCommonType(PyObject arg0, int[] arg1);
@NoException public static native PyArray_Descr PyArray_DescrFromScalar(PyObject arg0);
@NoException public static native PyArray_Descr PyArray_DescrFromTypeObject(PyObject arg0);
@NoException public static native @Cast("npy_intp") long PyArray_Size(PyObject arg0);
@NoException public static native PyObject PyArray_Scalar(Pointer arg0, PyArray_Descr arg1, PyObject arg2);
@NoException public static native PyObject PyArray_FromScalar(PyObject arg0, PyArray_Descr arg1);
@NoException public static native void PyArray_ScalarAsCtype(PyObject arg0, Pointer arg1);
@NoException public static native int PyArray_CastScalarToCtype(PyObject arg0, Pointer arg1, PyArray_Descr arg2);
@NoException public static native int PyArray_CastScalarDirect(PyObject arg0, PyArray_Descr arg1, Pointer arg2, int arg3);
@NoException public static native PyObject PyArray_ScalarFromObject(PyObject arg0);
@NoException public static native PyArray_VectorUnaryFunc PyArray_GetCastFunc(PyArray_Descr arg0, int arg1);
@NoException public static native PyObject PyArray_FromDims(int __NPY_UNUSED_TAGGEDnd, IntPointer __NPY_UNUSED_TAGGEDd, int __NPY_UNUSED_TAGGEDtype );
@NoException public static native PyObject PyArray_FromDims(int __NPY_UNUSED_TAGGEDnd, IntBuffer __NPY_UNUSED_TAGGEDd, int __NPY_UNUSED_TAGGEDtype );
@NoException public static native PyObject PyArray_FromDims(int __NPY_UNUSED_TAGGEDnd, int[] __NPY_UNUSED_TAGGEDd, int __NPY_UNUSED_TAGGEDtype );
@NoException public static native PyObject PyArray_FromDimsAndDataAndDescr(int __NPY_UNUSED_TAGGEDnd, IntPointer __NPY_UNUSED_TAGGEDd, PyArray_Descr arg2, @Cast("char*") BytePointer __NPY_UNUSED_TAGGEDdata );
@NoException public static native PyObject PyArray_FromDimsAndDataAndDescr(int __NPY_UNUSED_TAGGEDnd, IntBuffer __NPY_UNUSED_TAGGEDd, PyArray_Descr arg2, @Cast("char*") ByteBuffer __NPY_UNUSED_TAGGEDdata );
@NoException public static native PyObject PyArray_FromDimsAndDataAndDescr(int __NPY_UNUSED_TAGGEDnd, int[] __NPY_UNUSED_TAGGEDd, PyArray_Descr arg2, @Cast("char*") byte[] __NPY_UNUSED_TAGGEDdata );
@NoException public static native PyObject PyArray_FromAny(PyObject arg0, PyArray_Descr arg1, int arg2, int arg3, int arg4, PyObject arg5);
@NoException public static native PyObject PyArray_EnsureArray(PyObject arg0);
@NoException public static native PyObject PyArray_EnsureAnyArray(PyObject arg0);
@NoException public static native PyObject PyArray_FromFile(@Cast("FILE*") Pointer arg0, PyArray_Descr arg1, @Cast("npy_intp") long arg2, @Cast("char*") BytePointer arg3);
@NoException public static native PyObject PyArray_FromFile(@Cast("FILE*") Pointer arg0, PyArray_Descr arg1, @Cast("npy_intp") long arg2, @Cast("char*") ByteBuffer arg3);
@NoException public static native PyObject PyArray_FromFile(@Cast("FILE*") Pointer arg0, PyArray_Descr arg1, @Cast("npy_intp") long arg2, @Cast("char*") byte[] arg3);
@NoException public static native PyObject PyArray_FromString(@Cast("char*") BytePointer arg0, @Cast("npy_intp") long arg1, PyArray_Descr arg2, @Cast("npy_intp") long arg3, @Cast("char*") BytePointer arg4);
@NoException public static native PyObject PyArray_FromString(@Cast("char*") ByteBuffer arg0, @Cast("npy_intp") long arg1, PyArray_Descr arg2, @Cast("npy_intp") long arg3, @Cast("char*") ByteBuffer arg4);
@NoException public static native PyObject PyArray_FromString(@Cast("char*") byte[] arg0, @Cast("npy_intp") long arg1, PyArray_Descr arg2, @Cast("npy_intp") long arg3, @Cast("char*") byte[] arg4);
@NoException public static native PyObject PyArray_FromBuffer(PyObject arg0, PyArray_Descr arg1, @Cast("npy_intp") long arg2, @Cast("npy_intp") long arg3);
@NoException public static native PyObject PyArray_FromIter(PyObject arg0, PyArray_Descr arg1, @Cast("npy_intp") long arg2);
@NoException public static native PyObject PyArray_Return(PyArrayObject arg0);
@NoException public static native PyObject PyArray_GetField(PyArrayObject arg0, PyArray_Descr arg1, int arg2);
@NoException public static native int PyArray_SetField(PyArrayObject arg0, PyArray_Descr arg1, int arg2, PyObject arg3);
@NoException public static native PyObject PyArray_Byteswap(PyArrayObject arg0, @Cast("npy_bool") byte arg1);
@NoException public static native PyObject PyArray_Resize(PyArrayObject arg0, PyArray_Dims arg1, int arg2, @Cast("NPY_ORDER") int __NPY_UNUSED_TAGGEDorder );
@NoException public static native int PyArray_MoveInto(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native int PyArray_CopyInto(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native int PyArray_CopyAnyInto(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native int PyArray_CopyObject(PyArrayObject arg0, PyObject arg1);
@NoException public static native PyObject PyArray_NewCopy(PyArrayObject arg0, @Cast("NPY_ORDER") int arg1);
@NoException public static native PyObject PyArray_ToList(PyArrayObject arg0);
@NoException public static native PyObject PyArray_ToString(PyArrayObject arg0, @Cast("NPY_ORDER") int arg1);
@NoException public static native int PyArray_ToFile(PyArrayObject arg0, @Cast("FILE*") Pointer arg1, @Cast("char*") BytePointer arg2, @Cast("char*") BytePointer arg3);
@NoException public static native int PyArray_ToFile(PyArrayObject arg0, @Cast("FILE*") Pointer arg1, @Cast("char*") ByteBuffer arg2, @Cast("char*") ByteBuffer arg3);
@NoException public static native int PyArray_ToFile(PyArrayObject arg0, @Cast("FILE*") Pointer arg1, @Cast("char*") byte[] arg2, @Cast("char*") byte[] arg3);
@NoException public static native int PyArray_Dump(PyObject arg0, PyObject arg1, int arg2);
@NoException public static native PyObject PyArray_Dumps(PyObject arg0, int arg1);
@NoException public static native int PyArray_ValidType(int arg0);
@NoException public static native void PyArray_UpdateFlags(PyArrayObject arg0, int arg1);
@NoException public static native PyObject PyArray_New(PyTypeObject arg0, int arg1, @Cast("const npy_intp*") SizeTPointer arg2, int arg3, @Cast("const npy_intp*") SizeTPointer arg4, Pointer arg5, int arg6, int arg7, PyObject arg8);
@NoException public static native PyObject PyArray_NewFromDescr(PyTypeObject arg0, PyArray_Descr arg1, int arg2, @Cast("const npy_intp*") SizeTPointer arg3, @Cast("const npy_intp*") SizeTPointer arg4, Pointer arg5, int arg6, PyObject arg7);
@NoException public static native PyArray_Descr PyArray_DescrNew(PyArray_Descr arg0);
@NoException public static native PyArray_Descr PyArray_DescrNewFromType(int arg0);
@NoException public static native double PyArray_GetPriority(PyObject arg0, double arg1);
@NoException public static native PyObject PyArray_IterNew(PyObject arg0);
@NoException public static native PyObject PyArray_MultiIterNew(int arg0);
@NoException public static native int PyArray_PyIntAsInt(PyObject arg0);
@NoException public static native @Cast("npy_intp") long PyArray_PyIntAsIntp(PyObject arg0);
@NoException public static native int PyArray_Broadcast(PyArrayMultiIterObject arg0);
@NoException public static native void PyArray_FillObjectArray(PyArrayObject arg0, PyObject arg1);
@NoException public static native int PyArray_FillWithScalar(PyArrayObject arg0, PyObject arg1);
@NoException public static native @Cast("npy_bool") byte PyArray_CheckStrides(int arg0, int arg1, @Cast("npy_intp") long arg2, @Cast("npy_intp") long arg3, @Cast("const npy_intp*") SizeTPointer arg4, @Cast("const npy_intp*") SizeTPointer arg5);
@NoException public static native PyArray_Descr PyArray_DescrNewByteorder(PyArray_Descr arg0, @Cast("char") byte arg1);
@NoException public static native PyObject PyArray_IterAllButAxis(PyObject arg0, IntPointer arg1);
@NoException public static native PyObject PyArray_IterAllButAxis(PyObject arg0, IntBuffer arg1);
@NoException public static native PyObject PyArray_IterAllButAxis(PyObject arg0, int[] arg1);
@NoException public static native PyObject PyArray_CheckFromAny(PyObject arg0, PyArray_Descr arg1, int arg2, int arg3, int arg4, PyObject arg5);
@NoException public static native PyObject PyArray_FromArray(PyArrayObject arg0, PyArray_Descr arg1, int arg2);
@NoException public static native PyObject PyArray_FromInterface(PyObject arg0);
@NoException public static native PyObject PyArray_FromStructInterface(PyObject arg0);
@NoException public static native PyObject PyArray_FromArrayAttr(PyObject arg0, PyArray_Descr arg1, PyObject arg2);
@NoException public static native @Cast("NPY_SCALARKIND") int PyArray_ScalarKind(int arg0, @Cast("PyArrayObject**") PointerPointer arg1);
@NoException public static native @Cast("NPY_SCALARKIND") int PyArray_ScalarKind(int arg0, @ByPtrPtr PyArrayObject arg1);
@NoException public static native int PyArray_CanCoerceScalar(int arg0, int arg1, @Cast("NPY_SCALARKIND") int arg2);
@NoException public static native PyObject PyArray_NewFlagsObject(PyObject arg0);
@NoException public static native @Cast("npy_bool") byte PyArray_CanCastScalar(PyTypeObject arg0, PyTypeObject arg1);
@NoException public static native int PyArray_CompareUCS4(@Cast("const npy_ucs4*") IntPointer arg0, @Cast("const npy_ucs4*") IntPointer arg1, @Cast("size_t") long arg2);
@NoException public static native int PyArray_CompareUCS4(@Cast("const npy_ucs4*") IntBuffer arg0, @Cast("const npy_ucs4*") IntBuffer arg1, @Cast("size_t") long arg2);
@NoException public static native int PyArray_CompareUCS4(@Cast("const npy_ucs4*") int[] arg0, @Cast("const npy_ucs4*") int[] arg1, @Cast("size_t") long arg2);
@NoException public static native int PyArray_RemoveSmallest(PyArrayMultiIterObject arg0);
@NoException public static native int PyArray_ElementStrides(PyObject arg0);
@NoException public static native void PyArray_Item_INCREF(@Cast("char*") BytePointer arg0, PyArray_Descr arg1);
@NoException public static native void PyArray_Item_INCREF(@Cast("char*") ByteBuffer arg0, PyArray_Descr arg1);
@NoException public static native void PyArray_Item_INCREF(@Cast("char*") byte[] arg0, PyArray_Descr arg1);
@NoException public static native void PyArray_Item_XDECREF(@Cast("char*") BytePointer arg0, PyArray_Descr arg1);
@NoException public static native void PyArray_Item_XDECREF(@Cast("char*") ByteBuffer arg0, PyArray_Descr arg1);
@NoException public static native void PyArray_Item_XDECREF(@Cast("char*") byte[] arg0, PyArray_Descr arg1);
@NoException public static native PyObject PyArray_FieldNames(PyObject arg0);
@NoException public static native PyObject PyArray_Transpose(PyArrayObject arg0, PyArray_Dims arg1);
@NoException public static native PyObject PyArray_TakeFrom(PyArrayObject arg0, PyObject arg1, int arg2, PyArrayObject arg3, @Cast("NPY_CLIPMODE") int arg4);
@NoException public static native PyObject PyArray_PutTo(PyArrayObject arg0, PyObject arg1, PyObject arg2, @Cast("NPY_CLIPMODE") int arg3);
@NoException public static native PyObject PyArray_PutMask(PyArrayObject arg0, PyObject arg1, PyObject arg2);
@NoException public static native PyObject PyArray_Repeat(PyArrayObject arg0, PyObject arg1, int arg2);
@NoException public static native PyObject PyArray_Choose(PyArrayObject arg0, PyObject arg1, PyArrayObject arg2, @Cast("NPY_CLIPMODE") int arg3);
@NoException public static native int PyArray_Sort(PyArrayObject arg0, int arg1, @Cast("NPY_SORTKIND") int arg2);
@NoException public static native PyObject PyArray_ArgSort(PyArrayObject arg0, int arg1, @Cast("NPY_SORTKIND") int arg2);
@NoException public static native PyObject PyArray_SearchSorted(PyArrayObject arg0, PyObject arg1, @Cast("NPY_SEARCHSIDE") int arg2, PyObject arg3);
@NoException public static native PyObject PyArray_ArgMax(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_ArgMin(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_Reshape(PyArrayObject arg0, PyObject arg1);
@NoException public static native PyObject PyArray_Newshape(PyArrayObject arg0, PyArray_Dims arg1, @Cast("NPY_ORDER") int arg2);
@NoException public static native PyObject PyArray_Squeeze(PyArrayObject arg0);
@NoException public static native PyObject PyArray_View(PyArrayObject arg0, PyArray_Descr arg1, PyTypeObject arg2);
@NoException public static native PyObject PyArray_SwapAxes(PyArrayObject arg0, int arg1, int arg2);
@NoException public static native PyObject PyArray_Max(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_Min(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_Ptp(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_Mean(PyArrayObject arg0, int arg1, int arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_Trace(PyArrayObject arg0, int arg1, int arg2, int arg3, int arg4, PyArrayObject arg5);
@NoException public static native PyObject PyArray_Diagonal(PyArrayObject arg0, int arg1, int arg2, int arg3);
@NoException public static native PyObject PyArray_Clip(PyArrayObject arg0, PyObject arg1, PyObject arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_Conjugate(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native PyObject PyArray_Nonzero(PyArrayObject arg0);
@NoException public static native PyObject PyArray_Std(PyArrayObject arg0, int arg1, int arg2, PyArrayObject arg3, int arg4);
@NoException public static native PyObject PyArray_Sum(PyArrayObject arg0, int arg1, int arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_CumSum(PyArrayObject arg0, int arg1, int arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_Prod(PyArrayObject arg0, int arg1, int arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_CumProd(PyArrayObject arg0, int arg1, int arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_All(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_Any(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native PyObject PyArray_Compress(PyArrayObject arg0, PyObject arg1, int arg2, PyArrayObject arg3);
@NoException public static native PyObject PyArray_Flatten(PyArrayObject arg0, @Cast("NPY_ORDER") int arg1);
@NoException public static native PyObject PyArray_Ravel(PyArrayObject arg0, @Cast("NPY_ORDER") int arg1);
@NoException public static native @Cast("npy_intp") long PyArray_MultiplyList(@Cast("const npy_intp*") SizeTPointer arg0, int arg1);
@NoException public static native int PyArray_MultiplyIntList(@Const IntPointer arg0, int arg1);
@NoException public static native int PyArray_MultiplyIntList(@Const IntBuffer arg0, int arg1);
@NoException public static native int PyArray_MultiplyIntList(@Const int[] arg0, int arg1);
@NoException public static native Pointer PyArray_GetPtr(PyArrayObject arg0, @Cast("const npy_intp*") SizeTPointer arg1);
@NoException public static native int PyArray_CompareLists(@Cast("const npy_intp*") SizeTPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, int arg2);
@NoException public static native int PyArray_AsCArray(@Cast("PyObject**") PointerPointer arg0, Pointer arg1, @Cast("npy_intp*") SizeTPointer arg2, int arg3, PyArray_Descr arg4);
@NoException public static native int PyArray_AsCArray(@ByPtrPtr PyObject arg0, Pointer arg1, @Cast("npy_intp*") SizeTPointer arg2, int arg3, PyArray_Descr arg4);
@NoException public static native int PyArray_As1D(@Cast("PyObject**") PointerPointer __NPY_UNUSED_TAGGEDop, @Cast("char**") PointerPointer __NPY_UNUSED_TAGGEDptr, IntPointer __NPY_UNUSED_TAGGEDd1, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As1D(@ByPtrPtr PyObject __NPY_UNUSED_TAGGEDop, @Cast("char**") @ByPtrPtr BytePointer __NPY_UNUSED_TAGGEDptr, IntPointer __NPY_UNUSED_TAGGEDd1, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As1D(@ByPtrPtr PyObject __NPY_UNUSED_TAGGEDop, @Cast("char**") @ByPtrPtr ByteBuffer __NPY_UNUSED_TAGGEDptr, IntBuffer __NPY_UNUSED_TAGGEDd1, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As1D(@ByPtrPtr PyObject __NPY_UNUSED_TAGGEDop, @Cast("char**") @ByPtrPtr byte[] __NPY_UNUSED_TAGGEDptr, int[] __NPY_UNUSED_TAGGEDd1, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As2D(@Cast("PyObject**") PointerPointer __NPY_UNUSED_TAGGEDop, @Cast("char***") @ByPtrPtr PointerPointer __NPY_UNUSED_TAGGEDptr, IntPointer __NPY_UNUSED_TAGGEDd1, IntPointer __NPY_UNUSED_TAGGEDd2, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As2D(@ByPtrPtr PyObject __NPY_UNUSED_TAGGEDop, @Cast("char***") @ByPtrPtr PointerPointer __NPY_UNUSED_TAGGEDptr, IntPointer __NPY_UNUSED_TAGGEDd1, IntPointer __NPY_UNUSED_TAGGEDd2, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As2D(@ByPtrPtr PyObject __NPY_UNUSED_TAGGEDop, @Cast("char***") @ByPtrPtr PointerPointer __NPY_UNUSED_TAGGEDptr, IntBuffer __NPY_UNUSED_TAGGEDd1, IntBuffer __NPY_UNUSED_TAGGEDd2, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_As2D(@ByPtrPtr PyObject __NPY_UNUSED_TAGGEDop, @Cast("char***") @ByPtrPtr PointerPointer __NPY_UNUSED_TAGGEDptr, int[] __NPY_UNUSED_TAGGEDd1, int[] __NPY_UNUSED_TAGGEDd2, int __NPY_UNUSED_TAGGEDtypecode );
@NoException public static native int PyArray_Free(PyObject arg0, Pointer arg1);
@NoException public static native int PyArray_Converter(PyObject arg0, @Cast("PyObject**") PointerPointer arg1);
@NoException public static native int PyArray_Converter(PyObject arg0, @ByPtrPtr PyObject arg1);
@NoException public static native int PyArray_IntpFromSequence(PyObject arg0, @Cast("npy_intp*") SizeTPointer arg1, int arg2);
@NoException public static native PyObject PyArray_Concatenate(PyObject arg0, int arg1);
@NoException public static native PyObject PyArray_InnerProduct(PyObject arg0, PyObject arg1);
@NoException public static native PyObject PyArray_MatrixProduct(PyObject arg0, PyObject arg1);
@NoException public static native PyObject PyArray_CopyAndTranspose(PyObject arg0);
@NoException public static native PyObject PyArray_Correlate(PyObject arg0, PyObject arg1, int arg2);
@NoException public static native int PyArray_TypestrConvert(int arg0, int arg1);
@NoException public static native int PyArray_DescrConverter(PyObject arg0, @Cast("PyArray_Descr**") PointerPointer arg1);
@NoException public static native int PyArray_DescrConverter(PyObject arg0, @ByPtrPtr PyArray_Descr arg1);
@NoException public static native int PyArray_DescrConverter2(PyObject arg0, @Cast("PyArray_Descr**") PointerPointer arg1);
@NoException public static native int PyArray_DescrConverter2(PyObject arg0, @ByPtrPtr PyArray_Descr arg1);
@NoException public static native int PyArray_IntpConverter(PyObject arg0, PyArray_Dims arg1);
@NoException public static native int PyArray_BufferConverter(PyObject arg0, PyArray_Chunk arg1);
@NoException public static native int PyArray_AxisConverter(PyObject arg0, IntPointer arg1);
@NoException public static native int PyArray_AxisConverter(PyObject arg0, IntBuffer arg1);
@NoException public static native int PyArray_AxisConverter(PyObject arg0, int[] arg1);
@NoException public static native int PyArray_BoolConverter(PyObject arg0, @Cast("npy_bool*") BytePointer arg1);
@NoException public static native int PyArray_BoolConverter(PyObject arg0, @Cast("npy_bool*") ByteBuffer arg1);
@NoException public static native int PyArray_BoolConverter(PyObject arg0, @Cast("npy_bool*") byte[] arg1);
@NoException public static native int PyArray_ByteorderConverter(PyObject arg0, @Cast("char*") BytePointer arg1);
@NoException public static native int PyArray_ByteorderConverter(PyObject arg0, @Cast("char*") ByteBuffer arg1);
@NoException public static native int PyArray_ByteorderConverter(PyObject arg0, @Cast("char*") byte[] arg1);
@NoException public static native int PyArray_OrderConverter(PyObject arg0, @Cast("NPY_ORDER*") IntPointer arg1);
@NoException public static native int PyArray_OrderConverter(PyObject arg0, @Cast("NPY_ORDER*") IntBuffer arg1);
@NoException public static native int PyArray_OrderConverter(PyObject arg0, @Cast("NPY_ORDER*") int[] arg1);
@NoException public static native @Cast("unsigned char") byte PyArray_EquivTypes(PyArray_Descr arg0, PyArray_Descr arg1);
@NoException public static native PyObject PyArray_Zeros(int arg0, @Cast("const npy_intp*") SizeTPointer arg1, PyArray_Descr arg2, int arg3);
@NoException public static native PyObject PyArray_Empty(int arg0, @Cast("const npy_intp*") SizeTPointer arg1, PyArray_Descr arg2, int arg3);
@NoException public static native PyObject PyArray_Where(PyObject arg0, PyObject arg1, PyObject arg2);
@NoException public static native PyObject PyArray_Arange(double arg0, double arg1, double arg2, int arg3);
@NoException public static native PyObject PyArray_ArangeObj(PyObject arg0, PyObject arg1, PyObject arg2, PyArray_Descr arg3);
@NoException public static native int PyArray_SortkindConverter(PyObject arg0, @Cast("NPY_SORTKIND*") IntPointer arg1);
@NoException public static native int PyArray_SortkindConverter(PyObject arg0, @Cast("NPY_SORTKIND*") IntBuffer arg1);
@NoException public static native int PyArray_SortkindConverter(PyObject arg0, @Cast("NPY_SORTKIND*") int[] arg1);
@NoException public static native PyObject PyArray_LexSort(PyObject arg0, int arg1);
@NoException public static native PyObject PyArray_Round(PyArrayObject arg0, int arg1, PyArrayObject arg2);
@NoException public static native @Cast("unsigned char") byte PyArray_EquivTypenums(int arg0, int arg1);
@NoException public static native int PyArray_RegisterDataType(PyArray_Descr arg0);
@NoException public static native int PyArray_RegisterCastFunc(PyArray_Descr arg0, int arg1, PyArray_VectorUnaryFunc arg2);
@NoException public static native int PyArray_RegisterCanCast(PyArray_Descr arg0, int arg1, @Cast("NPY_SCALARKIND") int arg2);
@NoException public static native void PyArray_InitArrFuncs(PyArray_ArrFuncs arg0);
@NoException public static native PyObject PyArray_IntTupleFromIntp(int arg0, @Cast("const npy_intp*") SizeTPointer arg1);
@NoException public static native int PyArray_TypeNumFromName(@Cast("const char*") BytePointer arg0);
@NoException public static native int PyArray_TypeNumFromName(String arg0);
@NoException public static native int PyArray_ClipmodeConverter(PyObject arg0, @Cast("NPY_CLIPMODE*") IntPointer arg1);
@NoException public static native int PyArray_ClipmodeConverter(PyObject arg0, @Cast("NPY_CLIPMODE*") IntBuffer arg1);
@NoException public static native int PyArray_ClipmodeConverter(PyObject arg0, @Cast("NPY_CLIPMODE*") int[] arg1);
@NoException public static native int PyArray_OutputConverter(PyObject arg0, @Cast("PyArrayObject**") PointerPointer arg1);
@NoException public static native int PyArray_OutputConverter(PyObject arg0, @ByPtrPtr PyArrayObject arg1);
@NoException public static native PyObject PyArray_BroadcastToShape(PyObject arg0, @Cast("npy_intp*") SizeTPointer arg1, int arg2);
@NoException public static native void _PyArray_SigintHandler(int arg0);
@NoException public static native Pointer _PyArray_GetSigintBuf();
@NoException public static native int PyArray_DescrAlignConverter(PyObject arg0, @Cast("PyArray_Descr**") PointerPointer arg1);
@NoException public static native int PyArray_DescrAlignConverter(PyObject arg0, @ByPtrPtr PyArray_Descr arg1);
@NoException public static native int PyArray_DescrAlignConverter2(PyObject arg0, @Cast("PyArray_Descr**") PointerPointer arg1);
@NoException public static native int PyArray_DescrAlignConverter2(PyObject arg0, @ByPtrPtr PyArray_Descr arg1);
@NoException public static native int PyArray_SearchsideConverter(PyObject arg0, Pointer arg1);
@NoException public static native PyObject PyArray_CheckAxis(PyArrayObject arg0, IntPointer arg1, int arg2);
@NoException public static native PyObject PyArray_CheckAxis(PyArrayObject arg0, IntBuffer arg1, int arg2);
@NoException public static native PyObject PyArray_CheckAxis(PyArrayObject arg0, int[] arg1, int arg2);
@NoException public static native @Cast("npy_intp") long PyArray_OverflowMultiplyList(@Cast("const npy_intp*") SizeTPointer arg0, int arg1);
@NoException public static native int PyArray_CompareString(@Cast("const char*") BytePointer arg0, @Cast("const char*") BytePointer arg1, @Cast("size_t") long arg2);
@NoException public static native int PyArray_CompareString(String arg0, String arg1, @Cast("size_t") long arg2);
@NoException public static native PyObject PyArray_MultiIterFromObjects(@Cast("PyObject**") PointerPointer arg0, int arg1, int arg2);
@NoException public static native PyObject PyArray_MultiIterFromObjects(@ByPtrPtr PyObject arg0, int arg1, int arg2);
@NoException public static native int PyArray_GetEndianness();
@NoException public static native @Cast("unsigned int") int PyArray_GetNDArrayCFeatureVersion();
@NoException public static native PyObject PyArray_Correlate2(PyObject arg0, PyObject arg1, int arg2);
@NoException public static native PyObject PyArray_NeighborhoodIterNew(PyArrayIterObject arg0, @Cast("const npy_intp*") SizeTPointer arg1, int arg2, PyArrayObject arg3);
public static native @ByRef PyTypeObject PyTimeIntegerArrType_Type(); public static native void PyTimeIntegerArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyDatetimeArrType_Type(); public static native void PyDatetimeArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyTimedeltaArrType_Type(); public static native void PyTimedeltaArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject PyHalfArrType_Type(); public static native void PyHalfArrType_Type(PyTypeObject setter);

public static native @ByRef PyTypeObject NpyIter_Type(); public static native void NpyIter_Type(PyTypeObject setter);

@NoException public static native void PyArray_SetDatetimeParseFunction(PyObject __NPY_UNUSED_TAGGEDop );
@NoException public static native void PyArray_DatetimeToDatetimeStruct(@Cast("npy_datetime") long __NPY_UNUSED_TAGGEDval, @Cast("NPY_DATETIMEUNIT") int __NPY_UNUSED_TAGGEDfr, npy_datetimestruct arg2);
@NoException public static native void PyArray_TimedeltaToTimedeltaStruct(@Cast("npy_timedelta") long __NPY_UNUSED_TAGGEDval, @Cast("NPY_DATETIMEUNIT") int __NPY_UNUSED_TAGGEDfr, npy_timedeltastruct arg2);
@NoException public static native @Cast("npy_datetime") long PyArray_DatetimeStructToDatetime(@Cast("NPY_DATETIMEUNIT") int __NPY_UNUSED_TAGGEDfr, npy_datetimestruct __NPY_UNUSED_TAGGEDd );
@NoException public static native @Cast("npy_datetime") long PyArray_TimedeltaStructToTimedelta(@Cast("NPY_DATETIMEUNIT") int __NPY_UNUSED_TAGGEDfr, npy_timedeltastruct __NPY_UNUSED_TAGGEDd );
@NoException public static native NpyIter NpyIter_New(PyArrayObject arg0, @Cast("npy_uint32") int arg1, @Cast("NPY_ORDER") int arg2, @Cast("NPY_CASTING") int arg3, PyArray_Descr arg4);
@NoException public static native NpyIter NpyIter_MultiNew(int arg0, @Cast("PyArrayObject**") PointerPointer arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") IntPointer arg5, @Cast("PyArray_Descr**") PointerPointer arg6);
@NoException public static native NpyIter NpyIter_MultiNew(int arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") IntPointer arg5, @ByPtrPtr PyArray_Descr arg6);
@NoException public static native NpyIter NpyIter_MultiNew(int arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") IntBuffer arg5, @ByPtrPtr PyArray_Descr arg6);
@NoException public static native NpyIter NpyIter_MultiNew(int arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") int[] arg5, @ByPtrPtr PyArray_Descr arg6);
@NoException public static native NpyIter NpyIter_AdvancedNew(int arg0, @Cast("PyArrayObject**") PointerPointer arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") IntPointer arg5, @Cast("PyArray_Descr**") PointerPointer arg6, int arg7, @Cast("int**") PointerPointer arg8, @Cast("npy_intp*") SizeTPointer arg9, @Cast("npy_intp") long arg10);
@NoException public static native NpyIter NpyIter_AdvancedNew(int arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") IntPointer arg5, @ByPtrPtr PyArray_Descr arg6, int arg7, @ByPtrPtr IntPointer arg8, @Cast("npy_intp*") SizeTPointer arg9, @Cast("npy_intp") long arg10);
@NoException public static native NpyIter NpyIter_AdvancedNew(int arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") IntBuffer arg5, @ByPtrPtr PyArray_Descr arg6, int arg7, @ByPtrPtr IntBuffer arg8, @Cast("npy_intp*") SizeTPointer arg9, @Cast("npy_intp") long arg10);
@NoException public static native NpyIter NpyIter_AdvancedNew(int arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_uint32") int arg2, @Cast("NPY_ORDER") int arg3, @Cast("NPY_CASTING") int arg4, @Cast("npy_uint32*") int[] arg5, @ByPtrPtr PyArray_Descr arg6, int arg7, @ByPtrPtr int[] arg8, @Cast("npy_intp*") SizeTPointer arg9, @Cast("npy_intp") long arg10);
@NoException public static native NpyIter NpyIter_Copy(NpyIter arg0);
@NoException public static native int NpyIter_Deallocate(NpyIter arg0);
@NoException public static native @Cast("npy_bool") byte NpyIter_HasDelayedBufAlloc(NpyIter arg0);
@NoException public static native @Cast("npy_bool") byte NpyIter_HasExternalLoop(NpyIter arg0);
@NoException public static native int NpyIter_EnableExternalLoop(NpyIter arg0);
@NoException public static native @Cast("npy_intp*") SizeTPointer NpyIter_GetInnerStrideArray(NpyIter arg0);
@NoException public static native @Cast("npy_intp*") SizeTPointer NpyIter_GetInnerLoopSizePtr(NpyIter arg0);
@NoException public static native int NpyIter_Reset(NpyIter arg0, @Cast("char**") PointerPointer arg1);
@NoException public static native int NpyIter_Reset(NpyIter arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
@NoException public static native int NpyIter_Reset(NpyIter arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
@NoException public static native int NpyIter_Reset(NpyIter arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
@NoException public static native int NpyIter_ResetBasePointers(NpyIter arg0, @Cast("char**") PointerPointer arg1, @Cast("char**") PointerPointer arg2);
@NoException public static native int NpyIter_ResetBasePointers(NpyIter arg0, @Cast("char**") @ByPtrPtr BytePointer arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
@NoException public static native int NpyIter_ResetBasePointers(NpyIter arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
@NoException public static native int NpyIter_ResetBasePointers(NpyIter arg0, @Cast("char**") @ByPtrPtr byte[] arg1, @Cast("char**") @ByPtrPtr byte[] arg2);
@NoException public static native int NpyIter_ResetToIterIndexRange(NpyIter arg0, @Cast("npy_intp") long arg1, @Cast("npy_intp") long arg2, @Cast("char**") PointerPointer arg3);
@NoException public static native int NpyIter_ResetToIterIndexRange(NpyIter arg0, @Cast("npy_intp") long arg1, @Cast("npy_intp") long arg2, @Cast("char**") @ByPtrPtr BytePointer arg3);
@NoException public static native int NpyIter_ResetToIterIndexRange(NpyIter arg0, @Cast("npy_intp") long arg1, @Cast("npy_intp") long arg2, @Cast("char**") @ByPtrPtr ByteBuffer arg3);
@NoException public static native int NpyIter_ResetToIterIndexRange(NpyIter arg0, @Cast("npy_intp") long arg1, @Cast("npy_intp") long arg2, @Cast("char**") @ByPtrPtr byte[] arg3);
@NoException public static native int NpyIter_GetNDim(NpyIter arg0);
@NoException public static native int NpyIter_GetNOp(NpyIter arg0);
@NoException public static native NpyIter_IterNextFunc NpyIter_GetIterNext(NpyIter arg0, @Cast("char**") PointerPointer arg1);
@NoException public static native NpyIter_IterNextFunc NpyIter_GetIterNext(NpyIter arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
@NoException public static native NpyIter_IterNextFunc NpyIter_GetIterNext(NpyIter arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
@NoException public static native NpyIter_IterNextFunc NpyIter_GetIterNext(NpyIter arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
@NoException public static native @Cast("npy_intp") long NpyIter_GetIterSize(NpyIter arg0);
@NoException public static native void NpyIter_GetIterIndexRange(NpyIter arg0, @Cast("npy_intp*") SizeTPointer arg1, @Cast("npy_intp*") SizeTPointer arg2);
@NoException public static native @Cast("npy_intp") long NpyIter_GetIterIndex(NpyIter arg0);
@NoException public static native int NpyIter_GotoIterIndex(NpyIter arg0, @Cast("npy_intp") long arg1);
@NoException public static native @Cast("npy_bool") byte NpyIter_HasMultiIndex(NpyIter arg0);
@NoException public static native int NpyIter_GetShape(NpyIter arg0, @Cast("npy_intp*") SizeTPointer arg1);
@NoException public static native NpyIter_GetMultiIndexFunc NpyIter_GetGetMultiIndex(NpyIter arg0, @Cast("char**") PointerPointer arg1);
@NoException public static native NpyIter_GetMultiIndexFunc NpyIter_GetGetMultiIndex(NpyIter arg0, @Cast("char**") @ByPtrPtr BytePointer arg1);
@NoException public static native NpyIter_GetMultiIndexFunc NpyIter_GetGetMultiIndex(NpyIter arg0, @Cast("char**") @ByPtrPtr ByteBuffer arg1);
@NoException public static native NpyIter_GetMultiIndexFunc NpyIter_GetGetMultiIndex(NpyIter arg0, @Cast("char**") @ByPtrPtr byte[] arg1);
@NoException public static native int NpyIter_GotoMultiIndex(NpyIter arg0, @Cast("const npy_intp*") SizeTPointer arg1);
@NoException public static native int NpyIter_RemoveMultiIndex(NpyIter arg0);
@NoException public static native @Cast("npy_bool") byte NpyIter_HasIndex(NpyIter arg0);
@NoException public static native @Cast("npy_bool") byte NpyIter_IsBuffered(NpyIter arg0);
@NoException public static native @Cast("npy_bool") byte NpyIter_IsGrowInner(NpyIter arg0);
@NoException public static native @Cast("npy_intp") long NpyIter_GetBufferSize(NpyIter arg0);
@NoException public static native @Cast("npy_intp*") SizeTPointer NpyIter_GetIndexPtr(NpyIter arg0);
@NoException public static native int NpyIter_GotoIndex(NpyIter arg0, @Cast("npy_intp") long arg1);
@NoException public static native @Cast("char**") PointerPointer NpyIter_GetDataPtrArray(NpyIter arg0);
@NoException public static native @Cast("PyArray_Descr**") PointerPointer NpyIter_GetDescrArray(NpyIter arg0);
@NoException public static native @Cast("PyArrayObject**") PointerPointer NpyIter_GetOperandArray(NpyIter arg0);
@NoException public static native PyArrayObject NpyIter_GetIterView(NpyIter arg0, @Cast("npy_intp") long arg1);
@NoException public static native void NpyIter_GetReadFlags(NpyIter arg0, @Cast("char*") BytePointer arg1);
@NoException public static native void NpyIter_GetReadFlags(NpyIter arg0, @Cast("char*") ByteBuffer arg1);
@NoException public static native void NpyIter_GetReadFlags(NpyIter arg0, @Cast("char*") byte[] arg1);
@NoException public static native void NpyIter_GetWriteFlags(NpyIter arg0, @Cast("char*") BytePointer arg1);
@NoException public static native void NpyIter_GetWriteFlags(NpyIter arg0, @Cast("char*") ByteBuffer arg1);
@NoException public static native void NpyIter_GetWriteFlags(NpyIter arg0, @Cast("char*") byte[] arg1);
@NoException public static native void NpyIter_DebugPrint(NpyIter arg0);
@NoException public static native @Cast("npy_bool") byte NpyIter_IterationNeedsAPI(NpyIter arg0);
@NoException public static native void NpyIter_GetInnerFixedStrideArray(NpyIter arg0, @Cast("npy_intp*") SizeTPointer arg1);
@NoException public static native int NpyIter_RemoveAxis(NpyIter arg0, int arg1);
@NoException public static native @Cast("npy_intp*") SizeTPointer NpyIter_GetAxisStrideArray(NpyIter arg0, int arg1);
@NoException public static native @Cast("npy_bool") byte NpyIter_RequiresBuffering(NpyIter arg0);
@NoException public static native @Cast("char**") PointerPointer NpyIter_GetInitialDataPtrArray(NpyIter arg0);
@NoException public static native int NpyIter_CreateCompatibleStrides(NpyIter arg0, @Cast("npy_intp") long arg1, @Cast("npy_intp*") SizeTPointer arg2);
@NoException public static native int PyArray_CastingConverter(PyObject arg0, @Cast("NPY_CASTING*") IntPointer arg1);
@NoException public static native int PyArray_CastingConverter(PyObject arg0, @Cast("NPY_CASTING*") IntBuffer arg1);
@NoException public static native int PyArray_CastingConverter(PyObject arg0, @Cast("NPY_CASTING*") int[] arg1);
@NoException public static native @Cast("npy_intp") long PyArray_CountNonzero(PyArrayObject arg0);
@NoException public static native PyArray_Descr PyArray_PromoteTypes(PyArray_Descr arg0, PyArray_Descr arg1);
@NoException public static native PyArray_Descr PyArray_MinScalarType(PyArrayObject arg0);
@NoException public static native PyArray_Descr PyArray_ResultType(@Cast("npy_intp") long arg0, @Cast("PyArrayObject**") PointerPointer arg1, @Cast("npy_intp") long arg2, @Cast("PyArray_Descr**") PointerPointer arg3);
@NoException public static native PyArray_Descr PyArray_ResultType(@Cast("npy_intp") long arg0, @ByPtrPtr PyArrayObject arg1, @Cast("npy_intp") long arg2, @ByPtrPtr PyArray_Descr arg3);
@NoException public static native @Cast("npy_bool") byte PyArray_CanCastArrayTo(PyArrayObject arg0, PyArray_Descr arg1, @Cast("NPY_CASTING") int arg2);
@NoException public static native @Cast("npy_bool") byte PyArray_CanCastTypeTo(PyArray_Descr arg0, PyArray_Descr arg1, @Cast("NPY_CASTING") int arg2);
@NoException public static native PyArrayObject PyArray_EinsteinSum(@Cast("char*") BytePointer arg0, @Cast("npy_intp") long arg1, @Cast("PyArrayObject**") PointerPointer arg2, PyArray_Descr arg3, @Cast("NPY_ORDER") int arg4, @Cast("NPY_CASTING") int arg5, PyArrayObject arg6);
@NoException public static native PyArrayObject PyArray_EinsteinSum(@Cast("char*") BytePointer arg0, @Cast("npy_intp") long arg1, @ByPtrPtr PyArrayObject arg2, PyArray_Descr arg3, @Cast("NPY_ORDER") int arg4, @Cast("NPY_CASTING") int arg5, PyArrayObject arg6);
@NoException public static native PyArrayObject PyArray_EinsteinSum(@Cast("char*") ByteBuffer arg0, @Cast("npy_intp") long arg1, @ByPtrPtr PyArrayObject arg2, PyArray_Descr arg3, @Cast("NPY_ORDER") int arg4, @Cast("NPY_CASTING") int arg5, PyArrayObject arg6);
@NoException public static native PyArrayObject PyArray_EinsteinSum(@Cast("char*") byte[] arg0, @Cast("npy_intp") long arg1, @ByPtrPtr PyArrayObject arg2, PyArray_Descr arg3, @Cast("NPY_ORDER") int arg4, @Cast("NPY_CASTING") int arg5, PyArrayObject arg6);
@NoException public static native PyObject PyArray_NewLikeArray(PyArrayObject arg0, @Cast("NPY_ORDER") int arg1, PyArray_Descr arg2, int arg3);
@NoException public static native int PyArray_GetArrayParamsFromObject(PyObject __NPY_UNUSED_TAGGEDop, PyArray_Descr __NPY_UNUSED_TAGGEDrequested_dtype, @Cast("npy_bool") byte __NPY_UNUSED_TAGGEDwriteable, @Cast("PyArray_Descr**") PointerPointer __NPY_UNUSED_TAGGEDout_dtype, IntPointer __NPY_UNUSED_TAGGEDout_ndim, @Cast("npy_intp*") SizeTPointer __NPY_UNUSED_TAGGEDout_dims, @Cast("PyArrayObject**") PointerPointer __NPY_UNUSED_TAGGEDout_arr, PyObject __NPY_UNUSED_TAGGEDcontext );
@NoException public static native int PyArray_GetArrayParamsFromObject(PyObject __NPY_UNUSED_TAGGEDop, PyArray_Descr __NPY_UNUSED_TAGGEDrequested_dtype, @Cast("npy_bool") byte __NPY_UNUSED_TAGGEDwriteable, @ByPtrPtr PyArray_Descr __NPY_UNUSED_TAGGEDout_dtype, IntPointer __NPY_UNUSED_TAGGEDout_ndim, @Cast("npy_intp*") SizeTPointer __NPY_UNUSED_TAGGEDout_dims, @ByPtrPtr PyArrayObject __NPY_UNUSED_TAGGEDout_arr, PyObject __NPY_UNUSED_TAGGEDcontext );
@NoException public static native int PyArray_GetArrayParamsFromObject(PyObject __NPY_UNUSED_TAGGEDop, PyArray_Descr __NPY_UNUSED_TAGGEDrequested_dtype, @Cast("npy_bool") byte __NPY_UNUSED_TAGGEDwriteable, @ByPtrPtr PyArray_Descr __NPY_UNUSED_TAGGEDout_dtype, IntBuffer __NPY_UNUSED_TAGGEDout_ndim, @Cast("npy_intp*") SizeTPointer __NPY_UNUSED_TAGGEDout_dims, @ByPtrPtr PyArrayObject __NPY_UNUSED_TAGGEDout_arr, PyObject __NPY_UNUSED_TAGGEDcontext );
@NoException public static native int PyArray_GetArrayParamsFromObject(PyObject __NPY_UNUSED_TAGGEDop, PyArray_Descr __NPY_UNUSED_TAGGEDrequested_dtype, @Cast("npy_bool") byte __NPY_UNUSED_TAGGEDwriteable, @ByPtrPtr PyArray_Descr __NPY_UNUSED_TAGGEDout_dtype, int[] __NPY_UNUSED_TAGGEDout_ndim, @Cast("npy_intp*") SizeTPointer __NPY_UNUSED_TAGGEDout_dims, @ByPtrPtr PyArrayObject __NPY_UNUSED_TAGGEDout_arr, PyObject __NPY_UNUSED_TAGGEDcontext );
@NoException public static native int PyArray_ConvertClipmodeSequence(PyObject arg0, @Cast("NPY_CLIPMODE*") IntPointer arg1, int arg2);
@NoException public static native int PyArray_ConvertClipmodeSequence(PyObject arg0, @Cast("NPY_CLIPMODE*") IntBuffer arg1, int arg2);
@NoException public static native int PyArray_ConvertClipmodeSequence(PyObject arg0, @Cast("NPY_CLIPMODE*") int[] arg1, int arg2);
@NoException public static native PyObject PyArray_MatrixProduct2(PyObject arg0, PyObject arg1, PyArrayObject arg2);
@NoException public static native @Cast("npy_bool") byte NpyIter_IsFirstVisit(NpyIter arg0, int arg1);
@NoException public static native int PyArray_SetBaseObject(PyArrayObject arg0, PyObject arg1);
@NoException public static native void PyArray_CreateSortedStridePerm(int arg0, @Cast("const npy_intp*") SizeTPointer arg1, npy_stride_sort_item arg2);
@NoException public static native void PyArray_RemoveAxesInPlace(PyArrayObject arg0, @Cast("const npy_bool*") BytePointer arg1);
@NoException public static native void PyArray_RemoveAxesInPlace(PyArrayObject arg0, @Cast("const npy_bool*") ByteBuffer arg1);
@NoException public static native void PyArray_RemoveAxesInPlace(PyArrayObject arg0, @Cast("const npy_bool*") byte[] arg1);
@NoException public static native void PyArray_DebugPrint(PyArrayObject arg0);
@NoException public static native int PyArray_FailUnlessWriteable(PyArrayObject arg0, @Cast("const char*") BytePointer arg1);
@NoException public static native int PyArray_FailUnlessWriteable(PyArrayObject arg0, String arg1);
@NoException public static native int PyArray_SetUpdateIfCopyBase(PyArrayObject arg0, PyArrayObject arg1);
@NoException public static native Pointer PyDataMem_NEW(@Cast("size_t") long arg0);
@NoException public static native void PyDataMem_FREE(Pointer arg0);
@NoException public static native Pointer PyDataMem_RENEW(Pointer arg0, @Cast("size_t") long arg1);
@NoException public static native PyDataMem_EventHookFunc PyDataMem_SetEventHook(PyDataMem_EventHookFunc arg0, Pointer arg1, @Cast("void**") PointerPointer arg2);
@NoException public static native PyDataMem_EventHookFunc PyDataMem_SetEventHook(PyDataMem_EventHookFunc arg0, Pointer arg1, @Cast("void**") @ByPtrPtr Pointer arg2);
public static native @Cast("NPY_CASTING") int NPY_DEFAULT_ASSIGN_CASTING(); public static native void NPY_DEFAULT_ASSIGN_CASTING(int setter);

@NoException public static native void PyArray_MapIterSwapAxes(PyArrayMapIterObject arg0, @Cast("PyArrayObject**") PointerPointer arg1, int arg2);
@NoException public static native void PyArray_MapIterSwapAxes(PyArrayMapIterObject arg0, @ByPtrPtr PyArrayObject arg1, int arg2);
@NoException public static native PyObject PyArray_MapIterArray(PyArrayObject arg0, PyObject arg1);
@NoException public static native void PyArray_MapIterNext(PyArrayMapIterObject arg0);
@NoException public static native int PyArray_Partition(PyArrayObject arg0, PyArrayObject arg1, int arg2, @Cast("NPY_SELECTKIND") int arg3);
@NoException public static native PyObject PyArray_ArgPartition(PyArrayObject arg0, PyArrayObject arg1, int arg2, @Cast("NPY_SELECTKIND") int arg3);
@NoException public static native int PyArray_SelectkindConverter(PyObject arg0, @Cast("NPY_SELECTKIND*") IntPointer arg1);
@NoException public static native int PyArray_SelectkindConverter(PyObject arg0, @Cast("NPY_SELECTKIND*") IntBuffer arg1);
@NoException public static native int PyArray_SelectkindConverter(PyObject arg0, @Cast("NPY_SELECTKIND*") int[] arg1);
@NoException public static native Pointer PyDataMem_NEW_ZEROED(@Cast("size_t") long arg0, @Cast("size_t") long arg1);
@NoException public static native int PyArray_CheckAnyScalarExact(PyObject arg0);
@NoException public static native PyObject PyArray_MapIterArrayCopyIfOverlap(PyArrayObject arg0, PyObject arg1, int arg2, PyArrayObject arg3);
@NoException public static native int PyArray_ResolveWritebackIfCopy(PyArrayObject arg0);
@NoException public static native int PyArray_SetWritebackIfCopyBase(PyArrayObject arg0, PyArrayObject arg1);

// #else

// #if defined(PY_ARRAY_UNIQUE_SYMBOL)
// #endif

// #if defined(NO_IMPORT) || defined(NO_IMPORT_ARRAY)
public static native Pointer PyArray_API(int i); public static native void PyArray_API(int i, Pointer setter);
public static native @Cast("void**") PointerPointer PyArray_API(); public static native void PyArray_API(PointerPointer setter);
// #else
// #if defined(PY_ARRAY_UNIQUE_SYMBOL)
// #else
// #endif
// #endif


// #if !defined(NO_IMPORT_ARRAY) && !defined(NO_IMPORT)
@NoException public static native int _import_array();

// #define import_array() {if (_import_array() < 0) {PyErr_Print(); PyErr_SetString(PyExc_ImportError, "numpy.core.multiarray failed to import"); return NULL; } }

// #define import_array1(ret) {if (_import_array() < 0) {PyErr_Print(); PyErr_SetString(PyExc_ImportError, "numpy.core.multiarray failed to import"); return ret; } }

// #define import_array2(msg, ret) {if (_import_array() < 0) {PyErr_Print(); PyErr_SetString(PyExc_ImportError, msg); return ret; } }

// #endif

// #endif


// Parsed from _neighborhood_iterator_imp.h

// #ifndef _NPY_INCLUDE_NEIGHBORHOOD_IMP
// #error You should not include this header directly
// #endif
/*
 * Private API (here for inline)
 */
@NoException public static native int _PyArrayNeighborhoodIter_IncrCoord(PyArrayNeighborhoodIterObject iter);

/*
 * Update to next item of the iterator
 *
 * Note: this simply increment the coordinates vector, last dimension
 * incremented first , i.e, for dimension 3
 * ...
 * -1, -1, -1
 * -1, -1,  0
 * -1, -1,  1
 *  ....
 * -1,  0, -1
 * -1,  0,  0
 *  ....
 * 0,  -1, -1
 * 0,  -1,  0
 *  ....
 */
// #define _UPDATE_COORD_ITER(c)
//     wb = iter->coordinates[c] < iter->bounds[c][1];
//     if (wb) {
//         iter->coordinates[c] += 1;
//         return 0;
//     }
//     else {
//         iter->coordinates[c] = iter->bounds[c][0];
//     }

/*
 * Version optimized for 2d arrays, manual loop unrolling
 */
@NoException public static native int _PyArrayNeighborhoodIter_IncrCoord2D(PyArrayNeighborhoodIterObject iter);
// #undef _UPDATE_COORD_ITER

/*
 * Advance to the next neighbour
 */

/*
 * Reset functions
 */


// Parsed from __ufunc_api.h


// #ifdef _UMATHMODULE

public static native @ByRef PyTypeObject PyUFunc_Type(); public static native void PyUFunc_Type(PyTypeObject setter);

@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") PointerPointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9);
@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9);
@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") ByteBuffer arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9);
@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") byte[] arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9);
@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9);
@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") ByteBuffer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9);
@NoException public static native PyObject PyUFunc_FromFuncAndData(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") byte[] arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9);
@NoException public static native int PyUFunc_RegisterLoopForType(PyUFuncObject arg0, int arg1, PyUFuncGenericFunction arg2, @Const IntPointer arg3, Pointer arg4);
@NoException public static native int PyUFunc_RegisterLoopForType(PyUFuncObject arg0, int arg1, PyUFuncGenericFunction arg2, @Const IntBuffer arg3, Pointer arg4);
@NoException public static native int PyUFunc_RegisterLoopForType(PyUFuncObject arg0, int arg1, PyUFuncGenericFunction arg2, @Const int[] arg3, Pointer arg4);
@NoException public static native int PyUFunc_GenericFunction(PyUFuncObject arg0, PyObject arg1, PyObject arg2, @Cast("PyArrayObject**") PointerPointer arg3);
@NoException public static native int PyUFunc_GenericFunction(PyUFuncObject arg0, PyObject arg1, PyObject arg2, @ByPtrPtr PyArrayObject arg3);
@NoException public static native void PyUFunc_f_f_As_d_d(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f_As_d_d(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f_As_d_d(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f_As_d_d(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_d_d(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_d_d(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_d_d(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_d_d(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_f_f(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_g_g(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_g_g(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_g_g(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_g_g(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F_As_D_D(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F_As_D_D(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F_As_D_D(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F_As_D_D(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_F_F(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_D_D(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_D_D(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_D_D(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_D_D(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_G_G(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_G_G(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_G_G(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_G_G(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f_As_dd_d(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f_As_dd_d(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f_As_dd_d(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f_As_dd_d(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ff_f(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_dd_d(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_dd_d(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_dd_d(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_dd_d(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_gg_g(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_gg_g(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_gg_g(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_gg_g(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F_As_DD_D(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F_As_DD_D(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F_As_DD_D(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F_As_DD_D(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_DD_D(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_DD_D(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_DD_D(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_DD_D(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_FF_F(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_GG_G(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_GG_G(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_GG_G(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_GG_G(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O_method(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O_method(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O_method(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_O_O_method(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O_method(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O_method(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O_method(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_OO_O_method(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_On_Om(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_On_Om(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_On_Om(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_On_Om(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native int PyUFunc_GetPyValues(@Cast("char*") BytePointer arg0, IntPointer arg1, IntPointer arg2, @Cast("PyObject**") PointerPointer arg3);
@NoException public static native int PyUFunc_GetPyValues(@Cast("char*") BytePointer arg0, IntPointer arg1, IntPointer arg2, @ByPtrPtr PyObject arg3);
@NoException public static native int PyUFunc_GetPyValues(@Cast("char*") ByteBuffer arg0, IntBuffer arg1, IntBuffer arg2, @ByPtrPtr PyObject arg3);
@NoException public static native int PyUFunc_GetPyValues(@Cast("char*") byte[] arg0, int[] arg1, int[] arg2, @ByPtrPtr PyObject arg3);
@NoException public static native int PyUFunc_checkfperr(int arg0, PyObject arg1, IntPointer arg2);
@NoException public static native int PyUFunc_checkfperr(int arg0, PyObject arg1, IntBuffer arg2);
@NoException public static native int PyUFunc_checkfperr(int arg0, PyObject arg1, int[] arg2);
@NoException public static native void PyUFunc_clearfperr();
@NoException public static native int PyUFunc_getfperr();
@NoException public static native int PyUFunc_handlefperr(int arg0, PyObject arg1, int arg2, IntPointer arg3);
@NoException public static native int PyUFunc_handlefperr(int arg0, PyObject arg1, int arg2, IntBuffer arg3);
@NoException public static native int PyUFunc_handlefperr(int arg0, PyObject arg1, int arg2, int[] arg3);
@NoException public static native int PyUFunc_ReplaceLoopBySignature(PyUFuncObject arg0, PyUFuncGenericFunction arg1, @Const IntPointer arg2, @ByPtrPtr PyUFuncGenericFunction arg3);
@NoException public static native int PyUFunc_ReplaceLoopBySignature(PyUFuncObject arg0, PyUFuncGenericFunction arg1, @Const IntBuffer arg2, @ByPtrPtr PyUFuncGenericFunction arg3);
@NoException public static native int PyUFunc_ReplaceLoopBySignature(PyUFuncObject arg0, PyUFuncGenericFunction arg1, @Const int[] arg2, @ByPtrPtr PyUFuncGenericFunction arg3);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") PointerPointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") ByteBuffer arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9, String arg10);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") byte[] arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9, String arg10);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") ByteBuffer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignature(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") byte[] arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9, String arg10);
@NoException public static native int PyUFunc_SetUsesArraysAsData(@Cast("void**") PointerPointer arg0, @Cast("size_t") long arg1);
@NoException public static native int PyUFunc_SetUsesArraysAsData(@Cast("void**") @ByPtrPtr Pointer arg0, @Cast("size_t") long arg1);
@NoException public static native void PyUFunc_e_e(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_f_f(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_f_f(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_f_f(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_f_f(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_d_d(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_d_d(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_d_d(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_e_e_As_d_d(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_ff_f(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_ff_f(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_ff_f(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_ff_f(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_dd_d(@Cast("char**") PointerPointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_dd_d(@Cast("char**") @ByPtrPtr BytePointer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_dd_d(@Cast("char**") @ByPtrPtr ByteBuffer arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native void PyUFunc_ee_e_As_dd_d(@Cast("char**") @ByPtrPtr byte[] arg0, @Cast("const npy_intp*") SizeTPointer arg1, @Cast("const npy_intp*") SizeTPointer arg2, Pointer arg3);
@NoException public static native int PyUFunc_DefaultTypeResolver(PyUFuncObject arg0, @Cast("NPY_CASTING") int arg1, @Cast("PyArrayObject**") PointerPointer arg2, PyObject arg3, @Cast("PyArray_Descr**") PointerPointer arg4);
@NoException public static native int PyUFunc_DefaultTypeResolver(PyUFuncObject arg0, @Cast("NPY_CASTING") int arg1, @ByPtrPtr PyArrayObject arg2, PyObject arg3, @ByPtrPtr PyArray_Descr arg4);
@NoException public static native int PyUFunc_ValidateCasting(PyUFuncObject arg0, @Cast("NPY_CASTING") int arg1, @Cast("PyArrayObject**") PointerPointer arg2, @Cast("PyArray_Descr**") PointerPointer arg3);
@NoException public static native int PyUFunc_ValidateCasting(PyUFuncObject arg0, @Cast("NPY_CASTING") int arg1, @ByPtrPtr PyArrayObject arg2, @ByPtrPtr PyArray_Descr arg3);
@NoException public static native int PyUFunc_RegisterLoopForDescr(PyUFuncObject arg0, PyArray_Descr arg1, PyUFuncGenericFunction arg2, @Cast("PyArray_Descr**") PointerPointer arg3, Pointer arg4);
@NoException public static native int PyUFunc_RegisterLoopForDescr(PyUFuncObject arg0, PyArray_Descr arg1, PyUFuncGenericFunction arg2, @ByPtrPtr PyArray_Descr arg3, Pointer arg4);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") PointerPointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10, PyObject arg11);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10, PyObject arg11);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") ByteBuffer arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9, String arg10, PyObject arg11);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") byte[] arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10, PyObject arg11);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") BytePointer arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9, String arg10, PyObject arg11);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") ByteBuffer arg2, int arg3, int arg4, int arg5, int arg6, @Cast("const char*") BytePointer arg7, @Cast("const char*") BytePointer arg8, int arg9, @Cast("const char*") BytePointer arg10, PyObject arg11);
@NoException public static native PyObject PyUFunc_FromFuncAndDataAndSignatureAndIdentity(@ByPtrPtr PyUFuncGenericFunction arg0, @Cast("void**") @ByPtrPtr Pointer arg1, @Cast("char*") byte[] arg2, int arg3, int arg4, int arg5, int arg6, String arg7, String arg8, int arg9, String arg10, PyObject arg11);

// #else

// #if defined(PY_UFUNC_UNIQUE_SYMBOL)
// #endif

// #if defined(NO_IMPORT) || defined(NO_IMPORT_UFUNC)
public static native Pointer PyUFunc_API(int i); public static native void PyUFunc_API(int i, Pointer setter);
public static native @Cast("void**") PointerPointer PyUFunc_API(); public static native void PyUFunc_API(PointerPointer setter);
// #else
// #if defined(PY_UFUNC_UNIQUE_SYMBOL)
// #else
// #endif
// #endif


@NoException public static native int _import_umath();

// #define import_umath()
//     do {
//         UFUNC_NOFPE
//         if (_import_umath() < 0) {
//             PyErr_Print();
//             PyErr_SetString(PyExc_ImportError,
//                     "numpy.core.umath failed to import");
//             return NULL;
//         }
//     } while(0)

// #define import_umath1(ret)
//     do {
//         UFUNC_NOFPE
//         if (_import_umath() < 0) {
//             PyErr_Print();
//             PyErr_SetString(PyExc_ImportError,
//                     "numpy.core.umath failed to import");
//             return ret;
//         }
//     } while(0)

// #define import_umath2(ret, msg)
//     do {
//         UFUNC_NOFPE
//         if (_import_umath() < 0) {
//             PyErr_Print();
//             PyErr_SetString(PyExc_ImportError, msg);
//             return ret;
//         }
//     } while(0)

// #define import_ufunc()
//     do {
//         UFUNC_NOFPE
//         if (_import_umath() < 0) {
//             PyErr_Print();
//             PyErr_SetString(PyExc_ImportError,
//                     "numpy.core.umath failed to import");
//         }
//     } while(0)

// #endif


// Parsed from ufuncobject.h

// #ifndef Py_UFUNCOBJECT_H
// #define Py_UFUNCOBJECT_H

// #include <numpy/npy_math.h>
// #include <numpy/npy_common.h>

// #ifdef __cplusplus
// Targeting ../PyUFuncGenericFunction.java


// Targeting ../PyUFunc_MaskedStridedInnerLoopFunc.java



/* Forward declaration for the type resolver and loop selector typedefs */
// Targeting ../PyUFunc_TypeResolutionFunc.java


// Targeting ../PyUFunc_LegacyInnerLoopSelectionFunc.java


// Targeting ../PyUFunc_MaskedInnerLoopSelectionFunc.java


// Targeting ../PyUFuncObject.java



// #include "arrayobject.h"
/* Generalized ufunc; 0x0001 reserved for possible use as CORE_ENABLED */
/* the core dimension's size will be determined by the operands. */
public static final int UFUNC_CORE_DIM_SIZE_INFERRED = 0x0002;
/* the core dimension may be absent */
public static final int UFUNC_CORE_DIM_CAN_IGNORE = 0x0004;
/* flags inferred during execution */
public static final int UFUNC_CORE_DIM_MISSING = 0x00040000;

public static final int UFUNC_ERR_IGNORE = 0;
public static final int UFUNC_ERR_WARN =   1;
public static final int UFUNC_ERR_RAISE =  2;
public static final int UFUNC_ERR_CALL =   3;
public static final int UFUNC_ERR_PRINT =  4;
public static final int UFUNC_ERR_LOG =    5;

        /* Python side integer mask */

public static final int UFUNC_MASK_DIVIDEBYZERO = 0x07;
public static final int UFUNC_MASK_OVERFLOW = 0x3f;
public static final int UFUNC_MASK_UNDERFLOW = 0x1ff;
public static final int UFUNC_MASK_INVALID = 0xfff;

public static final int UFUNC_SHIFT_DIVIDEBYZERO = 0;
public static final int UFUNC_SHIFT_OVERFLOW =     3;
public static final int UFUNC_SHIFT_UNDERFLOW =    6;
public static final int UFUNC_SHIFT_INVALID =      9;


public static final int UFUNC_OBJ_ISOBJECT =      1;
public static final int UFUNC_OBJ_NEEDS_API =     2;

   /* Default user error mode */
public static final int UFUNC_ERR_DEFAULT =                               
        (UFUNC_ERR_WARN << UFUNC_SHIFT_DIVIDEBYZERO) +  
        (UFUNC_ERR_WARN << UFUNC_SHIFT_OVERFLOW) +      
        (UFUNC_ERR_WARN << UFUNC_SHIFT_INVALID);

// #if NPY_ALLOW_THREADS
// #define NPY_LOOP_BEGIN_THREADS do {if (!(loop->obj & UFUNC_OBJ_NEEDS_API)) _save = PyEval_SaveThread();} while (0);
// #define NPY_LOOP_END_THREADS   do {if (!(loop->obj & UFUNC_OBJ_NEEDS_API)) PyEval_RestoreThread(_save);} while (0);
// #else
// #endif

/*
 * UFunc has unit of 0, and the order of operations can be reordered
 * This case allows reduction with multiple axes at once.
 */
public static final int PyUFunc_Zero = 0;
/*
 * UFunc has unit of 1, and the order of operations can be reordered
 * This case allows reduction with multiple axes at once.
 */
public static final int PyUFunc_One = 1;
/*
 * UFunc has unit of -1, and the order of operations can be reordered
 * This case allows reduction with multiple axes at once. Intended for
 * bitwise_and reduction.
 */
public static final int PyUFunc_MinusOne = 2;
/*
 * UFunc has no unit, and the order of operations cannot be reordered.
 * This case does not allow reduction with multiple axes at once.
 */
public static final int PyUFunc_None = -1;
/*
 * UFunc has no unit, and the order of operations can be reordered
 * This case allows reduction with multiple axes at once.
 */
public static final int PyUFunc_ReorderableNone = -2;
/*
 * UFunc unit is an identity_value, and the order of operations can be reordered
 * This case allows reduction with multiple axes at once.
 */
public static final int PyUFunc_IdentityValue = -3;


public static final int UFUNC_REDUCE = 0;
public static final int UFUNC_ACCUMULATE = 1;
public static final int UFUNC_REDUCEAT = 2;
public static final int UFUNC_OUTER = 3;
// Targeting ../PyUFunc_PyFuncData.java


// Targeting ../PyUFunc_Loop1d.java




// #include "__ufunc_api.h"

public static final String UFUNC_PYVALS_NAME = "UFUNC_PYVALS";

/*
 * THESE MACROS ARE DEPRECATED.
 * Use npy_set_floatstatus_* in the npymath library.
 */
public static final int UFUNC_FPE_DIVIDEBYZERO =  NPY_FPE_DIVIDEBYZERO;
public static final int UFUNC_FPE_OVERFLOW =      NPY_FPE_OVERFLOW;
public static final int UFUNC_FPE_UNDERFLOW =     NPY_FPE_UNDERFLOW;
public static final int UFUNC_FPE_INVALID =       NPY_FPE_INVALID;

// #define generate_divbyzero_error() npy_set_floatstatus_divbyzero()
// #define generate_overflow_error() npy_set_floatstatus_overflow()

  /* Make sure it gets defined if it isn't already */
// #ifndef UFUNC_NOFPE
/* Clear the floating point exception default of Borland C++ */
// #if defined(__BORLANDC__)
// #define UFUNC_NOFPE _control87(MCW_EM, MCW_EM);
// #else
// #define UFUNC_NOFPE
// #endif
// #endif


// #ifdef __cplusplus
// #endif
// #endif /* !Py_UFUNCOBJECT_H */


}
