// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.mxnet.global;

import org.bytedeco.mxnet.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;

public class mxnet extends org.bytedeco.mxnet.presets.mxnet {
    static { Loader.load(); }

// Parsed from mxnet/c_api.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 *  Copyright (c) 2015 by Contributors
 * \file c_api.h
 * \brief C API of mxnet
 */
// #ifndef MXNET_C_API_H_
// #define MXNET_C_API_H_

/** \brief Inhibit C++ name-mangling for MXNet functions. */
// #ifdef __cplusplus
// #endif  // __cplusplus

/** \brief Keep the default value in C++ */
// #ifdef __cplusplus
// #define DEFAULT(x) = x
// #else
// #endif  // __cplusplus

// #include <stdint.h>

// #include <stdint.h>
// #include <stddef.h>
// #include <stdbool.h>

/** \brief MXNET_DLL prefix for windows */
// #ifdef _WIN32
// #ifdef MXNET_EXPORTS
// #define MXNET_DLL __declspec(dllexport)
// #else
// #define MXNET_DLL __declspec(dllimport)
// #endif
// #else
// #define MXNET_DLL
// #endif

/** \brief manually define unsigned int */
/** \brief manually define float */
/** \brief data type to store dim size */
// Targeting ..\NDArrayHandle.java


// Targeting ..\FunctionHandle.java


// Targeting ..\AtomicSymbolCreator.java


// Targeting ..\CachedOpHandle.java


// Targeting ..\SymbolHandle.java


// Targeting ..\AtomicSymbolHandle.java


// Targeting ..\ExecutorHandle.java


// Targeting ..\DataIterCreator.java


// Targeting ..\DataIterHandle.java


// Targeting ..\KVStoreHandle.java


// Targeting ..\RecordIOHandle.java


// Targeting ..\RtcHandle.java


// Targeting ..\CudaModuleHandle.java


// Targeting ..\CudaKernelHandle.java


// Targeting ..\ProfileHandle.java


// Targeting ..\DLManagedTensorHandle.java


// Targeting ..\ContextHandle.java


// Targeting ..\EngineFnPropertyHandle.java


// Targeting ..\EngineVarHandle.java


// Targeting ..\EngineAsyncFunc.java


// Targeting ..\EngineSyncFunc.java


// Targeting ..\EngineFuncParamDeleter.java


// Targeting ..\ExecutorMonitorCallback.java


// Targeting ..\CachedOpMonitorCallback.java


// Targeting ..\NativeOpInfo.java


// Targeting ..\NDArrayOpInfo.java


// Targeting ..\MXGenericCallback.java


// Targeting ..\MXCallbackList.java


// Targeting ..\LibFeature.java



/** enum CustomOpCallbacks */
public static final int
  kCustomOpDelete = 0,
  kCustomOpForward = 1,
  kCustomOpBackward = 2;

/** enum CustomOpPropCallbacks */
public static final int
  kCustomOpPropDelete = 0,
  kCustomOpPropListArguments = 1,
  kCustomOpPropListOutputs = 2,
  kCustomOpPropListAuxiliaryStates = 3,
  kCustomOpPropInferShape = 4,
  kCustomOpPropDeclareBackwardDependency = 5,
  kCustomOpPropCreateOperator = 6,
  kCustomOpPropInferType = 7,
  kCustomOpPropInferStorageType = 8,
  kCustomOpPropBackwardInferStorageType = 9;
// Targeting ..\CustomOpFBFunc.java


// Targeting ..\CustomOpDelFunc.java


// Targeting ..\CustomOpListFunc.java


// Targeting ..\CustomOpInferShapeFunc.java


// Targeting ..\CustomOpInferStorageTypeFunc.java


// Targeting ..\CustomOpBackwardInferStorageTypeFunc.java


// Targeting ..\CustomOpInferTypeFunc.java


// Targeting ..\CustomOpBwdDepFunc.java


// Targeting ..\CustomOpCreateFunc.java


// Targeting ..\CustomOpPropCreator.java




/** enum CustomFunctionCallbacks */
public static final int
  kCustomFunctionBackward = 0,
  kCustomFunctionDelete = 1;
// Targeting ..\CustomFunctionBwdFunc.java


// Targeting ..\CustomFunctionDelFunc.java



/**
 * \brief return str message of the last error
 *  all function in this file will return 0 when success
 *  and -1 when an error occured,
 *  MXGetLastError can be called to retrieve the error
 *
 *  this function is threadsafe and can be called by different thread
 *  @return error info
 */
public static native @Cast("const char*") BytePointer MXGetLastError();

//-------------------------------------
// Part 0: Global State setups
//-------------------------------------

/**
 * \brief Load library dynamically
 * @param path to the library .so file
 * @param 0 for quiet, 1 for verbose
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXLoadLib(@Cast("const char*") BytePointer path, @Cast("unsigned") int verbose);
public static native int MXLoadLib(String path, @Cast("unsigned") int verbose);

/**
 * \brief Get list of features supported on the runtime
 * @param libFeature pointer to array of LibFeature
 * @param size of the array
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXLibInfoFeatures(@Cast("const LibFeature**") PointerPointer libFeature, @Cast("size_t*") SizeTPointer size);
public static native int MXLibInfoFeatures(@Const @ByPtrPtr LibFeature libFeature, @Cast("size_t*") SizeTPointer size);

/**
 * \brief Seed all global random number generators in mxnet.
 * @param seed the random number seed.
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXRandomSeed(int seed);

/**
 * \brief Seed the global random number generator of the given device.
 * @param seed the random number seed.
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXRandomSeedContext(int seed, int dev_type, int dev_id);

/**
 * \brief Notify the engine about a shutdown,
 *  This can help engine to print less messages into display.
 *
 *  User do not have to call this function.
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXNotifyShutdown();

/**
 * \brief Set up configuration of profiler for the process passed as profile_process in keys
 * @param num_params Number of parameters
 * @param keys array of parameter keys
 * @param vals array of parameter values
 * @param kvstoreHandle handle to kvstore
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXSetProcessProfilerConfig(int num_params, @Cast("const char*const*") PointerPointer keys,
                                         @Cast("const char*const*") PointerPointer vals,
                                         KVStoreHandle kvstoreHandle);
public static native int MXSetProcessProfilerConfig(int num_params, @Cast("const char*const*") @ByPtrPtr BytePointer keys,
                                         @Cast("const char*const*") @ByPtrPtr BytePointer vals,
                                         KVStoreHandle kvstoreHandle);
public static native int MXSetProcessProfilerConfig(int num_params, @Cast("const char*const*") @ByPtrPtr ByteBuffer keys,
                                         @Cast("const char*const*") @ByPtrPtr ByteBuffer vals,
                                         KVStoreHandle kvstoreHandle);
public static native int MXSetProcessProfilerConfig(int num_params, @Cast("const char*const*") @ByPtrPtr byte[] keys,
                                         @Cast("const char*const*") @ByPtrPtr byte[] vals,
                                         KVStoreHandle kvstoreHandle);

/**
 * \brief Set up configuration of profiler for worker/current process
 * @param num_params Number of parameters
 * @param keys array of parameter keys
 * @param vals array of parameter values
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXSetProfilerConfig(int num_params, @Cast("const char*const*") PointerPointer keys, @Cast("const char*const*") PointerPointer vals);
public static native int MXSetProfilerConfig(int num_params, @Cast("const char*const*") @ByPtrPtr BytePointer keys, @Cast("const char*const*") @ByPtrPtr BytePointer vals);
public static native int MXSetProfilerConfig(int num_params, @Cast("const char*const*") @ByPtrPtr ByteBuffer keys, @Cast("const char*const*") @ByPtrPtr ByteBuffer vals);
public static native int MXSetProfilerConfig(int num_params, @Cast("const char*const*") @ByPtrPtr byte[] keys, @Cast("const char*const*") @ByPtrPtr byte[] vals);

/**
 * \brief Set up state of profiler for either worker or server process
 * @param state indicate the working state of profiler,
 *  profiler not running when state == 0,
 *  profiler running when state == 1
 * @param profile_process an int,
 * when 0 command is for worker/current process,
 * when 1 command is for server process
 * @param kvstoreHandle handle to kvstore, needed for server process profiling
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXSetProcessProfilerState(int state, int profile_process,
                                        KVStoreHandle kvStoreHandle);

/**
 * \brief Set up state of profiler for current process
 * @param state indicate the working state of profiler,
 *  profiler not running when state == 0,
 *  profiler running when state == 1
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXSetProfilerState(int state);

/**
 * \brief Save profile and stop profiler
 * @param finished true if stat output should stop after this point
 * @param profile_process an int,
 * when 0 command is for worker/current process,
 * when 1 command is for server process
 * @param kvstoreHandle handle to kvstore
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXDumpProcessProfile(int finished, int profile_process, KVStoreHandle kvStoreHandle);


/**
 * \brief Save profile and stop profiler for worker/current process
 * @param finished true if stat output should stop after this point
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXDumpProfile(int finished);


/**
 * \brief Deprecated, use MXAggregateProfileStatsPrintEx instead.
 * @param out_str Will receive a pointer to the output string
 * @param reset Clear the aggregate stats after printing
 * @return 0 when success, -1 when failure happens.
 * \note
 */
public static native int MXAggregateProfileStatsPrint(@Cast("const char**") PointerPointer out_str, int reset);
public static native int MXAggregateProfileStatsPrint(@Cast("const char**") @ByPtrPtr BytePointer out_str, int reset);
public static native int MXAggregateProfileStatsPrint(@Cast("const char**") @ByPtrPtr ByteBuffer out_str, int reset);
public static native int MXAggregateProfileStatsPrint(@Cast("const char**") @ByPtrPtr byte[] out_str, int reset);

/**
 * \brief Print sorted aggregate stats to the a string
 *        How aggregate stats are stored will not change
 * @param out_str will receive a pointer to the output string
 * @param reset clear the aggregate stats after printing
 * @param format whether to return in tabular or json format
 * @param sort_by sort by total, avg, min, max, or count
 * @param ascending whether to sort ascendingly
 * @return 0 when success, -1 when failure happens.
 * \note
 */
public static native int MXAggregateProfileStatsPrintEx(@Cast("const char**") PointerPointer out_str, int reset, int format,
                                            int sort_by, int ascending);
public static native int MXAggregateProfileStatsPrintEx(@Cast("const char**") @ByPtrPtr BytePointer out_str, int reset, int format,
                                            int sort_by, int ascending);
public static native int MXAggregateProfileStatsPrintEx(@Cast("const char**") @ByPtrPtr ByteBuffer out_str, int reset, int format,
                                            int sort_by, int ascending);
public static native int MXAggregateProfileStatsPrintEx(@Cast("const char**") @ByPtrPtr byte[] out_str, int reset, int format,
                                            int sort_by, int ascending);

/**
 * \brief Pause profiler tuning collection
 * @param paused If nonzero, profiling pauses. Otherwise, profiling resumes/continues
 * @param profile_process integer which denotes whether to process worker or server process
 * @param kvstoreHandle handle to kvstore
 * @return 0 when success, -1 when failure happens.
 * \note pausing and resuming is global and not recursive
 */
public static native int MXProcessProfilePause(int paused, int profile_process, KVStoreHandle kvStoreHandle);

/**
 * \brief Pause profiler tuning collection for worker/current process
 * @param paused If nonzero, profiling pauses. Otherwise, profiling resumes/continues
 * @return 0 when success, -1 when failure happens.
 * \note pausing and resuming is global and not recursive
 */
public static native int MXProfilePause(int paused);

/**
 * \brief Create profiling domain
 * @param domain String representing the domain name to create
 * @param out Return domain object
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileCreateDomain(@Cast("const char*") BytePointer domain, @ByPtrPtr ProfileHandle out);
public static native int MXProfileCreateDomain(String domain, @ByPtrPtr ProfileHandle out);

/**
 * \brief Create profile task
 * @param name Name of the task
 * @param domain Domain of the task
 * @param out Output handle
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileCreateTask(ProfileHandle domain,
                                  @Cast("const char*") BytePointer task_name,
                                  @ByPtrPtr ProfileHandle out);
public static native int MXProfileCreateTask(ProfileHandle domain,
                                  String task_name,
                                  @ByPtrPtr ProfileHandle out);

/**
 * \brief Create profile frame
 * @param name Name of the frame
 * @param domain Domain of the frame
 * @param out Output handle
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileCreateFrame(ProfileHandle domain,
                                   @Cast("const char*") BytePointer frame_name,
                                   @ByPtrPtr ProfileHandle out);
public static native int MXProfileCreateFrame(ProfileHandle domain,
                                   String frame_name,
                                   @ByPtrPtr ProfileHandle out);

/**
 * \brief Create profile event
 * @param name Name of the event
 * @param out Output handle
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileCreateEvent(@Cast("const char*") BytePointer event_name, @ByPtrPtr ProfileHandle out);
public static native int MXProfileCreateEvent(String event_name, @ByPtrPtr ProfileHandle out);

/**
 * \brief Create profile counter
 * @param name Name of the counter
 * @param domain Domain of the counter
 * @param out Output handle
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileCreateCounter(ProfileHandle domain,
                                     @Cast("const char*") BytePointer counter_name,
                                     @ByPtrPtr ProfileHandle out);
public static native int MXProfileCreateCounter(ProfileHandle domain,
                                     String counter_name,
                                     @ByPtrPtr ProfileHandle out);

/**
 * \brief Destroy a frame
 * @param frame_handle Handle to frame to destroy
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileDestroyHandle(ProfileHandle frame_handle);

/**
 * \brief Start timing the duration of a profile duration object such as an event, task or frame
 * @param duration_handle handle to the duration object
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileDurationStart(ProfileHandle duration_handle);

/**
 * \brief Stop timing the duration of a profile duration object such as an event, task or frame
 * @param duration_handle handle to the duration object
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileDurationStop(ProfileHandle duration_handle);

/**
 * \brief Set a counter, given its handle
 * @param counter_handle Handle to counter to set
 * @param value Value to set the counter to (64-bit unsigned integer)
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileSetCounter(ProfileHandle counter_handle, @Cast("uint64_t") long value);

/**
 * \brief Adjust a counter by the given amount, given its handle
 * @param counter_handle Handle to counter to adjust
 * @param value Value to adjust the counter by (64-bit signed integer)
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileAdjustCounter(ProfileHandle counter_handle, @Cast("int64_t") long value);

/**
 * \brief Mark a single instant in time
 * @param domain Domain of the marker
 * @param instant_marker_name Name of the marker
 * @param scope Scope of marker ('global', 'process', 'thread', 'task', 'marker')
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXProfileSetMarker(ProfileHandle domain,
                                 @Cast("const char*") BytePointer instant_marker_name,
                                 @Cast("const char*") BytePointer scope);
public static native int MXProfileSetMarker(ProfileHandle domain,
                                 String instant_marker_name,
                                 String scope);

/**
 * \brief Set the number of OMP threads to use
 * @param thread_num Number of OMP threads desired
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXSetNumOMPThreads(int thread_num);

/**
 * \brief set bulk execution limit
 * @param bulk_size new bulk_size
 * @param prev_bulk_size previous bulk_size
 */
public static native int MXEngineSetBulkSize(int bulk_size, IntPointer prev_bulk_size);
public static native int MXEngineSetBulkSize(int bulk_size, IntBuffer prev_bulk_size);
public static native int MXEngineSetBulkSize(int bulk_size, int[] prev_bulk_size);

/**
 * \brief Get the number of GPUs.
 * @param pointer to int that will hold the number of GPUs available.
 * @return 0 when success, -1 when failure happens.
 */
public static native int MXGetGPUCount(IntPointer out);
public static native int MXGetGPUCount(IntBuffer out);
public static native int MXGetGPUCount(int[] out);

/**
 * \brief get the free and total available memory on a GPU
 *  Note: Deprecated, use MXGetGPUMemoryInformation64 instead.
 * @param dev the GPU number to query
 * @param free_mem pointer to the integer holding free GPU memory
 * @param total_mem pointer to the integer holding total GPU memory
 * @return 0 when success, -1 when failure happens
 */
public static native int MXGetGPUMemoryInformation(int dev, IntPointer free_mem, IntPointer total_mem);
public static native int MXGetGPUMemoryInformation(int dev, IntBuffer free_mem, IntBuffer total_mem);
public static native int MXGetGPUMemoryInformation(int dev, int[] free_mem, int[] total_mem);

/**
 * \brief get the free and total available memory on a GPU
 * @param dev the GPU number to query
 * @param free_mem pointer to the uint64_t holding free GPU memory
 * @param total_mem pointer to the uint64_t holding total GPU memory
 * @return 0 when success, -1 when failure happens
 */
public static native int MXGetGPUMemoryInformation64(int dev, @Cast("uint64_t*") LongPointer free_mem, @Cast("uint64_t*") LongPointer total_mem);
public static native int MXGetGPUMemoryInformation64(int dev, @Cast("uint64_t*") LongBuffer free_mem, @Cast("uint64_t*") LongBuffer total_mem);
public static native int MXGetGPUMemoryInformation64(int dev, @Cast("uint64_t*") long[] free_mem, @Cast("uint64_t*") long[] total_mem);

/**
 * \brief get the MXNet library version as an integer
 * @param pointer to the integer holding the version number
 * @return 0 when success, -1 when failure happens
 */
public static native int MXGetVersion(IntPointer out);
public static native int MXGetVersion(IntBuffer out);
public static native int MXGetVersion(int[] out);

/**
 * \brief Load TVM operator from the binary library
 * @param libpath TVM operators lib file
 * @return 0 when success, -1 when failure happens
 */
// #if MXNET_USE_TVM_OP
// #endif  // MXNET_USE_TVM_OP


//-------------------------------------
// Part 1: NDArray creation and deletion
//-------------------------------------
/**
 * \brief create a NDArray handle that is not initialized
 *  can be used to pass in as mutate variables
 *  to hold the result of NDArray
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayCreateNone(PointerPointer out);
public static native int MXNDArrayCreateNone(@Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief create a NDArray with specified shape
 * @param shape the pointer to the shape
 * @param ndim the dimension of the shape
 * @param dev_type device type, specify device we want to take
 * @param dev_id the device id of the specific device
 * @param delay_alloc whether to delay allocation until
 *    the narray is first mutated
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayCreate(@Cast("const uint32_t*") IntPointer shape,
                              @Cast("uint32_t") int ndim,
                              int dev_type,
                              int dev_id,
                              int delay_alloc,
                              PointerPointer out);
public static native int MXNDArrayCreate(@Cast("const uint32_t*") IntBuffer shape,
                              @Cast("uint32_t") int ndim,
                              int dev_type,
                              int dev_id,
                              int delay_alloc,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreate(@Cast("const uint32_t*") int[] shape,
                              @Cast("uint32_t") int ndim,
                              int dev_type,
                              int dev_id,
                              int delay_alloc,
                              PointerPointer out);
public static native int MXNDArrayCreate(@Cast("const uint32_t*") IntPointer shape,
                              @Cast("uint32_t") int ndim,
                              int dev_type,
                              int dev_id,
                              int delay_alloc,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreate(@Cast("const uint32_t*") IntBuffer shape,
                              @Cast("uint32_t") int ndim,
                              int dev_type,
                              int dev_id,
                              int delay_alloc,
                              PointerPointer out);
public static native int MXNDArrayCreate(@Cast("const uint32_t*") int[] shape,
                              @Cast("uint32_t") int ndim,
                              int dev_type,
                              int dev_id,
                              int delay_alloc,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief create a NDArray with specified shape and data type
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param shape the pointer to the shape
 * @param ndim the dimension of the shape
 * @param dev_type device type, specify device we want to take
 * @param dev_id the device id of the specific device
 * @param delay_alloc whether to delay allocation until
 *    the narray is first mutated
 * @param dtype data type of created array
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayCreateEx(@Cast("const uint32_t*") IntPointer shape,
                                @Cast("uint32_t") int ndim,
                                int dev_type,
                                int dev_id,
                                int delay_alloc,
                                int dtype,
                                PointerPointer out);
public static native int MXNDArrayCreateEx(@Cast("const uint32_t*") IntBuffer shape,
                                @Cast("uint32_t") int ndim,
                                int dev_type,
                                int dev_id,
                                int delay_alloc,
                                int dtype,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateEx(@Cast("const uint32_t*") int[] shape,
                                @Cast("uint32_t") int ndim,
                                int dev_type,
                                int dev_id,
                                int delay_alloc,
                                int dtype,
                                PointerPointer out);
public static native int MXNDArrayCreateEx(@Cast("const uint32_t*") IntPointer shape,
                                @Cast("uint32_t") int ndim,
                                int dev_type,
                                int dev_id,
                                int delay_alloc,
                                int dtype,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateEx(@Cast("const uint32_t*") IntBuffer shape,
                                @Cast("uint32_t") int ndim,
                                int dev_type,
                                int dev_id,
                                int delay_alloc,
                                int dtype,
                                PointerPointer out);
public static native int MXNDArrayCreateEx(@Cast("const uint32_t*") int[] shape,
                                @Cast("uint32_t") int ndim,
                                int dev_type,
                                int dev_id,
                                int delay_alloc,
                                int dtype,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief create a NDArray with specified shape and data type
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param shape the pointer to int64_t shape
 * @param ndim the dimension of the shape
 * @param dev_type device type, specify device we want to take
 * @param dev_id the device id of the specific device
 * @param delay_alloc whether to delay allocation until
 *    the narray is first mutated
 * @param dtype data type of created array
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayCreateEx64(@Cast("const int64_t*") LongPointer shape,
                                  int ndim,
                                  int dev_type,
                                  int dev_id,
                                  int delay_alloc,
                                  int dtype,
                                  PointerPointer out);
public static native int MXNDArrayCreateEx64(@Cast("const int64_t*") LongBuffer shape,
                                  int ndim,
                                  int dev_type,
                                  int dev_id,
                                  int delay_alloc,
                                  int dtype,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateEx64(@Cast("const int64_t*") long[] shape,
                                  int ndim,
                                  int dev_type,
                                  int dev_id,
                                  int delay_alloc,
                                  int dtype,
                                  PointerPointer out);
public static native int MXNDArrayCreateEx64(@Cast("const int64_t*") LongPointer shape,
                                  int ndim,
                                  int dev_type,
                                  int dev_id,
                                  int delay_alloc,
                                  int dtype,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateEx64(@Cast("const int64_t*") LongBuffer shape,
                                  int ndim,
                                  int dev_type,
                                  int dev_id,
                                  int delay_alloc,
                                  int dtype,
                                  PointerPointer out);
public static native int MXNDArrayCreateEx64(@Cast("const int64_t*") long[] shape,
                                  int ndim,
                                  int dev_type,
                                  int dev_id,
                                  int delay_alloc,
                                  int dtype,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief create an empty sparse NDArray with specified shape and data type
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param storage_type the storage type of the ndarray
 * @param shape the pointer to the shape
 * @param ndim the dimension of the shape
 * @param dev_type device type, specify device we want to take
 * @param dev_id the device id of the specific device
 * @param delay_alloc whether to delay allocation until
 *        the narray is first mutated
 * @param dtype data type of created array
 * @param num_aux the number of aux data to support this ndarray
 * @param aux_type data type of the aux data for the created array
 * @param aux_ndims the dimension of the shapes of aux data
 * @param aux_shape the shapes of aux data
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayCreateSparseEx(int storage_type,
                                      @Cast("const uint32_t*") IntPointer shape,
                                      @Cast("uint32_t") int ndim,
                                      int dev_type,
                                      int dev_id,
                                      int delay_alloc,
                                      int dtype,
                                      @Cast("uint32_t") int num_aux,
                                      IntPointer aux_type,
                                      @Cast("uint32_t*") IntPointer aux_ndims,
                                      @Cast("const uint32_t*") IntPointer aux_shape,
                                      PointerPointer out);
public static native int MXNDArrayCreateSparseEx(int storage_type,
                                      @Cast("const uint32_t*") IntBuffer shape,
                                      @Cast("uint32_t") int ndim,
                                      int dev_type,
                                      int dev_id,
                                      int delay_alloc,
                                      int dtype,
                                      @Cast("uint32_t") int num_aux,
                                      IntBuffer aux_type,
                                      @Cast("uint32_t*") IntBuffer aux_ndims,
                                      @Cast("const uint32_t*") IntBuffer aux_shape,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateSparseEx(int storage_type,
                                      @Cast("const uint32_t*") int[] shape,
                                      @Cast("uint32_t") int ndim,
                                      int dev_type,
                                      int dev_id,
                                      int delay_alloc,
                                      int dtype,
                                      @Cast("uint32_t") int num_aux,
                                      int[] aux_type,
                                      @Cast("uint32_t*") int[] aux_ndims,
                                      @Cast("const uint32_t*") int[] aux_shape,
                                      PointerPointer out);
public static native int MXNDArrayCreateSparseEx(int storage_type,
                                      @Cast("const uint32_t*") IntPointer shape,
                                      @Cast("uint32_t") int ndim,
                                      int dev_type,
                                      int dev_id,
                                      int delay_alloc,
                                      int dtype,
                                      @Cast("uint32_t") int num_aux,
                                      IntPointer aux_type,
                                      @Cast("uint32_t*") IntPointer aux_ndims,
                                      @Cast("const uint32_t*") IntPointer aux_shape,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateSparseEx(int storage_type,
                                      @Cast("const uint32_t*") IntBuffer shape,
                                      @Cast("uint32_t") int ndim,
                                      int dev_type,
                                      int dev_id,
                                      int delay_alloc,
                                      int dtype,
                                      @Cast("uint32_t") int num_aux,
                                      IntBuffer aux_type,
                                      @Cast("uint32_t*") IntBuffer aux_ndims,
                                      @Cast("const uint32_t*") IntBuffer aux_shape,
                                      PointerPointer out);
public static native int MXNDArrayCreateSparseEx(int storage_type,
                                      @Cast("const uint32_t*") int[] shape,
                                      @Cast("uint32_t") int ndim,
                                      int dev_type,
                                      int dev_id,
                                      int delay_alloc,
                                      int dtype,
                                      @Cast("uint32_t") int num_aux,
                                      int[] aux_type,
                                      @Cast("uint32_t*") int[] aux_ndims,
                                      @Cast("const uint32_t*") int[] aux_shape,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief create an empty sparse NDArray with specified shape and data type
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param storage_type the storage type of the ndarray
 * @param shape the pointer to the shape
 * @param ndim the dimension of the shape
 * @param dev_type device type, specify device we want to take
 * @param dev_id the device id of the specific device
 * @param delay_alloc whether to delay allocation until
 *        the narray is first mutated
 * @param dtype data type of created array
 * @param num_aux the number of aux data to support this ndarray
 * @param aux_type data type of the aux data for the created array
 * @param aux_ndims the dimension of the shapes of aux data
 * @param aux_shape the shapes of aux data
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */


/**
 * \brief create a NDArray handle that is loaded from raw bytes.
 * @param buf the head of the raw bytes
 * @param size size of the raw bytes
 * @param out the returning handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayLoadFromRawBytes(@Const Pointer buf,
                                        @Cast("size_t") long size,
                                        PointerPointer out);
public static native int MXNDArrayLoadFromRawBytes(@Const Pointer buf,
                                        @Cast("size_t") long size,
                                        @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief save the NDArray into raw bytes.
 * @param handle the NDArray handle
 * @param out_size size of the raw bytes
 * @param out_buf the head of returning memory bytes.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArraySaveRawBytes(NDArrayHandle handle,
                                    @Cast("size_t*") SizeTPointer out_size,
                                    @Cast("const char**") PointerPointer out_buf);
public static native int MXNDArraySaveRawBytes(NDArrayHandle handle,
                                    @Cast("size_t*") SizeTPointer out_size,
                                    @Cast("const char**") @ByPtrPtr BytePointer out_buf);
public static native int MXNDArraySaveRawBytes(NDArrayHandle handle,
                                    @Cast("size_t*") SizeTPointer out_size,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer out_buf);
public static native int MXNDArraySaveRawBytes(NDArrayHandle handle,
                                    @Cast("size_t*") SizeTPointer out_size,
                                    @Cast("const char**") @ByPtrPtr byte[] out_buf);
/**
 * \brief Save list of narray into the file.
 * @param fname name of the file.
 * @param num_args number of arguments to save.
 * @param args the array of NDArrayHandles to be saved.
 * @param keys the name of the NDArray, optional, can be NULL
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArraySave(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t") int num_args,
                            PointerPointer args,
                            @Cast("const char**") PointerPointer keys);
public static native int MXNDArraySave(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t") int num_args,
                            PointerPointer args,
                            @Cast("const char**") @ByPtrPtr BytePointer keys);
public static native int MXNDArraySave(String fname,
                            @Cast("uint32_t") int num_args,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle args,
                            @Cast("const char**") @ByPtrPtr ByteBuffer keys);
public static native int MXNDArraySave(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t") int num_args,
                            PointerPointer args,
                            @Cast("const char**") @ByPtrPtr byte[] keys);
public static native int MXNDArraySave(String fname,
                            @Cast("uint32_t") int num_args,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle args,
                            @Cast("const char**") @ByPtrPtr BytePointer keys);
public static native int MXNDArraySave(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t") int num_args,
                            PointerPointer args,
                            @Cast("const char**") @ByPtrPtr ByteBuffer keys);
public static native int MXNDArraySave(String fname,
                            @Cast("uint32_t") int num_args,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle args,
                            @Cast("const char**") @ByPtrPtr byte[] keys);
/**
 * \brief Load list of narray from the file.
 * @param fname name of the file.
 * @param out_size number of narray loaded.
 * @param out_arr head of the returning narray handles.
 * @param out_name_size size of output name arrray.
 * @param out_names the names of returning NDArrays, can be NULL
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayLoad(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t*") IntPointer out_size,
                            @ByPtrPtr PointerPointer out_arr,
                            @Cast("uint32_t*") IntPointer out_name_size,
                            @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoad(String fname,
                            @Cast("uint32_t*") IntBuffer out_size,
                            @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer out_arr,
                            @Cast("uint32_t*") IntBuffer out_name_size,
                            @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoad(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t*") int[] out_size,
                            @ByPtrPtr PointerPointer out_arr,
                            @Cast("uint32_t*") int[] out_name_size,
                            @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoad(String fname,
                            @Cast("uint32_t*") IntPointer out_size,
                            @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer out_arr,
                            @Cast("uint32_t*") IntPointer out_name_size,
                            @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoad(@Cast("const char*") BytePointer fname,
                            @Cast("uint32_t*") IntBuffer out_size,
                            @ByPtrPtr PointerPointer out_arr,
                            @Cast("uint32_t*") IntBuffer out_name_size,
                            @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoad(String fname,
                            @Cast("uint32_t*") int[] out_size,
                            @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer out_arr,
                            @Cast("uint32_t*") int[] out_name_size,
                            @Cast("const char***") @ByPtrPtr PointerPointer out_names);

/**
 * \brief Load list / dictionary of narrays from file content loaded into memory.
 * This will load a list of ndarrays in a similar
 * manner to MXNDArrayLoad, however, it loads from
 * buffer containing the contents of a file, rather than
 * from a specified file.
 * @param ndarray_buffer pointer to the start of the ndarray file content
 * @param size size of the file
 * @param out_size number of narray loaded.
 * @param out_arr head of the returning narray handles.
 * @param out_name_size size of output name arrray.
 * @param out_names the names of returning NDArrays, can be NULL
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayLoadFromBuffer(@Const Pointer ndarray_buffer,
                                      @Cast("size_t") long size,
                                      @Cast("uint32_t*") IntPointer out_size,
                                      @ByPtrPtr PointerPointer out_arr,
                                      @Cast("uint32_t*") IntPointer out_name_size,
                                      @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoadFromBuffer(@Const Pointer ndarray_buffer,
                                      @Cast("size_t") long size,
                                      @Cast("uint32_t*") IntBuffer out_size,
                                      @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer out_arr,
                                      @Cast("uint32_t*") IntBuffer out_name_size,
                                      @Cast("const char***") @ByPtrPtr PointerPointer out_names);
public static native int MXNDArrayLoadFromBuffer(@Const Pointer ndarray_buffer,
                                      @Cast("size_t") long size,
                                      @Cast("uint32_t*") int[] out_size,
                                      @ByPtrPtr PointerPointer out_arr,
                                      @Cast("uint32_t*") int[] out_name_size,
                                      @Cast("const char***") @ByPtrPtr PointerPointer out_names);

/**
 * \brief Perform a synchronize copy from a contiguous CPU memory region.
 *
 *  This function will call WaitToWrite before the copy is performed.
 *  This is useful to copy data from existing memory region that are
 *  not wrapped by NDArray(thus dependency not being tracked).
 *
 * @param handle the NDArray handle
 * @param data the data source to copy from.
 * @param size the memory size we want to copy from.
 */
public static native int MXNDArraySyncCopyFromCPU(NDArrayHandle handle,
                                       @Const Pointer data,
                                       @Cast("size_t") long size);
/**
 * \brief Perform a synchronize copyto a contiguous CPU memory region.
 *
 *  This function will call WaitToRead before the copy is performed.
 *  This is useful to copy data from existing memory region that are
 *  not wrapped by NDArray(thus dependency not being tracked).
 *
 * @param handle the NDArray handle
 * @param data the data source to copy into.
 * @param size the memory size we want to copy into.
 */
public static native int MXNDArraySyncCopyToCPU(NDArrayHandle handle,
                                     Pointer data,
                                     @Cast("size_t") long size);

/**
 * \brief Copy src.data() to dst.data() if i = -1, else dst.aux_data(i) if i >= 0
 * This function blocks. Do not use it in performance critical code.
 * @param handle_dst handle of a dst ndarray whose data/aux_data has been allocated
 * @param handle_src handle of a src ndarray which has default storage type
 * @param i dst data blob indicator
 */
public static native int MXNDArraySyncCopyFromNDArray(NDArrayHandle handle_dst,
                                           NDArrayHandle handle_src,
                                           int i);

/**
 * \brief check whether the NDArray format is valid
 * @param full_check if {@code True}, rigorous check, O(N) operations
 *    Otherwise basic check, O(1) operations
 */
public static native int MXNDArraySyncCheckFormat(NDArrayHandle handle, @Cast("const bool") boolean full_check);

/**
 * \brief Wait until all the pending writes with respect NDArray are finished.
 *  Always call this before read data out synchronizely.
 * @param handle the NDArray handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayWaitToRead(NDArrayHandle handle);

/**
 * \brief Wait until all the pending read/write with respect NDArray are finished.
 *  Always call this before write data into NDArray synchronizely.
 * @param handle the NDArray handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayWaitToWrite(NDArrayHandle handle);

/**
 * \brief wait until all delayed operations in
 *   the system is completed
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayWaitAll();

/**
 * \brief free the narray handle
 * @param handle the handle to be freed
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayFree(NDArrayHandle handle);

/**
 * \brief Slice the NDArray along axis 0.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param handle the handle to the NDArray
 * @param slice_begin The beginning index of slice
 * @param slice_end The ending index of slice
 * @param out The NDArrayHandle of sliced NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArraySlice(NDArrayHandle handle,
                             @Cast("uint32_t") int slice_begin,
                             @Cast("uint32_t") int slice_end,
                             PointerPointer out);
public static native int MXNDArraySlice(NDArrayHandle handle,
                             @Cast("uint32_t") int slice_begin,
                             @Cast("uint32_t") int slice_end,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief Slice the NDArray along axis 0.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param handle the handle to the NDArray
 * @param slice_begin The beginning index of slice
 * @param slice_end The ending index of slice
 * @param out The NDArrayHandle of sliced NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArraySlice64(NDArrayHandle handle,
                               @Cast("int64_t") long slice_begin,
                               @Cast("int64_t") long slice_end,
                               PointerPointer out);
public static native int MXNDArraySlice64(NDArrayHandle handle,
                               @Cast("int64_t") long slice_begin,
                               @Cast("int64_t") long slice_end,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief Index the NDArray along axis 0.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param handle the handle to the NDArray
 * @param idx the index
 * @param out The NDArrayHandle of output NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayAt(NDArrayHandle handle,
                          @Cast("uint32_t") int idx,
                          PointerPointer out);
public static native int MXNDArrayAt(NDArrayHandle handle,
                          @Cast("uint32_t") int idx,
                          @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief Index the NDArray along axis 0.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param handle the handle to the NDArray
 * @param idx the index
 * @param out The NDArrayHandle of output NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayAt64(NDArrayHandle handle,
                            @Cast("int64_t") long idx,
                            PointerPointer out);
public static native int MXNDArrayAt64(NDArrayHandle handle,
                            @Cast("int64_t") long idx,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief get the storage type of the array
 */
public static native int MXNDArrayGetStorageType(NDArrayHandle handle,
                                      IntPointer out_storage_type);
public static native int MXNDArrayGetStorageType(NDArrayHandle handle,
                                      IntBuffer out_storage_type);
public static native int MXNDArrayGetStorageType(NDArrayHandle handle,
                                      int[] out_storage_type);

/**
 * \brief Reshape the NDArray.
 * @param handle the handle to the narray
 * @param ndim number of dimensions of new shape
 * @param dims new shape
 * @param out the NDArrayHandle of reshaped NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayReshape(NDArrayHandle handle,
                               int ndim,
                               IntPointer dims,
                               PointerPointer out);
public static native int MXNDArrayReshape(NDArrayHandle handle,
                               int ndim,
                               IntBuffer dims,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayReshape(NDArrayHandle handle,
                               int ndim,
                               int[] dims,
                               PointerPointer out);
public static native int MXNDArrayReshape(NDArrayHandle handle,
                               int ndim,
                               IntPointer dims,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayReshape(NDArrayHandle handle,
                               int ndim,
                               IntBuffer dims,
                               PointerPointer out);
public static native int MXNDArrayReshape(NDArrayHandle handle,
                               int ndim,
                               int[] dims,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief Reshape the NDArray.
 * @param handle the handle to the narray
 * @param ndim number of dimensions of new shape
 * @param dims new shape
 * @param out the NDArrayHandle of reshaped NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayReshape64(NDArrayHandle handle,
                                 int ndim,
                                 @Cast("dim_t*") LongPointer dims,
                                 @Cast("bool") boolean reverse,
                                 PointerPointer out);
public static native int MXNDArrayReshape64(NDArrayHandle handle,
                                 int ndim,
                                 @Cast("dim_t*") LongBuffer dims,
                                 @Cast("bool") boolean reverse,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayReshape64(NDArrayHandle handle,
                                 int ndim,
                                 @Cast("dim_t*") long[] dims,
                                 @Cast("bool") boolean reverse,
                                 PointerPointer out);
public static native int MXNDArrayReshape64(NDArrayHandle handle,
                                 int ndim,
                                 @Cast("dim_t*") LongPointer dims,
                                 @Cast("bool") boolean reverse,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayReshape64(NDArrayHandle handle,
                                 int ndim,
                                 @Cast("dim_t*") LongBuffer dims,
                                 @Cast("bool") boolean reverse,
                                 PointerPointer out);
public static native int MXNDArrayReshape64(NDArrayHandle handle,
                                 int ndim,
                                 @Cast("dim_t*") long[] dims,
                                 @Cast("bool") boolean reverse,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief DEPRECATED. Use MXNDArrayGetShapeEx instead.
 * get the shape of the array
 * @param handle the handle to the narray
 * @param out_dim the output dimension
 * @param out_pdata pointer holder to get data pointer of the shape
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetShape(NDArrayHandle handle,
                                @Cast("uint32_t*") IntPointer out_dim,
                                @Cast("const uint32_t**") PointerPointer out_pdata);
public static native int MXNDArrayGetShape(NDArrayHandle handle,
                                @Cast("uint32_t*") IntPointer out_dim,
                                @Cast("const uint32_t**") @ByPtrPtr IntPointer out_pdata);
public static native int MXNDArrayGetShape(NDArrayHandle handle,
                                @Cast("uint32_t*") IntBuffer out_dim,
                                @Cast("const uint32_t**") @ByPtrPtr IntBuffer out_pdata);
public static native int MXNDArrayGetShape(NDArrayHandle handle,
                                @Cast("uint32_t*") int[] out_dim,
                                @Cast("const uint32_t**") @ByPtrPtr int[] out_pdata);

/**
 * \brief get the shape of the array
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param handle the handle to the narray
 * @param out_dim the output dimension
 * @param out_pdata pointer holder to get data pointer of the shape
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetShapeEx(NDArrayHandle handle,
                                  IntPointer out_dim,
                                  @Cast("const int**") PointerPointer out_pdata);
public static native int MXNDArrayGetShapeEx(NDArrayHandle handle,
                                  IntPointer out_dim,
                                  @Const @ByPtrPtr IntPointer out_pdata);
public static native int MXNDArrayGetShapeEx(NDArrayHandle handle,
                                  IntBuffer out_dim,
                                  @Const @ByPtrPtr IntBuffer out_pdata);
public static native int MXNDArrayGetShapeEx(NDArrayHandle handle,
                                  int[] out_dim,
                                  @Const @ByPtrPtr int[] out_pdata);

/**
 * \brief get the shape of the array
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param handle the handle to the narray
 * @param out_dim the output dimension
 * @param out_pdata pointer holder to get data pointer of the shape
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetShapeEx64(NDArrayHandle handle,
                                    IntPointer out_dim,
                                    @Cast("const int64_t**") PointerPointer out_pdata);
public static native int MXNDArrayGetShapeEx64(NDArrayHandle handle,
                                    IntPointer out_dim,
                                    @Cast("const int64_t**") @ByPtrPtr LongPointer out_pdata);
public static native int MXNDArrayGetShapeEx64(NDArrayHandle handle,
                                    IntBuffer out_dim,
                                    @Cast("const int64_t**") @ByPtrPtr LongBuffer out_pdata);
public static native int MXNDArrayGetShapeEx64(NDArrayHandle handle,
                                    int[] out_dim,
                                    @Cast("const int64_t**") @ByPtrPtr long[] out_pdata);

/**
 * \brief get the content of the data in NDArray
 * @param handle the handle to the ndarray
 * @param out_pdata pointer holder to get pointer of data
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetData(NDArrayHandle handle,
                               @Cast("void**") PointerPointer out_pdata);
public static native int MXNDArrayGetData(NDArrayHandle handle,
                               @Cast("void**") @ByPtrPtr Pointer out_pdata);
/**
* \brief Create a reference view of NDArray that
*  represents as DLManagedTensor
*  Notice: MXNet uses asynchronous execution. Please call MXNDArrayWaitToRead or
*          MXNDArrayWaitToWrite before calling MXNDArrayToDLPack.
* @param handle the handle to the ndarray
* @param out_dlpack pointer holder to get pointer of DLManagedTensor
* @return 0 when success, -1 when failure happens
*/
public static native int MXNDArrayToDLPack(NDArrayHandle handle,
                                       @ByPtrPtr DLManagedTensorHandle out_dlpack);

/**
* \brief DEPRECATED. Use MXNDArrayFromDLPackEx instead.
<p>
*
* This allows us to create a NDArray using the memory
* allocated by an external deep learning framework
* that is DLPack compatible.
*
* The memory is retained until the NDArray went out of scope.
*
* @param dlpack the pointer of the input DLManagedTensor
* @param transient_handle whether the handle will be destructed before calling the deleter
* @param out_handle pointer holder to get pointer of NDArray
* @return 0 when success, -1 when failure happens
*/
public static native int MXNDArrayFromDLPack(DLManagedTensorHandle dlpack,
                                  PointerPointer out_handle);
public static native int MXNDArrayFromDLPack(DLManagedTensorHandle dlpack,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out_handle);

/**
* \brief Create a NDArray backed by a dlpack tensor.
*
* This allows us to create a NDArray using the memory
* allocated by an external deep learning framework
* that is DLPack compatible.
*
* The memory is retained until the NDArray went out of scope.
*
* @param dlpack the pointer of the input DLManagedTensor
* @param transient_handle whether the handle will be destructed before calling the deleter
* @param out_handle pointer holder to get pointer of NDArray
* @return 0 when success, -1 when failure happens
*/
public static native int MXNDArrayFromDLPackEx(DLManagedTensorHandle dlpack,
                                    @Cast("const bool") boolean transient_handle,
                                    PointerPointer out_handle);
public static native int MXNDArrayFromDLPackEx(DLManagedTensorHandle dlpack,
                                    @Cast("const bool") boolean transient_handle,
                                    @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out_handle);

/**
 * \brief Delete a dlpack tensor
 * @param dlpack the pointer of the input DLManagedTensor
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayCallDLPackDeleter(DLManagedTensorHandle dlpack);

/**
 * \brief get the type of the data in NDArray
 * @param handle the handle to the narray
 * @param out_dtype pointer holder to get type of data
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetDType(NDArrayHandle handle,
                               IntPointer out_dtype);
public static native int MXNDArrayGetDType(NDArrayHandle handle,
                               IntBuffer out_dtype);
public static native int MXNDArrayGetDType(NDArrayHandle handle,
                               int[] out_dtype);

/**
 * \brief get the type of the ith aux data in NDArray
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param handle the handle to the narray
 * @param i the index of the aux data
 * @param out_type pointer holder to get type of aux data
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetAuxType(NDArrayHandle handle,
                                  @Cast("uint32_t") int i,
                                  IntPointer out_type);
public static native int MXNDArrayGetAuxType(NDArrayHandle handle,
                                  @Cast("uint32_t") int i,
                                  IntBuffer out_type);
public static native int MXNDArrayGetAuxType(NDArrayHandle handle,
                                  @Cast("uint32_t") int i,
                                  int[] out_type);

/**
 * \brief get the type of the ith aux data in NDArray
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param handle the handle to the narray
 * @param i the index of the aux data
 * @param out_type pointer holder to get type of aux data
 * @return 0 when success, -1 when failure happens
 */


/**
 * \brief Get a deep copy of the ith aux data blob
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * in the form of an NDArray of default storage type.
 * This function blocks. Do not use it in performance critical code.
 */
public static native int MXNDArrayGetAuxNDArray(NDArrayHandle handle,
                                     @Cast("uint32_t") int i,
                                     PointerPointer out);
public static native int MXNDArrayGetAuxNDArray(NDArrayHandle handle,
                                     @Cast("uint32_t") int i,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief Get a deep copy of the ith aux data blob
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * in the form of an NDArray of default storage type.
 * This function blocks. Do not use it in performance critical code.
 */


/**
 * \brief Get a deep copy of the data blob
 * in the form of an NDArray of default storage type.
 * This function blocks. Do not use it in performance critical code.
 */
public static native int MXNDArrayGetDataNDArray(NDArrayHandle handle,
                                      PointerPointer out);
public static native int MXNDArrayGetDataNDArray(NDArrayHandle handle,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief get the context of the NDArray
 * @param handle the handle to the narray
 * @param out_dev_type the output device type
 * @param out_dev_id the output device id
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetContext(NDArrayHandle handle,
                                  IntPointer out_dev_type,
                                  IntPointer out_dev_id);
public static native int MXNDArrayGetContext(NDArrayHandle handle,
                                  IntBuffer out_dev_type,
                                  IntBuffer out_dev_id);
public static native int MXNDArrayGetContext(NDArrayHandle handle,
                                  int[] out_dev_type,
                                  int[] out_dev_id);
/**
 * \brief return gradient buffer attached to this NDArray
 * @param handle NDArray handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetGrad(NDArrayHandle handle, PointerPointer out);
public static native int MXNDArrayGetGrad(NDArrayHandle handle, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief detach and ndarray from computation graph by clearing entry_
 * @param handle NDArray handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayDetach(NDArrayHandle handle, PointerPointer out);
public static native int MXNDArrayDetach(NDArrayHandle handle, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief set the flag for gradient array state.
 * @param handle NDArray handle
 * @param state the new state.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArraySetGradState(NDArrayHandle handle, int state);
/**
 * \brief set the flag for gradient array state.
 * @param handle NDArray handle
 * @param state the new state.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXNDArrayGetGradState(NDArrayHandle handle, IntPointer out);
public static native int MXNDArrayGetGradState(NDArrayHandle handle, IntBuffer out);
public static native int MXNDArrayGetGradState(NDArrayHandle handle, int[] out);
//--------------------------------
// Part 2: functions on NDArray
//--------------------------------
/**
 * \brief list all the available functions handles
 *   most user can use it to list all the needed functions
 * @param out_size the size of returned array
 * @param out_array the output function array
 * @return 0 when success, -1 when failure happens
 */
public static native int MXListFunctions(@Cast("uint32_t*") IntPointer out_size,
                              @Const @ByPtrPtr PointerPointer out_array);
public static native int MXListFunctions(@Cast("uint32_t*") IntBuffer out_size,
                              @Cast("FunctionHandle**") @Const @ByPtrPtr PointerPointer out_array);
public static native int MXListFunctions(@Cast("uint32_t*") int[] out_size,
                              @Const @ByPtrPtr PointerPointer out_array);

/**
 * \brief get the function handle by name
 * @param name the name of the function
 * @param out the corresponding function handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXGetFunction(@Cast("const char*") BytePointer name,
                            @Const PointerPointer out);
public static native int MXGetFunction(String name,
                            @Const @Cast("FunctionHandle*") @ByPtrPtr FunctionHandle out);
/**
 * \brief Get the information of the function handle.
 * @param fun The function handle.
 * @param name The returned name of the function.
 * @param description The returned description of the function.
 * @param num_args Number of arguments.
 * @param arg_names Name of the arguments.
 * @param arg_type_infos Type information about the arguments.
 * @param arg_descriptions Description information about the arguments.
 * @param return_type Return type of the function.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") PointerPointer name,
                            @Cast("const char**") PointerPointer description,
                            @Cast("uint32_t*") IntPointer num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                            @Cast("const char**") PointerPointer return_type/*=NULL*/);
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") @ByPtrPtr BytePointer name,
                            @Cast("const char**") @ByPtrPtr BytePointer description,
                            @Cast("uint32_t*") IntPointer num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") @ByPtrPtr BytePointer name,
                            @Cast("const char**") @ByPtrPtr BytePointer description,
                            @Cast("uint32_t*") IntPointer num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                            @Cast("const char**") @ByPtrPtr BytePointer return_type/*=NULL*/);
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") @ByPtrPtr ByteBuffer name,
                            @Cast("const char**") @ByPtrPtr ByteBuffer description,
                            @Cast("uint32_t*") IntBuffer num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                            @Cast("const char**") @ByPtrPtr ByteBuffer return_type/*=NULL*/);
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") @ByPtrPtr ByteBuffer name,
                            @Cast("const char**") @ByPtrPtr ByteBuffer description,
                            @Cast("uint32_t*") IntBuffer num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") @ByPtrPtr byte[] name,
                            @Cast("const char**") @ByPtrPtr byte[] description,
                            @Cast("uint32_t*") int[] num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                            @Cast("const char**") @ByPtrPtr byte[] return_type/*=NULL*/);
public static native int MXFuncGetInfo(@Const FunctionHandle fun,
                            @Cast("const char**") @ByPtrPtr byte[] name,
                            @Cast("const char**") @ByPtrPtr byte[] description,
                            @Cast("uint32_t*") int[] num_args,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                            @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
/**
 * \brief get the argument requirements of the function
 * @param fun input function handle
 * @param num_use_vars how many NDArrays to be passed in as used_vars
 * @param num_scalars scalar variable is needed
 * @param num_mutate_vars how many NDArrays to be passed in as mutate_vars
 * @param type_mask the type mask of this function
 * @return 0 when success, -1 when failure happens
 * @see MXFuncInvoke
 */
public static native int MXFuncDescribe(@Const FunctionHandle fun,
                             @Cast("uint32_t*") IntPointer num_use_vars,
                             @Cast("uint32_t*") IntPointer num_scalars,
                             @Cast("uint32_t*") IntPointer num_mutate_vars,
                             IntPointer type_mask);
public static native int MXFuncDescribe(@Const FunctionHandle fun,
                             @Cast("uint32_t*") IntBuffer num_use_vars,
                             @Cast("uint32_t*") IntBuffer num_scalars,
                             @Cast("uint32_t*") IntBuffer num_mutate_vars,
                             IntBuffer type_mask);
public static native int MXFuncDescribe(@Const FunctionHandle fun,
                             @Cast("uint32_t*") int[] num_use_vars,
                             @Cast("uint32_t*") int[] num_scalars,
                             @Cast("uint32_t*") int[] num_mutate_vars,
                             int[] type_mask);
/**
 * \brief invoke a function, the array size of passed in arguments
 *   must match the values in the
 * @param fun the function
 * @param use_vars the normal arguments passed to function
 * @param scalar_args the scalar qarguments
 * @param mutate_vars the mutate arguments
 * @return 0 when success, -1 when failure happens
 * @see MXFuncDescribeArgs
 */
public static native int MXFuncInvoke(@Const FunctionHandle fun,
                           PointerPointer use_vars,
                           FloatPointer scalar_args,
                           PointerPointer mutate_vars);
public static native int MXFuncInvoke(@Const FunctionHandle fun,
                           @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle use_vars,
                           FloatBuffer scalar_args,
                           @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutate_vars);
public static native int MXFuncInvoke(@Const FunctionHandle fun,
                           PointerPointer use_vars,
                           float[] scalar_args,
                           PointerPointer mutate_vars);
public static native int MXFuncInvoke(@Const FunctionHandle fun,
                           @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle use_vars,
                           FloatPointer scalar_args,
                           @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutate_vars);
public static native int MXFuncInvoke(@Const FunctionHandle fun,
                           PointerPointer use_vars,
                           FloatBuffer scalar_args,
                           PointerPointer mutate_vars);
public static native int MXFuncInvoke(@Const FunctionHandle fun,
                           @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle use_vars,
                           float[] scalar_args,
                           @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutate_vars);
/**
 * \brief invoke a function, the array size of passed in arguments
 *   must match the values in the
 * @param fun the function
 * @param use_vars the normal arguments passed to function
 * @param scalar_args the scalar qarguments
 * @param mutate_vars the mutate arguments
 * @param num_params number of keyword parameters
 * @param param_keys keys for keyword parameters
 * @param param_vals values for keyword parameters
 * @return 0 when success, -1 when failure happens
 * @see MXFuncDescribeArgs
 */
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             PointerPointer use_vars,
                             FloatPointer scalar_args,
                             PointerPointer mutate_vars,
                             int num_params,
                             @Cast("char**") PointerPointer param_keys,
                             @Cast("char**") PointerPointer param_vals);
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             PointerPointer use_vars,
                             FloatPointer scalar_args,
                             PointerPointer mutate_vars,
                             int num_params,
                             @Cast("char**") @ByPtrPtr BytePointer param_keys,
                             @Cast("char**") @ByPtrPtr BytePointer param_vals);
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle use_vars,
                             FloatBuffer scalar_args,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutate_vars,
                             int num_params,
                             @Cast("char**") @ByPtrPtr ByteBuffer param_keys,
                             @Cast("char**") @ByPtrPtr ByteBuffer param_vals);
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             PointerPointer use_vars,
                             float[] scalar_args,
                             PointerPointer mutate_vars,
                             int num_params,
                             @Cast("char**") @ByPtrPtr byte[] param_keys,
                             @Cast("char**") @ByPtrPtr byte[] param_vals);
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle use_vars,
                             FloatPointer scalar_args,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutate_vars,
                             int num_params,
                             @Cast("char**") @ByPtrPtr BytePointer param_keys,
                             @Cast("char**") @ByPtrPtr BytePointer param_vals);
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             PointerPointer use_vars,
                             FloatBuffer scalar_args,
                             PointerPointer mutate_vars,
                             int num_params,
                             @Cast("char**") @ByPtrPtr ByteBuffer param_keys,
                             @Cast("char**") @ByPtrPtr ByteBuffer param_vals);
public static native int MXFuncInvokeEx(@Const FunctionHandle fun,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle use_vars,
                             float[] scalar_args,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutate_vars,
                             int num_params,
                             @Cast("char**") @ByPtrPtr byte[] param_keys,
                             @Cast("char**") @ByPtrPtr byte[] param_vals);
/**
 * \brief invoke a nnvm op and imperative function
 * @param creator the op
 * @param num_inputs number of input NDArrays
 * @param inputs input NDArrays
 * @param num_outputs number of output NDArrays
 * @param outputs output NDArrays
 * @param num_params number of keyword parameters
 * @param param_keys keys for keyword parameters
 * @param param_vals values for keyword parameters
 * @return 0 when success, -1 when failure happens
 */
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 IntPointer num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") PointerPointer param_keys,
                                 @Cast("const char**") PointerPointer param_vals);
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 IntPointer num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") @ByPtrPtr BytePointer param_keys,
                                 @Cast("const char**") @ByPtrPtr BytePointer param_vals);
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                 IntBuffer num_outputs,
                                 @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer param_keys,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer param_vals);
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 int[] num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") @ByPtrPtr byte[] param_keys,
                                 @Cast("const char**") @ByPtrPtr byte[] param_vals);
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                 IntPointer num_outputs,
                                 @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") @ByPtrPtr BytePointer param_keys,
                                 @Cast("const char**") @ByPtrPtr BytePointer param_vals);
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 IntBuffer num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer param_keys,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer param_vals);
public static native int MXImperativeInvoke(AtomicSymbolCreator creator,
                                 int num_inputs,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                 int[] num_outputs,
                                 @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                 int num_params,
                                 @Cast("const char**") @ByPtrPtr byte[] param_keys,
                                 @Cast("const char**") @ByPtrPtr byte[] param_vals);
/**
 * \brief invoke a nnvm op and imperative function
 * @param creator the op
 * @param num_inputs number of input NDArrays
 * @param inputs input NDArrays
 * @param num_outputs number of output NDArrays
 * @param outputs output NDArrays
 * @param num_params number of keyword parameters
 * @param param_keys keys for keyword parameters
 * @param param_vals values for keyword parameters
 * @param out_stypes output ndarrays' stypes
 * @return 0 when success, -1 when failure happens
 */
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   PointerPointer inputs,
                                   IntPointer num_outputs,
                                   @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") PointerPointer param_keys,
                                   @Cast("const char**") PointerPointer param_vals,
                                   @Cast("const int**") PointerPointer out_stypes);
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   PointerPointer inputs,
                                   IntPointer num_outputs,
                                   @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") @ByPtrPtr BytePointer param_keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer param_vals,
                                   @Const @ByPtrPtr IntPointer out_stypes);
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                   IntBuffer num_outputs,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer param_keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer param_vals,
                                   @Const @ByPtrPtr IntBuffer out_stypes);
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   PointerPointer inputs,
                                   int[] num_outputs,
                                   @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") @ByPtrPtr byte[] param_keys,
                                   @Cast("const char**") @ByPtrPtr byte[] param_vals,
                                   @Const @ByPtrPtr int[] out_stypes);
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                   IntPointer num_outputs,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") @ByPtrPtr BytePointer param_keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer param_vals,
                                   @Const @ByPtrPtr IntPointer out_stypes);
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   PointerPointer inputs,
                                   IntBuffer num_outputs,
                                   @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer param_keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer param_vals,
                                   @Const @ByPtrPtr IntBuffer out_stypes);
public static native int MXImperativeInvokeEx(AtomicSymbolCreator creator,
                                   int num_inputs,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                   int[] num_outputs,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                   int num_params,
                                   @Cast("const char**") @ByPtrPtr byte[] param_keys,
                                   @Cast("const char**") @ByPtrPtr byte[] param_vals,
                                   @Const @ByPtrPtr int[] out_stypes);
/**
 * \brief set whether to record operator for autograd
 * @param is_recording 1 when recording, 0 when not recording.
 * @param prev returns the previous status before this set.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradSetIsRecording(int is_recording, IntPointer prev);
public static native int MXAutogradSetIsRecording(int is_recording, IntBuffer prev);
public static native int MXAutogradSetIsRecording(int is_recording, int[] prev);
/**
 * \brief set whether to record operator for autograd
 * @param is_training 1 when training, 0 when testing
 * @param prev returns the previous status before this set.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradSetIsTraining(int is_training, IntPointer prev);
public static native int MXAutogradSetIsTraining(int is_training, IntBuffer prev);
public static native int MXAutogradSetIsTraining(int is_training, int[] prev);
/**
 * \brief get whether autograd recording is on
 * @param curr returns the current status.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradIsRecording(@Cast("bool*") BoolPointer curr);
public static native int MXAutogradIsRecording(@Cast("bool*") boolean[] curr);
/**
 * \brief get whether training mode is on
 * @param curr returns the current status.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradIsTraining(@Cast("bool*") BoolPointer curr);
public static native int MXAutogradIsTraining(@Cast("bool*") boolean[] curr);
/**
 * \brief get whether numpy compatibility is on
 * @param curr returns the current status
 * @return 0 when success, -1 when failure happens
 */
public static native int MXIsNumpyShape(IntPointer curr);
public static native int MXIsNumpyShape(IntBuffer curr);
public static native int MXIsNumpyShape(int[] curr);
/**
 * \brief set numpy compatibility switch
 * @param is_np_shape 1 when numpy shape semantics is thread local on,
 *        2 when numpy shape semantics is global on and 0 when off
 * @param prev returns the previous status before this set
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSetIsNumpyShape(int is_np_shape, IntPointer prev);
public static native int MXSetIsNumpyShape(int is_np_shape, IntBuffer prev);
public static native int MXSetIsNumpyShape(int is_np_shape, int[] prev);
/**
 * \brief mark NDArrays as variables to compute gradient for autograd
 * @param num_var number of variable NDArrays
 * @param var_handles variable NDArrays
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradMarkVariables(@Cast("uint32_t") int num_var,
                                      PointerPointer var_handles,
                                      @Cast("uint32_t*") IntPointer reqs_array,
                                      PointerPointer grad_handles);
public static native int MXAutogradMarkVariables(@Cast("uint32_t") int num_var,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle var_handles,
                                      @Cast("uint32_t*") IntBuffer reqs_array,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle grad_handles);
public static native int MXAutogradMarkVariables(@Cast("uint32_t") int num_var,
                                      PointerPointer var_handles,
                                      @Cast("uint32_t*") int[] reqs_array,
                                      PointerPointer grad_handles);
public static native int MXAutogradMarkVariables(@Cast("uint32_t") int num_var,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle var_handles,
                                      @Cast("uint32_t*") IntPointer reqs_array,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle grad_handles);
public static native int MXAutogradMarkVariables(@Cast("uint32_t") int num_var,
                                      PointerPointer var_handles,
                                      @Cast("uint32_t*") IntBuffer reqs_array,
                                      PointerPointer grad_handles);
public static native int MXAutogradMarkVariables(@Cast("uint32_t") int num_var,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle var_handles,
                                      @Cast("uint32_t*") int[] reqs_array,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle grad_handles);
/**
 * \brief compute the gradient of outputs w.r.t variabels
 * @param num_output number of output NDArray
 * @param output_handles output NDArrays
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradComputeGradient(@Cast("uint32_t") int num_output,
                                        PointerPointer output_handles);
public static native int MXAutogradComputeGradient(@Cast("uint32_t") int num_output,
                                        @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle output_handles);
/**
 * \brief compute the gradient of outputs w.r.t variabels
 * @param num_output number of output NDArray
 * @param output_handles output NDArrays
 * @param ograd_handles head gradient for NDArrays
 * @param retain_graph whether to keep the graph after backward
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradBackward(@Cast("uint32_t") int num_output,
                                 PointerPointer output_handles,
                                 PointerPointer ograd_handles,
                                 int retain_graph);
public static native int MXAutogradBackward(@Cast("uint32_t") int num_output,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle output_handles,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle ograd_handles,
                                 int retain_graph);
/**
 * \brief compute the gradient of outputs w.r.t variabels
 * @param num_output number of output NDArray
 * @param output_handles output NDArrays
 * @param ograd_handles head gradient for NDArrays
 * @param num_variables number of variables
 * @param
 * @param retain_graph whether to keep the graph after backward
 * @param is_train whether to do backward for training or inference
 * @return 0 when success, -1 when failure happens
 */
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   PointerPointer output_handles,
                                   PointerPointer ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   PointerPointer var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @ByPtrPtr PointerPointer grad_handles,
                                   @Cast("int**") PointerPointer grad_stypes);
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   PointerPointer output_handles,
                                   PointerPointer ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   PointerPointer var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @ByPtrPtr PointerPointer grad_handles,
                                   @ByPtrPtr IntPointer grad_stypes);
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle output_handles,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer grad_handles,
                                   @ByPtrPtr IntBuffer grad_stypes);
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   PointerPointer output_handles,
                                   PointerPointer ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   PointerPointer var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @ByPtrPtr PointerPointer grad_handles,
                                   @ByPtrPtr int[] grad_stypes);
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle output_handles,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer grad_handles,
                                   @ByPtrPtr IntPointer grad_stypes);
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   PointerPointer output_handles,
                                   PointerPointer ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   PointerPointer var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @ByPtrPtr PointerPointer grad_handles,
                                   @ByPtrPtr IntBuffer grad_stypes);
public static native int MXAutogradBackwardEx(@Cast("uint32_t") int num_output,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle output_handles,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle ograd_handles,
                                   @Cast("uint32_t") int num_variables,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle var_handles,
                                   int retain_graph,
                                   int create_graph,
                                   int is_train,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer grad_handles,
                                   @ByPtrPtr int[] grad_stypes);
/*
 * \brief get the graph constructed by autograd.
 * \param handle ndarray handle
 * \param out output symbol handle
 */
public static native int MXAutogradGetSymbol(NDArrayHandle handle, PointerPointer out);
public static native int MXAutogradGetSymbol(NDArrayHandle handle, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief create cached operator
 */
public static native int MXCreateCachedOp(SymbolHandle handle, @ByPtrPtr CachedOpHandle out);
/**
 * \brief create cached operator
 */
public static native int MXCreateCachedOpEx(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") PointerPointer keys,
                                 @Cast("const char**") PointerPointer vals,
                                 @ByPtrPtr CachedOpHandle out);
public static native int MXCreateCachedOpEx(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr BytePointer keys,
                                 @Cast("const char**") @ByPtrPtr BytePointer vals,
                                 @ByPtrPtr CachedOpHandle out);
public static native int MXCreateCachedOpEx(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                 @ByPtrPtr CachedOpHandle out);
public static native int MXCreateCachedOpEx(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr byte[] keys,
                                 @Cast("const char**") @ByPtrPtr byte[] vals,
                                 @ByPtrPtr CachedOpHandle out);

/**
 * \brief create cached operator, allows to choose thread_safe version
 * of cachedop
 */
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") PointerPointer keys,
                                 @Cast("const char**") PointerPointer vals,
                                 @ByPtrPtr CachedOpHandle out,
                                 @Cast("bool") boolean thread_safe/*=false*/);
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr BytePointer keys,
                                 @Cast("const char**") @ByPtrPtr BytePointer vals,
                                 @ByPtrPtr CachedOpHandle out);
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr BytePointer keys,
                                 @Cast("const char**") @ByPtrPtr BytePointer vals,
                                 @ByPtrPtr CachedOpHandle out,
                                 @Cast("bool") boolean thread_safe/*=false*/);
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                 @ByPtrPtr CachedOpHandle out,
                                 @Cast("bool") boolean thread_safe/*=false*/);
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                 @ByPtrPtr CachedOpHandle out);
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr byte[] keys,
                                 @Cast("const char**") @ByPtrPtr byte[] vals,
                                 @ByPtrPtr CachedOpHandle out,
                                 @Cast("bool") boolean thread_safe/*=false*/);
public static native int MXCreateCachedOpEX(SymbolHandle handle,
                                 int num_flags,
                                 @Cast("const char**") @ByPtrPtr byte[] keys,
                                 @Cast("const char**") @ByPtrPtr byte[] vals,
                                 @ByPtrPtr CachedOpHandle out);

/**
 * \brief free cached operator
 */
public static native int MXFreeCachedOp(CachedOpHandle handle);

/**
 * \brief invoke cached operator
 */
public static native int MXInvokeCachedOp(CachedOpHandle handle,
                               int num_inputs,
                               PointerPointer inputs,
                               IntPointer num_outputs,
                               @ByPtrPtr PointerPointer outputs);
public static native int MXInvokeCachedOp(CachedOpHandle handle,
                               int num_inputs,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                               IntBuffer num_outputs,
                               @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs);
public static native int MXInvokeCachedOp(CachedOpHandle handle,
                               int num_inputs,
                               PointerPointer inputs,
                               int[] num_outputs,
                               @ByPtrPtr PointerPointer outputs);
public static native int MXInvokeCachedOp(CachedOpHandle handle,
                               int num_inputs,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                               IntPointer num_outputs,
                               @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs);
public static native int MXInvokeCachedOp(CachedOpHandle handle,
                               int num_inputs,
                               PointerPointer inputs,
                               IntBuffer num_outputs,
                               @ByPtrPtr PointerPointer outputs);
public static native int MXInvokeCachedOp(CachedOpHandle handle,
                               int num_inputs,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                               int[] num_outputs,
                               @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs);

/**
 * \brief invoke a cached op
 * @param handle the handle to the cached op
 * @param num_inputs number of input NDArrays
 * @param inputs input NDArrays
 * @param num_outputs number of output NDArrays
 * @param outputs output NDArrays
 * @param out_stypes output ndarrays' stypes
 * @return 0 when success, -1 when failure happens
 */
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 IntPointer num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 @Cast("const int**") PointerPointer out_stypes);
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 IntPointer num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 @Const @ByPtrPtr IntPointer out_stypes);
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                 IntBuffer num_outputs,
                                 @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                 @Const @ByPtrPtr IntBuffer out_stypes);
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 int[] num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 @Const @ByPtrPtr int[] out_stypes);
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                 IntPointer num_outputs,
                                 @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                 @Const @ByPtrPtr IntPointer out_stypes);
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 PointerPointer inputs,
                                 IntBuffer num_outputs,
                                 @ByPtrPtr PointerPointer outputs,
                                 @Const @ByPtrPtr IntBuffer out_stypes);
public static native int MXInvokeCachedOpEx(CachedOpHandle handle,
                                 int num_inputs,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                 int[] num_outputs,
                                 @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer outputs,
                                 @Const @ByPtrPtr int[] out_stypes);

/**
 * \brief cached op set monitor callback
 */
public static native int MXCachedOpRegisterOpHook(NDArrayHandle handle,
                                       CachedOpMonitorCallback callback,
                                       @Cast("bool") boolean monitor_all);

//--------------------------------------------
// Part 3: symbolic configuration generation
//--------------------------------------------
/**
 * \brief list all the available operator names, include entries.
 * @param out_size the size of returned array
 * @param out_array the output operator name array.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXListAllOpNames(@Cast("uint32_t*") IntPointer out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out_array);
public static native int MXListAllOpNames(@Cast("uint32_t*") IntBuffer out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out_array);
public static native int MXListAllOpNames(@Cast("uint32_t*") int[] out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out_array);

/**
 * \brief list all the available AtomicSymbolEntry
 * @param out_size the size of returned array
 * @param out_array the output AtomicSymbolCreator array
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolListAtomicSymbolCreators(@Cast("uint32_t*") IntPointer out_size,
                                               @ByPtrPtr PointerPointer out_array);
public static native int MXSymbolListAtomicSymbolCreators(@Cast("uint32_t*") IntBuffer out_size,
                                               @Cast("AtomicSymbolCreator**") @ByPtrPtr PointerPointer out_array);
public static native int MXSymbolListAtomicSymbolCreators(@Cast("uint32_t*") int[] out_size,
                                               @ByPtrPtr PointerPointer out_array);

/**
 * \brief Get the name of an atomic symbol.
 * @param creator the AtomicSymbolCreator.
 * @param name The returned name of the creator.
 */
public static native int MXSymbolGetAtomicSymbolName(AtomicSymbolCreator creator,
                                          @Cast("const char**") PointerPointer name);
public static native int MXSymbolGetAtomicSymbolName(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr BytePointer name);
public static native int MXSymbolGetAtomicSymbolName(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer name);
public static native int MXSymbolGetAtomicSymbolName(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr byte[] name);

/**
 * \brief Get the input symbols of the graph.
 * @param sym The graph.
 * @param inputs The input symbols of the graph.
 * @param input_size the number of input symbols returned.
 */
public static native int MXSymbolGetInputSymbols(SymbolHandle sym, @ByPtrPtr PointerPointer inputs,
                                      IntPointer input_size);
public static native int MXSymbolGetInputSymbols(SymbolHandle sym, @Cast("SymbolHandle**") @ByPtrPtr PointerPointer inputs,
                                      IntBuffer input_size);
public static native int MXSymbolGetInputSymbols(SymbolHandle sym, @ByPtrPtr PointerPointer inputs,
                                      int[] input_size);

/**
 * \brief Cut a subgraph whose nodes are marked with a subgraph attribute.
 * The input graph will be modified. A variable node will be created for each
 * edge that connects to nodes outside the subgraph. The outside nodes that
 * connect to the subgraph will be returned.
 * @param sym The graph.
 * @param inputs The nodes that connect to the subgraph.
 * @param input_size The number of such nodes.
 */
public static native int MXSymbolCutSubgraph(SymbolHandle sym, @ByPtrPtr PointerPointer inputs,
                                  IntPointer input_size);
public static native int MXSymbolCutSubgraph(SymbolHandle sym, @Cast("SymbolHandle**") @ByPtrPtr PointerPointer inputs,
                                  IntBuffer input_size);
public static native int MXSymbolCutSubgraph(SymbolHandle sym, @ByPtrPtr PointerPointer inputs,
                                  int[] input_size);

/**
 * \brief Get the detailed information about atomic symbol.
 * @param creator the AtomicSymbolCreator.
 * @param name The returned name of the creator.
 * @param description The returned description of the symbol.
 * @param num_args Number of arguments.
 * @param arg_names Name of the arguments.
 * @param arg_type_infos Type informations about the arguments.
 * @param arg_descriptions Description information about the arguments.
 * @param key_var_num_args The keyword argument for specifying variable number of arguments.
 *            When this parameter has non-zero length, the function allows variable number
 *            of positional arguments, and will need the caller to pass it in in
 *            MXSymbolCreateAtomicSymbol,
 *            With key = key_var_num_args, and value = number of positional arguments.
 * @param return_type Return type of the function, can be Symbol or Symbol[]
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") PointerPointer name,
                                          @Cast("const char**") PointerPointer description,
                                          @Cast("uint32_t*") IntPointer num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") PointerPointer key_var_num_args,
                                          @Cast("const char**") PointerPointer return_type/*=NULL*/);
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr BytePointer name,
                                          @Cast("const char**") @ByPtrPtr BytePointer description,
                                          @Cast("uint32_t*") IntPointer num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") @ByPtrPtr BytePointer key_var_num_args);
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr BytePointer name,
                                          @Cast("const char**") @ByPtrPtr BytePointer description,
                                          @Cast("uint32_t*") IntPointer num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") @ByPtrPtr BytePointer key_var_num_args,
                                          @Cast("const char**") @ByPtrPtr BytePointer return_type/*=NULL*/);
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer name,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer description,
                                          @Cast("uint32_t*") IntBuffer num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer key_var_num_args,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer return_type/*=NULL*/);
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer name,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer description,
                                          @Cast("uint32_t*") IntBuffer num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer key_var_num_args);
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr byte[] name,
                                          @Cast("const char**") @ByPtrPtr byte[] description,
                                          @Cast("uint32_t*") int[] num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") @ByPtrPtr byte[] key_var_num_args,
                                          @Cast("const char**") @ByPtrPtr byte[] return_type/*=NULL*/);
public static native int MXSymbolGetAtomicSymbolInfo(AtomicSymbolCreator creator,
                                          @Cast("const char**") @ByPtrPtr byte[] name,
                                          @Cast("const char**") @ByPtrPtr byte[] description,
                                          @Cast("uint32_t*") int[] num_args,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                          @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                                          @Cast("const char**") @ByPtrPtr byte[] key_var_num_args);
/**
 * \brief Create an AtomicSymbol.
 * @param creator the AtomicSymbolCreator
 * @param num_param the number of parameters
 * @param keys the keys to the params
 * @param vals the vals of the params
 * @param out pointer to the created symbol handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") PointerPointer keys,
                                         @Cast("const char**") PointerPointer vals,
                                         PointerPointer out);
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") @ByPtrPtr BytePointer keys,
                                         @Cast("const char**") @ByPtrPtr BytePointer vals,
                                         PointerPointer out);
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                         @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                         @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") @ByPtrPtr byte[] keys,
                                         @Cast("const char**") @ByPtrPtr byte[] vals,
                                         PointerPointer out);
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") @ByPtrPtr BytePointer keys,
                                         @Cast("const char**") @ByPtrPtr BytePointer vals,
                                         @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                         @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                         PointerPointer out);
public static native int MXSymbolCreateAtomicSymbol(AtomicSymbolCreator creator,
                                         @Cast("uint32_t") int num_param,
                                         @Cast("const char**") @ByPtrPtr byte[] keys,
                                         @Cast("const char**") @ByPtrPtr byte[] vals,
                                         @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Create a Variable Symbol.
 * @param name name of the variable
 * @param out pointer to the created symbol handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCreateVariable(@Cast("const char*") BytePointer name, PointerPointer out);
public static native int MXSymbolCreateVariable(String name, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Create a Symbol by grouping list of symbols together
 * @param num_symbols number of symbols to be grouped
 * @param symbols array of symbol handles
 * @param out pointer to the created symbol handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCreateGroup(@Cast("uint32_t") int num_symbols,
                                  PointerPointer symbols,
                                  PointerPointer out);
public static native int MXSymbolCreateGroup(@Cast("uint32_t") int num_symbols,
                                  @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle symbols,
                                  @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Load a symbol from a json file.
 * @param fname the file name.
 * @param out the output symbol.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCreateFromFile(@Cast("const char*") BytePointer fname, PointerPointer out);
public static native int MXSymbolCreateFromFile(String fname, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Load a symbol from a json string.
 * @param json the json string.
 * @param out the output symbol.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCreateFromJSON(@Cast("const char*") BytePointer json, PointerPointer out);
public static native int MXSymbolCreateFromJSON(String json, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Remove the operators amp_cast and amp_multicast
 * @param sym_handle the input symbol.
 * @param ret_sym_handle the output symbol.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolRemoveAmpCast(SymbolHandle sym_handle, PointerPointer ret_sym_handle);
public static native int MXSymbolRemoveAmpCast(SymbolHandle sym_handle, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle);
/**
 * \brief Save a symbol into a json file.
 * @param symbol the input symbol.
 * @param fname the file name.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolSaveToFile(SymbolHandle symbol, @Cast("const char*") BytePointer fname);
public static native int MXSymbolSaveToFile(SymbolHandle symbol, String fname);
/**
 * \brief Save a symbol into a json string
 * @param symbol the input symbol.
 * @param out_json output json string.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolSaveToJSON(SymbolHandle symbol, @Cast("const char**") PointerPointer out_json);
public static native int MXSymbolSaveToJSON(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr BytePointer out_json);
public static native int MXSymbolSaveToJSON(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr ByteBuffer out_json);
public static native int MXSymbolSaveToJSON(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr byte[] out_json);
/**
 * \brief Free the symbol handle.
 * @param symbol the symbol
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolFree(SymbolHandle symbol);
/**
 * \brief Copy the symbol to another handle
 * @param symbol the source symbol
 * @param out used to hold the result of copy
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCopy(SymbolHandle symbol, PointerPointer out);
public static native int MXSymbolCopy(SymbolHandle symbol, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Print the content of symbol, used for debug.
 * @param symbol the symbol
 * @param out_str pointer to hold the output string of the printing.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolPrint(SymbolHandle symbol, @Cast("const char**") PointerPointer out_str);
public static native int MXSymbolPrint(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr BytePointer out_str);
public static native int MXSymbolPrint(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr ByteBuffer out_str);
public static native int MXSymbolPrint(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr byte[] out_str);
/**
 * \brief Get string name from symbol
 * @param symbol the source symbol
 * @param out The result name.
 * @param success Whether the result is contained in out.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetName(SymbolHandle symbol,
                              @Cast("const char**") PointerPointer out,
                              IntPointer success);
public static native int MXSymbolGetName(SymbolHandle symbol,
                              @Cast("const char**") @ByPtrPtr BytePointer out,
                              IntPointer success);
public static native int MXSymbolGetName(SymbolHandle symbol,
                              @Cast("const char**") @ByPtrPtr ByteBuffer out,
                              IntBuffer success);
public static native int MXSymbolGetName(SymbolHandle symbol,
                              @Cast("const char**") @ByPtrPtr byte[] out,
                              int[] success);
/**
 * \brief Get string attribute from symbol
 * @param symbol the source symbol
 * @param key The key of the symbol.
 * @param out The result attribute, can be NULL if the attribute do not exist.
 * @param success Whether the result is contained in out.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              @Cast("const char*") BytePointer key,
                              @Cast("const char**") PointerPointer out,
                              IntPointer success);
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              @Cast("const char*") BytePointer key,
                              @Cast("const char**") @ByPtrPtr BytePointer out,
                              IntPointer success);
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              String key,
                              @Cast("const char**") @ByPtrPtr ByteBuffer out,
                              IntBuffer success);
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              @Cast("const char*") BytePointer key,
                              @Cast("const char**") @ByPtrPtr byte[] out,
                              int[] success);
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              String key,
                              @Cast("const char**") @ByPtrPtr BytePointer out,
                              IntPointer success);
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              @Cast("const char*") BytePointer key,
                              @Cast("const char**") @ByPtrPtr ByteBuffer out,
                              IntBuffer success);
public static native int MXSymbolGetAttr(SymbolHandle symbol,
                              String key,
                              @Cast("const char**") @ByPtrPtr byte[] out,
                              int[] success);
/**
 * \brief Set string attribute from symbol.
 *  NOTE: Setting attribute to a symbol can affect the semantics(mutable/immutable) of symbolic graph.
 *
 *  Safe recommendaton: use  immutable graph
 *  - Only allow set attributes during creation of new symbol as optional parameter
 *
 *  Mutable graph (be careful about the semantics):
 *  - Allow set attr at any point.
 *  - Mutating an attribute of some common node of two graphs can cause confusion from user.
 *
 * @param symbol the source symbol
 * @param key The key of the symbol.
 * @param value The value to be saved.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolSetAttr(SymbolHandle symbol,
                              @Cast("const char*") BytePointer key,
                              @Cast("const char*") BytePointer value);
public static native int MXSymbolSetAttr(SymbolHandle symbol,
                              String key,
                              String value);
/**
 * \brief Get all attributes from symbol, including all descendents.
 * @param symbol the source symbol
 * @param out_size The number of output attributes
 * @param out 2*out_size strings representing key value pairs.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolListAttr(SymbolHandle symbol,
                               @Cast("uint32_t*") IntPointer out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out);
public static native int MXSymbolListAttr(SymbolHandle symbol,
                               @Cast("uint32_t*") IntBuffer out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out);
public static native int MXSymbolListAttr(SymbolHandle symbol,
                               @Cast("uint32_t*") int[] out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out);
/**
 * \brief Get all attributes from symbol, excluding descendents.
 * @param symbol the source symbol
 * @param out_size The number of output attributes
 * @param out 2*out_size strings representing key value pairs.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolListAttrShallow(SymbolHandle symbol,
                                      @Cast("uint32_t*") IntPointer out_size,
                                      @Cast("const char***") @ByPtrPtr PointerPointer out);
public static native int MXSymbolListAttrShallow(SymbolHandle symbol,
                                      @Cast("uint32_t*") IntBuffer out_size,
                                      @Cast("const char***") @ByPtrPtr PointerPointer out);
public static native int MXSymbolListAttrShallow(SymbolHandle symbol,
                                      @Cast("uint32_t*") int[] out_size,
                                      @Cast("const char***") @ByPtrPtr PointerPointer out);
/**
 * \brief List arguments in the symbol.
 * @param symbol the symbol
 * @param out_size output size
 * @param out_str_array pointer to hold the output string array
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolListArguments(SymbolHandle symbol,
                                    @Cast("uint32_t*") IntPointer out_size,
                                    @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int MXSymbolListArguments(SymbolHandle symbol,
                                    @Cast("uint32_t*") IntBuffer out_size,
                                    @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int MXSymbolListArguments(SymbolHandle symbol,
                                    @Cast("uint32_t*") int[] out_size,
                                    @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);

/**
 * \brief List returns in the symbol.
 * @param symbol the symbol
 * @param out_size output size
 * @param out_str_array pointer to hold the output string array
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolListOutputs(SymbolHandle symbol,
                                  @Cast("uint32_t*") IntPointer out_size,
                                  @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int MXSymbolListOutputs(SymbolHandle symbol,
                                  @Cast("uint32_t*") IntBuffer out_size,
                                  @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int MXSymbolListOutputs(SymbolHandle symbol,
                                  @Cast("uint32_t*") int[] out_size,
                                  @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);

/**
 * \brief Get number of outputs of the symbol.
 * @param symbol The symbol
 * @param out_size number of outputs
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetNumOutputs(SymbolHandle symbol,
                                    @Cast("uint32_t*") IntPointer output_count);
public static native int MXSymbolGetNumOutputs(SymbolHandle symbol,
                                    @Cast("uint32_t*") IntBuffer output_count);
public static native int MXSymbolGetNumOutputs(SymbolHandle symbol,
                                    @Cast("uint32_t*") int[] output_count);

/**
 * \brief Get a symbol that contains all the internals.
 * @param symbol The symbol
 * @param out The output symbol whose outputs are all the internals.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetInternals(SymbolHandle symbol,
                                   PointerPointer out);
public static native int MXSymbolGetInternals(SymbolHandle symbol,
                                   @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Get a symbol that contains only direct children.
 * @param symbol The symbol
 * @param out The output symbol whose outputs are the direct children.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetChildren(SymbolHandle symbol,
                                  PointerPointer out);
public static native int MXSymbolGetChildren(SymbolHandle symbol,
                                  @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Get index-th outputs of the symbol.
 * @param symbol The symbol
 * @param index the Index of the output.
 * @param out The output symbol whose outputs are the index-th symbol.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGetOutput(SymbolHandle symbol,
                                @Cast("uint32_t") int index,
                                PointerPointer out);
public static native int MXSymbolGetOutput(SymbolHandle symbol,
                                @Cast("uint32_t") int index,
                                @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);

/**
 * \brief List auxiliary states in the symbol.
 * @param symbol the symbol
 * @param out_size output size
 * @param out_str_array pointer to hold the output string array
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolListAuxiliaryStates(SymbolHandle symbol,
                                          @Cast("uint32_t*") IntPointer out_size,
                                          @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int MXSymbolListAuxiliaryStates(SymbolHandle symbol,
                                          @Cast("uint32_t*") IntBuffer out_size,
                                          @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int MXSymbolListAuxiliaryStates(SymbolHandle symbol,
                                          @Cast("uint32_t*") int[] out_size,
                                          @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);

/**
 * \brief Compose the symbol on other symbols.
 *
 *  This function will change the sym hanlde.
 *  To achieve function apply behavior, copy the symbol first
 *  before apply.
 *
 * @param sym the symbol to apply
 * @param name the name of symbol
 * @param num_args number of arguments
 * @param keys the key of keyword args (optional)
 * @param args arguments to sym
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolCompose(SymbolHandle sym,
                              @Cast("const char*") BytePointer name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") PointerPointer keys,
                              PointerPointer args);
public static native int MXSymbolCompose(SymbolHandle sym,
                              @Cast("const char*") BytePointer name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              PointerPointer args);
public static native int MXSymbolCompose(SymbolHandle sym,
                              String name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle args);
public static native int MXSymbolCompose(SymbolHandle sym,
                              @Cast("const char*") BytePointer name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              PointerPointer args);
public static native int MXSymbolCompose(SymbolHandle sym,
                              String name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle args);
public static native int MXSymbolCompose(SymbolHandle sym,
                              @Cast("const char*") BytePointer name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              PointerPointer args);
public static native int MXSymbolCompose(SymbolHandle sym,
                              String name,
                              @Cast("uint32_t") int num_args,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle args);
/**
 * \brief Get the gradient graph of the symbol
 *
 * @param sym the symbol to get gradient
 * @param num_wrt number of arguments to get gradient
 * @param wrt the name of the arguments to get gradient
 * @param out the returned symbol that has gradient
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") PointerPointer wrt,
                           PointerPointer out);
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") @ByPtrPtr BytePointer wrt,
                           PointerPointer out);
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") @ByPtrPtr ByteBuffer wrt,
                           @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") @ByPtrPtr byte[] wrt,
                           PointerPointer out);
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") @ByPtrPtr BytePointer wrt,
                           @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") @ByPtrPtr ByteBuffer wrt,
                           PointerPointer out);
public static native int MXSymbolGrad(SymbolHandle sym,
                           @Cast("uint32_t") int num_wrt,
                           @Cast("const char**") @ByPtrPtr byte[] wrt,
                           @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief DEPRECATED. Use MXSymbolInferShapeEx instead.
 * infer shape of unknown input shapes given the known one.
 *  The shapes are packed into a CSR matrix represented by arg_ind_ptr and arg_shape_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *
 * @param sym symbol handle
 * @param num_args numbe of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_ind_ptr the head pointer of the rows in CSR
 * @param arg_shape_data the content of the CSR
 * @param in_shape_size sizeof the returning array of in_shapes
 * @param in_shape_ndim returning array of shape dimensions of each input shape.
 * @param in_shape_data returning array of pointers to head of the input shape.
 * @param out_shape_size sizeof the returning array of out_shapes
 * @param out_shape_ndim returning array of shape dimensions of each output shape.
 * @param out_shape_data returning array of pointers to head of the output shape.
 * @param aux_shape_size sizeof the returning array of aux_shapes
 * @param aux_shape_ndim returning array of shape dimensions of each auxiliary shape.
 * @param aux_shape_data returning array of pointers to head of the auxiliary shape.
 * @param complete whether infer shape completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferShape(SymbolHandle sym,
                                 @Cast("uint32_t") int num_args,
                                 @Cast("const char**") PointerPointer keys,
                                 @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                 @Cast("const uint32_t*") IntPointer arg_shape_data,
                                 @Cast("uint32_t*") IntPointer in_shape_size,
                                 @Cast("const uint32_t**") PointerPointer in_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                 @Cast("uint32_t*") IntPointer out_shape_size,
                                 @Cast("const uint32_t**") PointerPointer out_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                 @Cast("uint32_t*") IntPointer aux_shape_size,
                                 @Cast("const uint32_t**") PointerPointer aux_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                 IntPointer complete);
public static native int MXSymbolInferShape(SymbolHandle sym,
                                 @Cast("uint32_t") int num_args,
                                 @Cast("const char**") @ByPtrPtr BytePointer keys,
                                 @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                 @Cast("const uint32_t*") IntPointer arg_shape_data,
                                 @Cast("uint32_t*") IntPointer in_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr IntPointer in_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                 @Cast("uint32_t*") IntPointer out_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr IntPointer out_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                 @Cast("uint32_t*") IntPointer aux_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr IntPointer aux_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                 IntPointer complete);
public static native int MXSymbolInferShape(SymbolHandle sym,
                                 @Cast("uint32_t") int num_args,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                 @Cast("const uint32_t*") IntBuffer arg_ind_ptr,
                                 @Cast("const uint32_t*") IntBuffer arg_shape_data,
                                 @Cast("uint32_t*") IntBuffer in_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr IntBuffer in_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                 @Cast("uint32_t*") IntBuffer out_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr IntBuffer out_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                 @Cast("uint32_t*") IntBuffer aux_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr IntBuffer aux_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                 IntBuffer complete);
public static native int MXSymbolInferShape(SymbolHandle sym,
                                 @Cast("uint32_t") int num_args,
                                 @Cast("const char**") @ByPtrPtr byte[] keys,
                                 @Cast("const uint32_t*") int[] arg_ind_ptr,
                                 @Cast("const uint32_t*") int[] arg_shape_data,
                                 @Cast("uint32_t*") int[] in_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr int[] in_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                 @Cast("uint32_t*") int[] out_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr int[] out_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                 @Cast("uint32_t*") int[] aux_shape_size,
                                 @Cast("const uint32_t**") @ByPtrPtr int[] aux_shape_ndim,
                                 @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                 int[] complete);

/**
 * \brief infer shape of unknown input shapes given the known one.
 *  The shapes are packed into a CSR matrix represented by arg_ind_ptr and arg_shape_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 * @param sym symbol handle
 * @param num_args number of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_ind_ptr the head pointer of the rows in CSR
 * @param arg_shape_data the content of the CSR
 * @param in_shape_size sizeof the returning array of in_shapes
 * @param in_shape_ndim returning array of shape dimensions of eachs input shape.
 * @param in_shape_data returning array of pointers to head of the input shape.
 * @param out_shape_size sizeof the returning array of out_shapes
 * @param out_shape_ndim returning array of shape dimensions of each output shape.
 * @param out_shape_data returning array of pointers to head of the output shape.
 * @param aux_shape_size sizeof the returning array of aux_shapes
 * @param aux_shape_ndim returning array of shape dimensions of each auxiliary shape.
 * @param aux_shape_data returning array of pointers to head of the auxiliary shape.
 * @param complete whether infer shape completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferShapeEx(SymbolHandle sym,
                                   @Cast("uint32_t") int num_args,
                                   @Cast("const char**") PointerPointer keys,
                                   @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                   @Const IntPointer arg_shape_data,
                                   @Cast("uint32_t*") IntPointer in_shape_size,
                                   @Cast("const int**") PointerPointer in_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                   @Cast("uint32_t*") IntPointer out_shape_size,
                                   @Cast("const int**") PointerPointer out_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                   @Cast("uint32_t*") IntPointer aux_shape_size,
                                   @Cast("const int**") PointerPointer aux_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                   IntPointer complete);
public static native int MXSymbolInferShapeEx(SymbolHandle sym,
                                   @Cast("uint32_t") int num_args,
                                   @Cast("const char**") @ByPtrPtr BytePointer keys,
                                   @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                   @Const IntPointer arg_shape_data,
                                   @Cast("uint32_t*") IntPointer in_shape_size,
                                   @Const @ByPtrPtr IntPointer in_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                   @Cast("uint32_t*") IntPointer out_shape_size,
                                   @Const @ByPtrPtr IntPointer out_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                   @Cast("uint32_t*") IntPointer aux_shape_size,
                                   @Const @ByPtrPtr IntPointer aux_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                   IntPointer complete);
public static native int MXSymbolInferShapeEx(SymbolHandle sym,
                                   @Cast("uint32_t") int num_args,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                   @Cast("const uint32_t*") IntBuffer arg_ind_ptr,
                                   @Const IntBuffer arg_shape_data,
                                   @Cast("uint32_t*") IntBuffer in_shape_size,
                                   @Const @ByPtrPtr IntBuffer in_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                   @Cast("uint32_t*") IntBuffer out_shape_size,
                                   @Const @ByPtrPtr IntBuffer out_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                   @Cast("uint32_t*") IntBuffer aux_shape_size,
                                   @Const @ByPtrPtr IntBuffer aux_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                   IntBuffer complete);
public static native int MXSymbolInferShapeEx(SymbolHandle sym,
                                   @Cast("uint32_t") int num_args,
                                   @Cast("const char**") @ByPtrPtr byte[] keys,
                                   @Cast("const uint32_t*") int[] arg_ind_ptr,
                                   @Const int[] arg_shape_data,
                                   @Cast("uint32_t*") int[] in_shape_size,
                                   @Const @ByPtrPtr int[] in_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                   @Cast("uint32_t*") int[] out_shape_size,
                                   @Const @ByPtrPtr int[] out_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                   @Cast("uint32_t*") int[] aux_shape_size,
                                   @Const @ByPtrPtr int[] aux_shape_ndim,
                                   @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                   int[] complete);

/**
 * \brief infer shape of unknown input shapes given the known one.
 *  The shapes are packed into a CSR matrix represented by arg_ind_ptr and arg_shape_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 * @param sym symbol handle
 * @param num_args number of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_ind_ptr the head pointer of the rows in CSR
 * @param arg_shape_data the content of the CSR
 * @param in_shape_size sizeof the returning array of in_shapes
 * @param in_shape_ndim returning array of shape dimensions of each input shape.
 * @param in_shape_data returning array of pointers to head of the input shape.
 * @param out_shape_size sizeof the returning array of out_shapes
 * @param out_shape_ndim returning array of shape dimensions of each output shape.
 * @param out_shape_data returning array of pointers to head of the output shape.
 * @param aux_shape_size sizeof the returning array of aux_shapes
 * @param aux_shape_ndim returning array of shape dimensions of each auxiliary shape.
 * @param aux_shape_data returning array of pointers to head of the auxiliary shape.
 * @param complete whether infer shape completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferShapeEx64(SymbolHandle sym,
                                     @Cast("uint32_t") int num_args,
                                     @Cast("const char**") PointerPointer keys,
                                     @Cast("const int64_t*") LongPointer arg_ind_ptr,
                                     @Cast("const int64_t*") LongPointer arg_shape_data,
                                     @Cast("size_t*") SizeTPointer in_shape_size,
                                     @Cast("const int**") PointerPointer in_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                     @Cast("size_t*") SizeTPointer out_shape_size,
                                     @Cast("const int**") PointerPointer out_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                     @Cast("size_t*") SizeTPointer aux_shape_size,
                                     @Cast("const int**") PointerPointer aux_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                     IntPointer complete);
public static native int MXSymbolInferShapeEx64(SymbolHandle sym,
                                     @Cast("uint32_t") int num_args,
                                     @Cast("const char**") @ByPtrPtr BytePointer keys,
                                     @Cast("const int64_t*") LongPointer arg_ind_ptr,
                                     @Cast("const int64_t*") LongPointer arg_shape_data,
                                     @Cast("size_t*") SizeTPointer in_shape_size,
                                     @Const @ByPtrPtr IntPointer in_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                     @Cast("size_t*") SizeTPointer out_shape_size,
                                     @Const @ByPtrPtr IntPointer out_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                     @Cast("size_t*") SizeTPointer aux_shape_size,
                                     @Const @ByPtrPtr IntPointer aux_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                     IntPointer complete);
public static native int MXSymbolInferShapeEx64(SymbolHandle sym,
                                     @Cast("uint32_t") int num_args,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                     @Cast("const int64_t*") LongBuffer arg_ind_ptr,
                                     @Cast("const int64_t*") LongBuffer arg_shape_data,
                                     @Cast("size_t*") SizeTPointer in_shape_size,
                                     @Const @ByPtrPtr IntBuffer in_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                     @Cast("size_t*") SizeTPointer out_shape_size,
                                     @Const @ByPtrPtr IntBuffer out_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                     @Cast("size_t*") SizeTPointer aux_shape_size,
                                     @Const @ByPtrPtr IntBuffer aux_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                     IntBuffer complete);
public static native int MXSymbolInferShapeEx64(SymbolHandle sym,
                                     @Cast("uint32_t") int num_args,
                                     @Cast("const char**") @ByPtrPtr byte[] keys,
                                     @Cast("const int64_t*") long[] arg_ind_ptr,
                                     @Cast("const int64_t*") long[] arg_shape_data,
                                     @Cast("size_t*") SizeTPointer in_shape_size,
                                     @Const @ByPtrPtr int[] in_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                     @Cast("size_t*") SizeTPointer out_shape_size,
                                     @Const @ByPtrPtr int[] out_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                     @Cast("size_t*") SizeTPointer aux_shape_size,
                                     @Const @ByPtrPtr int[] aux_shape_ndim,
                                     @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                     int[] complete);

/**
 * \brief DEPRECATED. Use MXSymbolInferShapePartialEx instead.
 * partially infer shape of unknown input shapes given the known one.
 *
 *  Return partially inferred results if not all shapes could be inferred.
 *  The shapes are packed into a CSR matrix represented by arg_ind_ptr and arg_shape_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *
 * @param sym symbol handle
 * @param num_args numbe of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_ind_ptr the head pointer of the rows in CSR
 * @param arg_shape_data the content of the CSR
 * @param in_shape_size sizeof the returning array of in_shapes
 * @param in_shape_ndim returning array of shape dimensions of each input shape.
 * @param in_shape_data returning array of pointers to head of the input shape.
 * @param out_shape_size sizeof the returning array of out_shapes
 * @param out_shape_ndim returning array of shape dimensions of each output shape.
 * @param out_shape_data returning array of pointers to head of the output shape.
 * @param aux_shape_size sizeof the returning array of aux_shapes
 * @param aux_shape_ndim returning array of shape dimensions of each auxiliary shape.
 * @param aux_shape_data returning array of pointers to head of the auxiliary shape.
 * @param complete whether infer shape completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferShapePartial(SymbolHandle sym,
                                        @Cast("uint32_t") int num_args,
                                        @Cast("const char**") PointerPointer keys,
                                        @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                        @Cast("const uint32_t*") IntPointer arg_shape_data,
                                        @Cast("uint32_t*") IntPointer in_shape_size,
                                        @Cast("const uint32_t**") PointerPointer in_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                        @Cast("uint32_t*") IntPointer out_shape_size,
                                        @Cast("const uint32_t**") PointerPointer out_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                        @Cast("uint32_t*") IntPointer aux_shape_size,
                                        @Cast("const uint32_t**") PointerPointer aux_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                        IntPointer complete);
public static native int MXSymbolInferShapePartial(SymbolHandle sym,
                                        @Cast("uint32_t") int num_args,
                                        @Cast("const char**") @ByPtrPtr BytePointer keys,
                                        @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                        @Cast("const uint32_t*") IntPointer arg_shape_data,
                                        @Cast("uint32_t*") IntPointer in_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr IntPointer in_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                        @Cast("uint32_t*") IntPointer out_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr IntPointer out_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                        @Cast("uint32_t*") IntPointer aux_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr IntPointer aux_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                        IntPointer complete);
public static native int MXSymbolInferShapePartial(SymbolHandle sym,
                                        @Cast("uint32_t") int num_args,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                        @Cast("const uint32_t*") IntBuffer arg_ind_ptr,
                                        @Cast("const uint32_t*") IntBuffer arg_shape_data,
                                        @Cast("uint32_t*") IntBuffer in_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr IntBuffer in_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                        @Cast("uint32_t*") IntBuffer out_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr IntBuffer out_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                        @Cast("uint32_t*") IntBuffer aux_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr IntBuffer aux_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                        IntBuffer complete);
public static native int MXSymbolInferShapePartial(SymbolHandle sym,
                                        @Cast("uint32_t") int num_args,
                                        @Cast("const char**") @ByPtrPtr byte[] keys,
                                        @Cast("const uint32_t*") int[] arg_ind_ptr,
                                        @Cast("const uint32_t*") int[] arg_shape_data,
                                        @Cast("uint32_t*") int[] in_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr int[] in_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer in_shape_data,
                                        @Cast("uint32_t*") int[] out_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr int[] out_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer out_shape_data,
                                        @Cast("uint32_t*") int[] aux_shape_size,
                                        @Cast("const uint32_t**") @ByPtrPtr int[] aux_shape_ndim,
                                        @Cast("const uint32_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                        int[] complete);

/**
 * \brief partially infer shape of unknown input shapes given the known one.
 *
 *  Return partially inferred results if not all shapes could be inferred.
 *  The shapes are packed into a CSR matrix represented by arg_ind_ptr and arg_shape_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=0 (by default)
 *
 * @param sym symbol handle
 * @param num_args number of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_ind_ptr the head pointer of the rows in CSR
 * @param arg_shape_data the content of the CSR
 * @param in_shape_size sizeof the returning array of in_shapes
 * @param in_shape_ndim returning array of shape dimensions of each input shape.
 * @param in_shape_data returning array of pointers to head of the input shape.
 * @param out_shape_size sizeof the returning array of out_shapes
 * @param out_shape_ndim returning array of shape dimensions of each output shape.
 * @param out_shape_data returning array of pointers to head of the output shape.
 * @param aux_shape_size sizeof the returning array of aux_shapes
 * @param aux_shape_ndim returning array of shape dimensions of each auxiliary shape.
 * @param aux_shape_data returning array of pointers to head of the auxiliary shape.
 * @param complete whether infer shape completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferShapePartialEx(SymbolHandle sym,
                                          @Cast("uint32_t") int num_args,
                                          @Cast("const char**") PointerPointer keys,
                                          @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                          @Const IntPointer arg_shape_data,
                                          @Cast("uint32_t*") IntPointer in_shape_size,
                                          @Cast("const int**") PointerPointer in_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                          @Cast("uint32_t*") IntPointer out_shape_size,
                                          @Cast("const int**") PointerPointer out_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                          @Cast("uint32_t*") IntPointer aux_shape_size,
                                          @Cast("const int**") PointerPointer aux_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                          IntPointer complete);
public static native int MXSymbolInferShapePartialEx(SymbolHandle sym,
                                          @Cast("uint32_t") int num_args,
                                          @Cast("const char**") @ByPtrPtr BytePointer keys,
                                          @Cast("const uint32_t*") IntPointer arg_ind_ptr,
                                          @Const IntPointer arg_shape_data,
                                          @Cast("uint32_t*") IntPointer in_shape_size,
                                          @Const @ByPtrPtr IntPointer in_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                          @Cast("uint32_t*") IntPointer out_shape_size,
                                          @Const @ByPtrPtr IntPointer out_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                          @Cast("uint32_t*") IntPointer aux_shape_size,
                                          @Const @ByPtrPtr IntPointer aux_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                          IntPointer complete);
public static native int MXSymbolInferShapePartialEx(SymbolHandle sym,
                                          @Cast("uint32_t") int num_args,
                                          @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                          @Cast("const uint32_t*") IntBuffer arg_ind_ptr,
                                          @Const IntBuffer arg_shape_data,
                                          @Cast("uint32_t*") IntBuffer in_shape_size,
                                          @Const @ByPtrPtr IntBuffer in_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                          @Cast("uint32_t*") IntBuffer out_shape_size,
                                          @Const @ByPtrPtr IntBuffer out_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                          @Cast("uint32_t*") IntBuffer aux_shape_size,
                                          @Const @ByPtrPtr IntBuffer aux_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                          IntBuffer complete);
public static native int MXSymbolInferShapePartialEx(SymbolHandle sym,
                                          @Cast("uint32_t") int num_args,
                                          @Cast("const char**") @ByPtrPtr byte[] keys,
                                          @Cast("const uint32_t*") int[] arg_ind_ptr,
                                          @Const int[] arg_shape_data,
                                          @Cast("uint32_t*") int[] in_shape_size,
                                          @Const @ByPtrPtr int[] in_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer in_shape_data,
                                          @Cast("uint32_t*") int[] out_shape_size,
                                          @Const @ByPtrPtr int[] out_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer out_shape_data,
                                          @Cast("uint32_t*") int[] aux_shape_size,
                                          @Const @ByPtrPtr int[] aux_shape_ndim,
                                          @Cast("const int***") @ByPtrPtr PointerPointer aux_shape_data,
                                          int[] complete);

/**
 * \brief partially infer shape of unknown input shapes given the known one.
 *
 *  Return partially inferred results if not all shapes could be inferred.
 *  The shapes are packed into a CSR matrix represented by arg_ind_ptr and arg_shape_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *  This api is available when MXNet is built with flag
 *  USE_INT64_TENSOR_SIZE=1 (not default) i.e. Large Tensor Support
 *
 * @param sym symbol handle
 * @param num_args number of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_ind_ptr the head pointer of the rows in CSR
 * @param arg_shape_data the content of the CSR
 * @param in_shape_size sizeof the returning array of in_shapes
 * @param in_shape_ndim returning array of shape dimensions of each input shape.
 * @param in_shape_data returning array of pointers to head of the input shape.
 * @param out_shape_size sizeof the returning array of out_shapes
 * @param out_shape_ndim returning array of shape dimensions of each output shape.
 * @param out_shape_data returning array of pointers to head of the output shape.
 * @param aux_shape_size sizeof the returning array of aux_shapes
 * @param aux_shape_ndim returning array of shape dimensions of each auxiliary shape.
 * @param aux_shape_data returning array of pointers to head of the auxiliary shape.
 * @param complete whether infer shape completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferShapePartialEx64(SymbolHandle sym,
                                            @Cast("uint32_t") int num_args,
                                            @Cast("const char**") PointerPointer keys,
                                            @Cast("const int64_t*") LongPointer arg_ind_ptr,
                                            @Cast("const int64_t*") LongPointer arg_shape_data,
                                            @Cast("size_t*") SizeTPointer in_shape_size,
                                            @Cast("const int**") PointerPointer in_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                            @Cast("size_t*") SizeTPointer out_shape_size,
                                            @Cast("const int**") PointerPointer out_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                            @Cast("size_t*") SizeTPointer aux_shape_size,
                                            @Cast("const int**") PointerPointer aux_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                            IntPointer complete);
public static native int MXSymbolInferShapePartialEx64(SymbolHandle sym,
                                            @Cast("uint32_t") int num_args,
                                            @Cast("const char**") @ByPtrPtr BytePointer keys,
                                            @Cast("const int64_t*") LongPointer arg_ind_ptr,
                                            @Cast("const int64_t*") LongPointer arg_shape_data,
                                            @Cast("size_t*") SizeTPointer in_shape_size,
                                            @Const @ByPtrPtr IntPointer in_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                            @Cast("size_t*") SizeTPointer out_shape_size,
                                            @Const @ByPtrPtr IntPointer out_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                            @Cast("size_t*") SizeTPointer aux_shape_size,
                                            @Const @ByPtrPtr IntPointer aux_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                            IntPointer complete);
public static native int MXSymbolInferShapePartialEx64(SymbolHandle sym,
                                            @Cast("uint32_t") int num_args,
                                            @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                            @Cast("const int64_t*") LongBuffer arg_ind_ptr,
                                            @Cast("const int64_t*") LongBuffer arg_shape_data,
                                            @Cast("size_t*") SizeTPointer in_shape_size,
                                            @Const @ByPtrPtr IntBuffer in_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                            @Cast("size_t*") SizeTPointer out_shape_size,
                                            @Const @ByPtrPtr IntBuffer out_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                            @Cast("size_t*") SizeTPointer aux_shape_size,
                                            @Const @ByPtrPtr IntBuffer aux_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                            IntBuffer complete);
public static native int MXSymbolInferShapePartialEx64(SymbolHandle sym,
                                            @Cast("uint32_t") int num_args,
                                            @Cast("const char**") @ByPtrPtr byte[] keys,
                                            @Cast("const int64_t*") long[] arg_ind_ptr,
                                            @Cast("const int64_t*") long[] arg_shape_data,
                                            @Cast("size_t*") SizeTPointer in_shape_size,
                                            @Const @ByPtrPtr int[] in_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer in_shape_data,
                                            @Cast("size_t*") SizeTPointer out_shape_size,
                                            @Const @ByPtrPtr int[] out_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer out_shape_data,
                                            @Cast("size_t*") SizeTPointer aux_shape_size,
                                            @Const @ByPtrPtr int[] aux_shape_ndim,
                                            @Cast("const int64_t***") @ByPtrPtr PointerPointer aux_shape_data,
                                            int[] complete);

/**
 * \brief infer type of unknown input types given the known one.
 *  The types are packed into a CSR matrix represented by arg_ind_ptr and arg_type_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *
 * @param sym symbol handle
 * @param num_args numbe of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_type_data the content of the CSR
 * @param in_type_size sizeof the returning array of in_types
 * @param in_type_data returning array of pointers to head of the input type.
 * @param out_type_size sizeof the returning array of out_types
 * @param out_type_data returning array of pointers to head of the output type.
 * @param aux_type_size sizeof the returning array of aux_types
 * @param aux_type_data returning array of pointers to head of the auxiliary type.
 * @param complete whether infer type completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferType(SymbolHandle sym,
                                @Cast("uint32_t") int num_args,
                                @Cast("const char**") PointerPointer keys,
                                @Const IntPointer arg_type_data,
                                @Cast("uint32_t*") IntPointer in_type_size,
                                @Cast("const int**") PointerPointer in_type_data,
                                @Cast("uint32_t*") IntPointer out_type_size,
                                @Cast("const int**") PointerPointer out_type_data,
                                @Cast("uint32_t*") IntPointer aux_type_size,
                                @Cast("const int**") PointerPointer aux_type_data,
                                IntPointer complete);
public static native int MXSymbolInferType(SymbolHandle sym,
                                @Cast("uint32_t") int num_args,
                                @Cast("const char**") @ByPtrPtr BytePointer keys,
                                @Const IntPointer arg_type_data,
                                @Cast("uint32_t*") IntPointer in_type_size,
                                @Const @ByPtrPtr IntPointer in_type_data,
                                @Cast("uint32_t*") IntPointer out_type_size,
                                @Const @ByPtrPtr IntPointer out_type_data,
                                @Cast("uint32_t*") IntPointer aux_type_size,
                                @Const @ByPtrPtr IntPointer aux_type_data,
                                IntPointer complete);
public static native int MXSymbolInferType(SymbolHandle sym,
                                @Cast("uint32_t") int num_args,
                                @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                @Const IntBuffer arg_type_data,
                                @Cast("uint32_t*") IntBuffer in_type_size,
                                @Const @ByPtrPtr IntBuffer in_type_data,
                                @Cast("uint32_t*") IntBuffer out_type_size,
                                @Const @ByPtrPtr IntBuffer out_type_data,
                                @Cast("uint32_t*") IntBuffer aux_type_size,
                                @Const @ByPtrPtr IntBuffer aux_type_data,
                                IntBuffer complete);
public static native int MXSymbolInferType(SymbolHandle sym,
                                @Cast("uint32_t") int num_args,
                                @Cast("const char**") @ByPtrPtr byte[] keys,
                                @Const int[] arg_type_data,
                                @Cast("uint32_t*") int[] in_type_size,
                                @Const @ByPtrPtr int[] in_type_data,
                                @Cast("uint32_t*") int[] out_type_size,
                                @Const @ByPtrPtr int[] out_type_data,
                                @Cast("uint32_t*") int[] aux_type_size,
                                @Const @ByPtrPtr int[] aux_type_data,
                                int[] complete);

/**
 * \brief partially infer type of unknown input types given the known one.
 *
 *  Return partially inferred results if not all types could be inferred.
 *  The types are packed into a CSR matrix represented by arg_ind_ptr and arg_type_data
 *  The call will be treated as a kwargs call if key != NULL or num_args==0, otherwise it is positional.
 *
 * @param sym symbol handle
 * @param num_args numbe of input arguments.
 * @param keys the key of keyword args (optional)
 * @param arg_type_data the content of the CSR
 * @param in_type_size sizeof the returning array of in_types
 * @param in_type_data returning array of pointers to head of the input type.
 * @param out_type_size sizeof the returning array of out_types
 * @param out_type_data returning array of pointers to head of the output type.
 * @param aux_type_size sizeof the returning array of aux_types
 * @param aux_type_data returning array of pointers to head of the auxiliary type.
 * @param complete whether infer type completes or more information is needed.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXSymbolInferTypePartial(SymbolHandle sym,
                                       @Cast("uint32_t") int num_args,
                                       @Cast("const char**") PointerPointer keys,
                                       @Const IntPointer arg_type_data,
                                       @Cast("uint32_t*") IntPointer in_type_size,
                                       @Cast("const int**") PointerPointer in_type_data,
                                       @Cast("uint32_t*") IntPointer out_type_size,
                                       @Cast("const int**") PointerPointer out_type_data,
                                       @Cast("uint32_t*") IntPointer aux_type_size,
                                       @Cast("const int**") PointerPointer aux_type_data,
                                       IntPointer complete);
public static native int MXSymbolInferTypePartial(SymbolHandle sym,
                                       @Cast("uint32_t") int num_args,
                                       @Cast("const char**") @ByPtrPtr BytePointer keys,
                                       @Const IntPointer arg_type_data,
                                       @Cast("uint32_t*") IntPointer in_type_size,
                                       @Const @ByPtrPtr IntPointer in_type_data,
                                       @Cast("uint32_t*") IntPointer out_type_size,
                                       @Const @ByPtrPtr IntPointer out_type_data,
                                       @Cast("uint32_t*") IntPointer aux_type_size,
                                       @Const @ByPtrPtr IntPointer aux_type_data,
                                       IntPointer complete);
public static native int MXSymbolInferTypePartial(SymbolHandle sym,
                                       @Cast("uint32_t") int num_args,
                                       @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                       @Const IntBuffer arg_type_data,
                                       @Cast("uint32_t*") IntBuffer in_type_size,
                                       @Const @ByPtrPtr IntBuffer in_type_data,
                                       @Cast("uint32_t*") IntBuffer out_type_size,
                                       @Const @ByPtrPtr IntBuffer out_type_data,
                                       @Cast("uint32_t*") IntBuffer aux_type_size,
                                       @Const @ByPtrPtr IntBuffer aux_type_data,
                                       IntBuffer complete);
public static native int MXSymbolInferTypePartial(SymbolHandle sym,
                                       @Cast("uint32_t") int num_args,
                                       @Cast("const char**") @ByPtrPtr byte[] keys,
                                       @Const int[] arg_type_data,
                                       @Cast("uint32_t*") int[] in_type_size,
                                       @Const @ByPtrPtr int[] in_type_data,
                                       @Cast("uint32_t*") int[] out_type_size,
                                       @Const @ByPtrPtr int[] out_type_data,
                                       @Cast("uint32_t*") int[] aux_type_size,
                                       @Const @ByPtrPtr int[] aux_type_data,
                                       int[] complete);

/**
 * \brief Convert a symbol into a quantized symbol where FP32 operators are replaced with INT8
 * @param sym_handle symbol to be converted
 * @param ret_sym_handle quantized symbol result
 * @param dev_type device type
 * @param num_excluded_sym_names number of layers excluded from being quantized in the input symbol
 * @param excluded_sym_names node names to be excluded from being quantized
 * @param num_excluded_op_names number of operators excluded from being quantized in the input symbol
 * @param excluded_op_names operator names to be excluded from being quantized
 * @param num_offline number of parameters that are quantized offline
 * @param offline_params array of c strings representing the names of params quantized offline
 * @param quantized_dtype the quantized destination type for input data
 * @param calib_quantize **Deprecated**. quantize op will always be calibrated if could
 * @param quantize_mode quantize mode to be used in quantize pass
 * @param quantize_granularity quantize granularity, tensor-wise or channel-wise
 * @param out_num_calib_names return the number of nodes to be calibrated
 * @param out_calib_names return the node names to be calibrated
 */
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               PointerPointer ret_sym_handle,
                               @Const IntPointer dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") PointerPointer excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") PointerPointer excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") PointerPointer offline_params,
                               @Cast("const char*") BytePointer quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               @Cast("const char*") BytePointer quantize_mode, @Cast("const char*") BytePointer quantize_granularity,
                               @Cast("uint32_t*") IntPointer out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               PointerPointer ret_sym_handle,
                               @Const IntPointer dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") @ByPtrPtr BytePointer excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") @ByPtrPtr BytePointer excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") @ByPtrPtr BytePointer offline_params,
                               @Cast("const char*") BytePointer quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               @Cast("const char*") BytePointer quantize_mode, @Cast("const char*") BytePointer quantize_granularity,
                               @Cast("uint32_t*") IntPointer out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                               @Const IntBuffer dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") @ByPtrPtr ByteBuffer excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") @ByPtrPtr ByteBuffer excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") @ByPtrPtr ByteBuffer offline_params,
                               String quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               String quantize_mode, String quantize_granularity,
                               @Cast("uint32_t*") IntBuffer out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               PointerPointer ret_sym_handle,
                               @Const int[] dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") @ByPtrPtr byte[] excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") @ByPtrPtr byte[] excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") @ByPtrPtr byte[] offline_params,
                               @Cast("const char*") BytePointer quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               @Cast("const char*") BytePointer quantize_mode, @Cast("const char*") BytePointer quantize_granularity,
                               @Cast("uint32_t*") int[] out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                               @Const IntPointer dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") @ByPtrPtr BytePointer excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") @ByPtrPtr BytePointer excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") @ByPtrPtr BytePointer offline_params,
                               String quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               String quantize_mode, String quantize_granularity,
                               @Cast("uint32_t*") IntPointer out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               PointerPointer ret_sym_handle,
                               @Const IntBuffer dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") @ByPtrPtr ByteBuffer excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") @ByPtrPtr ByteBuffer excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") @ByPtrPtr ByteBuffer offline_params,
                               @Cast("const char*") BytePointer quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               @Cast("const char*") BytePointer quantize_mode, @Cast("const char*") BytePointer quantize_granularity,
                               @Cast("uint32_t*") IntBuffer out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);
public static native int MXQuantizeSymbol(SymbolHandle sym_handle,
                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                               @Const int[] dev_type,
                               @Cast("const uint32_t") int num_excluded_sym_names,
                               @Cast("const char**") @ByPtrPtr byte[] excluded_sym_names,
                               @Cast("const uint32_t") int num_excluded_op_names,
                               @Cast("const char**") @ByPtrPtr byte[] excluded_op_names,
                               @Cast("const uint32_t") int num_offline, @Cast("const char**") @ByPtrPtr byte[] offline_params,
                               String quantized_dtype, @Cast("const bool") boolean calib_quantize,
                               String quantize_mode, String quantize_granularity,
                               @Cast("uint32_t*") int[] out_num_calib_names, @Cast("const char***") @ByPtrPtr PointerPointer out_calib_names);

/**
 * \brief Convert a symbol into a mixed precision symbol with cast operators for target dtype casting
 * @param sym_handle symbol to be converted
 * @param ret_sym_handle mixed precision symbol result
 * @param num_args number of arguments for known dtypes
 * @param arg_type_data arg types of the arguments
 * @param target_dtype target_dtype for mixed precision symbol
 * @param cast_optional_params whether to cast optional params to target_dtype
 * @param num_target_dtype_op_names number of ops to be casted to target_dtype
 * @param num_fp32_op_names number of ops to be casted to FP32
 * @param num_widest_dtype_op_names number of ops to be casted to widest dtype
 * @param num_conditional_fp32_op_names number of ops to be casted to FP32 based on a condition
 * @param num_excluded_symbols number of symbols to be excluded from casting
 * @param num_model_params number of model parameters
 * @param num_widest_dtype_op_names number of ops to be casted to the widest dtype
 * @param num_conditional_fp32_op_names number of ops to be cast to fp32 based on precision
 * @param target_dtype_op_names op names to be casted to target_dtype
 * @param fp32_op_names op names to be casted to fp32
 * @param widest_dtype_op_names names to be casted to widest dtype
 * @param conditional_fp32_op_names names to be casted to FP32 conditionally
 * @param excluded_symbols symbol names to be excluded from casting
 * @param param_names param names for conditional FP32 casting
 * @param param_values param values for conditional FP32 casting
 * @param arg_names argument names for which type information is provided
 * @param model_param_names names for model parameters
 */
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      PointerPointer ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const IntPointer arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const IntPointer ind_ptr,
                                      @Const IntPointer target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") PointerPointer target_dtype_op_names,
                                      @Cast("const char**") PointerPointer fp32_op_names,
                                      @Cast("const char**") PointerPointer widest_dtype_op_names,
                                      @Cast("const char**") PointerPointer conditional_fp32_op_names,
                                      @Cast("const char**") PointerPointer excluded_symbols,
                                      @Cast("const char**") PointerPointer conditional_param_names,
                                      @Cast("const char**") PointerPointer conditional_param_vals,
                                      @Cast("const char**") PointerPointer model_param_names,
                                      @Cast("const char**") PointerPointer arg_names);
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      PointerPointer ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const IntPointer arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const IntPointer ind_ptr,
                                      @Const IntPointer target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") @ByPtrPtr BytePointer target_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer widest_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer conditional_fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer excluded_symbols,
                                      @Cast("const char**") @ByPtrPtr BytePointer conditional_param_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer conditional_param_vals,
                                      @Cast("const char**") @ByPtrPtr BytePointer model_param_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer arg_names);
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const IntBuffer arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const IntBuffer ind_ptr,
                                      @Const IntBuffer target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer target_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer widest_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer conditional_fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer excluded_symbols,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer conditional_param_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer conditional_param_vals,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer model_param_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer arg_names);
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      PointerPointer ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const int[] arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const int[] ind_ptr,
                                      @Const int[] target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") @ByPtrPtr byte[] target_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] widest_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] conditional_fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] excluded_symbols,
                                      @Cast("const char**") @ByPtrPtr byte[] conditional_param_names,
                                      @Cast("const char**") @ByPtrPtr byte[] conditional_param_vals,
                                      @Cast("const char**") @ByPtrPtr byte[] model_param_names,
                                      @Cast("const char**") @ByPtrPtr byte[] arg_names);
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const IntPointer arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const IntPointer ind_ptr,
                                      @Const IntPointer target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") @ByPtrPtr BytePointer target_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer widest_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer conditional_fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer excluded_symbols,
                                      @Cast("const char**") @ByPtrPtr BytePointer conditional_param_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer conditional_param_vals,
                                      @Cast("const char**") @ByPtrPtr BytePointer model_param_names,
                                      @Cast("const char**") @ByPtrPtr BytePointer arg_names);
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      PointerPointer ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const IntBuffer arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const IntBuffer ind_ptr,
                                      @Const IntBuffer target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer target_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer widest_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer conditional_fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer excluded_symbols,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer conditional_param_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer conditional_param_vals,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer model_param_names,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer arg_names);
public static native int MXReducePrecisionSymbol(SymbolHandle sym_handle,
                                      @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                                      @Cast("uint32_t") int num_args,
                                      @Const int[] arg_type_data,
                                      @Cast("uint32_t") int num_ind_ptr,
                                      @Const int[] ind_ptr,
                                      @Const int[] target_dtype,
                                      int cast_optional_params,
                                      @Cast("const uint32_t") int num_target_dtype_op_names,
                                      @Cast("const uint32_t") int num_fp32_op_names,
                                      @Cast("const uint32_t") int num_widest_dtype_op_names,
                                      @Cast("const uint32_t") int num_conditional_fp32_op_names,
                                      @Cast("const uint32_t") int num_excluded_symbols,
                                      @Cast("const uint32_t") int num_model_params,
                                      @Cast("const char**") @ByPtrPtr byte[] target_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] widest_dtype_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] conditional_fp32_op_names,
                                      @Cast("const char**") @ByPtrPtr byte[] excluded_symbols,
                                      @Cast("const char**") @ByPtrPtr byte[] conditional_param_names,
                                      @Cast("const char**") @ByPtrPtr byte[] conditional_param_vals,
                                      @Cast("const char**") @ByPtrPtr byte[] model_param_names,
                                      @Cast("const char**") @ByPtrPtr byte[] arg_names);
/**
 * \brief Set calibration table to node attributes in the sym
 * @param sym_handle symbol whose node attributes are to be set by calibration table
 * @param num_layers number of layers in the calibration table
 * @param layer names stored as keys in the calibration table
 * @param low_quantiles low quantiles of layers stored in the calibration table
 * @param high_quantiles high quantiles of layers stored in the calibration table
 * @param ret_sym_handle returned symbol
 */
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") PointerPointer layer_names,
                                               @Const FloatPointer low_quantiles,
                                               @Const FloatPointer high_quantiles,
                                               PointerPointer ret_sym_handle);
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") @ByPtrPtr BytePointer layer_names,
                                               @Const FloatPointer low_quantiles,
                                               @Const FloatPointer high_quantiles,
                                               PointerPointer ret_sym_handle);
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") @ByPtrPtr ByteBuffer layer_names,
                                               @Const FloatBuffer low_quantiles,
                                               @Const FloatBuffer high_quantiles,
                                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle);
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") @ByPtrPtr byte[] layer_names,
                                               @Const float[] low_quantiles,
                                               @Const float[] high_quantiles,
                                               PointerPointer ret_sym_handle);
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") @ByPtrPtr BytePointer layer_names,
                                               @Const FloatPointer low_quantiles,
                                               @Const FloatPointer high_quantiles,
                                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle);
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") @ByPtrPtr ByteBuffer layer_names,
                                               @Const FloatBuffer low_quantiles,
                                               @Const FloatBuffer high_quantiles,
                                               PointerPointer ret_sym_handle);
public static native int MXSetCalibTableToQuantizedSymbol(SymbolHandle qsym_handle,
                                               @Cast("const uint32_t") int num_layers,
                                               @Cast("const char**") @ByPtrPtr byte[] layer_names,
                                               @Const float[] low_quantiles,
                                               @Const float[] high_quantiles,
                                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle);

/**
 * \brief Run subgraph pass based on the backend provided
 * @param sym_handle symbol to be converted
 * @param backend backend names for subgraph pass
 * @param ret_sym_handle returned symbol
 */
public static native int MXGenBackendSubgraph(SymbolHandle sym_handle, @Cast("const char*") BytePointer backend,
                                   PointerPointer ret_sym_handle);
public static native int MXGenBackendSubgraph(SymbolHandle sym_handle, String backend,
                                   @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle);

/**
 * \brief Generate atomic symbol (able to be composed) from a source symbol
 * @param sym_handle source symbol
 * @param ret_sym_handle returned atomic symbol
 */
public static native int MXGenAtomicSymbolFromSymbol(SymbolHandle sym_handle, PointerPointer ret_sym_handle);
public static native int MXGenAtomicSymbolFromSymbol(SymbolHandle sym_handle, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle);
/**
 * \brief Partitions symbol for given backend, potentially creating subgraphs
 * @param sym_handle symbol to be partitioned
 * @param dev_type context device type
 * @param backend_name backend name
 * @param ret_sym_handle partitioned symbol returned
 * @param len number of args
 * @param in_args_handle args array
 * @param num_options number of key value pairs
 * @param keys keys for options
 * @param vals values corresponding to keys
 * @param num_input_shapes number of input shapes
 * @param input_shape_names names of the input shapes
 * @param input_shape_data pointer to the contiguous data shapes
 * @param input_shape_idx array of per shape starting idx, the shape length for the i-th input shape
 * is calculate as input_shape_idx[i+1] - input_shape_idx[i]
 * @param num_input_dtypes number of input data types
 * @param input_dtype_names array of names of the input data types
 * @param input_dtypes array of values of the input data types
 * @param num_input_stypesnumber of input storage types
 * @param input_stype_names array of names of the input storage types
 * @param input_stypes array of values of input storage types
 * @param skip_infer if the optimization should skip the attribute inferences
 * (to use if the backend does not require shape inference)
 * @param new_args_cnt pointer a number to store the number of new args
 * @param new_args_handle pointer on array to store the new args handles
 * @param new_arg_names_handle pointer on array to store the new args names
 * @param new_aux_cnt pointer a number to store the number of new aux
 * @param new_aux_handle pointer on array to store the new aux handles
 * @param new_aux_names_handle pointer on array to store the new aux names
 */
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   @Cast("const char*") BytePointer backend_name,
                                   int dev_type,
                                   PointerPointer ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   PointerPointer in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   PointerPointer in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") PointerPointer keys,
                                   @Cast("const char**") PointerPointer vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") PointerPointer input_shape_names,
                                   @Cast("const int64_t*") LongPointer input_shape_data,
                                   @Cast("const uint32_t*") IntPointer input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") PointerPointer input_dtype_names,
                                   @Const IntPointer input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") PointerPointer input_stype_names,
                                   @Const IntPointer input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   IntPointer new_args_cnt,
                                   @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   IntPointer new_aux_cnt,
                                   @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   @Cast("const char*") BytePointer backend_name,
                                   int dev_type,
                                   PointerPointer ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   PointerPointer in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   PointerPointer in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") @ByPtrPtr BytePointer keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") @ByPtrPtr BytePointer input_shape_names,
                                   @Cast("const int64_t*") LongPointer input_shape_data,
                                   @Cast("const uint32_t*") IntPointer input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer input_dtype_names,
                                   @Const IntPointer input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer input_stype_names,
                                   @Const IntPointer input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   IntPointer new_args_cnt,
                                   @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   IntPointer new_aux_cnt,
                                   @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   String backend_name,
                                   int dev_type,
                                   @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer input_shape_names,
                                   @Cast("const int64_t*") LongBuffer input_shape_data,
                                   @Cast("const uint32_t*") IntBuffer input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer input_dtype_names,
                                   @Const IntBuffer input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer input_stype_names,
                                   @Const IntBuffer input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   IntBuffer new_args_cnt,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   IntBuffer new_aux_cnt,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   @Cast("const char*") BytePointer backend_name,
                                   int dev_type,
                                   PointerPointer ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   PointerPointer in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   PointerPointer in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") @ByPtrPtr byte[] keys,
                                   @Cast("const char**") @ByPtrPtr byte[] vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") @ByPtrPtr byte[] input_shape_names,
                                   @Cast("const int64_t*") long[] input_shape_data,
                                   @Cast("const uint32_t*") int[] input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") @ByPtrPtr byte[] input_dtype_names,
                                   @Const int[] input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") @ByPtrPtr byte[] input_stype_names,
                                   @Const int[] input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   int[] new_args_cnt,
                                   @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   int[] new_aux_cnt,
                                   @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   String backend_name,
                                   int dev_type,
                                   @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") @ByPtrPtr BytePointer keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") @ByPtrPtr BytePointer input_shape_names,
                                   @Cast("const int64_t*") LongPointer input_shape_data,
                                   @Cast("const uint32_t*") IntPointer input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer input_dtype_names,
                                   @Const IntPointer input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer input_stype_names,
                                   @Const IntPointer input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   IntPointer new_args_cnt,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   IntPointer new_aux_cnt,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   @Cast("const char*") BytePointer backend_name,
                                   int dev_type,
                                   PointerPointer ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   PointerPointer in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   PointerPointer in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer input_shape_names,
                                   @Cast("const int64_t*") LongBuffer input_shape_data,
                                   @Cast("const uint32_t*") IntBuffer input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer input_dtype_names,
                                   @Const IntBuffer input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer input_stype_names,
                                   @Const IntBuffer input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   IntBuffer new_args_cnt,
                                   @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   IntBuffer new_aux_cnt,
                                   @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);
public static native int MXOptimizeForBackend(SymbolHandle sym_handle,
                                   String backend_name,
                                   int dev_type,
                                   @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle ret_sym_handle,
                                   @Cast("const mx_uint") int args_len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args_handle,
                                   @Cast("const mx_uint") int aux_len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_aux_handle,
                                   @Cast("const mx_uint") int num_options,
                                   @Cast("const char**") @ByPtrPtr byte[] keys,
                                   @Cast("const char**") @ByPtrPtr byte[] vals,
                                   @Cast("const uint32_t") int num_input_shapes,
                                   @Cast("const char**") @ByPtrPtr byte[] input_shape_names,
                                   @Cast("const int64_t*") long[] input_shape_data,
                                   @Cast("const uint32_t*") int[] input_shape_idx,
                                   @Cast("const uint32_t") int num_input_dtypes,
                                   @Cast("const char**") @ByPtrPtr byte[] input_dtype_names,
                                   @Const int[] input_dtypes,
                                   @Cast("const uint32_t") int num_input_stypes,
                                   @Cast("const char**") @ByPtrPtr byte[] input_stype_names,
                                   @Const int[] input_stypes,
                                   @Cast("bool") boolean skip_infer,
                                   int[] new_args_cnt,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer new_args_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_arg_names_handle,
                                   int[] new_aux_cnt,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer new_aux_handle,
                                   @Cast("char***") @ByPtrPtr PointerPointer new_aux_names_handle);


//--------------------------------------------
// Part 4: Executor interface
//--------------------------------------------
/**
 * \brief Delete the executor
 * @param handle the executor.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorFree(ExecutorHandle handle);
/**
 * \brief Print the content of execution plan, used for debug.
 * @param handle the executor.
 * @param out_str pointer to hold the output string of the printing.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorPrint(ExecutorHandle handle, @Cast("const char**") PointerPointer out_str);
public static native int MXExecutorPrint(ExecutorHandle handle, @Cast("const char**") @ByPtrPtr BytePointer out_str);
public static native int MXExecutorPrint(ExecutorHandle handle, @Cast("const char**") @ByPtrPtr ByteBuffer out_str);
public static native int MXExecutorPrint(ExecutorHandle handle, @Cast("const char**") @ByPtrPtr byte[] out_str);
/**
 * \brief Executor forward method
 *
 * @param handle executor handle
 * @param is_train int value to indicate whether the forward pass is for evaluation
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorForward(ExecutorHandle handle, int is_train);
/**
 * \brief Excecutor run backward
 *
 * @param handle execute handle
 * @param len lenth
 * @param head_grads NDArray handle for heads' gradient
 *
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorBackward(ExecutorHandle handle,
                                 @Cast("uint32_t") int len,
                                 PointerPointer head_grads);
public static native int MXExecutorBackward(ExecutorHandle handle,
                                 @Cast("uint32_t") int len,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle head_grads);
/**
 * \brief Excecutor run backward
 *
 * @param handle execute handle
 * @param len lenth
 * @param head_grads NDArray handle for heads' gradient
 * @param is_train int value to indicate whether the backward pass is for evaluation
 *
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorBackwardEx(ExecutorHandle handle,
                                   @Cast("uint32_t") int len,
                                   PointerPointer head_grads,
                                   int is_train);
public static native int MXExecutorBackwardEx(ExecutorHandle handle,
                                   @Cast("uint32_t") int len,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle head_grads,
                                   int is_train);
/**
 * \brief Get executor's head NDArray
 *
 * @param handle executor handle
 * @param out_size output narray vector size
 * @param out out put narray handles
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorOutputs(ExecutorHandle handle,
                                @Cast("uint32_t*") IntPointer out_size,
                                @ByPtrPtr PointerPointer out);
public static native int MXExecutorOutputs(ExecutorHandle handle,
                                @Cast("uint32_t*") IntBuffer out_size,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer out);
public static native int MXExecutorOutputs(ExecutorHandle handle,
                                @Cast("uint32_t*") int[] out_size,
                                @ByPtrPtr PointerPointer out);

/**
 * \brief Generate Executor from symbol
 *
 * @param symbol_handle symbol handle
 * @param dev_type device type
 * @param dev_id device id
 * @param len length
 * @param in_args in args array
 * @param arg_grad_store arg grads handle array
 * @param grad_req_type grad req array
 * @param aux_states_len length of auxiliary states
 * @param aux_states auxiliary states array
 * @param out output executor handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorBind(SymbolHandle symbol_handle,
                             int dev_type,
                             int dev_id,
                             @Cast("uint32_t") int len,
                             PointerPointer in_args,
                             PointerPointer arg_grad_store,
                             @Cast("uint32_t*") IntPointer grad_req_type,
                             @Cast("uint32_t") int aux_states_len,
                             PointerPointer aux_states,
                             PointerPointer out);
public static native int MXExecutorBind(SymbolHandle symbol_handle,
                             int dev_type,
                             int dev_id,
                             @Cast("uint32_t") int len,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                             @Cast("uint32_t*") IntBuffer grad_req_type,
                             @Cast("uint32_t") int aux_states_len,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                             @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorBind(SymbolHandle symbol_handle,
                             int dev_type,
                             int dev_id,
                             @Cast("uint32_t") int len,
                             PointerPointer in_args,
                             PointerPointer arg_grad_store,
                             @Cast("uint32_t*") int[] grad_req_type,
                             @Cast("uint32_t") int aux_states_len,
                             PointerPointer aux_states,
                             PointerPointer out);
public static native int MXExecutorBind(SymbolHandle symbol_handle,
                             int dev_type,
                             int dev_id,
                             @Cast("uint32_t") int len,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                             @Cast("uint32_t*") IntPointer grad_req_type,
                             @Cast("uint32_t") int aux_states_len,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                             @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorBind(SymbolHandle symbol_handle,
                             int dev_type,
                             int dev_id,
                             @Cast("uint32_t") int len,
                             PointerPointer in_args,
                             PointerPointer arg_grad_store,
                             @Cast("uint32_t*") IntBuffer grad_req_type,
                             @Cast("uint32_t") int aux_states_len,
                             PointerPointer aux_states,
                             PointerPointer out);
public static native int MXExecutorBind(SymbolHandle symbol_handle,
                             int dev_type,
                             int dev_id,
                             @Cast("uint32_t") int len,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                             @Cast("uint32_t*") int[] grad_req_type,
                             @Cast("uint32_t") int aux_states_len,
                             @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                             @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
/**
 * \brief Generate Executor from symbol,
 *  This is advanced function, allow specify group2ctx map.
 *  The user can annotate "ctx_group" attribute to name each group.
 *
 * @param symbol_handle symbol handle
 * @param dev_type device type of default context
 * @param dev_id device id of default context
 * @param num_map_keys size of group2ctx map
 * @param map_keys keys of group2ctx map
 * @param map_dev_types device type of group2ctx map
 * @param map_dev_ids device id of group2ctx map
 * @param len length
 * @param in_args in args array
 * @param arg_grad_store arg grads handle array
 * @param grad_req_type grad req array
 * @param aux_states_len length of auxiliary states
 * @param aux_states auxiliary states array
 * @param out output executor handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") PointerPointer map_keys,
                              @Const IntPointer map_dev_types,
                              @Const IntPointer map_dev_ids,
                              @Cast("uint32_t") int len,
                              PointerPointer in_args,
                              PointerPointer arg_grad_store,
                              @Cast("uint32_t*") IntPointer grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              PointerPointer aux_states,
                              PointerPointer out);
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                              @Const IntPointer map_dev_types,
                              @Const IntPointer map_dev_ids,
                              @Cast("uint32_t") int len,
                              PointerPointer in_args,
                              PointerPointer arg_grad_store,
                              @Cast("uint32_t*") IntPointer grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              PointerPointer aux_states,
                              PointerPointer out);
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                              @Const IntBuffer map_dev_types,
                              @Const IntBuffer map_dev_ids,
                              @Cast("uint32_t") int len,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                              @Cast("uint32_t*") IntBuffer grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                              @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") @ByPtrPtr byte[] map_keys,
                              @Const int[] map_dev_types,
                              @Const int[] map_dev_ids,
                              @Cast("uint32_t") int len,
                              PointerPointer in_args,
                              PointerPointer arg_grad_store,
                              @Cast("uint32_t*") int[] grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              PointerPointer aux_states,
                              PointerPointer out);
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                              @Const IntPointer map_dev_types,
                              @Const IntPointer map_dev_ids,
                              @Cast("uint32_t") int len,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                              @Cast("uint32_t*") IntPointer grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                              @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                              @Const IntBuffer map_dev_types,
                              @Const IntBuffer map_dev_ids,
                              @Cast("uint32_t") int len,
                              PointerPointer in_args,
                              PointerPointer arg_grad_store,
                              @Cast("uint32_t*") IntBuffer grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              PointerPointer aux_states,
                              PointerPointer out);
public static native int MXExecutorBindX(SymbolHandle symbol_handle,
                              int dev_type,
                              int dev_id,
                              @Cast("uint32_t") int num_map_keys,
                              @Cast("const char**") @ByPtrPtr byte[] map_keys,
                              @Const int[] map_dev_types,
                              @Const int[] map_dev_ids,
                              @Cast("uint32_t") int len,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                              @Cast("uint32_t*") int[] grad_req_type,
                              @Cast("uint32_t") int aux_states_len,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                              @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
/**
 * \brief Generate Executor from symbol,
 *  This is advanced function, allow specify group2ctx map.
 *  The user can annotate "ctx_group" attribute to name each group.
 *
 * @param symbol_handle symbol handle
 * @param dev_type device type of default context
 * @param dev_id device id of default context
 * @param num_map_keys size of group2ctx map
 * @param map_keys keys of group2ctx map
 * @param map_dev_types device type of group2ctx map
 * @param map_dev_ids device id of group2ctx map
 * @param len length
 * @param in_args in args array
 * @param arg_grad_store arg grads handle array
 * @param grad_req_type grad req array
 * @param aux_states_len length of auxiliary states
 * @param aux_states auxiliary states array
 * @param shared_exec input executor handle for memory sharing
 * @param out output executor handle
 * @return 0 when success, -1 when failure happens
 */
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") PointerPointer map_keys,
                               @Const IntPointer map_dev_types,
                               @Const IntPointer map_dev_ids,
                               @Cast("uint32_t") int len,
                               PointerPointer in_args,
                               PointerPointer arg_grad_store,
                               @Cast("uint32_t*") IntPointer grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               PointerPointer aux_states,
                               ExecutorHandle shared_exec,
                               PointerPointer out);
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                               @Const IntPointer map_dev_types,
                               @Const IntPointer map_dev_ids,
                               @Cast("uint32_t") int len,
                               PointerPointer in_args,
                               PointerPointer arg_grad_store,
                               @Cast("uint32_t*") IntPointer grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               PointerPointer aux_states,
                               ExecutorHandle shared_exec,
                               PointerPointer out);
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                               @Const IntBuffer map_dev_types,
                               @Const IntBuffer map_dev_ids,
                               @Cast("uint32_t") int len,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                               @Cast("uint32_t*") IntBuffer grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                               ExecutorHandle shared_exec,
                               @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") @ByPtrPtr byte[] map_keys,
                               @Const int[] map_dev_types,
                               @Const int[] map_dev_ids,
                               @Cast("uint32_t") int len,
                               PointerPointer in_args,
                               PointerPointer arg_grad_store,
                               @Cast("uint32_t*") int[] grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               PointerPointer aux_states,
                               ExecutorHandle shared_exec,
                               PointerPointer out);
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                               @Const IntPointer map_dev_types,
                               @Const IntPointer map_dev_ids,
                               @Cast("uint32_t") int len,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                               @Cast("uint32_t*") IntPointer grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                               ExecutorHandle shared_exec,
                               @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                               @Const IntBuffer map_dev_types,
                               @Const IntBuffer map_dev_ids,
                               @Cast("uint32_t") int len,
                               PointerPointer in_args,
                               PointerPointer arg_grad_store,
                               @Cast("uint32_t*") IntBuffer grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               PointerPointer aux_states,
                               ExecutorHandle shared_exec,
                               PointerPointer out);
public static native int MXExecutorBindEX(SymbolHandle symbol_handle,
                               int dev_type,
                               int dev_id,
                               @Cast("uint32_t") int num_map_keys,
                               @Cast("const char**") @ByPtrPtr byte[] map_keys,
                               @Const int[] map_dev_types,
                               @Const int[] map_dev_ids,
                               @Cast("uint32_t") int len,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle in_args,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle arg_grad_store,
                               @Cast("uint32_t*") int[] grad_req_type,
                               @Cast("uint32_t") int aux_states_len,
                               @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle aux_states,
                               ExecutorHandle shared_exec,
                               @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
/** \brief DEPRECATED. Use MXExecutorSimpleBindEx instead.
 */
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") PointerPointer g2c_keys,
                                   @Const IntPointer g2c_dev_types,
                                   @Const IntPointer g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") PointerPointer provided_grad_req_names,
                                   @Cast("const char**") PointerPointer provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") PointerPointer provided_arg_shape_names,
                                   @Cast("const uint32_t*") IntPointer provided_arg_shape_data,
                                   @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") PointerPointer provided_arg_dtype_names,
                                   @Const IntPointer provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") PointerPointer provided_arg_stype_names,
                                   @Const IntPointer provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") PointerPointer shared_arg_name_list,
                                   IntPointer shared_buffer_len,
                                   @Cast("const char**") PointerPointer shared_buffer_name_list,
                                   PointerPointer shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") IntPointer num_in_args,
                                   @ByPtrPtr PointerPointer in_args,
                                   @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") IntPointer num_aux_states,
                                   @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   PointerPointer out);
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer g2c_keys,
                                   @Const IntPointer g2c_dev_types,
                                   @Const IntPointer g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_names,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                   @Cast("const uint32_t*") IntPointer provided_arg_shape_data,
                                   @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                                   @Const IntPointer provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_arg_stype_names,
                                   @Const IntPointer provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") @ByPtrPtr BytePointer shared_arg_name_list,
                                   IntPointer shared_buffer_len,
                                   @Cast("const char**") @ByPtrPtr BytePointer shared_buffer_name_list,
                                   PointerPointer shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") IntPointer num_in_args,
                                   @ByPtrPtr PointerPointer in_args,
                                   @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") IntPointer num_aux_states,
                                   @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   PointerPointer out);
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer g2c_keys,
                                   @Const IntBuffer g2c_dev_types,
                                   @Const IntBuffer g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_names,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                   @Cast("const uint32_t*") IntBuffer provided_arg_shape_data,
                                   @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                                   @Const IntBuffer provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_stype_names,
                                   @Const IntBuffer provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer shared_arg_name_list,
                                   IntBuffer shared_buffer_len,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer shared_buffer_name_list,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") IntBuffer num_in_args,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") IntBuffer num_aux_states,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") @ByPtrPtr byte[] g2c_keys,
                                   @Const int[] g2c_dev_types,
                                   @Const int[] g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_names,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                   @Cast("const uint32_t*") int[] provided_arg_shape_data,
                                   @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                                   @Const int[] provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_arg_stype_names,
                                   @Const int[] provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") @ByPtrPtr byte[] shared_arg_name_list,
                                   int[] shared_buffer_len,
                                   @Cast("const char**") @ByPtrPtr byte[] shared_buffer_name_list,
                                   PointerPointer shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") int[] num_in_args,
                                   @ByPtrPtr PointerPointer in_args,
                                   @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") int[] num_aux_states,
                                   @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   PointerPointer out);
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer g2c_keys,
                                   @Const IntPointer g2c_dev_types,
                                   @Const IntPointer g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_names,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                   @Cast("const uint32_t*") IntPointer provided_arg_shape_data,
                                   @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                                   @Const IntPointer provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") @ByPtrPtr BytePointer provided_arg_stype_names,
                                   @Const IntPointer provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") @ByPtrPtr BytePointer shared_arg_name_list,
                                   IntPointer shared_buffer_len,
                                   @Cast("const char**") @ByPtrPtr BytePointer shared_buffer_name_list,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") IntPointer num_in_args,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") IntPointer num_aux_states,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer g2c_keys,
                                   @Const IntBuffer g2c_dev_types,
                                   @Const IntBuffer g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_names,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                   @Cast("const uint32_t*") IntBuffer provided_arg_shape_data,
                                   @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                                   @Const IntBuffer provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_stype_names,
                                   @Const IntBuffer provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer shared_arg_name_list,
                                   IntBuffer shared_buffer_len,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer shared_buffer_name_list,
                                   PointerPointer shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") IntBuffer num_in_args,
                                   @ByPtrPtr PointerPointer in_args,
                                   @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") IntBuffer num_aux_states,
                                   @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   PointerPointer out);
public static native int MXExecutorSimpleBind(SymbolHandle symbol_handle,
                                   int dev_type,
                                   int dev_id,
                                   @Cast("const uint32_t") int num_g2c_keys,
                                   @Cast("const char**") @ByPtrPtr byte[] g2c_keys,
                                   @Const int[] g2c_dev_types,
                                   @Const int[] g2c_dev_ids,
                                   @Cast("const uint32_t") int provided_grad_req_list_len,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_names,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_types,
                                   @Cast("const uint32_t") int num_provided_arg_shapes,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                   @Cast("const uint32_t*") int[] provided_arg_shape_data,
                                   @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                   @Cast("const uint32_t") int num_provided_arg_dtypes,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                                   @Const int[] provided_arg_dtypes,
                                   @Cast("const uint32_t") int num_provided_arg_stypes,
                                   @Cast("const char**") @ByPtrPtr byte[] provided_arg_stype_names,
                                   @Const int[] provided_arg_stypes,
                                   @Cast("const uint32_t") int num_shared_arg_names,
                                   @Cast("const char**") @ByPtrPtr byte[] shared_arg_name_list,
                                   int[] shared_buffer_len,
                                   @Cast("const char**") @ByPtrPtr byte[] shared_buffer_name_list,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                   @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                   @Cast("uint32_t*") int[] num_in_args,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                   @Cast("uint32_t*") int[] num_aux_states,
                                   @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                   ExecutorHandle shared_exec_handle,
                                   @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);


public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") PointerPointer g2c_keys,
                                     @Const IntPointer g2c_dev_types,
                                     @Const IntPointer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") PointerPointer provided_grad_req_names,
                                     @Cast("const char**") PointerPointer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") PointerPointer provided_arg_shape_names,
                                     @Const IntPointer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") PointerPointer provided_arg_dtype_names,
                                     @Const IntPointer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") PointerPointer provided_arg_stype_names,
                                     @Const IntPointer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") PointerPointer shared_arg_name_list,
                                     IntPointer shared_buffer_len,
                                     @Cast("const char**") PointerPointer shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntPointer num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntPointer num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr BytePointer g2c_keys,
                                     @Const IntPointer g2c_dev_types,
                                     @Const IntPointer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                     @Const IntPointer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                                     @Const IntPointer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_stype_names,
                                     @Const IntPointer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_arg_name_list,
                                     IntPointer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntPointer num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntPointer num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer g2c_keys,
                                     @Const IntBuffer g2c_dev_types,
                                     @Const IntBuffer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                     @Const IntBuffer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                                     @Const IntBuffer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_stype_names,
                                     @Const IntBuffer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_arg_name_list,
                                     IntBuffer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_buffer_name_list,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntBuffer num_in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntBuffer num_aux_states,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr byte[] g2c_keys,
                                     @Const int[] g2c_dev_types,
                                     @Const int[] g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                     @Const int[] provided_arg_shape_data,
                                     @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                                     @Const int[] provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_stype_names,
                                     @Const int[] provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_arg_name_list,
                                     int[] shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") int[] num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") int[] num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr BytePointer g2c_keys,
                                     @Const IntPointer g2c_dev_types,
                                     @Const IntPointer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                     @Const IntPointer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                                     @Const IntPointer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_stype_names,
                                     @Const IntPointer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_arg_name_list,
                                     IntPointer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_buffer_name_list,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntPointer num_in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntPointer num_aux_states,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer g2c_keys,
                                     @Const IntBuffer g2c_dev_types,
                                     @Const IntBuffer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                     @Const IntBuffer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                                     @Const IntBuffer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_stype_names,
                                     @Const IntBuffer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_arg_name_list,
                                     IntBuffer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntBuffer num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntBuffer num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr byte[] g2c_keys,
                                     @Const int[] g2c_dev_types,
                                     @Const int[] g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                     @Const int[] provided_arg_shape_data,
                                     @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                                     @Const int[] provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_stype_names,
                                     @Const int[] provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_arg_name_list,
                                     int[] shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_buffer_name_list,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") int[] num_in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") int[] num_aux_states,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);


public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") PointerPointer g2c_keys,
                                     @Const IntPointer g2c_dev_types,
                                     @Const IntPointer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") PointerPointer provided_grad_req_names,
                                     @Cast("const char**") PointerPointer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") PointerPointer provided_arg_shape_names,
                                     @Cast("const int64_t*") LongPointer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") PointerPointer provided_arg_dtype_names,
                                     @Const IntPointer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") PointerPointer provided_arg_stype_names,
                                     @Const IntPointer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") PointerPointer shared_arg_name_list,
                                     IntPointer shared_buffer_len,
                                     @Cast("const char**") PointerPointer shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntPointer num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntPointer num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr BytePointer g2c_keys,
                                     @Const IntPointer g2c_dev_types,
                                     @Const IntPointer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                     @Cast("const int64_t*") LongPointer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                                     @Const IntPointer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_stype_names,
                                     @Const IntPointer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_arg_name_list,
                                     IntPointer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntPointer num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntPointer num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer g2c_keys,
                                     @Const IntBuffer g2c_dev_types,
                                     @Const IntBuffer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                     @Cast("const int64_t*") LongBuffer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                                     @Const IntBuffer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_stype_names,
                                     @Const IntBuffer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_arg_name_list,
                                     IntBuffer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_buffer_name_list,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntBuffer num_in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntBuffer num_aux_states,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr byte[] g2c_keys,
                                     @Const int[] g2c_dev_types,
                                     @Const int[] g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                     @Cast("const int64_t*") long[] provided_arg_shape_data,
                                     @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                                     @Const int[] provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_stype_names,
                                     @Const int[] provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_arg_name_list,
                                     int[] shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") int[] num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") int[] num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr BytePointer g2c_keys,
                                     @Const IntPointer g2c_dev_types,
                                     @Const IntPointer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                     @Cast("const int64_t*") LongPointer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                                     @Const IntPointer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr BytePointer provided_arg_stype_names,
                                     @Const IntPointer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_arg_name_list,
                                     IntPointer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr BytePointer shared_buffer_name_list,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntPointer num_in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntPointer num_aux_states,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer g2c_keys,
                                     @Const IntBuffer g2c_dev_types,
                                     @Const IntBuffer g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                     @Cast("const int64_t*") LongBuffer provided_arg_shape_data,
                                     @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                                     @Const IntBuffer provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_stype_names,
                                     @Const IntBuffer provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_arg_name_list,
                                     IntBuffer shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer shared_buffer_name_list,
                                     PointerPointer shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") IntBuffer num_in_args,
                                     @ByPtrPtr PointerPointer in_args,
                                     @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") IntBuffer num_aux_states,
                                     @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     PointerPointer out);
public static native int MXExecutorSimpleBindEx64(SymbolHandle symbol_handle,
                                     int dev_type,
                                     int dev_id,
                                     @Cast("const uint32_t") int num_g2c_keys,
                                     @Cast("const char**") @ByPtrPtr byte[] g2c_keys,
                                     @Const int[] g2c_dev_types,
                                     @Const int[] g2c_dev_ids,
                                     @Cast("const uint32_t") int provided_grad_req_list_len,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_names,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_grad_req_types,
                                     @Cast("const uint32_t") int num_provided_arg_shapes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                     @Cast("const int64_t*") long[] provided_arg_shape_data,
                                     @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                     @Cast("const uint32_t") int num_provided_arg_dtypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                                     @Const int[] provided_arg_dtypes,
                                     @Cast("const uint32_t") int num_provided_arg_stypes,
                                     @Cast("const char**") @ByPtrPtr byte[] provided_arg_stype_names,
                                     @Const int[] provided_arg_stypes,
                                     @Cast("const uint32_t") int num_shared_arg_names,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_arg_name_list,
                                     int[] shared_buffer_len,
                                     @Cast("const char**") @ByPtrPtr byte[] shared_buffer_name_list,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle shared_buffer_handle_list,
                                     @Cast("const char***") @ByPtrPtr PointerPointer updated_shared_buffer_name_list,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer updated_shared_buffer_handle_list,
                                     @Cast("uint32_t*") int[] num_in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                     @Cast("uint32_t*") int[] num_aux_states,
                                     @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                     ExecutorHandle shared_exec_handle,
                                     @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);


/**
 * \brief DEPRECATED. Use MXExecutorReshapeEx instead.
 * Return a new executor with the same symbol and shared memory,
 * but different input/output shapes.
 *
 * @param partial_shaping Whether to allow changing the shape of unspecified arguments.
 * @param allow_up_sizing Whether to allow allocating new ndarrays that's larger than the original.
 * @param dev_type device type of default context
 * @param dev_id device id of default context
 * @param num_map_keys size of group2ctx map
 * @param map_keys keys of group2ctx map
 * @param map_dev_types device type of group2ctx map
 * @param map_dev_ids device id of group2ctx map
 * @param num_in_args length of in_args
 * @param in_args in args array
 * @param arg_grads arg grads handle array
 * @param num_aux_states length of auxiliary states
 * @param aux_states auxiliary states array
 * @param shared_exec input executor handle for memory sharing
 * @param out output executor handle
 * @return a new executor
 */
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") PointerPointer map_keys,
                                @Const IntPointer map_dev_types,
                                @Const IntPointer map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") PointerPointer provided_arg_shape_names,
                                @Cast("const uint32_t*") IntPointer provided_arg_shape_data,
                                @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                @Cast("uint32_t*") IntPointer num_in_args,
                                @ByPtrPtr PointerPointer in_args,
                                @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") IntPointer num_aux_states,
                                @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                PointerPointer out);
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                                @Const IntPointer map_dev_types,
                                @Const IntPointer map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                @Cast("const uint32_t*") IntPointer provided_arg_shape_data,
                                @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                @Cast("uint32_t*") IntPointer num_in_args,
                                @ByPtrPtr PointerPointer in_args,
                                @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") IntPointer num_aux_states,
                                @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                PointerPointer out);
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                                @Const IntBuffer map_dev_types,
                                @Const IntBuffer map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                @Cast("const uint32_t*") IntBuffer provided_arg_shape_data,
                                @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                @Cast("uint32_t*") IntBuffer num_in_args,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") IntBuffer num_aux_states,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") @ByPtrPtr byte[] map_keys,
                                @Const int[] map_dev_types,
                                @Const int[] map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                @Cast("const uint32_t*") int[] provided_arg_shape_data,
                                @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                @Cast("uint32_t*") int[] num_in_args,
                                @ByPtrPtr PointerPointer in_args,
                                @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") int[] num_aux_states,
                                @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                PointerPointer out);
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                                @Const IntPointer map_dev_types,
                                @Const IntPointer map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                @Cast("const uint32_t*") IntPointer provided_arg_shape_data,
                                @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                @Cast("uint32_t*") IntPointer num_in_args,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") IntPointer num_aux_states,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                                @Const IntBuffer map_dev_types,
                                @Const IntBuffer map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                @Cast("const uint32_t*") IntBuffer provided_arg_shape_data,
                                @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                @Cast("uint32_t*") IntBuffer num_in_args,
                                @ByPtrPtr PointerPointer in_args,
                                @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") IntBuffer num_aux_states,
                                @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                PointerPointer out);
public static native int MXExecutorReshape(int partial_shaping,
                                int allow_up_sizing,
                                int dev_type,
                                int dev_id,
                                @Cast("uint32_t") int num_map_keys,
                                @Cast("const char**") @ByPtrPtr byte[] map_keys,
                                @Const int[] map_dev_types,
                                @Const int[] map_dev_ids,
                                @Cast("const uint32_t") int num_provided_arg_shapes,
                                @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                @Cast("const uint32_t*") int[] provided_arg_shape_data,
                                @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                @Cast("uint32_t*") int[] num_in_args,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                @Cast("uint32_t*") int[] num_aux_states,
                                @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                ExecutorHandle shared_exec,
                                @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
/**
 * \brief Return a new executor with the same symbol and shared memory,
 * but different input/output shapes.
 *
 * @param partial_shaping Whether to allow changing the shape of unspecified arguments.
 * @param allow_up_sizing Whether to allow allocating new ndarrays that's larger than the original.
 * @param dev_type device type of default context
 * @param dev_id device id of default context
 * @param num_map_keys size of group2ctx map
 * @param map_keys keys of group2ctx map
 * @param map_dev_types device type of group2ctx map
 * @param map_dev_ids device id of group2ctx map
 * @param num_in_args length of in_args
 * @param in_args in args array
 * @param arg_grads arg grads handle array
 * @param num_aux_states length of auxiliary states
 * @param aux_states auxiliary states array
 * @param shared_exec input executor handle for memory sharing
 * @param out output executor handle
 * @return a new executor
 */
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") PointerPointer map_keys,
                                  @Const IntPointer map_dev_types,
                                  @Const IntPointer map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") PointerPointer provided_arg_shape_names,
                                  @Const IntPointer provided_arg_shape_data,
                                  @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                  @Cast("uint32_t*") IntPointer num_in_args,
                                  @ByPtrPtr PointerPointer in_args,
                                  @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") IntPointer num_aux_states,
                                  @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  PointerPointer out);
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                                  @Const IntPointer map_dev_types,
                                  @Const IntPointer map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                  @Const IntPointer provided_arg_shape_data,
                                  @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                  @Cast("uint32_t*") IntPointer num_in_args,
                                  @ByPtrPtr PointerPointer in_args,
                                  @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") IntPointer num_aux_states,
                                  @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  PointerPointer out);
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                                  @Const IntBuffer map_dev_types,
                                  @Const IntBuffer map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                  @Const IntBuffer provided_arg_shape_data,
                                  @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                  @Cast("uint32_t*") IntBuffer num_in_args,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") IntBuffer num_aux_states,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") @ByPtrPtr byte[] map_keys,
                                  @Const int[] map_dev_types,
                                  @Const int[] map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                  @Const int[] provided_arg_shape_data,
                                  @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                  @Cast("uint32_t*") int[] num_in_args,
                                  @ByPtrPtr PointerPointer in_args,
                                  @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") int[] num_aux_states,
                                  @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  PointerPointer out);
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") @ByPtrPtr BytePointer map_keys,
                                  @Const IntPointer map_dev_types,
                                  @Const IntPointer map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") @ByPtrPtr BytePointer provided_arg_shape_names,
                                  @Const IntPointer provided_arg_shape_data,
                                  @Cast("const uint32_t*") IntPointer provided_arg_shape_idx,
                                  @Cast("uint32_t*") IntPointer num_in_args,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") IntPointer num_aux_states,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer map_keys,
                                  @Const IntBuffer map_dev_types,
                                  @Const IntBuffer map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_shape_names,
                                  @Const IntBuffer provided_arg_shape_data,
                                  @Cast("const uint32_t*") IntBuffer provided_arg_shape_idx,
                                  @Cast("uint32_t*") IntBuffer num_in_args,
                                  @ByPtrPtr PointerPointer in_args,
                                  @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") IntBuffer num_aux_states,
                                  @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  PointerPointer out);
public static native int MXExecutorReshapeEx(int partial_shaping,
                                  int allow_up_sizing,
                                  int dev_type,
                                  int dev_id,
                                  @Cast("uint32_t") int num_map_keys,
                                  @Cast("const char**") @ByPtrPtr byte[] map_keys,
                                  @Const int[] map_dev_types,
                                  @Const int[] map_dev_ids,
                                  @Cast("const uint32_t") int num_provided_arg_shapes,
                                  @Cast("const char**") @ByPtrPtr byte[] provided_arg_shape_names,
                                  @Const int[] provided_arg_shape_data,
                                  @Cast("const uint32_t*") int[] provided_arg_shape_idx,
                                  @Cast("uint32_t*") int[] num_in_args,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer in_args,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer arg_grads,
                                  @Cast("uint32_t*") int[] num_aux_states,
                                  @Cast("NDArrayHandle**") @ByPtrPtr PointerPointer aux_states,
                                  ExecutorHandle shared_exec,
                                  @Cast("ExecutorHandle*") @ByPtrPtr ExecutorHandle out);

/**
 * \brief get optimized graph from graph executor
 */
public static native int MXExecutorGetOptimizedSymbol(ExecutorHandle handle,
                                           PointerPointer out);
public static native int MXExecutorGetOptimizedSymbol(ExecutorHandle handle,
                                           @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief set a call back to notify the completion of operation
 */
public static native int MXExecutorSetMonitorCallback(ExecutorHandle handle,
                                           ExecutorMonitorCallback callback,
                                           Pointer callback_handle);

/**
 * \brief set a call back to notify the completion of operation
 * @param monitor_all If true, monitor both input and output, otherwise monitor output only.
 */
public static native int MXExecutorSetMonitorCallbackEX(ExecutorHandle handle,
                                             ExecutorMonitorCallback callback,
                                             Pointer callback_handle, @Cast("bool") boolean monitor_all);
//--------------------------------------------
// Part 5: IO Interface
//--------------------------------------------
/**
 * \brief List all the available iterator entries
 * @param out_size the size of returned iterators
 * @param out_array the output iteratos entries
 * @return 0 when success, -1 when failure happens
 */
public static native int MXListDataIters(@Cast("uint32_t*") IntPointer out_size,
                              @ByPtrPtr PointerPointer out_array);
public static native int MXListDataIters(@Cast("uint32_t*") IntBuffer out_size,
                              @Cast("DataIterCreator**") @ByPtrPtr PointerPointer out_array);
public static native int MXListDataIters(@Cast("uint32_t*") int[] out_size,
                              @ByPtrPtr PointerPointer out_array);
/**
 * \brief Init an iterator, init with parameters
 * the array size of passed in arguments
 * @param handle of the iterator creator
 * @param num_param number of parameter
 * @param keys parameter keys
 * @param vals parameter values
 * @param out resulting iterator
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") PointerPointer keys,
                                   @Cast("const char**") PointerPointer vals,
                                   PointerPointer out);
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") @ByPtrPtr BytePointer keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer vals,
                                   PointerPointer out);
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                   @Cast("DataIterHandle*") @ByPtrPtr DataIterHandle out);
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") @ByPtrPtr byte[] keys,
                                   @Cast("const char**") @ByPtrPtr byte[] vals,
                                   PointerPointer out);
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") @ByPtrPtr BytePointer keys,
                                   @Cast("const char**") @ByPtrPtr BytePointer vals,
                                   @Cast("DataIterHandle*") @ByPtrPtr DataIterHandle out);
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                   PointerPointer out);
public static native int MXDataIterCreateIter(DataIterCreator handle,
                                   @Cast("uint32_t") int num_param,
                                   @Cast("const char**") @ByPtrPtr byte[] keys,
                                   @Cast("const char**") @ByPtrPtr byte[] vals,
                                   @Cast("DataIterHandle*") @ByPtrPtr DataIterHandle out);
/**
 * \brief Get the detailed information about data iterator.
 * @param creator the DataIterCreator.
 * @param name The returned name of the creator.
 * @param description The returned description of the symbol.
 * @param num_args Number of arguments.
 * @param arg_names Name of the arguments.
 * @param arg_type_infos Type informations about the arguments.
 * @param arg_descriptions Description information about the arguments.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterGetIterInfo(DataIterCreator creator,
                                    @Cast("const char**") PointerPointer name,
                                    @Cast("const char**") PointerPointer description,
                                    @Cast("uint32_t*") IntPointer num_args,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
public static native int MXDataIterGetIterInfo(DataIterCreator creator,
                                    @Cast("const char**") @ByPtrPtr BytePointer name,
                                    @Cast("const char**") @ByPtrPtr BytePointer description,
                                    @Cast("uint32_t*") IntPointer num_args,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
public static native int MXDataIterGetIterInfo(DataIterCreator creator,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer name,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer description,
                                    @Cast("uint32_t*") IntBuffer num_args,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
public static native int MXDataIterGetIterInfo(DataIterCreator creator,
                                    @Cast("const char**") @ByPtrPtr byte[] name,
                                    @Cast("const char**") @ByPtrPtr byte[] description,
                                    @Cast("uint32_t*") int[] num_args,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                                    @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions);
/**
 * \brief Free the handle to the IO module
 * @param handle the handle pointer to the data iterator
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterFree(DataIterHandle handle);
/**
 * \brief Move iterator to next position
 * @param handle the handle to iterator
 * @param out return value of next
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterNext(DataIterHandle handle,
                             IntPointer out);
public static native int MXDataIterNext(DataIterHandle handle,
                             IntBuffer out);
public static native int MXDataIterNext(DataIterHandle handle,
                             int[] out);
/**
 * \brief Call iterator.Reset
 * @param handle the handle to iterator
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterBeforeFirst(DataIterHandle handle);

/**
 * \brief Get the handle to the NDArray of underlying data
 * @param handle the handle pointer to the data iterator
 * @param out handle to underlying data NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterGetData(DataIterHandle handle,
                                PointerPointer out);
public static native int MXDataIterGetData(DataIterHandle handle,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief Get the image index by array.
 * @param handle the handle pointer to the data iterator
 * @param out_index output index of the array.
 * @param out_size output size of the array.
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterGetIndex(DataIterHandle handle,
                                 @Cast("uint64_t**") PointerPointer out_index,
                                 @Cast("uint64_t*") LongPointer out_size);
public static native int MXDataIterGetIndex(DataIterHandle handle,
                                 @Cast("uint64_t**") @ByPtrPtr LongPointer out_index,
                                 @Cast("uint64_t*") LongPointer out_size);
public static native int MXDataIterGetIndex(DataIterHandle handle,
                                 @Cast("uint64_t**") @ByPtrPtr LongBuffer out_index,
                                 @Cast("uint64_t*") LongBuffer out_size);
public static native int MXDataIterGetIndex(DataIterHandle handle,
                                 @Cast("uint64_t**") @ByPtrPtr long[] out_index,
                                 @Cast("uint64_t*") long[] out_size);
/**
 * \brief Get the padding number in current data batch
 * @param handle the handle pointer to the data iterator
 * @param pad pad number ptr
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterGetPadNum(DataIterHandle handle,
                                  IntPointer pad);
public static native int MXDataIterGetPadNum(DataIterHandle handle,
                                  IntBuffer pad);
public static native int MXDataIterGetPadNum(DataIterHandle handle,
                                  int[] pad);

/**
 * \brief Get the handle to the NDArray of underlying label
 * @param handle the handle pointer to the data iterator
 * @param out the handle to underlying label NDArray
 * @return 0 when success, -1 when failure happens
 */
public static native int MXDataIterGetLabel(DataIterHandle handle,
                                 PointerPointer out);
public static native int MXDataIterGetLabel(DataIterHandle handle,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
//--------------------------------------------
// Part 6: basic KVStore interface
//--------------------------------------------
/**
 * \brief Initialized ps-lite environment variables
 * @param num_vars number of variables to initialize
 * @param keys environment keys
 * @param vals environment values
 */
public static native int MXInitPSEnv(@Cast("uint32_t") int num_vars,
                          @Cast("const char**") PointerPointer keys,
                          @Cast("const char**") PointerPointer vals);
public static native int MXInitPSEnv(@Cast("uint32_t") int num_vars,
                          @Cast("const char**") @ByPtrPtr BytePointer keys,
                          @Cast("const char**") @ByPtrPtr BytePointer vals);
public static native int MXInitPSEnv(@Cast("uint32_t") int num_vars,
                          @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                          @Cast("const char**") @ByPtrPtr ByteBuffer vals);
public static native int MXInitPSEnv(@Cast("uint32_t") int num_vars,
                          @Cast("const char**") @ByPtrPtr byte[] keys,
                          @Cast("const char**") @ByPtrPtr byte[] vals);


/**
 * \brief Create a kvstore
 * @param type the type of KVStore
 * @param out The output type of KVStore
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreCreate(@Cast("const char*") BytePointer type,
                              PointerPointer out);
public static native int MXKVStoreCreate(String type,
                              @Cast("KVStoreHandle*") @ByPtrPtr KVStoreHandle out);

/**
 * \brief Set parameters to use low-bit compressed gradients
 * @param handle handle to the kvstore
 * @param keys keys for compression parameters
 * @param vals values for compression parameters
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreSetGradientCompression(KVStoreHandle handle,
                                              @Cast("uint32_t") int num_params,
                                              @Cast("const char**") PointerPointer keys,
                                              @Cast("const char**") PointerPointer vals);
public static native int MXKVStoreSetGradientCompression(KVStoreHandle handle,
                                              @Cast("uint32_t") int num_params,
                                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                                              @Cast("const char**") @ByPtrPtr BytePointer vals);
public static native int MXKVStoreSetGradientCompression(KVStoreHandle handle,
                                              @Cast("uint32_t") int num_params,
                                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                              @Cast("const char**") @ByPtrPtr ByteBuffer vals);
public static native int MXKVStoreSetGradientCompression(KVStoreHandle handle,
                                              @Cast("uint32_t") int num_params,
                                              @Cast("const char**") @ByPtrPtr byte[] keys,
                                              @Cast("const char**") @ByPtrPtr byte[] vals);

/**
 * \brief Delete a KVStore handle.
 * @param handle handle to the kvstore
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreFree(KVStoreHandle handle);
/**
 * \brief Init a list of (key,value) pairs in kvstore
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreInit(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntPointer keys,
                            PointerPointer vals);
public static native int MXKVStoreInit(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntBuffer keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals);
public static native int MXKVStoreInit(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const int[] keys,
                            PointerPointer vals);
public static native int MXKVStoreInit(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntPointer keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals);
public static native int MXKVStoreInit(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntBuffer keys,
                            PointerPointer vals);
public static native int MXKVStoreInit(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const int[] keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals);

/**
 * \brief Init a list of (key,value) pairs in kvstore, where each key is a string
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") PointerPointer keys,
                              PointerPointer vals);
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              PointerPointer vals);
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals);
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              PointerPointer vals);
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals);
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              PointerPointer vals);
public static native int MXKVStoreInitEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals);

/**
 * \brief Push a list of (key,value) pairs to kvstore
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePush(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntPointer keys,
                            PointerPointer vals,
                            int priority);
public static native int MXKVStorePush(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntBuffer keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                            int priority);
public static native int MXKVStorePush(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const int[] keys,
                            PointerPointer vals,
                            int priority);
public static native int MXKVStorePush(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntPointer keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                            int priority);
public static native int MXKVStorePush(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntBuffer keys,
                            PointerPointer vals,
                            int priority);
public static native int MXKVStorePush(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const int[] keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                            int priority);
/**
 * \brief Push a list of (key,value) pairs to kvstore, where each key is a string
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") PointerPointer keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                              int priority);
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                              int priority);
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePushEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                              int priority);
/**
 * \brief pull a list of (key, value) pairs from the kvstore
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param priority the priority of the action
 * @param ignore_sparse whether to ignore sparse arrays in the request
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePullWithSparse(KVStoreHandle handle,
                                      @Cast("uint32_t") int num,
                                      @Const IntPointer keys,
                                      PointerPointer vals,
                                      int priority,
                                      @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparse(KVStoreHandle handle,
                                      @Cast("uint32_t") int num,
                                      @Const IntBuffer keys,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                      int priority,
                                      @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparse(KVStoreHandle handle,
                                      @Cast("uint32_t") int num,
                                      @Const int[] keys,
                                      PointerPointer vals,
                                      int priority,
                                      @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparse(KVStoreHandle handle,
                                      @Cast("uint32_t") int num,
                                      @Const IntPointer keys,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                      int priority,
                                      @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparse(KVStoreHandle handle,
                                      @Cast("uint32_t") int num,
                                      @Const IntBuffer keys,
                                      PointerPointer vals,
                                      int priority,
                                      @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparse(KVStoreHandle handle,
                                      @Cast("uint32_t") int num,
                                      @Const int[] keys,
                                      @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                      int priority,
                                      @Cast("bool") boolean ignore_sparse);
/**
 * \brief pull a list of (key, value) pairs from the kvstore, where each key is a string
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param priority the priority of the action
 * @param ignore_sparse whether to ignore sparse arrays in the request
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") PointerPointer keys,
                                        PointerPointer vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") @ByPtrPtr BytePointer keys,
                                        PointerPointer vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                        @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") @ByPtrPtr byte[] keys,
                                        PointerPointer vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") @ByPtrPtr BytePointer keys,
                                        @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                        PointerPointer vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
public static native int MXKVStorePullWithSparseEx(KVStoreHandle handle,
                                        @Cast("uint32_t") int num,
                                        @Cast("const char**") @ByPtrPtr byte[] keys,
                                        @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                        int priority,
                                        @Cast("bool") boolean ignore_sparse);
/**
 * \brief pull a list of (key, value) pairs from the kvstore
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePull(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntPointer keys,
                            PointerPointer vals,
                            int priority);
public static native int MXKVStorePull(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntBuffer keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                            int priority);
public static native int MXKVStorePull(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const int[] keys,
                            PointerPointer vals,
                            int priority);
public static native int MXKVStorePull(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntPointer keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                            int priority);
public static native int MXKVStorePull(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const IntBuffer keys,
                            PointerPointer vals,
                            int priority);
public static native int MXKVStorePull(KVStoreHandle handle,
                            @Cast("uint32_t") int num,
                            @Const int[] keys,
                            @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                            int priority);
/**
 * \brief pull a list of (key, value) pairs from the kvstore, where each key is a string
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") PointerPointer keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                              int priority);
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                              int priority);
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              PointerPointer vals,
                              int priority);
public static native int MXKVStorePullEx(KVStoreHandle handle,
                              @Cast("uint32_t") int num,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                              int priority);

/**
 * \brief pull a list of (key, value) pairs from the kvstore, where each key is an integer.
 *        The NDArray pulled back will be in row_sparse storage with only the specified
 *        row_ids present based row_ids (others rows are zeros).
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param row_ids the list of row_id NDArrays
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePullRowSparse(KVStoreHandle handle,
                                     @Cast("uint32_t") int num,
                                     @Const IntPointer keys,
                                     PointerPointer vals,
                                     @Cast("NDArrayHandle*") PointerPointer row_ids,
                                     int priority);
public static native int MXKVStorePullRowSparse(KVStoreHandle handle,
                                     @Cast("uint32_t") int num,
                                     @Const IntBuffer keys,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle row_ids,
                                     int priority);
public static native int MXKVStorePullRowSparse(KVStoreHandle handle,
                                     @Cast("uint32_t") int num,
                                     @Const int[] keys,
                                     PointerPointer vals,
                                     @Cast("NDArrayHandle*") PointerPointer row_ids,
                                     int priority);
public static native int MXKVStorePullRowSparse(KVStoreHandle handle,
                                     @Cast("uint32_t") int num,
                                     @Const IntPointer keys,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle row_ids,
                                     int priority);
public static native int MXKVStorePullRowSparse(KVStoreHandle handle,
                                     @Cast("uint32_t") int num,
                                     @Const IntBuffer keys,
                                     PointerPointer vals,
                                     @Cast("NDArrayHandle*") PointerPointer row_ids,
                                     int priority);
public static native int MXKVStorePullRowSparse(KVStoreHandle handle,
                                     @Cast("uint32_t") int num,
                                     @Const int[] keys,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                     @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle row_ids,
                                     int priority);
/**
 * \brief pull a list of (key, value) pairs from the kvstore, where each key is a string.
 *        The NDArray pulled back will be in row_sparse storage with only the specified
 *        row_ids present based row_ids (others rows are zeros).
 * @param handle handle to the kvstore
 * @param num the number of key-value pairs
 * @param keys the list of keys
 * @param vals the list of values
 * @param row_ids the list of row_id NDArrays
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") PointerPointer keys,
                                       PointerPointer vals,
                                       @Cast("NDArrayHandle*") PointerPointer row_ids,
                                       int priority);
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") @ByPtrPtr BytePointer keys,
                                       PointerPointer vals,
                                       @Cast("NDArrayHandle*") PointerPointer row_ids,
                                       int priority);
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                       @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                       @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle row_ids,
                                       int priority);
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") @ByPtrPtr byte[] keys,
                                       PointerPointer vals,
                                       @Cast("NDArrayHandle*") PointerPointer row_ids,
                                       int priority);
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") @ByPtrPtr BytePointer keys,
                                       @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                       @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle row_ids,
                                       int priority);
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                       PointerPointer vals,
                                       @Cast("NDArrayHandle*") PointerPointer row_ids,
                                       int priority);
public static native int MXKVStorePullRowSparseEx(KVStoreHandle handle,
                                       @Cast("uint32_t") int num,
                                       @Cast("const char**") @ByPtrPtr byte[] keys,
                                       @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                       @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle row_ids,
                                       int priority);

/**
 * \brief broadcast a list of (key, value) pairs from the kvstore
 * @param handle handle to the kvstore
 * @param vnum the number of key-value pairs corresponding to vkeys
 * @param vkeys the list of keys for the values to be pushed
 * @param onum the number of key-value pairs corresponding to okeys
 * @param okeys the list of keys for the values to be pulled
 * @param vals the list of values
 * @param outs the list of outputs
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreBroadcast(KVStoreHandle handle,
                                 @Cast("mx_uint") int vnum,
                                 @Const IntPointer vkeys,
                                 @Cast("mx_uint") int onum,
                                 @Const IntPointer okeys,
                                 PointerPointer vals,
                                 PointerPointer outs,
                                 int priority);
public static native int MXKVStoreBroadcast(KVStoreHandle handle,
                                 @Cast("mx_uint") int vnum,
                                 @Const IntBuffer vkeys,
                                 @Cast("mx_uint") int onum,
                                 @Const IntBuffer okeys,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                 int priority);
public static native int MXKVStoreBroadcast(KVStoreHandle handle,
                                 @Cast("mx_uint") int vnum,
                                 @Const int[] vkeys,
                                 @Cast("mx_uint") int onum,
                                 @Const int[] okeys,
                                 PointerPointer vals,
                                 PointerPointer outs,
                                 int priority);
public static native int MXKVStoreBroadcast(KVStoreHandle handle,
                                 @Cast("mx_uint") int vnum,
                                 @Const IntPointer vkeys,
                                 @Cast("mx_uint") int onum,
                                 @Const IntPointer okeys,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                 int priority);
public static native int MXKVStoreBroadcast(KVStoreHandle handle,
                                 @Cast("mx_uint") int vnum,
                                 @Const IntBuffer vkeys,
                                 @Cast("mx_uint") int onum,
                                 @Const IntBuffer okeys,
                                 PointerPointer vals,
                                 PointerPointer outs,
                                 int priority);
public static native int MXKVStoreBroadcast(KVStoreHandle handle,
                                 @Cast("mx_uint") int vnum,
                                 @Const int[] vkeys,
                                 @Cast("mx_uint") int onum,
                                 @Const int[] okeys,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                 int priority);
/**
 * \brief broadcast a list of (key, value) pairs from the kvstore,
 * where each key is a string
 * @param handle handle to the kvstore
 * @param vnum the number of key-value pairs corresponding to vkeys
 * @param vkeys the list of keys for the values to be pushed
 * @param onum the number of key-value pairs corresponding to okeys
 * @param okeys the list of keys for the values to be pulled
 * @param vals the list of values
 * @param outs the list of outputs
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") PointerPointer vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") PointerPointer okeys,
                                   PointerPointer vals,
                                   PointerPointer outs,
                                   int priority);
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") @ByPtrPtr BytePointer vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") @ByPtrPtr BytePointer okeys,
                                   PointerPointer vals,
                                   PointerPointer outs,
                                   int priority);
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer okeys,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                   int priority);
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") @ByPtrPtr byte[] vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") @ByPtrPtr byte[] okeys,
                                   PointerPointer vals,
                                   PointerPointer outs,
                                   int priority);
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") @ByPtrPtr BytePointer vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") @ByPtrPtr BytePointer okeys,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                   int priority);
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") @ByPtrPtr ByteBuffer okeys,
                                   PointerPointer vals,
                                   PointerPointer outs,
                                   int priority);
public static native int MXKVStoreBroadcastEx(KVStoreHandle handle,
                                   @Cast("mx_uint") int vnum,
                                   @Cast("const char**") @ByPtrPtr byte[] vkeys,
                                   @Cast("mx_uint") int onum,
                                   @Cast("const char**") @ByPtrPtr byte[] okeys,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                   @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                   int priority);

/**
 * \brief push and pull a list of (key, value) pairs from the kvstore
 * @param handle handle to the kvstore
 * @param vnum the number of key-value pairs corresponding to vkeys
 * @param vkeys the list of keys for the values to be pushed
 * @param onum the number of key-value pairs corresponding to okeys
 * @param okeys the list of keys for the values to be pulled
 * @param vals the list of values
 * @param outs the list of outputs
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePushPull(KVStoreHandle handle,
                                @Cast("mx_uint") int vnum,
                                @Const IntPointer vkeys,
                                @Cast("mx_uint") int onum,
                                @Const IntPointer okeys,
                                PointerPointer vals,
                                PointerPointer outs,
                                int priority);
public static native int MXKVStorePushPull(KVStoreHandle handle,
                                @Cast("mx_uint") int vnum,
                                @Const IntBuffer vkeys,
                                @Cast("mx_uint") int onum,
                                @Const IntBuffer okeys,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                int priority);
public static native int MXKVStorePushPull(KVStoreHandle handle,
                                @Cast("mx_uint") int vnum,
                                @Const int[] vkeys,
                                @Cast("mx_uint") int onum,
                                @Const int[] okeys,
                                PointerPointer vals,
                                PointerPointer outs,
                                int priority);
public static native int MXKVStorePushPull(KVStoreHandle handle,
                                @Cast("mx_uint") int vnum,
                                @Const IntPointer vkeys,
                                @Cast("mx_uint") int onum,
                                @Const IntPointer okeys,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                int priority);
public static native int MXKVStorePushPull(KVStoreHandle handle,
                                @Cast("mx_uint") int vnum,
                                @Const IntBuffer vkeys,
                                @Cast("mx_uint") int onum,
                                @Const IntBuffer okeys,
                                PointerPointer vals,
                                PointerPointer outs,
                                int priority);
public static native int MXKVStorePushPull(KVStoreHandle handle,
                                @Cast("mx_uint") int vnum,
                                @Const int[] vkeys,
                                @Cast("mx_uint") int onum,
                                @Const int[] okeys,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                int priority);
/**
 * \brief push and pull a list of (key, value) pairs from the kvstore,
 * where each key is a string
 * @param handle handle to the kvstore
 * @param vnum the number of key-value pairs corresponding to vkeys
 * @param vkeys the list of keys for the values to be pushed
 * @param onum the number of key-value pairs corresponding to okeys
 * @param okeys the list of keys for the values to be pulled
 * @param vals the list of values
 * @param outs the list of outputs
 * @param priority the priority of the action
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") PointerPointer vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") PointerPointer okeys,
                                  PointerPointer vals,
                                  PointerPointer outs,
                                  int priority);
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") @ByPtrPtr BytePointer vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") @ByPtrPtr BytePointer okeys,
                                  PointerPointer vals,
                                  PointerPointer outs,
                                  int priority);
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer okeys,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                  int priority);
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") @ByPtrPtr byte[] vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") @ByPtrPtr byte[] okeys,
                                  PointerPointer vals,
                                  PointerPointer outs,
                                  int priority);
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") @ByPtrPtr BytePointer vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") @ByPtrPtr BytePointer okeys,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                  int priority);
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer okeys,
                                  PointerPointer vals,
                                  PointerPointer outs,
                                  int priority);
public static native int MXKVStorePushPullEx(KVStoreHandle handle,
                                  @Cast("mx_uint") int vnum,
                                  @Cast("const char**") @ByPtrPtr byte[] vkeys,
                                  @Cast("mx_uint") int onum,
                                  @Cast("const char**") @ByPtrPtr byte[] okeys,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle vals,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outs,
                                  int priority);
// Targeting ..\MXKVStoreUpdater.java


// Targeting ..\MXKVStoreStrUpdater.java


/**
 * \brief register a push updater
 * @param handle handle to the KVStore
 * @param updater udpater function
 * @param updater_handle The additional handle used to invoke the updater
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreSetUpdater(KVStoreHandle handle,
                                  MXKVStoreUpdater updater,
                                  Pointer updater_handle);
/**
 * \brief register a push updater with int keys and one with string keys
 * @param handle handle to the KVStore
 * @param updater updater function with int keys
 * @param str_updater updater function with string keys
 * @param updater_handle The additional handle used to invoke the updater
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreSetUpdaterEx(KVStoreHandle handle,
                                    MXKVStoreUpdater updater,
                                    MXKVStoreStrUpdater str_updater,
                                    Pointer updater_handle);
/**
 * \brief get the type of the kvstore
 * @param handle handle to the KVStore
 * @param type a string type
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreGetType(KVStoreHandle handle,
                               @Cast("const char**") PointerPointer type);
public static native int MXKVStoreGetType(KVStoreHandle handle,
                               @Cast("const char**") @ByPtrPtr BytePointer type);
public static native int MXKVStoreGetType(KVStoreHandle handle,
                               @Cast("const char**") @ByPtrPtr ByteBuffer type);
public static native int MXKVStoreGetType(KVStoreHandle handle,
                               @Cast("const char**") @ByPtrPtr byte[] type);
//--------------------------------------------
// Part 6: advanced KVStore for multi-machines
//--------------------------------------------

/**
 * \brief return The rank of this node in its group, which is in [0, GroupSize).
 *
 * @param handle handle to the KVStore
 * @param ret the node rank
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreGetRank(KVStoreHandle handle,
                               IntPointer ret);
public static native int MXKVStoreGetRank(KVStoreHandle handle,
                               IntBuffer ret);
public static native int MXKVStoreGetRank(KVStoreHandle handle,
                               int[] ret);

/**
 * \brief return The number of nodes in this group, which is
 * - number of workers if if {@code IsWorkerNode() == true},
 * - number of servers if if {@code IsServerNode() == true},
 * - 1 if {@code IsSchedulerNode() == true},
 * @param handle handle to the KVStore
 * @param ret the group size
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreGetGroupSize(KVStoreHandle handle,
                                    IntPointer ret);
public static native int MXKVStoreGetGroupSize(KVStoreHandle handle,
                                    IntBuffer ret);
public static native int MXKVStoreGetGroupSize(KVStoreHandle handle,
                                    int[] ret);

/**
 * \brief return whether or not this process is a worker node.
 * @param ret 1 for yes, 0 for no
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreIsWorkerNode(IntPointer ret);
public static native int MXKVStoreIsWorkerNode(IntBuffer ret);
public static native int MXKVStoreIsWorkerNode(int[] ret);


/**
 * \brief return whether or not this process is a server node.
 * @param ret 1 for yes, 0 for no
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreIsServerNode(IntPointer ret);
public static native int MXKVStoreIsServerNode(IntBuffer ret);
public static native int MXKVStoreIsServerNode(int[] ret);


/**
 * \brief return whether or not this process is a scheduler node.
 * @param ret 1 for yes, 0 for no
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreIsSchedulerNode(IntPointer ret);
public static native int MXKVStoreIsSchedulerNode(IntBuffer ret);
public static native int MXKVStoreIsSchedulerNode(int[] ret);

/**
 * \brief global barrier among all worker machines
 *
 * @param handle handle to the KVStore
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreBarrier(KVStoreHandle handle);

/**
 * \brief whether to do barrier when finalize
 *
 * @param handle handle to the KVStore
 * @param barrier_before_exit whether to do barrier when kvstore finalize
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreSetBarrierBeforeExit(KVStoreHandle handle,
                                            int barrier_before_exit);
// Targeting ..\MXKVStoreServerController.java



/**
 * \brief Run as server (or scheduler)
 * @param handle handle to the KVStore
 * @param controller the user-defined server controller
 * @param controller_handle helper handle for implementing controller
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreRunServer(KVStoreHandle handle,
                                 MXKVStoreServerController controller,
                                 Pointer controller_handle);

/**
 * \brief Send a command to all server nodes
 * @param handle handle to the KVStore
 * @param cmd_id the head of the command
 * @param cmd_body the body of the command
 * @return 0 when success, -1 when failure happens
 */
public static native int MXKVStoreSendCommmandToServers(KVStoreHandle handle,
                                             int cmd_id,
                                             @Cast("const char*") BytePointer cmd_body);
public static native int MXKVStoreSendCommmandToServers(KVStoreHandle handle,
                                             int cmd_id,
                                             String cmd_body);

/**
 * \brief Get the number of ps dead node(s) specified by {node_id}
 *
 * @param handle handle to the KVStore
 * @param node_id Can be a node group or a single node.
 *                kScheduler = 1, kServerGroup = 2, kWorkerGroup = 4
 * @param number Ouptut number of dead nodes
 * @param timeout_sec A node fails to send heartbeart in {timeout_sec} seconds
 *                    will be presumed as 'dead'
 */
public static native int MXKVStoreGetNumDeadNode(KVStoreHandle handle,
                                      int node_id,
                                      IntPointer number,
                                      int timeout_sec/*=60*/);
public static native int MXKVStoreGetNumDeadNode(KVStoreHandle handle,
                                      int node_id,
                                      IntPointer number);
public static native int MXKVStoreGetNumDeadNode(KVStoreHandle handle,
                                      int node_id,
                                      IntBuffer number,
                                      int timeout_sec/*=60*/);
public static native int MXKVStoreGetNumDeadNode(KVStoreHandle handle,
                                      int node_id,
                                      IntBuffer number);
public static native int MXKVStoreGetNumDeadNode(KVStoreHandle handle,
                                      int node_id,
                                      int[] number,
                                      int timeout_sec/*=60*/);
public static native int MXKVStoreGetNumDeadNode(KVStoreHandle handle,
                                      int node_id,
                                      int[] number);

/**
 * \brief Create a RecordIO writer object
 * @param uri path to file
 * @param out handle pointer to the created object
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOWriterCreate(@Cast("const char*") BytePointer uri, PointerPointer out);
public static native int MXRecordIOWriterCreate(String uri, @Cast("RecordIOHandle*") @ByPtrPtr RecordIOHandle out);

/**
 * \brief Delete a RecordIO writer object
 * @param handle handle to RecordIO object
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOWriterFree(RecordIOHandle handle);

/**
 * \brief Write a record to a RecordIO object
 * @param handle handle to RecordIO object
 * @param buf buffer to write
 * @param size size of buffer
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOWriterWriteRecord(RecordIOHandle handle,
                                          @Cast("const char*") BytePointer buf, @Cast("size_t") long size);
public static native int MXRecordIOWriterWriteRecord(RecordIOHandle handle,
                                          String buf, @Cast("size_t") long size);

/**
 * \brief Get the current writer pointer position
 * @param handle handle to RecordIO object
 * @param pos handle to output position
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOWriterTell(RecordIOHandle handle, @Cast("size_t*") SizeTPointer pos);

/**
 * \brief Create a RecordIO reader object
 * @param uri path to file
 * @param out handle pointer to the created object
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOReaderCreate(@Cast("const char*") BytePointer uri, PointerPointer out);
public static native int MXRecordIOReaderCreate(String uri, @Cast("RecordIOHandle*") @ByPtrPtr RecordIOHandle out);

/**
 * \brief Delete a RecordIO reader object
 * @param handle handle to RecordIO object
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOReaderFree(RecordIOHandle handle);

/**
 * \brief Write a record to a RecordIO object
 * @param handle handle to RecordIO object
 * @param buf pointer to return buffer
 * @param size point to size of buffer
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOReaderReadRecord(RecordIOHandle handle,
                                        @Cast("const char**") PointerPointer buf, @Cast("size_t*") SizeTPointer size);
public static native int MXRecordIOReaderReadRecord(RecordIOHandle handle,
                                        @Cast("const char**") @ByPtrPtr BytePointer buf, @Cast("size_t*") SizeTPointer size);
public static native int MXRecordIOReaderReadRecord(RecordIOHandle handle,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer buf, @Cast("size_t*") SizeTPointer size);
public static native int MXRecordIOReaderReadRecord(RecordIOHandle handle,
                                        @Cast("const char**") @ByPtrPtr byte[] buf, @Cast("size_t*") SizeTPointer size);

/**
 * \brief Set the current reader pointer position
 * @param handle handle to RecordIO object
 * @param pos target position
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOReaderSeek(RecordIOHandle handle, @Cast("size_t") long pos);

/**
 * \brief Get the current writer pointer position
 * @param handle handle to RecordIO object
 * @param pos handle to output position
 * @return 0 when success, -1 when failure happens
*/
public static native int MXRecordIOReaderTell(RecordIOHandle handle, @Cast("size_t*") SizeTPointer pos);

/**
 * \brief Create a MXRtc object
*/
public static native int MXRtcCreate(@Cast("char*") BytePointer name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") PointerPointer input_names, @Cast("char**") PointerPointer output_names,
                          PointerPointer inputs, PointerPointer outputs,
                          @Cast("char*") BytePointer kernel, PointerPointer out);
public static native int MXRtcCreate(@Cast("char*") BytePointer name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") @ByPtrPtr BytePointer input_names, @Cast("char**") @ByPtrPtr BytePointer output_names,
                          PointerPointer inputs, PointerPointer outputs,
                          @Cast("char*") BytePointer kernel, PointerPointer out);
public static native int MXRtcCreate(@Cast("char*") ByteBuffer name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") @ByPtrPtr ByteBuffer input_names, @Cast("char**") @ByPtrPtr ByteBuffer output_names,
                          @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outputs,
                          @Cast("char*") ByteBuffer kernel, @Cast("RtcHandle*") @ByPtrPtr RtcHandle out);
public static native int MXRtcCreate(@Cast("char*") byte[] name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") @ByPtrPtr byte[] input_names, @Cast("char**") @ByPtrPtr byte[] output_names,
                          PointerPointer inputs, PointerPointer outputs,
                          @Cast("char*") byte[] kernel, PointerPointer out);
public static native int MXRtcCreate(@Cast("char*") BytePointer name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") @ByPtrPtr BytePointer input_names, @Cast("char**") @ByPtrPtr BytePointer output_names,
                          @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outputs,
                          @Cast("char*") BytePointer kernel, @Cast("RtcHandle*") @ByPtrPtr RtcHandle out);
public static native int MXRtcCreate(@Cast("char*") ByteBuffer name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") @ByPtrPtr ByteBuffer input_names, @Cast("char**") @ByPtrPtr ByteBuffer output_names,
                          PointerPointer inputs, PointerPointer outputs,
                          @Cast("char*") ByteBuffer kernel, PointerPointer out);
public static native int MXRtcCreate(@Cast("char*") byte[] name, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                          @Cast("char**") @ByPtrPtr byte[] input_names, @Cast("char**") @ByPtrPtr byte[] output_names,
                          @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outputs,
                          @Cast("char*") byte[] kernel, @Cast("RtcHandle*") @ByPtrPtr RtcHandle out);

/**
 * \brief Run cuda kernel
*/
public static native int MXRtcPush(RtcHandle handle, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                        PointerPointer inputs, PointerPointer outputs,
                        @Cast("uint32_t") int gridDimX,
                        @Cast("uint32_t") int gridDimY,
                        @Cast("uint32_t") int gridDimZ,
                        @Cast("uint32_t") int blockDimX,
                        @Cast("uint32_t") int blockDimY,
                        @Cast("uint32_t") int blockDimZ);
public static native int MXRtcPush(RtcHandle handle, @Cast("uint32_t") int num_input, @Cast("uint32_t") int num_output,
                        @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outputs,
                        @Cast("uint32_t") int gridDimX,
                        @Cast("uint32_t") int gridDimY,
                        @Cast("uint32_t") int gridDimZ,
                        @Cast("uint32_t") int blockDimX,
                        @Cast("uint32_t") int blockDimY,
                        @Cast("uint32_t") int blockDimZ);

/**
 * \brief Delete a MXRtc object
*/
public static native int MXRtcFree(RtcHandle handle);
/*
 * \brief register custom operators from frontend.
 * \param op_type name of custom op
 * \param creator
 */
public static native int MXCustomOpRegister(@Cast("const char*") BytePointer op_type, CustomOpPropCreator creator);
public static native int MXCustomOpRegister(String op_type, CustomOpPropCreator creator);
/*
 * \brief record custom function for backward later.
 * \param num_inputs number of input NDArrays.
 * \param inputs handle to input NDArrays.
 * \param num_outputs number of output NDArrays.
 * \param outputs handle to output NDArrays.
 * \param callbacks callbacks for backward function.
 */
public static native int MXCustomFunctionRecord(int num_inputs, PointerPointer inputs,
                                     int num_outputs, PointerPointer outputs,
                                     MXCallbackList callbacks);
public static native int MXCustomFunctionRecord(int num_inputs, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle inputs,
                                     int num_outputs, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle outputs,
                                     MXCallbackList callbacks);
/*
 * \brief create cuda rtc module
 * \param source cuda source code
 * \param num_options number of compiler flags
 * \param options compiler flags
 * \param num_exports number of exported function names
 * \param exported function names
 * \param out handle to created module
 */
public static native int MXRtcCudaModuleCreate(@Cast("const char*") BytePointer source, int num_options,
                                    @Cast("const char**") PointerPointer options, int num_exports,
                                    @Cast("const char**") PointerPointer exports, @ByPtrPtr CudaModuleHandle out);
public static native int MXRtcCudaModuleCreate(@Cast("const char*") BytePointer source, int num_options,
                                    @Cast("const char**") @ByPtrPtr BytePointer options, int num_exports,
                                    @Cast("const char**") @ByPtrPtr BytePointer exports, @ByPtrPtr CudaModuleHandle out);
public static native int MXRtcCudaModuleCreate(String source, int num_options,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer options, int num_exports,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer exports, @ByPtrPtr CudaModuleHandle out);
public static native int MXRtcCudaModuleCreate(@Cast("const char*") BytePointer source, int num_options,
                                    @Cast("const char**") @ByPtrPtr byte[] options, int num_exports,
                                    @Cast("const char**") @ByPtrPtr byte[] exports, @ByPtrPtr CudaModuleHandle out);
public static native int MXRtcCudaModuleCreate(String source, int num_options,
                                    @Cast("const char**") @ByPtrPtr BytePointer options, int num_exports,
                                    @Cast("const char**") @ByPtrPtr BytePointer exports, @ByPtrPtr CudaModuleHandle out);
public static native int MXRtcCudaModuleCreate(@Cast("const char*") BytePointer source, int num_options,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer options, int num_exports,
                                    @Cast("const char**") @ByPtrPtr ByteBuffer exports, @ByPtrPtr CudaModuleHandle out);
public static native int MXRtcCudaModuleCreate(String source, int num_options,
                                    @Cast("const char**") @ByPtrPtr byte[] options, int num_exports,
                                    @Cast("const char**") @ByPtrPtr byte[] exports, @ByPtrPtr CudaModuleHandle out);
/*
 * \brief delete cuda rtc module
 * \param handle handle to cuda module
 */
public static native int MXRtcCudaModuleFree(CudaModuleHandle handle);
/*
 * \brief get kernel from module
 * \param handle handle to cuda module
 * \param name name of kernel function
 * \param num_args number of arguments
 * \param is_ndarray whether argument is ndarray
 * \param is_const whether argument is constant
 * \param arg_types data type of arguments
 * \param out created kernel
 */
public static native int MXRtcCudaKernelCreate(CudaModuleHandle handle, @Cast("const char*") BytePointer name,
                                    int num_args, IntPointer is_ndarray, IntPointer is_const,
                                    IntPointer arg_types, @ByPtrPtr CudaKernelHandle out);
public static native int MXRtcCudaKernelCreate(CudaModuleHandle handle, String name,
                                    int num_args, IntBuffer is_ndarray, IntBuffer is_const,
                                    IntBuffer arg_types, @ByPtrPtr CudaKernelHandle out);
public static native int MXRtcCudaKernelCreate(CudaModuleHandle handle, @Cast("const char*") BytePointer name,
                                    int num_args, int[] is_ndarray, int[] is_const,
                                    int[] arg_types, @ByPtrPtr CudaKernelHandle out);
public static native int MXRtcCudaKernelCreate(CudaModuleHandle handle, String name,
                                    int num_args, IntPointer is_ndarray, IntPointer is_const,
                                    IntPointer arg_types, @ByPtrPtr CudaKernelHandle out);
public static native int MXRtcCudaKernelCreate(CudaModuleHandle handle, @Cast("const char*") BytePointer name,
                                    int num_args, IntBuffer is_ndarray, IntBuffer is_const,
                                    IntBuffer arg_types, @ByPtrPtr CudaKernelHandle out);
public static native int MXRtcCudaKernelCreate(CudaModuleHandle handle, String name,
                                    int num_args, int[] is_ndarray, int[] is_const,
                                    int[] arg_types, @ByPtrPtr CudaKernelHandle out);
/*
 * \brief delete kernel
 * \param handle handle to previously created kernel
 */
public static native int MXRtcCudaKernelFree(CudaKernelHandle handle);
/*
 * \brief launch cuda kernel
 * \param handle handle to kernel
 * \param dev_id (GPU) device id
 * \param args pointer to arguments
 * \param grid_dim_x grid dimension x
 * \param grid_dim_y grid dimension y
 * \param grid_dim_z grid dimension z
 * \param block_dim_x block dimension x
 * \param block_dim_y block dimension y
 * \param block_dim_z block dimension z
 * \param shared_mem size of dynamically allocated shared memory
 */
public static native int MXRtcCudaKernelCall(CudaKernelHandle handle, int dev_id, @Cast("void**") PointerPointer args,
                                  @Cast("uint32_t") int grid_dim_x, @Cast("uint32_t") int grid_dim_y,
                                  @Cast("uint32_t") int grid_dim_z, @Cast("uint32_t") int block_dim_x,
                                  @Cast("uint32_t") int block_dim_y, @Cast("uint32_t") int block_dim_z,
                                  @Cast("uint32_t") int shared_mem);
public static native int MXRtcCudaKernelCall(CudaKernelHandle handle, int dev_id, @Cast("void**") @ByPtrPtr Pointer args,
                                  @Cast("uint32_t") int grid_dim_x, @Cast("uint32_t") int grid_dim_y,
                                  @Cast("uint32_t") int grid_dim_z, @Cast("uint32_t") int block_dim_x,
                                  @Cast("uint32_t") int block_dim_y, @Cast("uint32_t") int block_dim_z,
                                  @Cast("uint32_t") int shared_mem);
/**
 * \brief Get shared memory handle from NDArray
 * @param handle NDArray handle.
 * @param shared_pid output PID
 * @param shared_id output shared memory id.
 */
public static native int MXNDArrayGetSharedMemHandle(NDArrayHandle handle, IntPointer shared_pid,
                                          IntPointer shared_id);
public static native int MXNDArrayGetSharedMemHandle(NDArrayHandle handle, IntBuffer shared_pid,
                                          IntBuffer shared_id);
public static native int MXNDArrayGetSharedMemHandle(NDArrayHandle handle, int[] shared_pid,
                                          int[] shared_id);
/**
 * \brief DEPRECATED. Use MXNDArrayCreateFromSharedMemEx instead.
 * Reconstruct NDArray from shared memory handle
 * @param shared_pid shared PID
 * @param shared_id shared memory id
 * @param shape pointer to NDArray dimensions
 * @param ndim number of NDArray dimensions
 * @param dtype data type of NDArray
 * @param out constructed NDArray
 */
public static native int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, @Cast("const uint32_t*") IntPointer shape,
                                           @Cast("uint32_t") int ndim, int dtype, PointerPointer out);
public static native int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, @Cast("const uint32_t*") IntBuffer shape,
                                           @Cast("uint32_t") int ndim, int dtype, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, @Cast("const uint32_t*") int[] shape,
                                           @Cast("uint32_t") int ndim, int dtype, PointerPointer out);
public static native int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, @Cast("const uint32_t*") IntPointer shape,
                                           @Cast("uint32_t") int ndim, int dtype, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, @Cast("const uint32_t*") IntBuffer shape,
                                           @Cast("uint32_t") int ndim, int dtype, PointerPointer out);
public static native int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, @Cast("const uint32_t*") int[] shape,
                                           @Cast("uint32_t") int ndim, int dtype, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
 * \brief Release all unreferenced memory from the devices storage managers memory pool
 * @param dev_type device type, specify device we want to take
 * @param dev_id the device id of the specific device
 */
public static native int MXStorageEmptyCache(int dev_type, int dev_id);

/**
 * \brief Reconstruct NDArray from shared memory handle
 * @param shared_pid shared PID
 * @param shared_id shared memory id
 * @param shape pointer to NDArray dimensions
 * @param ndim number of NDArray dimensions
 * @param dtype data type of NDArray
 * @param out constructed NDArray
 */
public static native int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, @Const IntPointer shape,
                                             int ndim, int dtype, PointerPointer out);
public static native int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, @Const IntBuffer shape,
                                             int ndim, int dtype, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, @Const int[] shape,
                                             int ndim, int dtype, PointerPointer out);
public static native int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, @Const IntPointer shape,
                                             int ndim, int dtype, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
public static native int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, @Const IntBuffer shape,
                                             int ndim, int dtype, PointerPointer out);
public static native int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, @Const int[] shape,
                                             int ndim, int dtype, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);

/**
  * \brief Push an asynchronous operation to the engine.
  * @param async_func Execution function whici takes a parameter on_complete
  *                   that must be called when the execution ompletes.
  * @param func_param The parameter set on calling async_func, can be NULL.
  * @param deleter The callback to free func_param, can be NULL.
  * @param ctx_handle Execution context.
  * @param const_vars_handle The variables that current operation will use
  *                          but not mutate.
  * @param num_const_vars The number of const_vars_handle.
  * @param mutable_vars_handle The variables that current operation will mutate.
  * @param num_mutable_vars The number of mutable_vars_handle.
  * @param prop_handle Property of the function.
  * @param priority Priority of the action, as hint to the engine.
  * @param opr_name The operation name.
  * @param wait Whether this is a WaitForVar operation.
  */
public static native int MXEnginePushAsync(EngineAsyncFunc async_func, Pointer func_param,
                                EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                EngineVarHandle const_vars_handle, int num_const_vars,
                                EngineVarHandle mutable_vars_handle, int num_mutable_vars,
                                EngineFnPropertyHandle prop_handle/*=NULL*/,
                                int priority/*=0*/, @Cast("const char*") BytePointer opr_name/*=NULL*/,
                                @Cast("bool") boolean _wait/*=false*/);
public static native int MXEnginePushAsync(EngineAsyncFunc async_func, Pointer func_param,
                                EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                EngineVarHandle const_vars_handle, int num_const_vars,
                                EngineVarHandle mutable_vars_handle, int num_mutable_vars);
public static native int MXEnginePushAsync(EngineAsyncFunc async_func, Pointer func_param,
                                EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                EngineVarHandle const_vars_handle, int num_const_vars,
                                EngineVarHandle mutable_vars_handle, int num_mutable_vars,
                                EngineFnPropertyHandle prop_handle/*=NULL*/,
                                int priority/*=0*/, String opr_name/*=NULL*/,
                                @Cast("bool") boolean _wait/*=false*/);

/**
  * \brief Push a synchronous operation to the engine.
  * @param sync_func Execution function that executes the operation.
  * @param func_param The parameter set on calling sync_func, can be NULL.
  * @param deleter The callback to free func_param, can be NULL.
  * @param ctx_handle Execution context.
  * @param const_vars_handle The variables that current operation will use
  *                          but not mutate.
  * @param num_const_vars The number of const_vars_handle.
  * @param mutable_vars_handle The variables that current operation will mutate.
  * @param num_mutable_vars The number of mutable_vars_handle.
  * @param prop_handle Property of the function.
  * @param priority Priority of the action, as hint to the engine.
  * @param opr_name The operation name.
  */
public static native int MXEnginePushSync(EngineSyncFunc sync_func, Pointer func_param,
                               EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                               EngineVarHandle const_vars_handle, int num_const_vars,
                               EngineVarHandle mutable_vars_handle, int num_mutable_vars,
                               EngineFnPropertyHandle prop_handle/*=NULL*/,
                               int priority/*=0*/, @Cast("const char*") BytePointer opr_name/*=NULL*/);
public static native int MXEnginePushSync(EngineSyncFunc sync_func, Pointer func_param,
                               EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                               EngineVarHandle const_vars_handle, int num_const_vars,
                               EngineVarHandle mutable_vars_handle, int num_mutable_vars);
public static native int MXEnginePushSync(EngineSyncFunc sync_func, Pointer func_param,
                               EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                               EngineVarHandle const_vars_handle, int num_const_vars,
                               EngineVarHandle mutable_vars_handle, int num_mutable_vars,
                               EngineFnPropertyHandle prop_handle/*=NULL*/,
                               int priority/*=0*/, String opr_name/*=NULL*/);
/**
 * \brief Create an NDArray from source sharing the same data chunk.
 * @param src source NDArray
 * @param out new NDArray sharing the same data chunck with src
 */
public static native int MXShallowCopyNDArray(NDArrayHandle src, PointerPointer out);
public static native int MXShallowCopyNDArray(NDArrayHandle src, @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle out);
/**
 * \brief Create an Symbol from source sharing the same graph structure.
 * @param src source Symbol
 * @param out new Symbol sharing the same graph structure with src
 */
public static native int MXShallowCopySymbol(SymbolHandle src, PointerPointer out);
public static native int MXShallowCopySymbol(SymbolHandle src, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);

/**
  * \brief Push an asynchronous operation to the engine.
  * @param async_func Execution function whici takes a parameter on_complete
  *                   that must be called when the execution ompletes.
  * @param func_param The parameter set on calling async_func, can be NULL.
  * @param deleter The callback to free func_param, can be NULL.
  * @param ctx_handle Execution context.
  * @param const_nds_handle The NDArrays that current operation will use
  *                          but not mutate.
  * @param num_const_nds The number of const_nds_handle.
  * @param mutable_nds_handle The NDArrays that current operation will mutate.
  * @param num_mutable_nds The number of mutable_nds_handle.
  * @param prop_handle Property of the function.
  * @param priority Priority of the action, as hint to the engine.
  * @param opr_name The operation name.
  * @param wait Whether this is a WaitForVar operation.
  */
public static native int MXEnginePushAsyncND(EngineAsyncFunc async_func, Pointer func_param,
                                  EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                  PointerPointer const_nds_handle, int num_const_nds,
                                  PointerPointer mutable_nds_handle, int num_mutable_nds,
                                  EngineFnPropertyHandle prop_handle/*=NULL*/,
                                  int priority/*=0*/, @Cast("const char*") BytePointer opr_name/*=NULL*/,
                                  @Cast("bool") boolean _wait/*=false*/);
public static native int MXEnginePushAsyncND(EngineAsyncFunc async_func, Pointer func_param,
                                  EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                  PointerPointer const_nds_handle, int num_const_nds,
                                  PointerPointer mutable_nds_handle, int num_mutable_nds);
public static native int MXEnginePushAsyncND(EngineAsyncFunc async_func, Pointer func_param,
                                  EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle const_nds_handle, int num_const_nds,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutable_nds_handle, int num_mutable_nds,
                                  EngineFnPropertyHandle prop_handle/*=NULL*/,
                                  int priority/*=0*/, String opr_name/*=NULL*/,
                                  @Cast("bool") boolean _wait/*=false*/);
public static native int MXEnginePushAsyncND(EngineAsyncFunc async_func, Pointer func_param,
                                  EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle const_nds_handle, int num_const_nds,
                                  @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutable_nds_handle, int num_mutable_nds);

/**
  * \brief Push a synchronous operation to the engine.
  * @param sync_func Execution function that executes the operation.
  * @param func_param The parameter set on calling sync_func, can be NULL.
  * @param deleter The callback to free func_param, can be NULL.
  * @param ctx_handle Execution context.
  * @param const_nds_handle The NDArrays that current operation will use
  *                          but not mutate.
  * @param num_const_nds The number of const_nds_handle.
  * @param mutable_nds_handle The NDArrays that current operation will mutate.
  * @param num_mutable_nds The number of mutable_nds_handle.
  * @param prop_handle Property of the function.
  * @param priority Priority of the action, as hint to the engine.
  * @param opr_name The operation name.
  */
public static native int MXEnginePushSyncND(EngineSyncFunc sync_func, Pointer func_param,
                                 EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                 PointerPointer const_nds_handle, int num_const_nds,
                                 PointerPointer mutable_nds_handle, int num_mutable_nds,
                                 EngineFnPropertyHandle prop_handle/*=NULL*/,
                                 int priority/*=0*/, @Cast("const char*") BytePointer opr_name/*=NULL*/);
public static native int MXEnginePushSyncND(EngineSyncFunc sync_func, Pointer func_param,
                                 EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                 PointerPointer const_nds_handle, int num_const_nds,
                                 PointerPointer mutable_nds_handle, int num_mutable_nds);
public static native int MXEnginePushSyncND(EngineSyncFunc sync_func, Pointer func_param,
                                 EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle const_nds_handle, int num_const_nds,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutable_nds_handle, int num_mutable_nds,
                                 EngineFnPropertyHandle prop_handle/*=NULL*/,
                                 int priority/*=0*/, String opr_name/*=NULL*/);
public static native int MXEnginePushSyncND(EngineSyncFunc sync_func, Pointer func_param,
                                 EngineFuncParamDeleter deleter, ContextHandle ctx_handle,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle const_nds_handle, int num_const_nds,
                                 @Cast("NDArrayHandle*") @ByPtrPtr NDArrayHandle mutable_nds_handle, int num_mutable_nds);

// #ifdef __cplusplus
// #endif  // __cplusplus

// #endif  // MXNET_C_API_H_


// Parsed from mxnet/c_predict_api.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 *  Copyright (c) 2015 by Contributors
 * \file c_predict_api.h
 * \brief C predict API of mxnet, contains a minimum API to run prediction.
 *  This file is self-contained, and do not dependent on any other files.
 */
// #ifndef MXNET_C_PREDICT_API_H_
// #define MXNET_C_PREDICT_API_H_

/** \brief Inhibit C++ name-mangling for MXNet functions. */
// #ifdef __cplusplus
// #endif  // __cplusplus

// #ifdef _WIN32
// #ifdef MXNET_EXPORTS
// #define MXNET_DLL __declspec(dllexport)
// #else
// #define MXNET_DLL __declspec(dllimport)
// #endif
// #else
// #define MXNET_DLL
// #endif

/** \brief manually define unsigned int */
/** \brief manually define float */
// Targeting ..\PredictorHandle.java


// Targeting ..\NDListHandle.java


// Targeting ..\NDArrayHandle.java


// Targeting ..\PredMonitorCallback.java



/**
 * \brief Get the last error happeneed.
 * @return The last error happened at the predictor.
 */

/**
 * \brief create a predictor
 * @param symbol_json_str The JSON string of the symbol.
 * @param param_bytes The in-memory raw bytes of parameter ndarray file.
 * @param param_size The size of parameter ndarray file.
 * @param dev_type The device type, 1: cpu, 2:gpu
 * @param dev_id The device id of the predictor.
 * @param num_input_nodes Number of input nodes to the net,
 *    For feedforward net, this is 1.
 * @param input_keys The name of input argument.
 *    For feedforward net, this is {"data"}
 * @param input_shape_indptr Index pointer of shapes of each input node.
 *    The length of this array = num_input_nodes + 1.
 *    For feedforward net that takes 4 dimensional input, this is {0, 4}.
 * @param input_shape_data A flattened data of shapes of each input node.
 *    For feedforward net that takes 4 dimensional input, this is the shape data.
 * @param out The created predictor handle.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredCreate(@Cast("const char*") BytePointer symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") PointerPointer input_keys,
                           @Cast("const uint32_t*") IntPointer input_shape_indptr,
                           @Cast("const uint32_t*") IntPointer input_shape_data,
                           PointerPointer out);
public static native int MXPredCreate(@Cast("const char*") BytePointer symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                           @Cast("const uint32_t*") IntPointer input_shape_indptr,
                           @Cast("const uint32_t*") IntPointer input_shape_data,
                           PointerPointer out);
public static native int MXPredCreate(String symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                           @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                           @Cast("const uint32_t*") IntBuffer input_shape_data,
                           @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreate(@Cast("const char*") BytePointer symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") @ByPtrPtr byte[] input_keys,
                           @Cast("const uint32_t*") int[] input_shape_indptr,
                           @Cast("const uint32_t*") int[] input_shape_data,
                           PointerPointer out);
public static native int MXPredCreate(String symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                           @Cast("const uint32_t*") IntPointer input_shape_indptr,
                           @Cast("const uint32_t*") IntPointer input_shape_data,
                           @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreate(@Cast("const char*") BytePointer symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                           @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                           @Cast("const uint32_t*") IntBuffer input_shape_data,
                           PointerPointer out);
public static native int MXPredCreate(String symbol_json_str,
                           @Const Pointer param_bytes,
                           int param_size,
                           int dev_type, int dev_id,
                           @Cast("uint32_t") int num_input_nodes,
                           @Cast("const char**") @ByPtrPtr byte[] input_keys,
                           @Cast("const uint32_t*") int[] input_shape_indptr,
                           @Cast("const uint32_t*") int[] input_shape_data,
                           @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);

/**
 * \brief create a predictor
 * @param symbol_json_str The JSON string of the symbol.
 * @param param_bytes The in-memory raw bytes of parameter ndarray file.
 * @param param_size The size of parameter ndarray file.
 * @param dev_type The device type, 1: cpu, 2: gpu
 * @param dev_id The device id of the predictor.
 * @param num_input_nodes Number of input nodes to the net.
 *    For feedforward net, this is 1.
 * @param input_keys The name of the input argument.
 *    For feedforward net, this is {"data"}
 * @param input_shape_indptr Index pointer of shapes of each input node.
 *    The length of this array = num_input_nodes + 1.
 *    For feedforward net that takes 4 dimensional input, this is {0, 4}.
 * @param input_shape_data A flattened data of shapes of each input node.
 *    For feedforward net that takes 4 dimensional input, this is the shape data.
 * @param num_provided_arg_dtypes
 *    The length of provided_arg_dtypes.
 * @param provided_arg_dtype_names
 *    The provided_arg_dtype_names the names of args for which dtypes are provided.
 * @param provided_arg_dtypes
 *    The provided_arg_dtypes the dtype provided
 * @param out The created predictor handle.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredCreateEx(@Cast("const char*") BytePointer symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") PointerPointer input_keys,
                             @Cast("const uint32_t*") IntPointer input_shape_indptr,
                             @Cast("const uint32_t*") IntPointer input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") PointerPointer provided_arg_dtype_names,
                             @Const IntPointer provided_arg_dtypes,
                             PointerPointer out);
public static native int MXPredCreateEx(@Cast("const char*") BytePointer symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                             @Cast("const uint32_t*") IntPointer input_shape_indptr,
                             @Cast("const uint32_t*") IntPointer input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                             @Const IntPointer provided_arg_dtypes,
                             PointerPointer out);
public static native int MXPredCreateEx(String symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                             @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                             @Cast("const uint32_t*") IntBuffer input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                             @Const IntBuffer provided_arg_dtypes,
                             @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreateEx(@Cast("const char*") BytePointer symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") @ByPtrPtr byte[] input_keys,
                             @Cast("const uint32_t*") int[] input_shape_indptr,
                             @Cast("const uint32_t*") int[] input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                             @Const int[] provided_arg_dtypes,
                             PointerPointer out);
public static native int MXPredCreateEx(String symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                             @Cast("const uint32_t*") IntPointer input_shape_indptr,
                             @Cast("const uint32_t*") IntPointer input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") @ByPtrPtr BytePointer provided_arg_dtype_names,
                             @Const IntPointer provided_arg_dtypes,
                             @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreateEx(@Cast("const char*") BytePointer symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                             @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                             @Cast("const uint32_t*") IntBuffer input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") @ByPtrPtr ByteBuffer provided_arg_dtype_names,
                             @Const IntBuffer provided_arg_dtypes,
                             PointerPointer out);
public static native int MXPredCreateEx(String symbol_json_str,
                             @Const Pointer param_bytes,
                             int param_size,
                             int dev_type, int dev_id,
                             @Cast("const uint32_t") int num_input_nodes,
                             @Cast("const char**") @ByPtrPtr byte[] input_keys,
                             @Cast("const uint32_t*") int[] input_shape_indptr,
                             @Cast("const uint32_t*") int[] input_shape_data,
                             @Cast("const uint32_t") int num_provided_arg_dtypes,
                             @Cast("const char**") @ByPtrPtr byte[] provided_arg_dtype_names,
                             @Const int[] provided_arg_dtypes,
                             @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);

/**
 * \brief create a predictor wich customized outputs
 * @param symbol_json_str The JSON string of the symbol.
 * @param param_bytes The in-memory raw bytes of parameter ndarray file.
 * @param param_size The size of parameter ndarray file.
 * @param dev_type The device type, 1: cpu, 2:gpu
 * @param dev_id The device id of the predictor.
 * @param num_input_nodes Number of input nodes to the net,
 *    For feedforward net, this is 1.
 * @param input_keys The name of input argument.
 *    For feedforward net, this is {"data"}
 * @param input_shape_indptr Index pointer of shapes of each input node.
 *    The length of this array = num_input_nodes + 1.
 *    For feedforward net that takes 4 dimensional input, this is {0, 4}.
 * @param input_shape_data A flattened data of shapes of each input node.
 *    For feedforward net that takes 4 dimensional input, this is the shape data.
 * @param num_output_nodes Number of output nodes to the net,
 * @param output_keys The name of output argument.
 *    For example {"global_pool"}
 * @param out The created predictor handle.
 * @return 0 when success, -1 when failure.
 */

public static native int MXPredCreatePartialOut(@Cast("const char*") BytePointer symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") PointerPointer input_keys,
                                     @Cast("const uint32_t*") IntPointer input_shape_indptr,
                                     @Cast("const uint32_t*") IntPointer input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") PointerPointer output_keys,
                                     PointerPointer out);
public static native int MXPredCreatePartialOut(@Cast("const char*") BytePointer symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                                     @Cast("const uint32_t*") IntPointer input_shape_indptr,
                                     @Cast("const uint32_t*") IntPointer input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") @ByPtrPtr BytePointer output_keys,
                                     PointerPointer out);
public static native int MXPredCreatePartialOut(String symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                                     @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                                     @Cast("const uint32_t*") IntBuffer input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer output_keys,
                                     @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreatePartialOut(@Cast("const char*") BytePointer symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") @ByPtrPtr byte[] input_keys,
                                     @Cast("const uint32_t*") int[] input_shape_indptr,
                                     @Cast("const uint32_t*") int[] input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") @ByPtrPtr byte[] output_keys,
                                     PointerPointer out);
public static native int MXPredCreatePartialOut(String symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                                     @Cast("const uint32_t*") IntPointer input_shape_indptr,
                                     @Cast("const uint32_t*") IntPointer input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") @ByPtrPtr BytePointer output_keys,
                                     @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreatePartialOut(@Cast("const char*") BytePointer symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                                     @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                                     @Cast("const uint32_t*") IntBuffer input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") @ByPtrPtr ByteBuffer output_keys,
                                     PointerPointer out);
public static native int MXPredCreatePartialOut(String symbol_json_str,
                                     @Const Pointer param_bytes,
                                     int param_size,
                                     int dev_type, int dev_id,
                                     @Cast("uint32_t") int num_input_nodes,
                                     @Cast("const char**") @ByPtrPtr byte[] input_keys,
                                     @Cast("const uint32_t*") int[] input_shape_indptr,
                                     @Cast("const uint32_t*") int[] input_shape_data,
                                     @Cast("uint32_t") int num_output_nodes,
                                     @Cast("const char**") @ByPtrPtr byte[] output_keys,
                                     @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);

/**
 * \brief create predictors for multiple threads. One predictor for a thread.
 * @param symbol_json_str The JSON string of the symbol.
 * @param param_bytes The in-memory raw bytes of parameter ndarray file.
 * @param param_size The size of parameter ndarray file.
 * @param dev_type The device type, 1: cpu, 2:gpu
 * @param dev_id The device id of the predictor.
 * @param num_input_nodes Number of input nodes to the net,
 *    For feedforward net, this is 1.
 * @param input_keys The name of input argument.
 *    For feedforward net, this is {"data"}
 * @param input_shape_indptr Index pointer of shapes of each input node.
 *    The length of this array = num_input_nodes + 1.
 *    For feedforward net that takes 4 dimensional input, this is {0, 4}.
 * @param input_shape_data A flattened data of shapes of each input node.
 *    For feedforward net that takes 4 dimensional input, this is the shape data.
 * @param num_threads The number of threads that we'll run the predictors.
 * @param out An array of created predictor handles. The array has to be large
 *   enough to keep {@code num_threads} predictors.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredCreateMultiThread(@Cast("const char*") BytePointer symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") PointerPointer input_keys,
                                      @Cast("const uint32_t*") IntPointer input_shape_indptr,
                                      @Cast("const uint32_t*") IntPointer input_shape_data,
                                      int num_threads,
                                      PointerPointer out);
public static native int MXPredCreateMultiThread(@Cast("const char*") BytePointer symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                                      @Cast("const uint32_t*") IntPointer input_shape_indptr,
                                      @Cast("const uint32_t*") IntPointer input_shape_data,
                                      int num_threads,
                                      PointerPointer out);
public static native int MXPredCreateMultiThread(String symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                                      @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                                      @Cast("const uint32_t*") IntBuffer input_shape_data,
                                      int num_threads,
                                      @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreateMultiThread(@Cast("const char*") BytePointer symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") @ByPtrPtr byte[] input_keys,
                                      @Cast("const uint32_t*") int[] input_shape_indptr,
                                      @Cast("const uint32_t*") int[] input_shape_data,
                                      int num_threads,
                                      PointerPointer out);
public static native int MXPredCreateMultiThread(String symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                                      @Cast("const uint32_t*") IntPointer input_shape_indptr,
                                      @Cast("const uint32_t*") IntPointer input_shape_data,
                                      int num_threads,
                                      @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredCreateMultiThread(@Cast("const char*") BytePointer symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                                      @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                                      @Cast("const uint32_t*") IntBuffer input_shape_data,
                                      int num_threads,
                                      PointerPointer out);
public static native int MXPredCreateMultiThread(String symbol_json_str,
                                      @Const Pointer param_bytes,
                                      int param_size,
                                      int dev_type, int dev_id,
                                      @Cast("uint32_t") int num_input_nodes,
                                      @Cast("const char**") @ByPtrPtr byte[] input_keys,
                                      @Cast("const uint32_t*") int[] input_shape_indptr,
                                      @Cast("const uint32_t*") int[] input_shape_data,
                                      int num_threads,
                                      @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);

/**
 * \brief Change the input shape of an existing predictor.
 * @param num_input_nodes Number of input nodes to the net,
 *    For feedforward net, this is 1.
 * @param input_keys The name of input argument.
 *    For feedforward net, this is {"data"}
 * @param input_shape_indptr Index pointer of shapes of each input node.
 *    The length of this array = num_input_nodes + 1.
 *    For feedforward net that takes 4 dimensional input, this is {0, 4}.
 * @param input_shape_data A flattened data of shapes of each input node.
 *    For feedforward net that takes 4 dimensional input, this is the shape data.
 * @param handle The original predictor handle.
 * @param out The reshaped predictor handle.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") PointerPointer input_keys,
                  @Cast("const uint32_t*") IntPointer input_shape_indptr,
                  @Cast("const uint32_t*") IntPointer input_shape_data,
                  PredictorHandle handle,
                  PointerPointer out);
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                  @Cast("const uint32_t*") IntPointer input_shape_indptr,
                  @Cast("const uint32_t*") IntPointer input_shape_data,
                  PredictorHandle handle,
                  PointerPointer out);
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                  @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                  @Cast("const uint32_t*") IntBuffer input_shape_data,
                  PredictorHandle handle,
                  @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") @ByPtrPtr byte[] input_keys,
                  @Cast("const uint32_t*") int[] input_shape_indptr,
                  @Cast("const uint32_t*") int[] input_shape_data,
                  PredictorHandle handle,
                  PointerPointer out);
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") @ByPtrPtr BytePointer input_keys,
                  @Cast("const uint32_t*") IntPointer input_shape_indptr,
                  @Cast("const uint32_t*") IntPointer input_shape_data,
                  PredictorHandle handle,
                  @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") @ByPtrPtr ByteBuffer input_keys,
                  @Cast("const uint32_t*") IntBuffer input_shape_indptr,
                  @Cast("const uint32_t*") IntBuffer input_shape_data,
                  PredictorHandle handle,
                  PointerPointer out);
public static native int MXPredReshape(@Cast("uint32_t") int num_input_nodes,
                  @Cast("const char**") @ByPtrPtr byte[] input_keys,
                  @Cast("const uint32_t*") int[] input_shape_indptr,
                  @Cast("const uint32_t*") int[] input_shape_data,
                  PredictorHandle handle,
                  @Cast("PredictorHandle*") @ByPtrPtr PredictorHandle out);
/**
 * \brief Get the shape of output node.
 *  The returned shape_data and shape_ndim is only valid before next call to MXPred function.
 * @param handle The handle of the predictor.
 * @param index The index of output node, set to 0 if there is only one output.
 * @param shape_data Used to hold pointer to the shape data
 * @param shape_ndim Used to hold shape dimension.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredGetOutputShape(PredictorHandle handle,
                                   @Cast("uint32_t") int index,
                                   @Cast("uint32_t**") PointerPointer shape_data,
                                   @Cast("uint32_t*") IntPointer shape_ndim);
public static native int MXPredGetOutputShape(PredictorHandle handle,
                                   @Cast("uint32_t") int index,
                                   @Cast("uint32_t**") @ByPtrPtr IntPointer shape_data,
                                   @Cast("uint32_t*") IntPointer shape_ndim);
public static native int MXPredGetOutputShape(PredictorHandle handle,
                                   @Cast("uint32_t") int index,
                                   @Cast("uint32_t**") @ByPtrPtr IntBuffer shape_data,
                                   @Cast("uint32_t*") IntBuffer shape_ndim);
public static native int MXPredGetOutputShape(PredictorHandle handle,
                                   @Cast("uint32_t") int index,
                                   @Cast("uint32_t**") @ByPtrPtr int[] shape_data,
                                   @Cast("uint32_t*") int[] shape_ndim);

/**
 * \brief Get the dtype of output node.
 * The returned data type is only valid before next call to MXPred function.
 * @param handle The handle of the predictor.
 * @param out_index The index of the output node, set to 0 if there is only one output.
 * @param out_dtype The dtype of the output node
 */
public static native int MXPredGetOutputType(PredictorHandle handle,
                                  @Cast("uint32_t") int out_index,
                                  IntPointer out_dtype);
public static native int MXPredGetOutputType(PredictorHandle handle,
                                  @Cast("uint32_t") int out_index,
                                  IntBuffer out_dtype);
public static native int MXPredGetOutputType(PredictorHandle handle,
                                  @Cast("uint32_t") int out_index,
                                  int[] out_dtype);

/**
 * \brief Set the input data of predictor.
 * @param handle The predictor handle.
 * @param key The name of input node to set.
 *     For feedforward net, this is "data".
 * @param data The pointer to the data to be set, with the shape specified in MXPredCreate.
 * @param size The size of data array, used for safety check.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredSetInput(PredictorHandle handle,
                             @Cast("const char*") BytePointer key,
                             @Const FloatPointer data,
                             @Cast("uint32_t") int size);
public static native int MXPredSetInput(PredictorHandle handle,
                             String key,
                             @Const FloatBuffer data,
                             @Cast("uint32_t") int size);
public static native int MXPredSetInput(PredictorHandle handle,
                             @Cast("const char*") BytePointer key,
                             @Const float[] data,
                             @Cast("uint32_t") int size);
public static native int MXPredSetInput(PredictorHandle handle,
                             String key,
                             @Const FloatPointer data,
                             @Cast("uint32_t") int size);
public static native int MXPredSetInput(PredictorHandle handle,
                             @Cast("const char*") BytePointer key,
                             @Const FloatBuffer data,
                             @Cast("uint32_t") int size);
public static native int MXPredSetInput(PredictorHandle handle,
                             String key,
                             @Const float[] data,
                             @Cast("uint32_t") int size);
/**
 * \brief Run a forward pass to get the output.
 * @param handle The handle of the predictor.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredForward(PredictorHandle handle);
/**
 * \brief Run a interactive forward pass to get the output.
 *  This is helpful for displaying progress of prediction which can be slow.
 *  User must call PartialForward from step=0, keep increasing it until step_left=0.
 * <pre>{@code
 * int step_left = 1;
 * for (int step = 0; step_left != 0; ++step) {
 *    MXPredPartialForward(handle, step, &step_left);
 *    printf("Current progress [%d/%d]\n", step, step + step_left + 1);
 * }
 * }</pre>
 * @param handle The handle of the predictor.
 * @param step The current step to run forward on.
 * @param step_left The number of steps left
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredPartialForward(PredictorHandle handle, int step, IntPointer step_left);
public static native int MXPredPartialForward(PredictorHandle handle, int step, IntBuffer step_left);
public static native int MXPredPartialForward(PredictorHandle handle, int step, int[] step_left);
/**
 * \brief Get the output value of prediction.
 * @param handle The handle of the predictor.
 * @param index The index of output node, set to 0 if there is only one output.
 * @param data User allocated data to hold the output.
 * @param size The size of data array, used for safe checking.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredGetOutput(PredictorHandle handle,
                              @Cast("uint32_t") int index,
                              FloatPointer data,
                              @Cast("uint32_t") int size);
public static native int MXPredGetOutput(PredictorHandle handle,
                              @Cast("uint32_t") int index,
                              FloatBuffer data,
                              @Cast("uint32_t") int size);
public static native int MXPredGetOutput(PredictorHandle handle,
                              @Cast("uint32_t") int index,
                              float[] data,
                              @Cast("uint32_t") int size);
/**
 * \brief Free a predictor handle.
 * @param handle The handle of the predictor.
 * @return 0 when success, -1 when failure.
 */
public static native int MXPredFree(PredictorHandle handle);
/**
 * \brief Create a NDArray List by loading from ndarray file.
 *     This can be used to load mean image file.
 * @param nd_file_bytes The byte contents of nd file to be loaded.
 * @param nd_file_size The size of the nd file to be loaded.
 * @param out The out put NDListHandle
 * @param out_length Length of the list.
 * @return 0 when success, -1 when failure.
 */
public static native int MXNDListCreate(@Cast("const char*") BytePointer nd_file_bytes,
                             int nd_file_size,
                             @ByPtrPtr NDListHandle out,
                             @Cast("uint32_t*") IntPointer out_length);
public static native int MXNDListCreate(String nd_file_bytes,
                             int nd_file_size,
                             @ByPtrPtr NDListHandle out,
                             @Cast("uint32_t*") IntBuffer out_length);
public static native int MXNDListCreate(@Cast("const char*") BytePointer nd_file_bytes,
                             int nd_file_size,
                             @ByPtrPtr NDListHandle out,
                             @Cast("uint32_t*") int[] out_length);
public static native int MXNDListCreate(String nd_file_bytes,
                             int nd_file_size,
                             @ByPtrPtr NDListHandle out,
                             @Cast("uint32_t*") IntPointer out_length);
public static native int MXNDListCreate(@Cast("const char*") BytePointer nd_file_bytes,
                             int nd_file_size,
                             @ByPtrPtr NDListHandle out,
                             @Cast("uint32_t*") IntBuffer out_length);
public static native int MXNDListCreate(String nd_file_bytes,
                             int nd_file_size,
                             @ByPtrPtr NDListHandle out,
                             @Cast("uint32_t*") int[] out_length);
/**
 * \brief Get an element from list
 * @param handle The handle to the NDArray
 * @param index The index in the list
 * @param out_key The output key of the item
 * @param out_data The data region of the item
 * @param out_shape The shape of the item.
 * @param out_ndim The number of dimension in the shape.
 * @return 0 when success, -1 when failure.
 */
public static native int MXNDListGet(NDListHandle handle,
                          @Cast("uint32_t") int index,
                          @Cast("const char**") PointerPointer out_key,
                          @Cast("const float**") PointerPointer out_data,
                          @Cast("const uint32_t**") PointerPointer out_shape,
                          @Cast("uint32_t*") IntPointer out_ndim);
public static native int MXNDListGet(NDListHandle handle,
                          @Cast("uint32_t") int index,
                          @Cast("const char**") @ByPtrPtr BytePointer out_key,
                          @Const @ByPtrPtr FloatPointer out_data,
                          @Cast("const uint32_t**") @ByPtrPtr IntPointer out_shape,
                          @Cast("uint32_t*") IntPointer out_ndim);
public static native int MXNDListGet(NDListHandle handle,
                          @Cast("uint32_t") int index,
                          @Cast("const char**") @ByPtrPtr ByteBuffer out_key,
                          @Const @ByPtrPtr FloatBuffer out_data,
                          @Cast("const uint32_t**") @ByPtrPtr IntBuffer out_shape,
                          @Cast("uint32_t*") IntBuffer out_ndim);
public static native int MXNDListGet(NDListHandle handle,
                          @Cast("uint32_t") int index,
                          @Cast("const char**") @ByPtrPtr byte[] out_key,
                          @Const @ByPtrPtr float[] out_data,
                          @Cast("const uint32_t**") @ByPtrPtr int[] out_shape,
                          @Cast("uint32_t*") int[] out_ndim);

/**
 * \brief set a call back to notify the completion of operation and allow for
 * additional monitoring
 */
public static native int MXPredSetMonitorCallback(PredictorHandle handle,
                                       PredMonitorCallback callback,
                                       Pointer callback_handle,
                                       @Cast("bool") boolean monitor_all);
/**
 * \brief Free a MXAPINDList
 * @param handle The handle of the MXAPINDList.
 * @return 0 when success, -1 when failure.
 */
public static native int MXNDListFree(NDListHandle handle);

// #ifdef __cplusplus
// #endif  // __cplusplus

// #endif  // MXNET_C_PREDICT_API_H_


// Parsed from nnvm/c_api.h

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * \file nnvm/c_api.h
 * \brief C API of NNVM symbolic construction and pass.
 *  Enables construction and transformation of Graph
 *  in any other host languages.
 */
// #ifndef NNVM_C_API_H_
// #define NNVM_C_API_H_

/** \brief NNVM_DLL prefix for windows */
// #ifdef _WIN32
// #ifdef NNVM_EXPORTS
// #define NNVM_DLL __declspec(dllexport)
// #else
// #define NNVM_DLL __declspec(dllimport)
// #endif
// #else
// #define NNVM_DLL __attribute__((visibility("default")))
// #endif

/** \brief manually define unsigned int */
// Targeting ..\OpHandle.java


// Targeting ..\SymbolHandle.java


// Targeting ..\GraphHandle.java



// #ifdef __cplusplus
// #endif
/**
 * \brief Set the last error message needed by C API
 * @param msg The error message to set.
 */
public static native void NNAPISetLastError(@Cast("const char*") BytePointer msg);
public static native void NNAPISetLastError(String msg);

/**
 * \brief return str message of the last error
 *  all function in this file will return 0 when success
 *  and -1 when an error occurred,
 *  NNGetLastError can be called to retrieve the error
 *
 *  this function is threadsafe and can be called by different thread
 *  @return error info
 */
public static native @Cast("const char*") BytePointer NNGetLastError();

/**
 * \brief list all the available operator names, include entries.
 * @param out_size the size of returned array
 * @param out_array the output operator name array.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNListAllOpNames(@Cast("nn_uint*") IntPointer out_size,
                              @Cast("const char***") @ByPtrPtr PointerPointer out_array);
public static native int NNListAllOpNames(@Cast("nn_uint*") IntBuffer out_size,
                              @Cast("const char***") @ByPtrPtr PointerPointer out_array);
public static native int NNListAllOpNames(@Cast("nn_uint*") int[] out_size,
                              @Cast("const char***") @ByPtrPtr PointerPointer out_array);

/**
 * \brief Get operator handle given name.
 * @param op_name The name of the operator.
 * @param op_out The returnning op handle.
 */
public static native int NNGetOpHandle(@Cast("const char*") BytePointer op_name,
                           @ByPtrPtr OpHandle op_out);
public static native int NNGetOpHandle(String op_name,
                           @ByPtrPtr OpHandle op_out);

/**
 * \brief list all the available operators.
 *  This won't include the alias, use ListAllNames
 *  instead to get all alias names.
 *
 * @param out_size the size of returned array
 * @param out_array the output AtomicSymbolCreator array
 * @return 0 when success, -1 when failure happens
 */
public static native int NNListUniqueOps(@Cast("nn_uint*") IntPointer out_size,
                             @Cast("OpHandle**") @ByPtrPtr PointerPointer out_array);
public static native int NNListUniqueOps(@Cast("nn_uint*") IntBuffer out_size,
                             @Cast("OpHandle**") @ByPtrPtr PointerPointer out_array);
public static native int NNListUniqueOps(@Cast("nn_uint*") int[] out_size,
                             @Cast("OpHandle**") @ByPtrPtr PointerPointer out_array);

/**
 * \brief Get the detailed information about atomic symbol.
 * @param op The operator handle.
 * @param real_name The returned name of the creator.
 *   This name is not the alias name of the atomic symbol.
 * @param description The returned description of the symbol.
 * @param num_doc_args Number of arguments that contain documents.
 * @param arg_names Name of the arguments of doc args
 * @param arg_type_infos Type informations about the arguments.
 * @param arg_descriptions Description information about the arguments.
 * @param return_type Return type of the function, if any.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGetOpInfo(OpHandle op,
                         @Cast("const char**") PointerPointer real_name,
                         @Cast("const char**") PointerPointer description,
                         @Cast("nn_uint*") IntPointer num_doc_args,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                         @Cast("const char**") PointerPointer return_type);
public static native int NNGetOpInfo(OpHandle op,
                         @Cast("const char**") @ByPtrPtr BytePointer real_name,
                         @Cast("const char**") @ByPtrPtr BytePointer description,
                         @Cast("nn_uint*") IntPointer num_doc_args,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                         @Cast("const char**") @ByPtrPtr BytePointer return_type);
public static native int NNGetOpInfo(OpHandle op,
                         @Cast("const char**") @ByPtrPtr ByteBuffer real_name,
                         @Cast("const char**") @ByPtrPtr ByteBuffer description,
                         @Cast("nn_uint*") IntBuffer num_doc_args,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                         @Cast("const char**") @ByPtrPtr ByteBuffer return_type);
public static native int NNGetOpInfo(OpHandle op,
                         @Cast("const char**") @ByPtrPtr byte[] real_name,
                         @Cast("const char**") @ByPtrPtr byte[] description,
                         @Cast("nn_uint*") int[] num_doc_args,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_names,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_type_infos,
                         @Cast("const char***") @ByPtrPtr PointerPointer arg_descriptions,
                         @Cast("const char**") @ByPtrPtr byte[] return_type);
/**
 * \brief Create an AtomicSymbol functor.
 * @param op The operator handle
 * @param num_param the number of parameters
 * @param keys the keys to the params
 * @param vals the vals of the params
 * @param out pointer to the created symbol handle
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") PointerPointer keys,
                                        @Cast("const char**") PointerPointer vals,
                                        PointerPointer out);
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") @ByPtrPtr BytePointer keys,
                                        @Cast("const char**") @ByPtrPtr BytePointer vals,
                                        PointerPointer out);
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                        @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") @ByPtrPtr byte[] keys,
                                        @Cast("const char**") @ByPtrPtr byte[] vals,
                                        PointerPointer out);
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") @ByPtrPtr BytePointer keys,
                                        @Cast("const char**") @ByPtrPtr BytePointer vals,
                                        @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                                        @Cast("const char**") @ByPtrPtr ByteBuffer vals,
                                        PointerPointer out);
public static native int NNSymbolCreateAtomicSymbol(OpHandle op,
                                        @Cast("nn_uint") int num_param,
                                        @Cast("const char**") @ByPtrPtr byte[] keys,
                                        @Cast("const char**") @ByPtrPtr byte[] vals,
                                        @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Create a Variable Symbol.
 * @param name name of the variable
 * @param out pointer to the created symbol handle
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolCreateVariable(@Cast("const char*") BytePointer name, PointerPointer out);
public static native int NNSymbolCreateVariable(String name, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Create a Symbol by grouping list of symbols together
 * @param num_symbols number of symbols to be grouped
 * @param symbols array of symbol handles
 * @param out pointer to the created symbol handle
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolCreateGroup(@Cast("nn_uint") int num_symbols,
                                 PointerPointer symbols,
                                 PointerPointer out);
public static native int NNSymbolCreateGroup(@Cast("nn_uint") int num_symbols,
                                 @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle symbols,
                                 @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Add src_dep to the handle as control dep.
 * @param handle The symbol to add dependency edges on.
 * @param src_dep the source handles.
 */
public static native int NNAddControlDeps(SymbolHandle handle,
                              SymbolHandle src_dep);
/**
 * \brief Free the symbol handle.
 * @param symbol the symbol
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolFree(SymbolHandle symbol);
/**
 * \brief Copy the symbol to another handle
 * @param symbol the source symbol
 * @param out used to hold the result of copy
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolCopy(SymbolHandle symbol, PointerPointer out);
public static native int NNSymbolCopy(SymbolHandle symbol, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Print the content of symbol, used for debug.
 * @param symbol the symbol
 * @param out_str pointer to hold the output string of the printing.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolPrint(SymbolHandle symbol, @Cast("const char**") PointerPointer out_str);
public static native int NNSymbolPrint(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr BytePointer out_str);
public static native int NNSymbolPrint(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr ByteBuffer out_str);
public static native int NNSymbolPrint(SymbolHandle symbol, @Cast("const char**") @ByPtrPtr byte[] out_str);
/**
 * \brief Get string attribute from symbol
 * @param symbol the source symbol
 * @param key The key of the symbol.
 * @param out The result attribute, can be NULL if the attribute do not exist.
 * @param success Whether the result is contained in out.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             @Cast("const char*") BytePointer key,
                             @Cast("const char**") PointerPointer out,
                             IntPointer success);
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             @Cast("const char*") BytePointer key,
                             @Cast("const char**") @ByPtrPtr BytePointer out,
                             IntPointer success);
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             String key,
                             @Cast("const char**") @ByPtrPtr ByteBuffer out,
                             IntBuffer success);
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             @Cast("const char*") BytePointer key,
                             @Cast("const char**") @ByPtrPtr byte[] out,
                             int[] success);
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             String key,
                             @Cast("const char**") @ByPtrPtr BytePointer out,
                             IntPointer success);
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             @Cast("const char*") BytePointer key,
                             @Cast("const char**") @ByPtrPtr ByteBuffer out,
                             IntBuffer success);
public static native int NNSymbolGetAttr(SymbolHandle symbol,
                             String key,
                             @Cast("const char**") @ByPtrPtr byte[] out,
                             int[] success);
/**
 * \brief Set string attribute from symbol.
 *  NOTE: Setting attribute to a symbol can affect the semantics(mutable/immutable) of symbolic graph.
 *
 *  Safe recommendaton: use  immutable graph
 *  - Only allow set attributes during creation of new symbol as optional parameter
 *
 *  Mutable graph (be careful about the semantics):
 *  - Allow set attr at any point.
 *  - Mutating an attribute of some common node of two graphs can cause confusion from user.
 *
 * @param symbol the source symbol
 * @param num_param Number of parameters to set.
 * @param keys The keys of the attribute
 * @param values The value to be set
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolSetAttrs(SymbolHandle symbol,
                              @Cast("nn_uint") int num_param,
                              @Cast("const char**") PointerPointer keys,
                              @Cast("const char**") PointerPointer values);
public static native int NNSymbolSetAttrs(SymbolHandle symbol,
                              @Cast("nn_uint") int num_param,
                              @Cast("const char**") @ByPtrPtr BytePointer keys,
                              @Cast("const char**") @ByPtrPtr BytePointer values);
public static native int NNSymbolSetAttrs(SymbolHandle symbol,
                              @Cast("nn_uint") int num_param,
                              @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                              @Cast("const char**") @ByPtrPtr ByteBuffer values);
public static native int NNSymbolSetAttrs(SymbolHandle symbol,
                              @Cast("nn_uint") int num_param,
                              @Cast("const char**") @ByPtrPtr byte[] keys,
                              @Cast("const char**") @ByPtrPtr byte[] values);
/**
 * \brief Get all attributes from symbol, including all descendents.
 * @param symbol the source symbol
 * @param recursive_option 0 for recursive, 1 for shallow.
 * @param out_size The number of output attributes
 * @param out 2*out_size strings representing key value pairs.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolListAttrs(SymbolHandle symbol,
                               int recursive_option,
                               @Cast("nn_uint*") IntPointer out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out);
public static native int NNSymbolListAttrs(SymbolHandle symbol,
                               int recursive_option,
                               @Cast("nn_uint*") IntBuffer out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out);
public static native int NNSymbolListAttrs(SymbolHandle symbol,
                               int recursive_option,
                               @Cast("nn_uint*") int[] out_size,
                               @Cast("const char***") @ByPtrPtr PointerPointer out);

/**
 * \brief List inputs variables in the symbol.
 * @param symbol the symbol
 * @param option The option to list the inputs
 *   option=0 means list all arguments.
 *   option=1 means list arguments that are readed only by the graph.
 *   option=2 means list arguments that are mutated by the graph.
 * @param out_size output size
 * @param out_sym_array the output array.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolListInputVariables(SymbolHandle symbol,
                                        int option,
                                        @Cast("nn_uint*") IntPointer out_size,
                                        @ByPtrPtr PointerPointer out_sym_array);
public static native int NNSymbolListInputVariables(SymbolHandle symbol,
                                        int option,
                                        @Cast("nn_uint*") IntBuffer out_size,
                                        @Cast("SymbolHandle**") @ByPtrPtr PointerPointer out_sym_array);
public static native int NNSymbolListInputVariables(SymbolHandle symbol,
                                        int option,
                                        @Cast("nn_uint*") int[] out_size,
                                        @ByPtrPtr PointerPointer out_sym_array);

/**
 * \brief List input names in the symbol.
 * @param symbol the symbol
 * @param option The option to list the inputs
 *   option=0 means list all arguments.
 *   option=1 means list arguments that are readed only by the graph.
 *   option=2 means list arguments that are mutated by the graph.
 * @param out_size output size
 * @param out_str_array pointer to hold the output string array
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolListInputNames(SymbolHandle symbol,
                                    int option,
                                    @Cast("nn_uint*") IntPointer out_size,
                                    @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int NNSymbolListInputNames(SymbolHandle symbol,
                                    int option,
                                    @Cast("nn_uint*") IntBuffer out_size,
                                    @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int NNSymbolListInputNames(SymbolHandle symbol,
                                    int option,
                                    @Cast("nn_uint*") int[] out_size,
                                    @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
/**
 * \brief List returns names in the symbol.
 * @param symbol the symbol
 * @param out_size output size
 * @param out_str_array pointer to hold the output string array
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolListOutputNames(SymbolHandle symbol,
                                     @Cast("nn_uint*") IntPointer out_size,
                                     @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int NNSymbolListOutputNames(SymbolHandle symbol,
                                     @Cast("nn_uint*") IntBuffer out_size,
                                     @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);
public static native int NNSymbolListOutputNames(SymbolHandle symbol,
                                     @Cast("nn_uint*") int[] out_size,
                                     @Cast("const char***") @ByPtrPtr PointerPointer out_str_array);


/**
 * \brief Supply number of outputs of the symbol.
 * @param symbol the symbol
 * @param output_count number of outputs
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolGetNumOutputs(SymbolHandle symbol,
                                    @Cast("nn_uint*") IntPointer output_count);
public static native int NNSymbolGetNumOutputs(SymbolHandle symbol,
                                    @Cast("nn_uint*") IntBuffer output_count);
public static native int NNSymbolGetNumOutputs(SymbolHandle symbol,
                                    @Cast("nn_uint*") int[] output_count);

/**
 * \brief Get a symbol that contains all the internals.
 * @param symbol The symbol
 * @param out The output symbol whose outputs are all the internals.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolGetInternals(SymbolHandle symbol,
                                  PointerPointer out);
public static native int NNSymbolGetInternals(SymbolHandle symbol,
                                  @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Get a symbol that contains only direct children.
 * @param symbol The symbol
 * @param out The output symbol whose outputs are the direct children.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolGetChildren(SymbolHandle symbol,
                                 PointerPointer out);
public static native int NNSymbolGetChildren(SymbolHandle symbol,
                                 @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);
/**
 * \brief Get index-th outputs of the symbol.
 * @param symbol The symbol
 * @param index the Index of the output.
 * @param out The output symbol whose outputs are the index-th symbol.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolGetOutput(SymbolHandle symbol,
                               @Cast("nn_uint") int index,
                               PointerPointer out);
public static native int NNSymbolGetOutput(SymbolHandle symbol,
                               @Cast("nn_uint") int index,
                               @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle out);

/**
 * \brief Compose the symbol on other symbols.
 *
 *  This function will change the sym hanlde.
 *  To achieve function apply behavior, copy the symbol first
 *  before apply.
 *
 * @param sym the symbol to apply
 * @param name the name of symbol
 * @param num_args number of arguments
 * @param keys the key of keyword args (optional)
 * @param args arguments to sym
 * @return 0 when success, -1 when failure happens
 */
public static native int NNSymbolCompose(SymbolHandle sym,
                             @Cast("const char*") BytePointer name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") PointerPointer keys,
                             PointerPointer args);
public static native int NNSymbolCompose(SymbolHandle sym,
                             @Cast("const char*") BytePointer name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") @ByPtrPtr BytePointer keys,
                             PointerPointer args);
public static native int NNSymbolCompose(SymbolHandle sym,
                             String name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                             @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle args);
public static native int NNSymbolCompose(SymbolHandle sym,
                             @Cast("const char*") BytePointer name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") @ByPtrPtr byte[] keys,
                             PointerPointer args);
public static native int NNSymbolCompose(SymbolHandle sym,
                             String name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") @ByPtrPtr BytePointer keys,
                             @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle args);
public static native int NNSymbolCompose(SymbolHandle sym,
                             @Cast("const char*") BytePointer name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") @ByPtrPtr ByteBuffer keys,
                             PointerPointer args);
public static native int NNSymbolCompose(SymbolHandle sym,
                             String name,
                             @Cast("nn_uint") int num_args,
                             @Cast("const char**") @ByPtrPtr byte[] keys,
                             @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle args);

// Graph IR API
/**
 * \brief create a graph handle from symbol
 * @param symbol The symbol representing the graph.
 * @param graph The graph handle created.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGraphCreate(SymbolHandle symbol, @ByPtrPtr GraphHandle graph);
/**
 * \brief free the graph handle
 * @param handle The handle to be freed.
 */
public static native int NNGraphFree(GraphHandle handle);
/**
 * \brief Get a new symbol from the graph.
 * @param graph The graph handle.
 * @param symbol The corresponding symbol
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGraphGetSymbol(GraphHandle graph, PointerPointer symbol);
public static native int NNGraphGetSymbol(GraphHandle graph, @Cast("SymbolHandle*") @ByPtrPtr SymbolHandle symbol);

/**
 * \brief Get Set a attribute in json format.
 * This feature allows pass graph attributes back and forth in reasonable speed.
 *
 * @param handle The graph handle.
 * @param key The key to the attribute.
 * @param json_value The value need to be in format [type_name, value],
 *  Where type_name is a registered type string in C++ side via DMLC_JSON_ENABLE_ANY.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGraphSetJSONAttr(GraphHandle handle,
                                @Cast("const char*") BytePointer key,
                                @Cast("const char*") BytePointer json_value);
public static native int NNGraphSetJSONAttr(GraphHandle handle,
                                String key,
                                String json_value);

/**
 * \brief Get a serialized attrirbute from graph.
 * This feature allows pass graph attributes back and forth in reasonable speed.
 *
 * @param handle The graph handle.
 * @param key The key to the attribute.
 * @param json_out The result attribute, can be NULL if the attribute do not exist.
 *  The json_out is an array of [type_name, value].
 *  Where the type_name is a registered type string in C++ side via DMLC_JSON_ENABLE_ANY.
 * @param success Whether the result is contained in out.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                @Cast("const char*") BytePointer key,
                                @Cast("const char**") PointerPointer json_out,
                                IntPointer success);
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                @Cast("const char*") BytePointer key,
                                @Cast("const char**") @ByPtrPtr BytePointer json_out,
                                IntPointer success);
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                String key,
                                @Cast("const char**") @ByPtrPtr ByteBuffer json_out,
                                IntBuffer success);
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                @Cast("const char*") BytePointer key,
                                @Cast("const char**") @ByPtrPtr byte[] json_out,
                                int[] success);
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                String key,
                                @Cast("const char**") @ByPtrPtr BytePointer json_out,
                                IntPointer success);
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                @Cast("const char*") BytePointer key,
                                @Cast("const char**") @ByPtrPtr ByteBuffer json_out,
                                IntBuffer success);
public static native int NNGraphGetJSONAttr(GraphHandle handle,
                                String key,
                                @Cast("const char**") @ByPtrPtr byte[] json_out,
                                int[] success);

/**
 * \brief Set a attribute whose type is std::vector<NodeEntry> in c++
 * This feature allows pass List of symbolic variables for gradient request.
 *
 * \note This is beta feature only used for test purpos
 *
 * @param handle The graph handle.
 * @param key The key to the attribute.
 * @param list The symbol whose outputs represents the list of NodeEntry to be passed.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGraphSetNodeEntryListAttr_(GraphHandle handle,
                                          @Cast("const char*") BytePointer key,
                                          SymbolHandle list);
public static native int NNGraphSetNodeEntryListAttr_(GraphHandle handle,
                                          String key,
                                          SymbolHandle list);
/**
 * \brief Apply passes on the src graph.
 * @param src The source graph handle.
 * @param num_pass The number of pass to be applied.
 * @param pass_names The names of the pass.
 * @param dst The result graph.
 * @return 0 when success, -1 when failure happens
 */
public static native int NNGraphApplyPasses(GraphHandle src,
                                @Cast("nn_uint") int num_pass,
                                @Cast("const char**") PointerPointer pass_names,
                                @ByPtrPtr GraphHandle dst);
public static native int NNGraphApplyPasses(GraphHandle src,
                                @Cast("nn_uint") int num_pass,
                                @Cast("const char**") @ByPtrPtr BytePointer pass_names,
                                @ByPtrPtr GraphHandle dst);
public static native int NNGraphApplyPasses(GraphHandle src,
                                @Cast("nn_uint") int num_pass,
                                @Cast("const char**") @ByPtrPtr ByteBuffer pass_names,
                                @ByPtrPtr GraphHandle dst);
public static native int NNGraphApplyPasses(GraphHandle src,
                                @Cast("nn_uint") int num_pass,
                                @Cast("const char**") @ByPtrPtr byte[] pass_names,
                                @ByPtrPtr GraphHandle dst);

// #ifdef __cplusplus /* end extern "C" */
// #endif

// #endif  // NNVM_C_API_H_


}
