// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class LinkCreatPropList
    \brief Class LinkCreatPropList inherits from PropList and provides
    wrappers for the HDF5 link creation property list.
*/
// Inheritance: PropList -> IdComponent
@Namespace("H5") @NoOffset @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class LinkCreatPropList extends PropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LinkCreatPropList(Pointer p) { super(p); }

        /**\brief Default link creation property list. */
        @MemberGetter public static native @Const @ByRef LinkCreatPropList DEFAULT();

        // Creates a link creation property list.
        public LinkCreatPropList() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**\brief Returns this class name. */
        public native @StdString BytePointer fromClass();

        // Copy constructor: same as the original LinkCreatPropList.
        public LinkCreatPropList(@Const @ByRef LinkCreatPropList original) { super((Pointer)null); allocate(original); }
        private native void allocate(@Const @ByRef LinkCreatPropList original);

        // Creates a copy of an existing link creation property list
        // using the property list id.
        public LinkCreatPropList(@Cast("const hid_t") long plist_id) { super((Pointer)null); allocate(plist_id); }
        private native void allocate(@Cast("const hid_t") long plist_id);

        // Specifies in property list whether to create missing
        // intermediate groups
        public native void setCreateIntermediateGroup(@Cast("bool") boolean crt_intmd_group);

        // Determines whether property is set to enable creating missing
        // intermediate groups
        public native @Cast("bool") boolean getCreateIntermediateGroup();

        // Sets the character encoding of the string.
        public native void setCharEncoding(@Cast("H5T_cset_t") int encoding);

        // Gets the character encoding of the string.
        public native @Cast("H5T_cset_t") int getCharEncoding();

        // Noop destructor

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

        // Deletes the global constant, should only be used by the library
        public static native void deleteConstants();

}
