/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import org.bytedeco.depthai.ImgDetection;
import org.bytedeco.depthai.Point3f;
import org.bytedeco.depthai.Rect;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.Properties;

@Namespace(value="dai")
@Properties(inherit={depthai.class})
public class Tracklet
extends Pointer {
    public Tracklet() {
        super((Pointer)null);
        this.allocate();
    }

    public Tracklet(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    public Tracklet(Pointer p) {
        super(p);
    }

    private native void allocate();

    private native void allocateArray(long var1);

    public Tracklet position(long position) {
        return (Tracklet)super.position(position);
    }

    public Tracklet getPointer(long i) {
        return (Tracklet)new Tracklet(this).offsetAddress(i);
    }

    @ByRef
    public native Rect roi();

    public native Tracklet roi(Rect var1);

    @Cast(value={"std::int32_t"})
    public native int id();

    public native Tracklet id(int var1);

    @Cast(value={"std::int32_t"})
    public native int label();

    public native Tracklet label(int var1);

    @Cast(value={"std::int32_t"})
    public native int age();

    public native Tracklet age(int var1);

    public native TrackingStatus status();

    public native Tracklet status(TrackingStatus var1);

    @ByRef
    public native ImgDetection srcImgDetection();

    public native Tracklet srcImgDetection(ImgDetection var1);

    @ByRef
    public native Point3f spatialCoordinates();

    public native Tracklet spatialCoordinates(Point3f var1);

    static {
        Loader.load();
    }

    public static enum TrackingStatus {
        NEW(0),
        TRACKED(1),
        LOST(2),
        REMOVED(3);

        public final int value;

        private TrackingStatus(int v) {
            this.value = v;
        }

        private TrackingStatus(TrackingStatus e) {
            this.value = e.value;
        }

        public TrackingStatus intern() {
            for (TrackingStatus e : TrackingStatus.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }
}

