/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import org.bytedeco.depthai.EepromData;
import org.bytedeco.depthai.IntOptional;
import org.bytedeco.depthai.RawStereoDepthConfig;
import org.bytedeco.depthai.global.depthai;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.javacpp.annotation.StdVector;

@Namespace(value="dai")
@Properties(inherit={depthai.class})
public class StereoDepthProperties
extends Pointer {
    public StereoDepthProperties() {
        super((Pointer)null);
        this.allocate();
    }

    public StereoDepthProperties(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    public StereoDepthProperties(Pointer p) {
        super(p);
    }

    private native void allocate();

    private native void allocateArray(long var1);

    public StereoDepthProperties position(long position) {
        return (StereoDepthProperties)super.position(position);
    }

    public StereoDepthProperties getPointer(long i) {
        return (StereoDepthProperties)new StereoDepthProperties(this).offsetAddress(i);
    }

    @ByRef
    public native RawStereoDepthConfig initialConfig();

    public native StereoDepthProperties initialConfig(RawStereoDepthConfig var1);

    @Cast(value={"bool"})
    public native boolean inputConfigSync();

    public native StereoDepthProperties inputConfigSync(boolean var1);

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public native BytePointer calibration();

    public native StereoDepthProperties calibration(BytePointer var1);

    @ByRef
    public native EepromData calibrationData();

    public native StereoDepthProperties calibrationData(EepromData var1);

    public native DepthAlign depthAlign();

    public native StereoDepthProperties depthAlign(DepthAlign var1);

    public native depthai.CameraBoardSocket depthAlignCamera();

    public native StereoDepthProperties depthAlignCamera(depthai.CameraBoardSocket var1);

    @Cast(value={"bool"})
    public native boolean enableRectification();

    public native StereoDepthProperties enableRectification(boolean var1);

    @Cast(value={"bool"})
    public native boolean enableLeftRightCheck();

    public native StereoDepthProperties enableLeftRightCheck(boolean var1);

    @Cast(value={"bool"})
    public native boolean enableSubpixel();

    public native StereoDepthProperties enableSubpixel(boolean var1);

    @Cast(value={"bool"})
    public native boolean enableExtendedDisparity();

    public native StereoDepthProperties enableExtendedDisparity(boolean var1);

    @Cast(value={"bool"})
    public native boolean rectifyMirrorFrame();

    public native StereoDepthProperties rectifyMirrorFrame(boolean var1);

    @Cast(value={"std::int32_t"})
    public native int rectifyEdgeFillColor();

    public native StereoDepthProperties rectifyEdgeFillColor(int var1);

    @ByRef
    @Cast(value={"tl::optional<std::int32_t>*"})
    public native IntOptional width();

    public native StereoDepthProperties width(IntOptional var1);

    @ByRef
    @Cast(value={"tl::optional<std::int32_t>*"})
    public native IntOptional height();

    public native StereoDepthProperties height(IntOptional var1);

    @ByRef
    @Cast(value={"tl::optional<std::int32_t>*"})
    public native IntOptional outWidth();

    public native StereoDepthProperties outWidth(IntOptional var1);

    @ByRef
    @Cast(value={"tl::optional<std::int32_t>*"})
    public native IntOptional outHeight();

    public native StereoDepthProperties outHeight(IntOptional var1);

    @Cast(value={"bool"})
    public native boolean outKeepAspectRatio();

    public native StereoDepthProperties outKeepAspectRatio(boolean var1);

    @ByRef
    public native RectificationMesh mesh();

    public native StereoDepthProperties mesh(RectificationMesh var1);

    static {
        Loader.load();
    }

    public static enum DepthAlign {
        RECTIFIED_RIGHT(0),
        RECTIFIED_LEFT(1),
        CENTER(2);

        public final int value;

        private DepthAlign(int v) {
            this.value = v;
        }

        private DepthAlign(DepthAlign e) {
            this.value = e.value;
        }

        public DepthAlign intern() {
            for (DepthAlign e : DepthAlign.values()) {
                if (e.value != this.value) continue;
                return e;
            }
            return this;
        }

        public String toString() {
            return this.intern().name();
        }
    }

    public static class RectificationMesh
    extends Pointer {
        public RectificationMesh() {
            super((Pointer)null);
            this.allocate();
        }

        public RectificationMesh(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public RectificationMesh(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public RectificationMesh position(long position) {
            return (RectificationMesh)super.position(position);
        }

        public RectificationMesh getPointer(long i) {
            return (RectificationMesh)new RectificationMesh(this).offsetAddress(i);
        }

        @StdString
        public native BytePointer meshLeftUri();

        public native RectificationMesh meshLeftUri(BytePointer var1);

        @StdString
        public native BytePointer meshRightUri();

        public native RectificationMesh meshRightUri(BytePointer var1);

        @ByRef
        @Cast(value={"tl::optional<std::uint32_t>*"})
        public native IntOptional meshSize();

        public native RectificationMesh meshSize(IntOptional var1);

        @Cast(value={"uint16_t"})
        public native short stepWidth();

        public native RectificationMesh stepWidth(short var1);

        @Cast(value={"uint16_t"})
        public native short stepHeight();

        public native RectificationMesh stepHeight(short var1);

        static {
            Loader.load();
        }
    }
}

