/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bytedeco.depthai.AssetManager;
import org.bytedeco.depthai.Assets;
import org.bytedeco.depthai.CalibrationHandler;
import org.bytedeco.depthai.ColorCamera;
import org.bytedeco.depthai.GlobalProperties;
import org.bytedeco.depthai.IMU;
import org.bytedeco.depthai.ImageManip;
import org.bytedeco.depthai.MobileNetDetectionNetwork;
import org.bytedeco.depthai.MobileNetSpatialDetectionNetwork;
import org.bytedeco.depthai.MonoCamera;
import org.bytedeco.depthai.NeuralNetwork;
import org.bytedeco.depthai.Node;
import org.bytedeco.depthai.NodeIdConnectionSetMap;
import org.bytedeco.depthai.NodeIdNodeMap;
import org.bytedeco.depthai.NodeVector;
import org.bytedeco.depthai.ObjectTracker;
import org.bytedeco.depthai.PipelineImpl;
import org.bytedeco.depthai.PipelineSchema;
import org.bytedeco.depthai.SPIOut;
import org.bytedeco.depthai.SpatialLocationCalculator;
import org.bytedeco.depthai.StereoDepth;
import org.bytedeco.depthai.SystemLogger;
import org.bytedeco.depthai.VideoEncoder;
import org.bytedeco.depthai.XLinkIn;
import org.bytedeco.depthai.XLinkOut;
import org.bytedeco.depthai.YoloDetectionNetwork;
import org.bytedeco.depthai.YoloSpatialDetectionNetwork;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.javacpp.annotation.StdVector;

@Namespace(value="dai")
@NoOffset
@Properties(inherit={depthai.class})
public class Pipeline
extends Pointer {
    public Pipeline(Pointer p) {
        super(p);
    }

    public Pipeline(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    private native void allocateArray(long var1);

    public Pipeline position(long position) {
        return (Pipeline)super.position(position);
    }

    public Pipeline getPointer(long i) {
        return (Pipeline)new Pipeline(this).offsetAddress(i);
    }

    public Pipeline() {
        super((Pointer)null);
        this.allocate();
    }

    private native void allocate();

    public Pipeline(@SharedPtr PipelineImpl pimpl) {
        super((Pointer)null);
        this.allocate(pimpl);
    }

    private native void allocate(@SharedPtr PipelineImpl var1);

    @ByVal
    public native Pipeline clone();

    @ByVal
    public native GlobalProperties getGlobalProperties();

    @ByVal
    public native PipelineSchema getPipelineSchema();

    public native void serialize(@ByRef PipelineSchema var1, @ByRef Assets var2, @Cast(value={"std::uint8_t*"}) @StdVector BytePointer var3, @Cast(value={"dai::OpenVINO::Version*"}) @ByRef IntPointer var4);

    public native void serialize(@ByRef PipelineSchema var1, @ByRef Assets var2, @Cast(value={"std::uint8_t*"}) @StdVector ByteBuffer var3, @Cast(value={"dai::OpenVINO::Version*"}) @ByRef IntBuffer var4);

    public native void serialize(@ByRef PipelineSchema var1, @ByRef Assets var2, @Cast(value={"std::uint8_t*"}) @StdVector byte[] var3, @Cast(value={"dai::OpenVINO::Version*"}) @ByRef int[] var4);

    @Name(value={"create<dai::node::IMU>"})
    @SharedPtr
    public native IMU createIMU();

    @Name(value={"create<dai::node::ColorCamera>"})
    @SharedPtr
    public native ColorCamera createColorCamera();

    @Name(value={"create<dai::node::ImageManip>"})
    @SharedPtr
    public native ImageManip createImageManip();

    @Name(value={"create<dai::node::MonoCamera>"})
    @SharedPtr
    public native MonoCamera createMonoCamera();

    @Name(value={"create<dai::node::NeuralNetwork>"})
    @SharedPtr
    public native NeuralNetwork createNeuralNetwork();

    @Name(value={"create<dai::node::MobileNetDetectionNetwork>"})
    @SharedPtr
    public native MobileNetDetectionNetwork createMobileNetDetectionNetwork();

    @Name(value={"create<dai::node::YoloDetectionNetwork>"})
    @SharedPtr
    public native YoloDetectionNetwork createYoloDetectionNetwork();

    @Name(value={"create<dai::node::ObjectTracker>"})
    @SharedPtr
    public native ObjectTracker createObjectTracker();

    @Name(value={"create<dai::node::SPIOut>"})
    @SharedPtr
    public native SPIOut createSPIOut();

    @Name(value={"create<dai::node::MobileNetSpatialDetectionNetwork>"})
    @SharedPtr
    public native MobileNetSpatialDetectionNetwork createMobileNetSpatialDetectionNetwork();

    @Name(value={"create<dai::node::YoloSpatialDetectionNetwork>"})
    @SharedPtr
    public native YoloSpatialDetectionNetwork createYoloSpatialDetectionNetwork();

    @Name(value={"create<dai::node::SpatialLocationCalculator>"})
    @SharedPtr
    public native SpatialLocationCalculator createSpatialLocationCalculator();

    @Name(value={"create<dai::node::StereoDepth>"})
    @SharedPtr
    public native StereoDepth createStereoDepth();

    @Name(value={"create<dai::node::SystemLogger>"})
    @SharedPtr
    public native SystemLogger createSystemLogger();

    @Name(value={"create<dai::node::VideoEncoder>"})
    @SharedPtr
    public native VideoEncoder createVideoEncoder();

    @Name(value={"create<dai::node::XLinkIn>"})
    @SharedPtr
    public native XLinkIn createXLinkIn();

    @Name(value={"create<dai::node::XLinkOut>"})
    @SharedPtr
    public native XLinkOut createXLinkOut();

    public native void remove(@SharedPtr @ByVal Node var1);

    @ByVal
    public native NodeVector getAllNodes();

    @SharedPtr
    @ByVal
    public native Node getNode(@Cast(value={"dai::Node::Id"}) long var1);

    @StdVector
    public native Node.Connection getConnections();

    @Cast(value={"const dai::Pipeline::NodeConnectionMap*"})
    @ByRef
    public native NodeIdConnectionSetMap getConnectionMap();

    @Cast(value={"const dai::Pipeline::NodeMap*"})
    @ByRef
    public native NodeIdNodeMap getNodeMap();

    public native void link(@Const @ByRef Node.Output var1, @Const @ByRef Node.Input var2);

    public native void unlink(@Const @ByRef Node.Output var1, @Const @ByRef Node.Input var2);

    @ByVal
    public native AssetManager getAllAssets();

    @ByRef
    public native AssetManager getAssetManager();

    public native void setOpenVINOVersion(@Cast(value={"dai::OpenVINO::Version"}) int var1);

    public native void setCalibrationData(@ByVal CalibrationHandler var1);

    @ByVal
    public native CalibrationHandler getCalibrationData();

    @Cast(value={"dai::OpenVINO::Version"})
    public native int getOpenVINOVersion();

    public native void setCameraTuningBlobPath(@StdString BytePointer var1);

    public native void setCameraTuningBlobPath(@StdString String var1);

    static {
        Loader.load();
    }
}

