/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.depthai;

import org.bytedeco.depthai.CalibrationHandler;
import org.bytedeco.depthai.ChipTemperature;
import org.bytedeco.depthai.CpuUsage;
import org.bytedeco.depthai.DataInputQueue;
import org.bytedeco.depthai.DataOutputQueue;
import org.bytedeco.depthai.DeviceInfo;
import org.bytedeco.depthai.MemoryInfo;
import org.bytedeco.depthai.Pipeline;
import org.bytedeco.depthai.StringVector;
import org.bytedeco.depthai.global.depthai;
import org.bytedeco.depthai.presets.depthai;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.javacpp.annotation.StdVector;

@Namespace(value="dai")
@NoOffset
@Properties(inherit={depthai.class})
public class Device
extends Pointer {
    public static final long EVENT_QUEUE_MAXIMUM_SIZE;
    public static final float DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ;

    public Device(Pointer p) {
        super(p);
    }

    @MemberGetter
    @ByRef
    @Cast(value={"const std::chrono::seconds*"})
    public static native Pointer DEFAULT_SEARCH_TIME();

    @MemberGetter
    @Cast(value={"const std::size_t"})
    public static native long EVENT_QUEUE_MAXIMUM_SIZE();

    @MemberGetter
    public static native float DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ();

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getAnyAvailableDevice();

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getFirstAvailableDevice();

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getDeviceByMxId(@StdString BytePointer var0);

    @ByVal
    @Cast(value={"std::tuple<bool,dai::DeviceInfo>*"})
    public static native Pointer getDeviceByMxId(@StdString String var0);

    @StdVector
    public static native DeviceInfo getAllAvailableDevices();

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public static native BytePointer getEmbeddedDeviceBinary(@Cast(value={"bool"}) boolean var0, @Cast(value={"dai::OpenVINO::Version"}) int var1);

    @Cast(value={"std::uint8_t*"})
    @StdVector
    public static native BytePointer getEmbeddedDeviceBinary(@Cast(value={"bool"}) boolean var0);

    public Device(@Const @ByRef Pipeline pipeline) {
        super((Pointer)null);
        this.allocate(pipeline);
    }

    private native void allocate(@Const @ByRef Pipeline var1);

    public Device(@Const @ByRef Pipeline pipeline, @Cast(value={"bool"}) boolean usb2Mode) {
        super((Pointer)null);
        this.allocate(pipeline, usb2Mode);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Cast(value={"bool"}) boolean var2);

    public Device(@Const @ByRef Pipeline pipeline, @Cast(value={"const char*"}) BytePointer pathToCmd) {
        super((Pointer)null);
        this.allocate(pipeline, pathToCmd);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Cast(value={"const char*"}) BytePointer var2);

    public Device(@Const @ByRef Pipeline pipeline, String pathToCmd) {
        super((Pointer)null);
        this.allocate(pipeline, pathToCmd);
    }

    private native void allocate(@Const @ByRef Pipeline var1, String var2);

    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast(value={"bool"}) boolean usb2Mode) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo, usb2Mode);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2, @Cast(value={"bool"}) boolean var3);

    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2);

    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, @Cast(value={"const char*"}) BytePointer pathToCmd) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo, pathToCmd);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2, @Cast(value={"const char*"}) BytePointer var3);

    public Device(@Const @ByRef Pipeline pipeline, @Const @ByRef DeviceInfo devInfo, String pathToCmd) {
        super((Pointer)null);
        this.allocate(pipeline, devInfo, pathToCmd);
    }

    private native void allocate(@Const @ByRef Pipeline var1, @Const @ByRef DeviceInfo var2, String var3);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version) {
        super((Pointer)null);
        this.allocate(version);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1);

    public Device() {
        super((Pointer)null);
        this.allocate();
    }

    private native void allocate();

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, @Cast(value={"bool"}) boolean usb2Mode) {
        super((Pointer)null);
        this.allocate(version, usb2Mode);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Cast(value={"bool"}) boolean var2);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, @Cast(value={"const char*"}) BytePointer pathToCmd) {
        super((Pointer)null);
        this.allocate(version, pathToCmd);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Cast(value={"const char*"}) BytePointer var2);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, String pathToCmd) {
        super((Pointer)null);
        this.allocate(version, pathToCmd);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, String var2);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo, @Cast(value={"bool"}) boolean usb2Mode) {
        super((Pointer)null);
        this.allocate(version, devInfo, usb2Mode);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2, @Cast(value={"bool"}) boolean var3);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo) {
        super((Pointer)null);
        this.allocate(version, devInfo);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo, @Cast(value={"const char*"}) BytePointer pathToCmd) {
        super((Pointer)null);
        this.allocate(version, devInfo, pathToCmd);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2, @Cast(value={"const char*"}) BytePointer var3);

    public Device(@Cast(value={"dai::OpenVINO::Version"}) int version, @Const @ByRef DeviceInfo devInfo, String pathToCmd) {
        super((Pointer)null);
        this.allocate(version, devInfo, pathToCmd);
    }

    private native void allocate(@Cast(value={"dai::OpenVINO::Version"}) int var1, @Const @ByRef DeviceInfo var2, String var3);

    @Cast(value={"bool"})
    public native boolean isPipelineRunning();

    @Cast(value={"bool"})
    @Deprecated
    public native boolean startPipeline();

    @Cast(value={"bool"})
    public native boolean startPipeline(@Const @ByRef Pipeline var1);

    public native void setLogLevel(depthai.LogLevel var1);

    public native void setLogLevel(@Cast(value={"dai::LogLevel"}) int var1);

    public native depthai.LogLevel getLogLevel();

    @ByVal
    public native DeviceInfo getDeviceInfo();

    public native void setLogOutputLevel(depthai.LogLevel var1);

    public native void setLogOutputLevel(@Cast(value={"dai::LogLevel"}) int var1);

    public native depthai.LogLevel getLogOutputLevel();

    public native int addLogCallback(depthai.LogCallback var1);

    @Cast(value={"bool"})
    public native boolean removeLogCallback(int var1);

    public native void setSystemInformationLoggingRate(float var1);

    public native float getSystemInformationLoggingRate();

    @SharedPtr
    public native DataOutputQueue getOutputQueue(@StdString BytePointer var1);

    @SharedPtr
    public native DataOutputQueue getOutputQueue(@StdString String var1);

    @SharedPtr
    public native DataOutputQueue getOutputQueue(@StdString BytePointer var1, @Cast(value={"unsigned int"}) int var2, @Cast(value={"bool"}) boolean var3);

    @SharedPtr
    public native DataOutputQueue getOutputQueue(@StdString BytePointer var1, @Cast(value={"unsigned int"}) int var2);

    @SharedPtr
    public native DataOutputQueue getOutputQueue(@StdString String var1, @Cast(value={"unsigned int"}) int var2, @Cast(value={"bool"}) boolean var3);

    @SharedPtr
    public native DataOutputQueue getOutputQueue(@StdString String var1, @Cast(value={"unsigned int"}) int var2);

    @ByVal
    public native StringVector getOutputQueueNames();

    @SharedPtr
    public native DataInputQueue getInputQueue(@StdString BytePointer var1);

    @SharedPtr
    public native DataInputQueue getInputQueue(@StdString String var1);

    @SharedPtr
    public native DataInputQueue getInputQueue(@StdString BytePointer var1, @Cast(value={"unsigned int"}) int var2, @Cast(value={"bool"}) boolean var3);

    @SharedPtr
    public native DataInputQueue getInputQueue(@StdString BytePointer var1, @Cast(value={"unsigned int"}) int var2);

    @SharedPtr
    public native DataInputQueue getInputQueue(@StdString String var1, @Cast(value={"unsigned int"}) int var2, @Cast(value={"bool"}) boolean var3);

    @SharedPtr
    public native DataInputQueue getInputQueue(@StdString String var1, @Cast(value={"unsigned int"}) int var2);

    @ByVal
    public native StringVector getInputQueueNames();

    @ByVal
    public native StringVector getQueueEvents(@Const @ByRef StringVector var1, @Cast(value={"std::size_t"}) long var2, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var4);

    @ByVal
    public native StringVector getQueueEvents(@Const @ByRef StringVector var1);

    @ByVal
    public native StringVector getQueueEvents(@StdString BytePointer var1, @Cast(value={"std::size_t"}) long var2, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var4);

    @ByVal
    public native StringVector getQueueEvents(@StdString BytePointer var1);

    @ByVal
    public native StringVector getQueueEvents(@StdString String var1, @Cast(value={"std::size_t"}) long var2, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var4);

    @ByVal
    public native StringVector getQueueEvents(@StdString String var1);

    @ByVal
    public native StringVector getQueueEvents(@Cast(value={"std::size_t"}) long var1, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var3);

    @ByVal
    public native StringVector getQueueEvents();

    @StdString
    public native BytePointer getQueueEvent(@Const @ByRef StringVector var1, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var2);

    @StdString
    public native BytePointer getQueueEvent(@Const @ByRef StringVector var1);

    @StdString
    public native BytePointer getQueueEvent(@StdString BytePointer var1, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var2);

    @StdString
    public native BytePointer getQueueEvent(@StdString BytePointer var1);

    @StdString
    public native String getQueueEvent(@StdString String var1, @ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var2);

    @StdString
    public native String getQueueEvent(@StdString String var1);

    @StdString
    public native BytePointer getQueueEvent(@ByVal(nullValue="std::chrono::microseconds(-1)") @Cast(value={"std::chrono::microseconds*"}) Pointer var1);

    @StdString
    public native BytePointer getQueueEvent();

    @StdString
    public native BytePointer getMxId();

    @StdVector
    @Cast(value={"dai::CameraBoardSocket*"})
    public native IntPointer getConnectedCameras();

    @ByVal
    public native MemoryInfo getDdrMemoryUsage();

    @ByVal
    public native MemoryInfo getCmxMemoryUsage();

    @ByVal
    public native MemoryInfo getLeonCssHeapUsage();

    @ByVal
    public native MemoryInfo getLeonMssHeapUsage();

    @ByVal
    public native ChipTemperature getChipTemperature();

    @ByVal
    public native CpuUsage getLeonCssCpuUsage();

    @ByVal
    public native CpuUsage getLeonMssCpuUsage();

    @Cast(value={"bool"})
    public native boolean flashCalibration(@ByVal CalibrationHandler var1);

    @ByVal
    public native CalibrationHandler readCalibration();

    public native depthai.UsbSpeed getUsbSpeed();

    @Name(value={"close"})
    public native void _close();

    @Cast(value={"bool"})
    public native boolean isClosed();

    static {
        Loader.load();
        EVENT_QUEUE_MAXIMUM_SIZE = Device.EVENT_QUEUE_MAXIMUM_SIZE();
        DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ = Device.DEFAULT_SYSTEM_INFORMATION_LOGGING_RATE_HZ();
    }
}

