/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.ale;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bytedeco.ale.ColourPalette;
import org.bytedeco.ale.Console;
import org.bytedeco.ale.Deserializer;
import org.bytedeco.ale.DisplayScreen;
import org.bytedeco.ale.Event;
import org.bytedeco.ale.Random;
import org.bytedeco.ale.ResolutionList;
import org.bytedeco.ale.Serializer;
import org.bytedeco.ale.Settings;
import org.bytedeco.ale.Sound;
import org.bytedeco.ale.presets.ale;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.annotation.ByPtrPtr;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;

@NoOffset
@Properties(inherit={ale.class})
public class OSystem
extends Pointer {
    public OSystem(Pointer p) {
        super(p);
    }

    @Cast(value={"bool"})
    public native boolean create();

    public native void attach(Settings var1);

    public native Event event();

    @ByRef
    public native Sound sound();

    @ByRef
    public native Settings settings();

    @ByRef
    public native Console console();

    public native void setFramerate(@Cast(value={"uInt32"}) int var1);

    public native void setConfigPaths();

    @Cast(value={"uInt32"})
    public native int frameRate();

    @Cast(value={"uInt32"})
    public native int desktopWidth();

    @Cast(value={"uInt32"})
    public native int desktopHeight();

    @Const
    @ByRef
    public native ResolutionList supportedResolutions();

    @StdString
    public native BytePointer baseDir();

    @StdString
    public native BytePointer cacheFile();

    @StdString
    public native BytePointer cheatFile();

    @StdString
    public native BytePointer configFile();

    @StdString
    public native BytePointer paletteFile();

    @StdString
    public native BytePointer propertiesFile();

    @StdString
    public native BytePointer romFile();

    @Cast(value={"bool"})
    public native boolean createConsole(@StdString BytePointer var1);

    @Cast(value={"bool"})
    public native boolean createConsole();

    @Cast(value={"bool"})
    public native boolean createConsole(@StdString String var1);

    public native void deleteConsole();

    @StdString
    public native BytePointer getROMInfo(@StdString BytePointer var1);

    @StdString
    public native String getROMInfo(@StdString String var1);

    @StdString
    public native BytePointer features();

    @Cast(value={"bool"})
    public native boolean openROM(@StdString BytePointer var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) PointerPointer var3, IntPointer var4);

    @Cast(value={"bool"})
    public native boolean openROM(@StdString BytePointer var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) @ByPtrPtr BytePointer var3, IntPointer var4);

    @Cast(value={"bool"})
    public native boolean openROM(@StdString String var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) @ByPtrPtr ByteBuffer var3, IntBuffer var4);

    @Cast(value={"bool"})
    public native boolean openROM(@StdString BytePointer var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) @ByPtrPtr byte[] var3, int[] var4);

    @Cast(value={"bool"})
    public native boolean openROM(@StdString String var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) @ByPtrPtr BytePointer var3, IntPointer var4);

    @Cast(value={"bool"})
    public native boolean openROM(@StdString BytePointer var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) @ByPtrPtr ByteBuffer var3, IntBuffer var4);

    @Cast(value={"bool"})
    public native boolean openROM(@StdString String var1, @StdString @ByRef BytePointer var2, @Cast(value={"uInt8**"}) @ByPtrPtr byte[] var3, int[] var4);

    public native void quit();

    public native void skipEmulation();

    @ByRef
    public native Random rng();

    public native void resetRNGSeed();

    @Cast(value={"bool"})
    public native boolean saveState(@ByRef Serializer var1);

    @Cast(value={"bool"})
    public native boolean loadState(@ByRef Deserializer var1);

    @Cast(value={"uInt32"})
    public native int getTicks();

    @Cast(value={"uInt32"})
    public native int myTimePerFrame();

    public native OSystem myTimePerFrame(int var1);

    @ByRef
    public native TimingInfo myTimingInfo();

    public native OSystem myTimingInfo(TimingInfo var1);

    @ByRef
    public native ColourPalette colourPalette();

    public native DisplayScreen p_display_screen();

    public native OSystem p_display_screen(DisplayScreen var1);

    static {
        Loader.load();
    }

    public static class TimingInfo
    extends Pointer {
        public TimingInfo() {
            super((Pointer)null);
            this.allocate();
        }

        public TimingInfo(long size) {
            super((Pointer)null);
            this.allocateArray(size);
        }

        public TimingInfo(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public TimingInfo position(long position) {
            return (TimingInfo)super.position(position);
        }

        public TimingInfo getPointer(long i) {
            return (TimingInfo)new TimingInfo(this).offsetAddress(i);
        }

        @Cast(value={"uInt32"})
        public native int start();

        public native TimingInfo start(int var1);

        @Cast(value={"uInt32"})
        public native int current();

        public native TimingInfo current(int var1);

        @Cast(value={"uInt32"})
        public native int virt();

        public native TimingInfo virt(int var1);

        @Cast(value={"uInt32"})
        public native int totalTime();

        public native TimingInfo totalTime(int var1);

        @Cast(value={"uInt32"})
        public native int totalFrames();

        public native TimingInfo totalFrames(int var1);

        static {
            Loader.load();
        }
    }
}

