// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.ale;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.ale.global.ale.*;


/**
  This class provides an interface for accessing operating system specific
  functions.  It also comprises an overall parent object, to which all the
  other objects belong.
  <p>
  @author  Stephen Anthony
  @version $Id: OSystem.hxx,v 1.55 2007/08/12 23:05:12 stephena Exp $
*/
@NoOffset @Properties(inherit = org.bytedeco.ale.presets.ale.class)
public class OSystem extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OSystem(Pointer p) { super(p); }

    /**
      Create a new OSystem abstract class
    */

    /**
      Destructor
    */

    /**
      Create all child objects which belong to this OSystem
    */
    public native @Cast("bool") boolean create();
    /**
      Adds the specified settings object to the system.
      <p>
      @param settings The settings object to add 
    */
    public native void attach(Settings settings);

    /**
      Get the event handler of the system
      <p>
      @return The event handler
    */
    //ALE  inline EventHandler& eventHandler() const { return *myEventHandler; }

    /**  //ALE 
      Get the event object of the system  
      <p>
      @return The event object
    */
    public native Event event();

    /**
      Get the frame buffer of the system
      <p>
      @return The frame buffer
    */
    //ALE  inline FrameBuffer& frameBuffer() const { return *myFrameBuffer; }

    /**
      Get the sound object of the system
      <p>
      @return The sound object
    */
    public native @ByRef Sound sound();

    /**
      Get the settings object of the system
      <p>
      @return The settings object
    */
    public native @ByRef Settings settings();

    /**
      Get the set of game properties for the system
      <p>
      @return The properties set object
    */

    /**
      Get the console of the system.
      <p>
      @return The console object
    */
    public native @ByRef Console console();

    /**
      Get the settings menu of the system.
      <p>
      @return The settings menu object
    */
    //ALE  inline Menu& menu(void) const { return *myMenu; }

    /**
      Get the command menu of the system.
      <p>
      @return The command menu object
    */
    //ALE  inline CommandMenu& commandMenu(void) const { return *myCommandMenu; }

    /**
      Get the ROM launcher of the system.
      <p>
      @return The launcher object
    */
    //ALE  inline Launcher& launcher(void) const { return *myLauncher; }

// #ifdef DEBUGGER_SUPPORT
// #endif

// #ifdef CHEATCODE_SUPPORT
// #endif

    /**
      Get the font object of the system
      <p>
      @return The font reference
    */
    //ALE  inline const GUI::Font& font() const { return *myFont; }

    /**
      Get the launcher font object of the system
      <p>
      @return The font reference
    */
    //ALE  inline const GUI::Font& launcherFont() const { return *myLauncherFont; }

    /**
      Get the console font object of the system
      <p>
      @return The console font reference
    */
    //ALE  inline const GUI::Font& consoleFont() const { return *myConsoleFont; }

    /**
      Set the framerate for the video system.  It's placed in this class since
      the mainLoop() method is defined here.
      <p>
      @param framerate  The video framerate to use
    */
    public native void setFramerate(@Cast("uInt32") int framerate);

    /**
      Set all config file paths for the OSystem.
    */
    public native void setConfigPaths();

    /**
      Set the user-interface palette which is specified in current settings.
    */
    //ALE  void setUIPalette();

    /**
      Get the current framerate for the video system.
      <p>
      @return  The video framerate currently in use
    */
    public native @Cast("uInt32") int frameRate();

    /**
      Get the maximum dimensions of a window for the video hardware.
    */
    public native @Cast("uInt32") int desktopWidth();
    public native @Cast("uInt32") int desktopHeight();

    /**
      Get the supported fullscreen resolutions for the video hardware.
      <p>
      @return  An array of supported resolutions
    */
    public native @Const @ByRef ResolutionList supportedResolutions();

    /**
      Return the default directory for storing data.
    */
    public native @StdString BytePointer baseDir();

    /**
      This method should be called to get the full path of the gamelist
      cache file (used by the Launcher to show a listing of available games).
      <p>
      @return String representing the full path of the gamelist cache file.
    */
    public native @StdString BytePointer cacheFile();

    /**
      This method should be called to get the full path of the cheat file.
      <p>
      @return String representing the full path of the cheat filename.
    */
    public native @StdString BytePointer cheatFile();

    /**
      This method should be called to get the full path of the config file.
      <p>
      @return String representing the full path of the config filename.
    */
    public native @StdString BytePointer configFile();

    /**
      This method should be called to get the full path of the
      (optional) palette file.
      <p>
      @return String representing the full path of the properties filename.
    */
    public native @StdString BytePointer paletteFile();

    /**
      This method should be called to get the full path of the
      properties file (stella.pro).
      <p>
      @return String representing the full path of the properties filename.
    */
    public native @StdString BytePointer propertiesFile();

    /**
      This method should be called to get the full path of the currently
      loaded ROM.
      <p>
      @return String representing the full path of the ROM file.
    */
    public native @StdString BytePointer romFile();

    /**
      Switches between software and OpenGL framebuffer modes.
    */
    //ALE  void toggleFrameBuffer();

    /**
      Creates a new game console from the specified romfile.
      <p>
      @param romfile  The full pathname of the ROM to use
      @return  True on successful creation, otherwise false
    */
    public native @Cast("bool") boolean createConsole(@StdString BytePointer romfile/*=""*/);
    public native @Cast("bool") boolean createConsole();
    public native @Cast("bool") boolean createConsole(@StdString String romfile/*=""*/);

    /**
      Deletes the currently defined console, if it exists.
      Also prints some statistics (fps, total frames, etc).
    */
    public native void deleteConsole();

    /**
      Creates a new ROM launcher, to select a new ROM to emulate.
    */
    //ALE  void createLauncher();

    /**
      Gets all possible info about the ROM by creating a temporary
      Console object and querying it.
      <p>
      @param romfile  The full pathname of the ROM to use
      @return  Some information about this ROM
    */
    public native @StdString BytePointer getROMInfo(@StdString BytePointer romfile);
    public native @StdString String getROMInfo(@StdString String romfile);

    /**
      The features which are conditionally compiled into Stella.
      <p>
      @return  The supported features
    */
    public native @StdString BytePointer features();

    /**
      Open the given ROM and return an array containing its contents.
      <p>
      @param rom    The absolute pathname of the ROM file
      @param md5    The md5 calculated from the ROM file
      @param image  A pointer to store the ROM data
                    Note, the calling method is responsible for deleting this
      @param size   The amount of data read into the image array
      @return  False on any errors, else true
    */
    public native @Cast("bool") boolean openROM(@StdString BytePointer rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") PointerPointer image, IntPointer size);
    public native @Cast("bool") boolean openROM(@StdString BytePointer rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") @ByPtrPtr BytePointer image, IntPointer size);
    public native @Cast("bool") boolean openROM(@StdString String rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") @ByPtrPtr ByteBuffer image, IntBuffer size);
    public native @Cast("bool") boolean openROM(@StdString BytePointer rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") @ByPtrPtr byte[] image, int[] size);
    public native @Cast("bool") boolean openROM(@StdString String rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") @ByPtrPtr BytePointer image, IntPointer size);
    public native @Cast("bool") boolean openROM(@StdString BytePointer rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") @ByPtrPtr ByteBuffer image, IntBuffer size);
    public native @Cast("bool") boolean openROM(@StdString String rom, @StdString @ByRef BytePointer md5, @Cast("uInt8**") @ByPtrPtr byte[] image, int[] size);

    /**
      Issue a quit event to the OSystem.
    */
    public native void quit();

    public native void skipEmulation();

    /**
      Returns the random number generator for this emulator.
    */
    public native @ByRef Random rng();

    /**
      Resets the seed for our random number generator.
    */
    public native void resetRNGSeed();

    /** 
      Serializes the OSystem state.
    */
    public native @Cast("bool") boolean saveState(@ByRef Serializer out);

    /** 
      Deserializes the OSystem state.
    */
    public native @Cast("bool") boolean loadState(@ByRef Deserializer in);
    //////////////////////////////////////////////////////////////////////
    // The following methods are system-specific and must be implemented
    // in derived classes.
    //////////////////////////////////////////////////////////////////////
    /**
      This method returns number of ticks in microseconds.
      <p>
      @return Current time in microseconds.
    */
    public native @Cast("uInt32") int getTicks(); //ALE 
    // Time per frame for a video update, based on the current framerate
    public native @Cast("uInt32") int myTimePerFrame(); public native OSystem myTimePerFrame(int setter);

    // Indicates whether the main processing loop should proceed
    public static class TimingInfo extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public TimingInfo() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public TimingInfo(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public TimingInfo(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public TimingInfo position(long position) {
            return (TimingInfo)super.position(position);
        }
    
      public native @Cast("uInt32") int start(); public native TimingInfo start(int setter);
      public native @Cast("uInt32") int current(); public native TimingInfo current(int setter);
      public native @Cast("uInt32") int virt(); public native TimingInfo virt(int setter);
      public native @Cast("uInt32") int totalTime(); public native TimingInfo totalTime(int setter);
      public native @Cast("uInt32") int totalFrames(); public native TimingInfo totalFrames(int setter);
    }
    public native @ByRef TimingInfo myTimingInfo(); public native OSystem myTimingInfo(TimingInfo setter);

    public native @ByRef ColourPalette colourPalette();
    public native DisplayScreen p_display_screen(); public native OSystem p_display_screen(DisplayScreen setter);
}
