/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.CharOperation;
import org.aspectj.asm.internal.NameConvertor;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

public class ProgramElement
implements IProgramElement {
    public transient AsmManager asm;
    private static final long serialVersionUID = 171673495267384449L;
    public static boolean shortITDNames = true;
    private static final String UNDEFINED = "<undefined>";
    private static final int AccPublic = 1;
    private static final int AccPrivate = 2;
    private static final int AccProtected = 4;
    private static final int AccPrivileged = 6;
    private static final int AccStatic = 8;
    private static final int AccFinal = 16;
    private static final int AccSynchronized = 32;
    private static final int AccVolatile = 64;
    private static final int AccTransient = 128;
    private static final int AccNative = 256;
    private static final int AccInterface = 512;
    private static final int AccAbstract = 1024;
    private static final int AccStrictfp = 2048;
    protected String name;
    private IProgramElement.Kind kind;
    protected IProgramElement parent = null;
    protected List children = Collections.EMPTY_LIST;
    public Map kvpairs = Collections.EMPTY_MAP;
    protected ISourceLocation sourceLocation = null;
    public int modifiers;
    private String handle = null;

    public AsmManager getModel() {
        return this.asm;
    }

    public ProgramElement() {
        boolean stop = true;
    }

    public ProgramElement(AsmManager asm, String name, IProgramElement.Kind kind, List children) {
        this.asm = asm;
        if (asm == null && !name.equals("<build to view structure>")) {
            throw new RuntimeException();
        }
        this.name = name;
        this.kind = kind;
        if (children != null) {
            this.setChildren(children);
        }
    }

    public ProgramElement(AsmManager asm, String name, IProgramElement.Kind kind, ISourceLocation sourceLocation, int modifiers, String comment, List children) {
        this(asm, name, kind, children);
        this.sourceLocation = sourceLocation;
        this.setFormalComment(comment);
        this.modifiers = modifiers;
    }

    public int getRawModifiers() {
        return this.modifiers;
    }

    public List getModifiers() {
        return ProgramElement.genModifiers(this.modifiers);
    }

    public IProgramElement.Accessibility getAccessibility() {
        return ProgramElement.genAccessibility(this.modifiers);
    }

    public void setDeclaringType(String t) {
        if (t != null && t.length() > 0) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("declaringType", t);
        }
    }

    public String getDeclaringType() {
        String dt = (String)this.kvpairs.get("declaringType");
        if (dt == null) {
            return "";
        }
        return dt;
    }

    public String getPackageName() {
        if (this.kind == IProgramElement.Kind.PACKAGE) {
            return this.getName();
        }
        if (this.getParent() == null) {
            return "";
        }
        return this.getParent().getPackageName();
    }

    public IProgramElement.Kind getKind() {
        return this.kind;
    }

    public boolean isCode() {
        return this.kind.equals(IProgramElement.Kind.CODE);
    }

    public ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(ISourceLocation sourceLocation) {
    }

    public IMessage getMessage() {
        return (IMessage)this.kvpairs.get("message");
    }

    public void setMessage(IMessage message) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("message", message);
    }

    public IProgramElement getParent() {
        return this.parent;
    }

    public void setParent(IProgramElement parent) {
        this.parent = parent;
    }

    public boolean isMemberKind() {
        return this.kind.isMember();
    }

    public void setRunnable(boolean value) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (value) {
            this.kvpairs.put("isRunnable", "true");
        } else {
            this.kvpairs.remove("isRunnable");
        }
    }

    public boolean isRunnable() {
        return this.kvpairs.get("isRunnable") != null;
    }

    public boolean isImplementor() {
        return this.kvpairs.get("isImplementor") != null;
    }

    public void setImplementor(boolean value) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (value) {
            this.kvpairs.put("isImplementor", "true");
        } else {
            this.kvpairs.remove("isImplementor");
        }
    }

    public boolean isOverrider() {
        return this.kvpairs.get("isOverrider") != null;
    }

    public void setOverrider(boolean value) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (value) {
            this.kvpairs.put("isOverrider", "true");
        } else {
            this.kvpairs.remove("isOverrider");
        }
    }

    public List getRelations() {
        return (List)this.kvpairs.get("relations");
    }

    public void setRelations(List relations) {
        if (relations.size() > 0) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("relations", relations);
        }
    }

    public String getFormalComment() {
        return (String)this.kvpairs.get("formalComment");
    }

    public String toString() {
        return this.toLabelString();
    }

    private static List genModifiers(int modifiers) {
        ArrayList<IProgramElement.Modifiers> modifiersList = new ArrayList<IProgramElement.Modifiers>();
        if ((modifiers & 8) != 0) {
            modifiersList.add(IProgramElement.Modifiers.STATIC);
        }
        if ((modifiers & 0x10) != 0) {
            modifiersList.add(IProgramElement.Modifiers.FINAL);
        }
        if ((modifiers & 0x20) != 0) {
            modifiersList.add(IProgramElement.Modifiers.SYNCHRONIZED);
        }
        if ((modifiers & 0x40) != 0) {
            modifiersList.add(IProgramElement.Modifiers.VOLATILE);
        }
        if ((modifiers & 0x80) != 0) {
            modifiersList.add(IProgramElement.Modifiers.TRANSIENT);
        }
        if ((modifiers & 0x100) != 0) {
            modifiersList.add(IProgramElement.Modifiers.NATIVE);
        }
        if ((modifiers & 0x400) != 0) {
            modifiersList.add(IProgramElement.Modifiers.ABSTRACT);
        }
        return modifiersList;
    }

    public static IProgramElement.Accessibility genAccessibility(int modifiers) {
        if ((modifiers & 1) != 0) {
            return IProgramElement.Accessibility.PUBLIC;
        }
        if ((modifiers & 2) != 0) {
            return IProgramElement.Accessibility.PRIVATE;
        }
        if ((modifiers & 4) != 0) {
            return IProgramElement.Accessibility.PROTECTED;
        }
        if ((modifiers & 6) != 0) {
            return IProgramElement.Accessibility.PRIVILEGED;
        }
        return IProgramElement.Accessibility.PACKAGE;
    }

    public String getBytecodeName() {
        String s = (String)this.kvpairs.get("bytecodeName");
        if (s == null) {
            return UNDEFINED;
        }
        return s;
    }

    public void setBytecodeName(String s) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("bytecodeName", s);
    }

    public void setBytecodeSignature(String s) {
        this.initMap();
        this.kvpairs.put("bytecodeSignature", s);
    }

    public String getBytecodeSignature() {
        String s = (String)this.kvpairs.get("bytecodeSignature");
        return s;
    }

    private void initMap() {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
    }

    public String getSourceSignature() {
        return (String)this.kvpairs.get("sourceSignature");
    }

    public void setSourceSignature(String string) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("sourceSignature", string);
    }

    public void setKind(IProgramElement.Kind kind) {
        this.kind = kind;
    }

    public void setCorrespondingType(String s) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("returnType", s);
    }

    public void setParentTypes(List ps) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("parentTypes", ps);
    }

    public List getParentTypes() {
        return this.kvpairs == null ? null : this.kvpairs.get("parentTypes");
    }

    public void setAnnotationType(String fullyQualifiedAnnotationType) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("annotationType", fullyQualifiedAnnotationType);
    }

    public String getAnnotationType() {
        return this.kvpairs == null ? null : this.kvpairs.get("annotationType");
    }

    public String getCorrespondingType() {
        return this.getCorrespondingType(false);
    }

    public String getCorrespondingType(boolean getFullyQualifiedType) {
        String returnType = (String)this.kvpairs.get("returnType");
        if (returnType == null) {
            returnType = "";
        }
        if (getFullyQualifiedType) {
            return returnType;
        }
        int index = returnType.lastIndexOf(".");
        if (index != -1) {
            return returnType.substring(index + 1);
        }
        return returnType;
    }

    public String getName() {
        return this.name;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
        if (children == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ((IProgramElement)it.next()).setParent(this);
        }
    }

    public void addChild(IProgramElement child) {
        if (this.children == null || this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(int position, IProgramElement child) {
        if (this.children == null || this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList();
        }
        this.children.add(position, child);
        child.setParent(this);
    }

    public boolean removeChild(IProgramElement child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    public void setName(String string) {
        this.name = string;
    }

    public IProgramElement walk(HierarchyWalker walker) {
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                IProgramElement child = (IProgramElement)it.next();
                walker.process(child);
            }
        }
        return this;
    }

    public String toLongString() {
        final StringBuffer buffer = new StringBuffer();
        HierarchyWalker walker = new HierarchyWalker(){
            private int depth = 0;

            public void preProcess(IProgramElement node) {
                for (int i = 0; i < this.depth; ++i) {
                    buffer.append(' ');
                }
                buffer.append(((Object)node).toString());
                buffer.append('\n');
                this.depth += 2;
            }

            public void postProcess(IProgramElement node) {
                this.depth -= 2;
            }
        };
        walker.process(this);
        return buffer.toString();
    }

    public void setModifiers(int i) {
        this.modifiers = i;
    }

    public void addModifiers(IProgramElement.Modifiers newModifier) {
        this.modifiers |= newModifier.getBit();
    }

    public String toSignatureString() {
        return this.toSignatureString(true);
    }

    public String toSignatureString(boolean getFullyQualifiedArgTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        List ptypes = this.getParameterTypes();
        if (ptypes != null && (!ptypes.isEmpty() || this.kind.equals(IProgramElement.Kind.METHOD)) || this.kind.equals(IProgramElement.Kind.CONSTRUCTOR) || this.kind.equals(IProgramElement.Kind.ADVICE) || this.kind.equals(IProgramElement.Kind.POINTCUT) || this.kind.equals(IProgramElement.Kind.INTER_TYPE_METHOD) || this.kind.equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR)) {
            sb.append('(');
            Iterator it = ptypes.iterator();
            while (it.hasNext()) {
                char[] arg = (char[])it.next();
                if (getFullyQualifiedArgTypes) {
                    sb.append(arg);
                } else {
                    int index = CharOperation.lastIndexOf('.', arg);
                    if (index != -1) {
                        sb.append(CharOperation.subarray(arg, index + 1, arg.length));
                    } else {
                        sb.append(arg);
                    }
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String toLinkLabelString() {
        return this.toLinkLabelString(true);
    }

    public String toLinkLabelString(boolean getFullyQualifiedArgTypes) {
        String label;
        if (this.kind == IProgramElement.Kind.CODE || this.kind == IProgramElement.Kind.INITIALIZER) {
            label = this.parent.getParent().getName() + ": ";
        } else if (this.kind.isInterTypeMember()) {
            if (shortITDNames) {
                label = "";
            } else {
                int dotIndex = this.name.indexOf(46);
                if (dotIndex != -1) {
                    return this.parent.getName() + ": " + this.toLabelString().substring(dotIndex + 1);
                }
                label = this.parent.getName() + '.';
            }
        } else {
            label = this.kind == IProgramElement.Kind.CLASS || this.kind == IProgramElement.Kind.ASPECT || this.kind == IProgramElement.Kind.INTERFACE ? "" : (this.kind.equals(IProgramElement.Kind.DECLARE_PARENTS) ? "" : (this.parent != null ? this.parent.getName() + '.' : "injar aspect: "));
        }
        label = label + this.toLabelString(getFullyQualifiedArgTypes);
        return label;
    }

    public String toLabelString() {
        return this.toLabelString(true);
    }

    public String toLabelString(boolean getFullyQualifiedArgTypes) {
        String label = this.toSignatureString(getFullyQualifiedArgTypes);
        String details = this.getDetails();
        if (details != null) {
            label = label + ": " + details;
        }
        return label;
    }

    public String getHandleIdentifier() {
        return this.getHandleIdentifier(true);
    }

    public String getHandleIdentifier(boolean create) {
        String h = this.handle;
        if (null == this.handle && create) {
            if (this.asm == null && this.name.equals("<build to view structure>")) {
                h = "<build to view structure>";
            } else {
                try {
                    h = this.asm.getHandleProvider().createHandleIdentifier(this);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    throw new RuntimeException("AIOOBE whilst building handle for " + this, aioobe);
                }
            }
        }
        this.setHandleIdentifier(h);
        return h;
    }

    public void setHandleIdentifier(String handle) {
        this.handle = handle;
    }

    public List getParameterNames() {
        List parameterNames = (List)this.kvpairs.get("parameterNames");
        return parameterNames;
    }

    public void setParameterNames(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("parameterNames", list);
    }

    public List getParameterTypes() {
        List l = this.getParameterSignatures();
        if (l == null || l.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<char[]> params = new ArrayList<char[]>();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            char[] param = (char[])iter.next();
            params.add(NameConvertor.convertFromSignature(param));
        }
        return params;
    }

    public List getParameterSignatures() {
        List parameters = (List)this.kvpairs.get("parameterSigs");
        return parameters;
    }

    public List getParameterSignaturesSourceRefs() {
        List parameters = (List)this.kvpairs.get("parameterSigsSourceRefs");
        return parameters;
    }

    public void setParameterSignatures(List list, List sourceRefs) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        if (list == null || list.size() == 0) {
            this.kvpairs.put("parameterSigs", Collections.EMPTY_LIST);
        } else {
            this.kvpairs.put("parameterSigs", list);
        }
        if (sourceRefs != null && sourceRefs.size() != 0) {
            this.kvpairs.put("parameterSigsSourceRefs", sourceRefs);
        }
    }

    public String getDetails() {
        String details = (String)this.kvpairs.get("details");
        return details;
    }

    public void setDetails(String string) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("details", string);
    }

    public void setFormalComment(String txt) {
        if (txt != null && txt.length() > 0) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("formalComment", txt);
        }
    }

    public void setExtraInfo(IProgramElement.ExtraInformation info) {
        if (this.kvpairs == Collections.EMPTY_MAP) {
            this.kvpairs = new HashMap();
        }
        this.kvpairs.put("ExtraInformation", info);
    }

    public IProgramElement.ExtraInformation getExtraInfo() {
        return (IProgramElement.ExtraInformation)this.kvpairs.get("ExtraInformation");
    }

    public boolean isAnnotationStyleDeclaration() {
        return this.kvpairs.get("annotationStyleDeclaration") != null;
    }

    public void setAnnotationStyleDeclaration(boolean b) {
        if (b) {
            if (this.kvpairs == Collections.EMPTY_MAP) {
                this.kvpairs = new HashMap();
            }
            this.kvpairs.put("annotationStyleDeclaration", "true");
        }
    }
}

