/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import java.io.File;
import java.util.HashSet;
import org.apache.lucene.util.QuickPatchThreadsFilter;
import org.apache.solr.SolrIgnoredThreadsFilter;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.util.TestHarness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadLeakFilters(defaultFilters=true, filters={SolrIgnoredThreadsFilter.class, QuickPatchThreadsFilter.class})
public abstract class AbstractSolrTestCase
extends SolrTestCaseJ4 {
    protected SolrConfig solrConfig;
    public static Logger log = LoggerFactory.getLogger(AbstractSolrTestCase.class);

    public String getSolrHome() {
        return SolrTestCaseJ4.TEST_HOME();
    }

    public static void ignoreException(String pattern) {
        if (SolrException.ignorePatterns == null) {
            SolrException.ignorePatterns = new HashSet();
        }
        SolrException.ignorePatterns.add(pattern);
    }

    public static void resetExceptionIgnores() {
        SolrException.ignorePatterns = null;
        AbstractSolrTestCase.ignoreException("ignore_exception");
    }

    @Override
    public void postSetUp() {
        log.info("####POSTSETUP " + this.getTestName());
    }

    @Override
    public void preTearDown() {
        log.info("####PRETEARDOWN " + this.getTestName());
    }

    public String adoc(int commitWithin, String ... fieldsAndValues) {
        SolrTestCaseJ4.XmlDoc d = AbstractSolrTestCase.doc(fieldsAndValues);
        return AbstractSolrTestCase.add(d, "commitWithin", String.valueOf(commitWithin));
    }

    public String delI(String id, String ... args) {
        return TestHarness.deleteById(id, args);
    }

    public String delQ(String q, String ... args) {
        return TestHarness.deleteByQuery(q, args);
    }

    public static boolean recurseDelete(File f) {
        if (f.isDirectory()) {
            for (File sub : f.listFiles()) {
                if (AbstractSolrTestCase.recurseDelete(sub)) continue;
                System.err.println("!!!! WARNING: best effort to remove " + sub.getAbsolutePath() + " FAILED !!!!!");
                return false;
            }
        }
        return f.delete();
    }

    public static File getFile(String name) {
        return SolrTestCaseJ4.getFile(name);
    }
}

