/*
 * $Id$
 */

package org.apache.maven.profiles;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;
import java.util.Properties;

/**
 * Class Profile.
 * 
 * @version $Revision$ $Date$
 */
public class Profile implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field activation
     */
    private Activation activation;

    /**
     * Field properties
     */
    private java.util.Properties properties;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     *  This may be removed or relocated in the near
     *             future. It is undecided whether plugins really
     * need a remote
     *             repository set of their own. 
     */
    private java.util.List pluginRepositories;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPluginRepository
     * 
     * @param repository
     */
    public void addPluginRepository(Repository repository)
    {
        getPluginRepositories().add( repository );
    } //-- void addPluginRepository(Repository) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Method getActivation
     */
    public Activation getActivation()
    {
        return this.activation;
    } //-- Activation getActivation() 

    /**
     * Method getId
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getPluginRepositories
     */
    public java.util.List getPluginRepositories()
    {
        if ( this.pluginRepositories == null )
        {
            this.pluginRepositories = new java.util.ArrayList();
        }
        
        return this.pluginRepositories;
    } //-- java.util.List getPluginRepositories() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method removePluginRepository
     * 
     * @param repository
     */
    public void removePluginRepository(Repository repository)
    {
        getPluginRepositories().remove( repository );
    } //-- void removePluginRepository(Repository) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Method setActivation
     * 
     * @param activation
     */
    public void setActivation(Activation activation)
    {
        this.activation = activation;
    } //-- void setActivation(Activation) 

    /**
     * Method setId
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Method setPluginRepositories
     * 
     * @param pluginRepositories
     */
    public void setPluginRepositories(java.util.List pluginRepositories)
    {
        this.pluginRepositories = pluginRepositories;
    } //-- void setPluginRepositories(java.util.List) 

    /**
     * Method setProperties
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Method setRepositories
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 

}
