/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.MetadataResponse;

public class MetadataRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.METADATA.id);
    private static final String TOPICS_KEY_NAME = "topics";
    private final List<String> topics;

    public MetadataRequest(List<String> topics) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        this.topics = topics;
    }

    public MetadataRequest(Struct struct) {
        super(struct);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        this.topics = new ArrayList<String>();
        for (Object topicObj : topicArray) {
            this.topics.add((String)topicObj);
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>();
        for (String topic : this.topics) {
            topicErrors.put(topic, Errors.forException(e));
        }
        Cluster cluster = new Cluster(Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        switch (versionId) {
            case 0: {
                return new MetadataResponse(cluster, topicErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.METADATA.id)));
    }

    public List<String> topics() {
        return this.topics;
    }

    public static MetadataRequest parse(ByteBuffer buffer, int versionId) {
        return new MetadataRequest(ProtoUtils.parseRequest(ApiKeys.METADATA.id, versionId, buffer));
    }

    public static MetadataRequest parse(ByteBuffer buffer) {
        return new MetadataRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

