/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="add_months", value="_FUNC_(start_date, num_months) - Returns the date that is num_months after start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_months is a number. The time part of start_date is ignored.\nExample:\n  > SELECT _FUNC_('2009-08-31', 1) FROM src LIMIT 1;\n '2009-09-30'")
public class GenericUDFAddMonths
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient ObjectInspectorConverters.Converter intWritableConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final Calendar calendar = Calendar.getInstance();
    private final Text output = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("add_months() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed. as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[2].getTypeName() + " is passed. as second arguments");
        }
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        switch (this.inputType1) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" ADD_MONTHS() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + (Object)((Object)this.inputType1));
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        if (this.inputType2 != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentException(" ADD_MONTHS() only takes INT types as second argument, got " + (Object)((Object)this.inputType2));
        }
        this.intWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Date date;
        if (arguments[0].get() == null) {
            return null;
        }
        IntWritable toBeAdded = (IntWritable)this.intWritableConverter.convert(arguments[1].get());
        if (toBeAdded == null) {
            return null;
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.textConverter.convert(arguments[0].get()).toString();
                try {
                    date = this.formatter.parse(dateString.toString());
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts;
                date = ts = ((TimestampWritable)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)this.dateWritableConverter.convert(arguments[0].get());
                date = dw.get();
                break;
            }
            default: {
                throw new UDFArgumentException("ADD_MONTHS() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType1));
            }
        }
        int numMonth = toBeAdded.get();
        this.addMonth(date, numMonth);
        Date newDate = this.calendar.getTime();
        this.output.set(this.formatter.format(newDate));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("add_months(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(", ");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected Calendar addMonth(Date d, int numMonths) {
        this.calendar.setTime(d);
        boolean lastDatOfMonth = this.isLastDayOfMonth(this.calendar);
        this.calendar.add(2, numMonths);
        if (lastDatOfMonth) {
            int maxDd = this.calendar.getActualMaximum(5);
            this.calendar.set(5, maxDd);
        }
        return this.calendar;
    }

    protected boolean isLastDayOfMonth(Calendar cal) {
        int maxDd = cal.getActualMaximum(5);
        int dd = cal.get(5);
        return dd == maxDd;
    }
}

