/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming.io;

import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.streaming.io.InputWriter;
import org.apache.hadoop.streaming.io.KeyOnlyTextInputWriter;
import org.apache.hadoop.streaming.io.KeyOnlyTextOutputReader;
import org.apache.hadoop.streaming.io.OutputReader;
import org.apache.hadoop.streaming.io.RawBytesInputWriter;
import org.apache.hadoop.streaming.io.RawBytesOutputReader;
import org.apache.hadoop.streaming.io.TextInputWriter;
import org.apache.hadoop.streaming.io.TextOutputReader;
import org.apache.hadoop.streaming.io.TypedBytesInputWriter;
import org.apache.hadoop.streaming.io.TypedBytesOutputReader;
import org.apache.hadoop.typedbytes.TypedBytesWritable;

public class IdentifierResolver {
    public static final String TEXT_ID = "text";
    public static final String RAW_BYTES_ID = "rawbytes";
    public static final String TYPED_BYTES_ID = "typedbytes";
    public static final String KEY_ONLY_TEXT_ID = "keyonlytext";
    private Class<? extends InputWriter> inputWriterClass = null;
    private Class<? extends OutputReader> outputReaderClass = null;
    private Class outputKeyClass = null;
    private Class outputValueClass = null;

    public void resolve(String identifier) {
        if (identifier.equalsIgnoreCase(RAW_BYTES_ID)) {
            this.setInputWriterClass(RawBytesInputWriter.class);
            this.setOutputReaderClass(RawBytesOutputReader.class);
            this.setOutputKeyClass(BytesWritable.class);
            this.setOutputValueClass(BytesWritable.class);
        } else if (identifier.equalsIgnoreCase(TYPED_BYTES_ID)) {
            this.setInputWriterClass(TypedBytesInputWriter.class);
            this.setOutputReaderClass(TypedBytesOutputReader.class);
            this.setOutputKeyClass(TypedBytesWritable.class);
            this.setOutputValueClass(TypedBytesWritable.class);
        } else if (identifier.equalsIgnoreCase(KEY_ONLY_TEXT_ID)) {
            this.setInputWriterClass(KeyOnlyTextInputWriter.class);
            this.setOutputReaderClass(KeyOnlyTextOutputReader.class);
            this.setOutputKeyClass(Text.class);
            this.setOutputValueClass(NullWritable.class);
        } else {
            this.setInputWriterClass(TextInputWriter.class);
            this.setOutputReaderClass(TextOutputReader.class);
            this.setOutputKeyClass(Text.class);
            this.setOutputValueClass(Text.class);
        }
    }

    public Class<? extends InputWriter> getInputWriterClass() {
        return this.inputWriterClass;
    }

    public Class<? extends OutputReader> getOutputReaderClass() {
        return this.outputReaderClass;
    }

    public Class getOutputKeyClass() {
        return this.outputKeyClass;
    }

    public Class getOutputValueClass() {
        return this.outputValueClass;
    }

    protected void setInputWriterClass(Class<? extends InputWriter> inputWriterClass) {
        this.inputWriterClass = inputWriterClass;
    }

    protected void setOutputReaderClass(Class<? extends OutputReader> outputReaderClass) {
        this.outputReaderClass = outputReaderClass;
    }

    protected void setOutputKeyClass(Class outputKeyClass) {
        this.outputKeyClass = outputKeyClass;
    }

    protected void setOutputValueClass(Class outputValueClass) {
        this.outputValueClass = outputValueClass;
    }
}

