/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTransferFsImage {
    private static final File TEST_DIR = PathUtils.getTestDir(TestTransferFsImage.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSideException() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        List<File> localPath = Collections.singletonList(new File("/xxxxx-does-not-exist/blah"));
        try {
            URL fsName = DFSUtil.getInfoServer((InetSocketAddress)cluster.getNameNode().getServiceRpcAddress(), (Configuration)conf, (String)DFSUtil.getHttpClientScheme((Configuration)conf)).toURL();
            String id = "getimage=1&txid=0";
            TransferFsImage.getFileClient((URL)fsName, (String)id, localPath, (Storage)mockStorage, (boolean)false);
            Assert.fail((String)"Didn't get an exception!");
        }
        catch (IOException ioe) {
            ((NNStorage)Mockito.verify((Object)mockStorage)).reportErrorOnFile(localPath.get(0));
            Assert.assertTrue((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)ioe)), (boolean)ioe.getMessage().contains("Unable to download to any storage"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientSideExceptionOnJustOneDir() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        ImmutableList localPaths = ImmutableList.of((Object)new File("/xxxxx-does-not-exist/blah"), (Object)new File(TEST_DIR, "testfile"));
        try {
            URL fsName = DFSUtil.getInfoServer((InetSocketAddress)cluster.getNameNode().getServiceRpcAddress(), (Configuration)conf, (String)DFSUtil.getHttpClientScheme((Configuration)conf)).toURL();
            String id = "getimage=1&txid=0";
            TransferFsImage.getFileClient((URL)fsName, (String)id, (List)localPaths, (Storage)mockStorage, (boolean)false);
            ((NNStorage)Mockito.verify((Object)mockStorage)).reportErrorOnFile((File)localPaths.get(0));
            Assert.assertTrue((String)"The valid local file should get saved properly", (((File)localPaths.get(1)).length() > 0L ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testImageTransferTimeout() throws Exception {
        HttpServer2 testServer = HttpServerFunctionalTest.createServer((String)"hdfs");
        try {
            testServer.addServlet("GetImage", "/getimage", TestGetImageServlet.class);
            testServer.start();
            URL serverURL = HttpServerFunctionalTest.getServerURL((HttpServer2)testServer);
            TransferFsImage.timeout = 2000;
            try {
                TransferFsImage.getFileClient((URL)serverURL, (String)"txid=1", null, null, (boolean)false);
                Assert.fail((String)"TransferImage Should fail with timeout");
            }
            catch (SocketTimeoutException e) {
                Assert.assertEquals((String)"Read should timeout", (Object)"Read timed out", (Object)e.getMessage());
            }
        }
        finally {
            if (testServer != null) {
                testServer.stop();
            }
        }
    }

    public static class TestGetImageServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            TestGetImageServlet testGetImageServlet = this;
            synchronized (testGetImageServlet) {
                try {
                    ((Object)((Object)this)).wait(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }
}

