/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestFSNamesystemMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String snapshotStats = (String)mbs.getAttribute(mxbeanName, "SnapshotStats");
            Map stat = (Map)JSON.parse((String)snapshotStats);
            Assert.assertTrue((stat.containsKey("SnapshottableDirectories") && (Long)stat.get("SnapshottableDirectories") == (long)fsn.getNumSnapshottableDirs() ? 1 : 0) != 0);
            Assert.assertTrue((stat.containsKey("Snapshots") && (Long)stat.get("Snapshots") == (long)fsn.getNumSnapshots() ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

