/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSShellGenericOptions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSCommand() throws IOException {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            String[] args = new String[4];
            args[2] = "-mkdir";
            args[3] = "/data";
            this.testFsOption(args, namenode);
            this.testConfOption(args, namenode);
            this.testPropertyOption(args, namenode);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testFsOption(String[] args, String namenode) {
        args[0] = "-fs";
        args[1] = namenode;
        this.execute(args, namenode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConfOption(String[] args, String namenode) {
        File configDir = new File(new File("build", "test"), "minidfs");
        Assert.assertTrue((boolean)configDir.mkdirs());
        File siteFile = new File(configDir, "hdfs-site.xml");
        try {
            PrintWriter pw = new PrintWriter(siteFile);
            pw.print("<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration>\n <property>\n   <name>fs.defaultFS</name>\n   <value>" + namenode + "</value>\n" + " </property>\n" + "</configuration>\n");
            pw.close();
            args[0] = "-conf";
            args[1] = siteFile.getPath();
            this.execute(args, namenode);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            siteFile.delete();
            configDir.delete();
        }
    }

    private void testPropertyOption(String[] args, String namenode) {
        args[0] = "-D";
        args[1] = "fs.defaultFS=" + namenode;
        this.execute(args, namenode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args, String namenode) {
        FsShell shell = new FsShell();
        FileSystem fs = null;
        try {
            ToolRunner.run((Tool)shell, (String[])args);
            fs = FileSystem.get((URI)NameNode.getUri((InetSocketAddress)NameNode.getAddress((String)namenode)), (Configuration)shell.getConf());
            Assert.assertTrue((String)"Directory does not get created", (boolean)fs.isDirectory(new Path("/data")));
            fs.delete(new Path("/data"), true);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

