/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;

class SelectTableSinkSchemaConverter {
    SelectTableSinkSchemaConverter() {
    }

    static TableSchema convertTimeAttributeToRegularTimestamp(TableSchema tableSchema) {
        DataType[] oldTypes = tableSchema.getFieldDataTypes();
        String[] oldNames = tableSchema.getFieldNames();
        TableSchema.Builder builder = TableSchema.builder();
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            LocalZonedTimestampType localZonedTimestampType;
            TimestampType timestampType;
            DataType fieldType = oldTypes[i];
            String fieldName = oldNames[i];
            if (fieldType.getLogicalType() instanceof TimestampType && !(timestampType = (TimestampType)fieldType.getLogicalType()).getKind().equals((Object)TimestampKind.REGULAR)) {
                builder.field(fieldName, Types.SQL_TIMESTAMP);
                continue;
            }
            if (fieldType.getLogicalType() instanceof LocalZonedTimestampType && !(localZonedTimestampType = (LocalZonedTimestampType)fieldType.getLogicalType()).getKind().equals((Object)TimestampKind.REGULAR)) {
                builder.field(fieldName, Types.SQL_TIMESTAMP);
                continue;
            }
            builder.field(fieldName, fieldType);
        }
        return builder.build();
    }
}

