/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.datastream;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.catalog.BasicOperatorTable$;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.PlannerResolvedFieldReference;
import org.apache.flink.table.expressions.WindowReference;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.plan.rules.common.LogicalWindowAggregateRule;
import org.apache.flink.table.plan.rules.datastream.DataStreamLogicalWindowAggregateRule$;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001#\t!C)\u0019;b'R\u0014X-Y7M_\u001eL7-\u00197XS:$wn^!hOJ,w-\u0019;f%VdWM\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\taaY8n[>t\u0017BA\f\u0015\u0005iaunZ5dC2<\u0016N\u001c3po\u0006;wM]3hCR,'+\u001e7f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001\u0003\u0004\u001f\u0001\u0011\u0005\u0003bH\u0001\u001eO\u0016$\u0018J\\!hOJ,w-\u0019;f\u000fJ|W\u000f]#yaJ,7o]5p]R\u0019\u0001\u0005K\u0017\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013a\u0001:fq*\u0011Q\u0005D\u0001\bG\u0006d7-\u001b;f\u0013\t9#EA\u0004SKbtu\u000eZ3\t\u000b%j\u0002\u0019\u0001\u0016\u0002\u0015I,\u0007PQ;jY\u0012,'\u000f\u0005\u0002\"W%\u0011AF\t\u0002\u000b%\u0016D()^5mI\u0016\u0014\b\"\u0002\u0018\u001e\u0001\u0004y\u0013\u0001E<j]\u0012|w/\u0012=qe\u0016\u001c8/[8o!\t\t\u0003'\u0003\u00022E\t9!+\u001a=DC2d\u0007BB\u001a\u0001\t\u0003BA'\u0001\u0010hKR|U\u000f^!hOJ,w-\u0019;f\u000fJ|W\u000f]#yaJ,7o]5p]R\u0019\u0001%\u000e\u001c\t\u000b%\u0012\u0004\u0019\u0001\u0016\t\u000b9\u0012\u0004\u0019A\u0018\t\ra\u0002A\u0011\t\u0005:\u0003e!(/\u00198tY\u0006$XmV5oI><X\t\u001f9sKN\u001c\u0018n\u001c8\u0015\u0007i\u0002%\t\u0005\u0002<}5\tAH\u0003\u0002>\r\u00059An\\4jG\u0006d\u0017BA =\u00055aunZ5dC2<\u0016N\u001c3po\")\u0011i\u000ea\u0001_\u0005Qq/\u001b8e_^,\u0005\u0010\u001d:\t\u000b\r;\u0004\u0019\u0001#\u0002\u000fI|w\u000fV=qKB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005if\u0004XM\u0003\u0002JI\u0005\u0019!/\u001a7\n\u0005-3%a\u0003*fY\u0012\u000bG/\u0019+za\u0016<Q!\u0014\u0002\t\u00029\u000bA\u0005R1uCN#(/Z1n\u0019><\u0017nY1m/&tGm\\<BO\u001e\u0014XmZ1uKJ+H.\u001a\t\u00039=3Q!\u0001\u0002\t\u0002A\u001b\"aT)\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\n\"\u0001Y)\u0005q\u0005b\u0002.P\u0005\u0004%\taW\u0001\t\u0013:\u001bF+\u0011(D\u000bV\t1\u0004\u0003\u0004^\u001f\u0002\u0006IaG\u0001\n\u0013:\u001bF+\u0011(D\u000b\u0002\u0002")
public class DataStreamLogicalWindowAggregateRule
extends LogicalWindowAggregateRule {
    public static DataStreamLogicalWindowAggregateRule INSTANCE() {
        return DataStreamLogicalWindowAggregateRule$.MODULE$.INSTANCE();
    }

    @Override
    public RexNode getInAggregateGroupExpression(RexBuilder rexBuilder, RexCall windowExpression) {
        RexNode timeAttribute;
        RexNode rexNode = timeAttribute = (RexNode)windowExpression.operands.get(0);
        if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(timeAttribute.getType())) {
            throw new TableException(new StringBuilder(41).append("Time attribute expected but ").append(timeAttribute.getType()).append(" encountered.").toString());
        }
        RexNode rexNode2 = timeAttribute;
        return rexNode2;
    }

    @Override
    public RexNode getOutAggregateGroupExpression(RexBuilder rexBuilder, RexCall windowExpression) {
        return rexBuilder.makeLiteral((Object)BoxesRunTime.boxToLong((long)0L), rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP), true);
    }

    @Override
    public LogicalWindow translateWindowExpression(RexCall windowExpr, RelDataType rowType) {
        LogicalWindow logicalWindow;
        SqlOperator sqlOperator = windowExpr.getOperator();
        SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE();
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
            PlannerResolvedFieldReference time = DataStreamLogicalWindowAggregateRule.getOperandAsTimeIndicator$1(windowExpr, 0, rowType);
            long interval = DataStreamLogicalWindowAggregateRule.getOperandAsLong$1(windowExpr, 1);
            logicalWindow = new TumblingGroupWindow(new WindowReference("w$", (Option<TypeInformation<?>>)new Some(time.resultType())), time, new Literal(BoxesRunTime.boxToLong((long)interval), (TypeInformation<?>)TimeIntervalTypeInfo.INTERVAL_MILLIS));
        } else {
            SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP();
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                PlannerResolvedFieldReference time = DataStreamLogicalWindowAggregateRule.getOperandAsTimeIndicator$1(windowExpr, 0, rowType);
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(DataStreamLogicalWindowAggregateRule.getOperandAsLong$1(windowExpr, 1), DataStreamLogicalWindowAggregateRule.getOperandAsLong$1(windowExpr, 2));
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                long slide = sp2._1$mcJ$sp();
                long size = sp2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(slide, size);
                Tuple2.mcJJ.sp sp4 = sp3;
                long slide2 = sp4._1$mcJ$sp();
                long size2 = sp4._2$mcJ$sp();
                logicalWindow = new SlidingGroupWindow(new WindowReference("w$", (Option<TypeInformation<?>>)new Some(time.resultType())), time, new Literal(BoxesRunTime.boxToLong((long)size2), (TypeInformation<?>)TimeIntervalTypeInfo.INTERVAL_MILLIS), new Literal(BoxesRunTime.boxToLong((long)slide2), (TypeInformation<?>)TimeIntervalTypeInfo.INTERVAL_MILLIS));
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION();
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null)) {
                    PlannerResolvedFieldReference time = DataStreamLogicalWindowAggregateRule.getOperandAsTimeIndicator$1(windowExpr, 0, rowType);
                    long gap = DataStreamLogicalWindowAggregateRule.getOperandAsLong$1(windowExpr, 1);
                    logicalWindow = new SessionGroupWindow(new WindowReference("w$", (Option<TypeInformation<?>>)new Some(time.resultType())), time, new Literal(BoxesRunTime.boxToLong((long)gap), (TypeInformation<?>)TimeIntervalTypeInfo.INTERVAL_MILLIS));
                } else {
                    throw new MatchError((Object)sqlOperator);
                }
            }
        }
        return logicalWindow;
    }

    private static final long getOperandAsLong$1(RexCall call, int idx) {
        RexLiteral rexLiteral;
        block3: {
            block2: {
                RexNode rexNode = call.getOperands().get(idx);
                if (!(rexNode instanceof RexLiteral)) break block2;
                rexLiteral = (RexLiteral)rexNode;
                SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
                SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
                if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) break block3;
            }
            throw new TableException("Only constant window intervals with millisecond resolution are supported.");
        }
        long l = ((BigDecimal)rexLiteral.getValue()).longValue();
        return l;
    }

    private static final PlannerResolvedFieldReference getOperandAsTimeIndicator$1(RexCall call, int idx, RelDataType rowType$1) {
        RexInputRef rexInputRef;
        RexNode rexNode = call.getOperands().get(idx);
        if (!(rexNode instanceof RexInputRef) || !FlinkTypeFactory$.MODULE$.isTimeIndicatorType((rexInputRef = (RexInputRef)rexNode).getType())) {
            throw new ValidationException("Window can only be defined over a time attribute column.");
        }
        PlannerResolvedFieldReference plannerResolvedFieldReference = new PlannerResolvedFieldReference(rowType$1.getFieldList().get(rexInputRef.getIndex()).getName(), FlinkTypeFactory$.MODULE$.toTypeInfo(rexInputRef.getType()));
        return plannerResolvedFieldReference;
    }

    public DataStreamLogicalWindowAggregateRule() {
        super("DataStreamLogicalWindowAggregateRule");
    }
}

