/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.common;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.catalog.BasicOperatorTable$;
import org.apache.flink.table.expressions.PlannerExpressionUtils$;
import org.apache.flink.table.expressions.ProctimeAttribute;
import org.apache.flink.table.expressions.RowtimeAttribute;
import org.apache.flink.table.expressions.WindowEnd;
import org.apache.flink.table.expressions.WindowReference;
import org.apache.flink.table.expressions.WindowStart;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.rel.LogicalWindowAggregate;
import org.apache.flink.table.plan.rules.common.WindowPropertiesBaseRule$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0003\u0003\t\"\u0001G,j]\u0012|w\u000f\u0015:pa\u0016\u0014H/[3t\u0005\u0006\u001cXMU;mK*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003']i\u0011\u0001\u0006\u0006\u0003\u000fUQ!A\u0006\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0001\u0004\u0006\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u001bI,H.\u001a)sK\u0012L7-\u0019;f!\t\u0019B$\u0003\u0002\u001e)\t\t\"+\u001a7PaR\u0014V\u000f\\3Pa\u0016\u0014\u0018M\u001c3\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0001B];mK:\u000bW.\u001a\t\u0003C\u001dr!AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011ae\t\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075z\u0003\u0007\u0005\u0002/\u00015\t!\u0001C\u0003\u001bU\u0001\u00071\u0004C\u0003 U\u0001\u0007\u0001\u0005C\u00033\u0001\u0011\u00053'A\u0004nCR\u001c\u0007.Z:\u0015\u0005Q:\u0004C\u0001\u00126\u0013\t14EA\u0004C_>dW-\u00198\t\u000ba\n\u0004\u0019A\u001d\u0002\t\r\fG\u000e\u001c\t\u0003'iJ!a\u000f\u000b\u0003\u001dI+Gn\u00149u%VdWmQ1mY\")Q\b\u0001C\u0001}\u0005\u00112m\u001c8wKJ$x+\u001b8e_^tu\u000eZ3t)\u0019yT)T+^?B\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)F\u0001\u0004e\u0016d\u0017B\u0001#B\u0005\u001d\u0011V\r\u001c(pI\u0016DQA\u0012\u001fA\u0002\u001d\u000bqAY;jY\u0012,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002K+\u0005)Ao\\8mg&\u0011A*\u0013\u0002\u000b%\u0016d')^5mI\u0016\u0014\b\"\u0002(=\u0001\u0004y\u0015a\u00029s_*,7\r\u001e\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0006\u000bq\u0001\\8hS\u000e\fG.\u0003\u0002U#\nqAj\\4jG\u0006d\u0007K]8kK\u000e$\b\"\u0002,=\u0001\u00049\u0016A\u00024jYR,'\u000fE\u0002#1jK!!W\u0012\u0003\r=\u0003H/[8o!\t\u00016,\u0003\u0002]#\niAj\\4jG\u0006dg)\u001b7uKJDQA\u0018\u001fA\u0002=\u000bA\"\u001b8oKJ\u0004&o\u001c6fGRDQ\u0001\u0019\u001fA\u0002\u0005\f1!Y4h!\t\u0011W-D\u0001d\u0015\t\u0011EM\u0003\u0002S\r%\u0011am\u0019\u0002\u0017\u0019><\u0017nY1m/&tGm\\<BO\u001e\u0014XmZ1uK\")\u0001\u000e\u0001C\u0005S\u0006iq-\u001a;XS:$wn\u001e+za\u0016$\"A[7\u0011\u0005\tZ\u0017B\u00017$\u0005\u0019\u0019\u00160\u001c2pY\")an\u001aa\u0001_\u00061q/\u001b8e_^\u0004\"\u0001]9\u000e\u0003\u0011L!A\u001d3\u0003\u001b1{w-[2bY^Kg\u000eZ8x\u0011\u0015!\b\u0001\"\u0003v\u00031\u0001(o\u001c9feRLh*Y7f)\r\u0001co\u001e\u0005\u0006]N\u0004\ra\u001c\u0005\u0006qN\u0004\r\u0001I\u0001\u0005]\u0006lW\rC\u0003{\u0001\u0011%10A\fsKBd\u0017mY3He>,\b/Q;yS2L\u0017M]5fgR9A0!\u0002\u0002\n\u0005-\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000+\u0005\u0019!/\u001a=\n\u0007\u0005\raPA\u0004SKbtu\u000eZ3\t\r\u0005\u001d\u0011\u00101\u0001}\u0003\u0011qw\u000eZ3\t\u000b9L\b\u0019A8\t\u000b\u0019K\b\u0019A$\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012\u0005i\u0011n],j]\u0012|wo\u0015;beR$2\u0001NA\n\u0011\u001d\t9!!\u0004A\u0002qDq!a\u0006\u0001\t\u0013\tI\"A\u0006jg^Kg\u000eZ8x\u000b:$Gc\u0001\u001b\u0002\u001c!9\u0011qAA\u000b\u0001\u0004a\bbBA\u0010\u0001\u0011%\u0011\u0011E\u0001\u0010SN<\u0016N\u001c3poJ{w\u000f^5nKR\u0019A'a\t\t\u000f\u0005\u001d\u0011Q\u0004a\u0001y\"9\u0011q\u0005\u0001\u0005\n\u0005%\u0012\u0001E5t/&tGm\\<Qe>\u001cG/[7f)\r!\u00141\u0006\u0005\b\u0003\u000f\t)\u00031\u0001}\u0001")
public abstract class WindowPropertiesBaseRule
extends RelOptRule {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("streamRowtime");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("streamProctime");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("batchRowtime");

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        return JavaConversions$.MODULE$.asScalaBuffer(project.getProjects()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WindowPropertiesBaseRule $outer;

            public final boolean apply(RexNode node) {
                return this.$outer.org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$hasGroupAuxiliaries$1(node);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public RelNode convertWindowNodes(RelBuilder builder, LogicalProject project, Option<LogicalFilter> filter, LogicalProject innerProject, LogicalWindowAggregate agg) {
        block5: {
            Seq seq;
            Seq startEndProperties;
            LogicalWindow w;
            block3: {
                String string;
                Symbol symbol;
                block4: {
                    String string2;
                    block2: {
                        String string3;
                        w = agg.getWindow();
                        Symbol windowType = this.getWindowType(w);
                        startEndProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "start"), new WindowStart(w.aliasAttribute())), new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "end"), new WindowEnd(w.aliasAttribute()))}));
                        symbol = windowType;
                        Option option = Symbol$.MODULE$.unapply((Object)symbol);
                        if (option.isEmpty() || !"streamRowtime".equals(string3 = (String)option.get())) break block2;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "rowtime"), new RowtimeAttribute(w.aliasAttribute())), new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "proctime"), new ProctimeAttribute(w.aliasAttribute()))}));
                        break block3;
                    }
                    Option option = Symbol$.MODULE$.unapply((Object)symbol);
                    if (option.isEmpty() || !"streamProctime".equals(string2 = (String)option.get())) break block4;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "proctime"), new ProctimeAttribute(w.aliasAttribute()))}));
                    break block3;
                }
                Option option = Symbol$.MODULE$.unapply((Object)symbol);
                if (option.isEmpty() || !"batchRowtime".equals(string = (String)option.get())) break block5;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FlinkRelBuilder.NamedWindowProperty[]{new FlinkRelBuilder.NamedWindowProperty(this.propertyName(w, "rowtime"), new RowtimeAttribute(w.aliasAttribute()))}));
            }
            Seq timeProperties = seq;
            Seq properties = (Seq)startEndProperties.$plus$plus((GenTraversableOnce)timeProperties, Seq$.MODULE$.canBuildFrom());
            builder.push(agg.copy((Seq<FlinkRelBuilder.NamedWindowProperty>)properties));
            builder.project(JavaConversions$.MODULE$.bufferAsJavaList(JavaConversions$.MODULE$.asScalaBuffer(innerProject.getProjects()).$plus$plus((GenTraversableOnce)properties.map((Function1)new Serializable(this, builder){
                public static final long serialVersionUID = 0L;
                private final RelBuilder builder$1;

                public final RexInputRef apply(FlinkRelBuilder.NamedWindowProperty np) {
                    return this.builder$1.field(np.name());
                }
                {
                    this.builder$1 = builder$1;
                }
            }, Seq$.MODULE$.canBuildFrom()))));
            filter.foreach((Function1)new Serializable(this, builder, w){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WindowPropertiesBaseRule $outer;
                public final RelBuilder builder$1;
                public final LogicalWindow w$1;

                public final RelBuilder apply(LogicalFilter f) {
                    return this.builder$1.filter(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(f.getChildExps()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$convertWindowNodes$2 $outer;

                        public final RexNode apply(RexNode expr) {
                            return this.$outer.org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$anonfun$$$outer().org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$replaceGroupAuxiliaries(expr, this.$outer.w$1, this.$outer.builder$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())));
                }

                public /* synthetic */ WindowPropertiesBaseRule org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.builder$1 = builder$1;
                    this.w$1 = w$1;
                }
            });
            builder.project(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(project.getProjects()).map((Function1)new Serializable(this, builder, w){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WindowPropertiesBaseRule $outer;
                private final RelBuilder builder$1;
                private final LogicalWindow w$1;

                public final RexNode apply(RexNode expr) {
                    return this.$outer.org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$replaceGroupAuxiliaries(expr, this.w$1, this.builder$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.builder$1 = builder$1;
                    this.w$1 = w$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())), project.getRowType().getFieldNames());
            return builder.build();
        }
        throw new TableException("Unknown window type encountered. Please report this bug.");
    }

    private Symbol getWindowType(LogicalWindow window) {
        block5: {
            Symbol symbol;
            block3: {
                block4: {
                    block2: {
                        if (!PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(window.timeAttribute())) break block2;
                        symbol = symbol$1;
                        break block3;
                    }
                    if (!PlannerExpressionUtils$.MODULE$.isProctimeAttribute(window.timeAttribute())) break block4;
                    symbol = symbol$2;
                    break block3;
                }
                TypeInformation<?> typeInformation = window.timeAttribute().resultType();
                TypeInformation typeInformation2 = Types.SQL_TIMESTAMP();
                if (typeInformation != null ? !typeInformation.equals((Object)typeInformation2) : typeInformation2 != null) break block5;
                symbol = symbol$3;
            }
            return symbol;
        }
        throw new TableException("Unknown window type encountered. Please report this bug.");
    }

    private String propertyName(LogicalWindow window, String name) {
        return new StringBuilder().append((Object)((WindowReference)window.aliasAttribute()).name()).append((Object)name).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RexNode org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$replaceGroupAuxiliaries(RexNode node, LogicalWindow window, RelBuilder builder) {
        RexBuilder rexBuilder = builder.getRexBuilder();
        Symbol windowType = this.getWindowType(window);
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (this.isWindowStart(rexCall)) {
                return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "start")), false);
            }
        }
        if (bl && this.isWindowEnd(rexCall)) {
            return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "end")), false);
        }
        if (bl && this.isWindowRowtime(rexCall)) {
            String string;
            Option option;
            String string2;
            Symbol symbol = windowType;
            Option option2 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl2 = !option2.isEmpty() && "streamRowtime".equals(string2 = (String)option2.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "batchRowtime".equals(string = (String)option.get());
            if (bl2) {
                RexInputRef rexInputRef = builder.field(this.propertyName(window, "rowtime"));
                return rexInputRef;
            }
            Option option3 = Symbol$.MODULE$.unapply((Object)symbol);
            if (option3.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
            String string3 = (String)option3.get();
            if (!"streamProctime".equals(string3)) throw new TableException("Unknown window type encountered. Please report this bug.");
            throw new ValidationException("A proctime window cannot provide a rowtime attribute.");
        }
        if (bl && this.isWindowProctime(rexCall)) {
            String string;
            Option option;
            String string4;
            Symbol symbol = windowType;
            Option option4 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl3 = !option4.isEmpty() && "streamProctime".equals(string4 = (String)option4.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "streamRowtime".equals(string = (String)option.get());
            if (bl3) {
                RexInputRef rexInputRef = builder.field(this.propertyName(window, "proctime"));
                return rexInputRef;
            }
            Option option5 = Symbol$.MODULE$.unapply((Object)symbol);
            if (option5.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
            String string5 = (String)option5.get();
            if (!"batchRowtime".equals(string5)) throw new TableException("Unknown window type encountered. Please report this bug.");
            throw new ValidationException("PROCTIME window property is not supported in batch queries.");
        }
        if (!bl) return rexNode;
        Buffer newOps = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(rexCall.getOperands()).map((Function1)new Serializable(this, window, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WindowPropertiesBaseRule $outer;
            private final LogicalWindow window$1;
            private final RelBuilder builder$2;

            public final RexNode apply(RexNode x$1) {
                return this.$outer.org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$replaceGroupAuxiliaries(x$1, this.window$1, this.builder$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.window$1 = window$1;
                this.builder$2 = builder$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return rexCall.clone(rexCall.getType(), JavaConversions$.MODULE$.bufferAsJavaList(newOps));
    }

    private boolean isWindowStart(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_START();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_START();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_START();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowEnd(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_END();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_END();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_END();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowRowtime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_ROWTIME();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_ROWTIME();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_ROWTIME();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowProctime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = BasicOperatorTable$.MODULE$.TUMBLE_PROCTIME();
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = BasicOperatorTable$.MODULE$.HOP_PROCTIME();
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = BasicOperatorTable$.MODULE$.SESSION_PROCTIME();
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$hasGroupAuxiliaries$1(RexNode node) {
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (rexCall.getOperator().isGroupAuxiliary()) {
                return true;
            }
        }
        if (!bl) return false;
        return JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WindowPropertiesBaseRule $outer;

            public final boolean apply(RexNode node) {
                return this.$outer.org$apache$flink$table$plan$rules$common$WindowPropertiesBaseRule$$hasGroupAuxiliaries$1(node);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public WindowPropertiesBaseRule(RelOptRuleOperand rulePredicate, String ruleName) {
        super(rulePredicate, ruleName);
    }
}

