/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoSourceScanRuleBase;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import scala.Tuple2;

public class PushFilterInCalcIntoTableSourceScanRule
extends PushFilterIntoSourceScanRuleBase {
    public static final PushFilterInCalcIntoTableSourceScanRule INSTANCE = new PushFilterInCalcIntoTableSourceScanRule();

    public PushFilterInCalcIntoTableSourceScanRule() {
        super(PushFilterInCalcIntoTableSourceScanRule.operand(FlinkLogicalCalc.class, PushFilterInCalcIntoTableSourceScanRule.operand(FlinkLogicalTableSourceScan.class, PushFilterInCalcIntoTableSourceScanRule.none()), new RelOptRuleOperand[0]), "PushFilterInCalcIntoTableSourceScanRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        if (!super.matches(call)) {
            return false;
        }
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        RexProgram originProgram = calc.getProgram();
        if (originProgram.getCondition() == null) {
            return false;
        }
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        return this.canPushdownFilter(tableSourceTable);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSourceTable table = scan.getTable().unwrap(TableSourceTable.class);
        this.pushFilterIntoScan(call, calc, scan, table);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Calc calc, FlinkLogicalTableSourceScan scan, FlinkPreparingTableBase relOptTable) {
        RexProgram program;
        RexProgram originProgram = calc.getProgram();
        RelBuilder relBuilder = call.builder();
        Tuple2<RexNode[], RexNode[]> extractedPredicates = this.extractPredicates(originProgram.getInputRowType().getFieldNames().toArray(new String[0]), originProgram.expandLocalRef(originProgram.getCondition()), scan, relBuilder.getRexBuilder());
        RexNode[] convertiblePredicates = (RexNode[])extractedPredicates._1;
        RexNode[] unconvertedPredicates = (RexNode[])extractedPredicates._2;
        if (convertiblePredicates.length == 0) {
            return;
        }
        Tuple2<SupportsFilterPushDown.Result, TableSourceTable> pushdownResultWithScan = this.resolveFiltersAndCreateTableSourceTable(convertiblePredicates, relOptTable.unwrap(TableSourceTable.class), scan, relBuilder);
        SupportsFilterPushDown.Result result = (SupportsFilterPushDown.Result)pushdownResultWithScan._1;
        TableSourceTable tableSourceTable = (TableSourceTable)pushdownResultWithScan._2;
        FlinkLogicalTableSourceScan newScan = FlinkLogicalTableSourceScan.create(scan.getCluster(), scan.getHints(), tableSourceTable);
        RexProgramBuilder programBuilder = RexProgramBuilder.forProgram(originProgram, call.builder().getRexBuilder(), true);
        programBuilder.clearCondition();
        if (!result.getRemainingFilters().isEmpty() || unconvertedPredicates.length != 0) {
            RexNode remainingCondition = this.createRemainingCondition(relBuilder, result.getRemainingFilters(), unconvertedPredicates);
            RexNode simplifiedRemainingCondition = FlinkRexUtil.simplify(relBuilder.getRexBuilder(), remainingCondition);
            programBuilder.addCondition(simplifiedRemainingCondition);
        }
        if ((program = programBuilder.getProgram()).isTrivial()) {
            call.transformTo(newScan);
        } else {
            FlinkLogicalCalc newCalc = FlinkLogicalCalc.create(newScan, program);
            call.transformTo(newCalc);
        }
    }
}

