/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.logical.StructuredType;

@Internal
public final class StructuredRelDataType
extends ObjectSqlType {
    private static final String IDENTIFIER_FORMAT = "*%s*";
    private static final String DIGEST_FORMAT = "*%s(%s)*%s";
    private final StructuredType structuredType;

    private StructuredRelDataType(StructuredType structuredType, List<RelDataTypeField> fields2) {
        super(SqlTypeName.STRUCTURED, StructuredRelDataType.createSqlIdentifier(structuredType), structuredType.isNullable(), fields2, StructuredRelDataType.createRelDataTypeComparability(structuredType));
        this.structuredType = structuredType;
        this.computeDigest();
    }

    public static StructuredRelDataType create(FlinkTypeFactory factory, StructuredType structuredType) {
        ArrayList<RelDataTypeField> fields2 = new ArrayList<RelDataTypeField>();
        for (int i = 0; i < structuredType.getAttributes().size(); ++i) {
            StructuredType.StructuredAttribute attribute = (StructuredType.StructuredAttribute)structuredType.getAttributes().get(i);
            RelDataTypeFieldImpl field = new RelDataTypeFieldImpl(attribute.getName(), i, factory.createFieldTypeFromLogicalType(attribute.getType()));
            fields2.add(field);
        }
        return new StructuredRelDataType(structuredType, fields2);
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    public StructuredRelDataType createWithNullability(boolean nullable) {
        if (nullable == this.isNullable()) {
            return this;
        }
        return new StructuredRelDataType((StructuredType)this.structuredType.copy(nullable), this.fieldList);
    }

    @Override
    public StructKind getStructKind() {
        return StructKind.PEEK_FIELDS_NO_EXPAND;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (this.structuredType == null) {
            return;
        }
        if (withDetail) {
            if (this.structuredType.getObjectIdentifier().isPresent()) {
                sb.append(this.structuredType.asSerializableString());
            } else {
                sb.append(String.format(DIGEST_FORMAT, this.structuredType.getImplementationClass().map(Class::getName).orElseThrow(IllegalStateException::new), this.fieldList.stream().map(field -> field.getType().getFullTypeString()).collect(Collectors.joining(", ")), this.structuredType.isNullable() ? "" : " NOT NULL"));
            }
        } else {
            sb.append(this.structuredType.asSummaryString());
        }
    }

    @Override
    protected void computeDigest() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, true);
        this.digest = sb.toString();
    }

    private static SqlIdentifier createSqlIdentifier(StructuredType structuredType) {
        return structuredType.getObjectIdentifier().map(i -> new SqlIdentifier(i.toList(), SqlParserPos.ZERO)).orElseGet(() -> new SqlIdentifier(String.format(IDENTIFIER_FORMAT, structuredType.getImplementationClass().map(Class::getName).orElseThrow(IllegalStateException::new)), SqlParserPos.ZERO));
    }

    private static RelDataTypeComparability createRelDataTypeComparability(StructuredType structuredType) {
        switch (structuredType.getComparision()) {
            case EQUALS: {
                return RelDataTypeComparability.UNORDERED;
            }
            case FULL: {
                return RelDataTypeComparability.ALL;
            }
            case NONE: {
                return RelDataTypeComparability.NONE;
            }
        }
        throw new IllegalArgumentException("Unsupported structured type comparision.");
    }
}

