/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class SortSpec {
    public static final String FIELD_NAME_FIELDS = "fields";
    public static final SortSpec ANY = new SortSpec(new SortFieldSpec[0]);
    @JsonProperty(value="fields")
    private final SortFieldSpec[] fieldSpecs;

    @JsonCreator
    public SortSpec(@JsonProperty(value="fields") SortFieldSpec[] fieldSpecs) {
        this.fieldSpecs = (SortFieldSpec[])Preconditions.checkNotNull((Object)fieldSpecs);
    }

    public SortSpec createSubSortSpec(int startIndex) {
        Preconditions.checkArgument((startIndex >= 0 && startIndex < this.fieldSpecs.length ? 1 : 0) != 0);
        return new SortSpec((SortFieldSpec[])Arrays.stream(this.fieldSpecs, startIndex, this.fieldSpecs.length).toArray(SortFieldSpec[]::new));
    }

    @JsonIgnore
    public int[] getFieldIndices() {
        return Arrays.stream(this.fieldSpecs).mapToInt(SortFieldSpec::getFieldIndex).toArray();
    }

    @JsonIgnore
    public boolean[] getAscendingOrders() {
        boolean[] orders = new boolean[this.fieldSpecs.length];
        IntStream.range(0, this.fieldSpecs.length).forEach(i -> {
            orders[i] = this.fieldSpecs[i].isAscendingOrder;
        });
        return orders;
    }

    @JsonIgnore
    public boolean[] getNullsIsLast() {
        boolean[] nullIsLasts = new boolean[this.fieldSpecs.length];
        IntStream.range(0, this.fieldSpecs.length).forEach(i -> {
            nullIsLasts[i] = this.fieldSpecs[i].nullIsLast;
        });
        return nullIsLasts;
    }

    @JsonIgnore
    public SortFieldSpec[] getFieldSpecs() {
        return this.fieldSpecs;
    }

    public SortFieldSpec getFieldSpec(int index) {
        return this.fieldSpecs[index];
    }

    @JsonIgnore
    public int getFieldSize() {
        return this.fieldSpecs.length;
    }

    public LogicalType[] getFieldTypes(RowType input) {
        return (LogicalType[])Stream.of(this.fieldSpecs).map(field -> input.getTypeAt(((SortFieldSpec)field).fieldIndex)).toArray(LogicalType[]::new);
    }

    public static SortSpecBuilder builder() {
        return new SortSpecBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortSpec sortSpec = (SortSpec)o;
        return Arrays.equals(this.fieldSpecs, sortSpec.fieldSpecs);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldSpecs);
    }

    public String toString() {
        return "Sort{fields=" + Arrays.toString(this.fieldSpecs) + '}';
    }

    public static class SortFieldSpec {
        public static final String FIELD_NAME_INDEX = "index";
        public static final String FIELD_NAME_IS_ASCENDING = "isAscending";
        public static final String FIELD_NAME_NULL_IS_LAST = "nullIsLast";
        @JsonProperty(value="index")
        private final int fieldIndex;
        @JsonProperty(value="isAscending")
        private final boolean isAscendingOrder;
        @JsonProperty(value="nullIsLast")
        private final boolean nullIsLast;

        @JsonCreator
        public SortFieldSpec(@JsonProperty(value="index") int fieldIndex, @JsonProperty(value="isAscending") boolean isAscendingOrder, @JsonProperty(value="nullIsLast") boolean nullIsLast) {
            this.fieldIndex = fieldIndex;
            this.isAscendingOrder = isAscendingOrder;
            this.nullIsLast = nullIsLast;
        }

        @JsonIgnore
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @JsonIgnore
        public boolean getIsAscendingOrder() {
            return this.isAscendingOrder;
        }

        @JsonIgnore
        public boolean getNullIsLast() {
            return this.nullIsLast;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortFieldSpec that = (SortFieldSpec)o;
            return this.fieldIndex == that.fieldIndex && this.isAscendingOrder == that.isAscendingOrder && this.nullIsLast == that.nullIsLast;
        }

        public int hashCode() {
            return Objects.hash(this.fieldIndex, this.isAscendingOrder, this.nullIsLast);
        }

        public String toString() {
            return "SortField{fieldIndex=" + this.fieldIndex + ", isAscendingOrder=" + this.isAscendingOrder + ", nullIsLast=" + this.nullIsLast + '}';
        }
    }

    public static class SortSpecBuilder {
        private final List<SortFieldSpec> fieldSpecs = new LinkedList<SortFieldSpec>();

        public SortSpecBuilder addField(int fieldIndex, boolean isAscendingOrder, boolean nullIsLast) {
            this.fieldSpecs.add(new SortFieldSpec(fieldIndex, isAscendingOrder, nullIsLast));
            return this;
        }

        public SortSpec build() {
            return new SortSpec(this.fieldSpecs.toArray(new SortFieldSpec[0]));
        }
    }
}

