/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import org.apache.calcite.plan.DeriveMode;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleDriver;
import org.apache.calcite.plan.volcano.TopDownRuleQueue;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.plan.volcano.VolcanoTimeoutException;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class TopDownRuleDriver
implements RuleDriver {
    private static final Logger LOGGER = CalciteTrace.getPlannerTaskTracer();
    private final VolcanoPlanner planner;
    private final TopDownRuleQueue ruleQueue;
    private Stack<Task> tasks = new Stack();
    private GeneratorTask applying = null;
    private Set<RelNode> passThroughCache = new HashSet<RelNode>();

    TopDownRuleDriver(VolcanoPlanner planner) {
        this.planner = planner;
        this.ruleQueue = new TopDownRuleQueue(planner);
    }

    @Override
    public void drive() {
        TaskDescriptor description = new TaskDescriptor();
        this.tasks.push(new OptimizeGroup(this.planner.root, this.planner.infCost));
        this.exploreMaterializationRoots();
        try {
            while (!this.tasks.isEmpty()) {
                Task task = this.tasks.pop();
                description.log(task);
                task.perform();
            }
        }
        catch (VolcanoTimeoutException ex) {
            LOGGER.warn("Volcano planning times out, cancels the subsequent optimization.");
        }
    }

    private void exploreMaterializationRoots() {
        for (RelSubset extraRoot : this.planner.explorationRoots) {
            RelSet rootSet = VolcanoPlanner.equivRoot(extraRoot.set);
            if (rootSet == this.planner.root.set) continue;
            for (RelNode rel : extraRoot.set.rels) {
                if (!this.planner.isLogical(rel)) continue;
                this.tasks.push(new OptimizeMExpr(rel, extraRoot, true));
            }
        }
    }

    @Override
    public TopDownRuleQueue getRuleQueue() {
        return this.ruleQueue;
    }

    @Override
    public void clear() {
        this.ruleQueue.clear();
        this.tasks.clear();
        this.passThroughCache.clear();
        this.applying = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyGenerator(GeneratorTask task, Procedure proc) {
        GeneratorTask applying = this.applying;
        this.applying = task;
        try {
            proc.exec();
        }
        finally {
            this.applying = applying;
        }
    }

    @Override
    public void onSetMerged(RelSet set) {
        this.applyGenerator(null, () -> this.clearProcessed(set));
    }

    private void clearProcessed(RelSet set) {
        boolean explored = set.exploringState != null;
        set.exploringState = null;
        for (RelSubset subset : set.subsets) {
            if (!subset.resetTaskState() && !explored) continue;
            Collection<RelNode> parentRels = subset.getParentRels();
            for (RelNode parentRel : parentRels) {
                this.clearProcessed(this.planner.getSet(parentRel));
            }
            if (subset != this.planner.root) continue;
            this.tasks.push(new OptimizeGroup(subset, this.planner.infCost));
        }
    }

    @Override
    public void onProduce(RelNode node, RelSubset subset) {
        if (this.applying == null || subset.set != VolcanoPlanner.equivRoot(this.applying.group().set)) {
            return;
        }
        if (!this.applying.onProduce(node)) {
            return;
        }
        if (!this.planner.isLogical(node)) {
            boolean canPassThrough;
            RelSubset optimizingGroup = null;
            boolean bl = canPassThrough = node instanceof PhysicalNode && !this.passThroughCache.contains(node);
            if (!canPassThrough && subset.taskState != null) {
                optimizingGroup = subset;
            } else {
                RelOptCost upperBound = this.planner.zeroCost;
                RelSet set = subset.getSet();
                ArrayList<RelSubset> subsetsToPassThrough = new ArrayList<RelSubset>();
                for (RelSubset otherSubset : set.subsets) {
                    if (!otherSubset.isRequired() || otherSubset != this.planner.root && otherSubset.taskState != RelSubset.OptimizeState.OPTIMIZING) continue;
                    if (node.getTraitSet().satisfies(otherSubset.getTraitSet())) {
                        if (!upperBound.isLt(otherSubset.upperBound)) continue;
                        upperBound = otherSubset.upperBound;
                        optimizingGroup = otherSubset;
                        continue;
                    }
                    if (!canPassThrough) continue;
                    subsetsToPassThrough.add(otherSubset);
                }
                for (RelSubset otherSubset : subsetsToPassThrough) {
                    Task task = this.getOptimizeInputTask(node, otherSubset);
                    if (task == null) continue;
                    this.tasks.push(task);
                }
            }
            if (optimizingGroup == null) {
                return;
            }
            Task task = this.getOptimizeInputTask(node, optimizingGroup);
            if (task != null) {
                this.tasks.push(task);
            }
        } else {
            boolean optimizing = subset.set.subsets.stream().anyMatch(s -> s.taskState == RelSubset.OptimizeState.OPTIMIZING);
            this.tasks.push(new OptimizeMExpr(node, this.applying.group(), this.applying.exploring() && !optimizing));
        }
    }

    private Task getOptimizeInputTask(RelNode rel, RelSubset group) {
        if (!rel.getTraitSet().satisfies(group.getTraitSet())) {
            RelNode passThroughRel = this.convert(rel, group);
            if (passThroughRel == null) {
                LOGGER.debug("Skip optimizing because of traits: {}", (Object)rel);
                return null;
            }
            RelNode finalPassThroughRel = passThroughRel;
            this.applyGenerator(null, () -> this.planner.register(finalPassThroughRel, group));
            rel = passThroughRel;
        }
        boolean unProcess = false;
        for (RelNode input : rel.getInputs()) {
            RelOptCost winner = ((RelSubset)input).getWinnerCost();
            if (winner != null) continue;
            unProcess = true;
            break;
        }
        if (!unProcess) {
            return new DeriveTrait(rel, group);
        }
        if (rel.getInputs().size() == 1) {
            return new OptimizeInput1(rel, group);
        }
        return new OptimizeInputs(rel, group);
    }

    private RelNode convert(RelNode rel, RelSubset group) {
        VolcanoRuleMatch match;
        if (!this.passThroughCache.contains(rel)) {
            if (this.checkLowerBound(rel, group)) {
                RelNode passThrough = group.passThrough(rel);
                if (passThrough != null) {
                    assert (passThrough.getConvention() == rel.getConvention());
                    this.passThroughCache.add(passThrough);
                    return passThrough;
                }
            } else {
                LOGGER.debug("Skip pass though because of lower bound. LB = {}, UP = {}", (Object)rel, (Object)group.upperBound);
            }
        }
        if ((match = this.ruleQueue.popMatch(Pair.of(rel, m -> m.getRule() instanceof ConverterRule && m.getRule().getOutTrait().satisfies(group.getTraitSet().getConvention())))) != null) {
            this.tasks.add(new ApplyRule(match, group, false));
        }
        return null;
    }

    private boolean checkLowerBound(RelNode rel, RelSubset group) {
        RelOptCost upperBound = group.upperBound;
        if (upperBound.isInfinite()) {
            return true;
        }
        RelOptCost lb = this.planner.getLowerBound(rel);
        return !upperBound.isLe(lb);
    }

    private class DeriveTrait
    implements GeneratorTask {
        private final RelNode mExpr;
        private final RelSubset group;

        DeriveTrait(RelNode mExpr, RelSubset group) {
            this.mExpr = mExpr;
            this.group = group;
        }

        @Override
        public void perform() {
            List<RelNode> inputs = this.mExpr.getInputs();
            for (RelNode input : inputs) {
                if (((RelSubset)input).getWinnerCost() != null) continue;
                return;
            }
            TopDownRuleDriver.this.tasks.push(new ApplyRules(this.mExpr, this.group, false));
            if (!TopDownRuleDriver.this.passThroughCache.contains(this.mExpr)) {
                TopDownRuleDriver.this.applyGenerator(this, this::derive);
            }
        }

        private void derive() {
            if (!(this.mExpr instanceof PhysicalNode) || ((PhysicalNode)this.mExpr).getDeriveMode() == DeriveMode.PROHIBITED) {
                return;
            }
            PhysicalNode rel = (PhysicalNode)this.mExpr;
            DeriveMode mode = rel.getDeriveMode();
            int arity = rel.getInputs().size();
            ArrayList<List<RelTraitSet>> inputTraits = new ArrayList<List<RelTraitSet>>(arity);
            for (int i = 0; i < arity; ++i) {
                int childId = i;
                if (mode == DeriveMode.RIGHT_FIRST) {
                    childId = arity - i - 1;
                }
                RelSubset input = (RelSubset)rel.getInput(childId);
                ArrayList<RelTraitSet> traits = new ArrayList<RelTraitSet>();
                inputTraits.add(traits);
                int numSubset = input.set.subsets.size();
                for (int j2 = 0; j2 < numSubset; ++j2) {
                    RelSubset subset = input.set.subsets.get(j2);
                    if (!subset.isDelivered() || subset.getTraitSet().equalsSansConvention(rel.getCluster().traitSet())) continue;
                    if (mode == DeriveMode.OMAKASE) {
                        traits.add(subset.getTraitSet());
                        continue;
                    }
                    RelNode newRel = rel.derive(subset.getTraitSet(), childId);
                    if (newRel == null || TopDownRuleDriver.this.planner.isRegistered(newRel)) continue;
                    RelNode newInput = newRel.getInput(childId);
                    assert (newInput instanceof RelSubset);
                    if (newInput == subset) {
                        subset.disableEnforcing();
                    }
                    RelSubset relSubset = TopDownRuleDriver.this.planner.register(newRel, rel);
                    assert (relSubset.set == ((TopDownRuleDriver)TopDownRuleDriver.this).planner.getSubset((RelNode)rel).set);
                }
                if (mode == DeriveMode.LEFT_FIRST || mode == DeriveMode.RIGHT_FIRST) break;
            }
            if (mode == DeriveMode.OMAKASE) {
                List<RelNode> relList = rel.derive(inputTraits);
                for (RelNode relNode : relList) {
                    if (TopDownRuleDriver.this.planner.isRegistered(relNode)) continue;
                    TopDownRuleDriver.this.planner.register(relNode, rel);
                }
            }
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("mExpr", this.mExpr).item("group", this.group);
        }

        @Override
        public RelSubset group() {
            return this.group;
        }

        @Override
        public boolean exploring() {
            return false;
        }

        @Override
        public boolean onProduce(RelNode node) {
            TopDownRuleDriver.this.passThroughCache.add(node);
            return true;
        }
    }

    private class CheckInput
    implements Task {
        private final OptimizeInputs context;
        private final RelOptCost upper;
        private final RelNode parent;
        private RelSubset input;
        private final int i;

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("parent", this.parent).item("i", this.i);
        }

        CheckInput(OptimizeInputs context, RelNode parent, RelSubset input, int i, RelOptCost upper) {
            this.context = context;
            this.parent = parent;
            this.input = input;
            this.i = i;
            this.upper = upper;
        }

        @Override
        public void perform() {
            if (this.input != this.parent.getInput(this.i)) {
                this.input = (RelSubset)this.parent.getInput(this.i);
                TopDownRuleDriver.this.tasks.push(this);
                TopDownRuleDriver.this.tasks.push(new OptimizeGroup(this.input, this.upper));
                return;
            }
            if (this.context == null) {
                return;
            }
            RelOptCost winner = this.input.getWinnerCost();
            if (winner == null) {
                this.context.lowerBoundSum = ((TopDownRuleDriver)TopDownRuleDriver.this).planner.infCost;
                return;
            }
            if (this.context.lowerBoundSum != null && this.context.lowerBoundSum != ((TopDownRuleDriver)TopDownRuleDriver.this).planner.infCost) {
                this.context.lowerBoundSum = this.context.lowerBoundSum.minus((RelOptCost)this.context.lowerBounds.get(this.i));
                this.context.lowerBoundSum = this.context.lowerBoundSum.plus(winner);
                this.context.lowerBounds.set(this.i, winner);
            }
        }
    }

    private class OptimizeInputs
    implements Task {
        private final RelNode mExpr;
        private final RelSubset group;
        private final int childCount;
        private RelOptCost upperBound;
        private RelOptCost upperForInput;
        private int processingChild;
        private List<RelOptCost> lowerBounds;
        private RelOptCost lowerBoundSum;

        OptimizeInputs(RelNode rel, RelSubset group) {
            this.mExpr = rel;
            this.group = group;
            this.upperBound = group.upperBound;
            this.upperForInput = ((TopDownRuleDriver)TopDownRuleDriver.this).planner.infCost;
            this.childCount = rel.getInputs().size();
            this.processingChild = 0;
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("mExpr", this.mExpr).item("upperBound", this.upperBound).item("processingChild", this.processingChild);
        }

        @Override
        public void perform() {
            RelOptCost bestCost = this.group.bestCost;
            if (!bestCost.isInfinite()) {
                if (bestCost.isLt(this.upperBound)) {
                    this.upperBound = bestCost;
                    this.upperForInput = TopDownRuleDriver.this.planner.upperBoundForInputs(this.mExpr, this.upperBound);
                }
                if (this.lowerBoundSum == null) {
                    if (this.upperForInput.isInfinite()) {
                        this.upperForInput = TopDownRuleDriver.this.planner.upperBoundForInputs(this.mExpr, this.upperBound);
                    }
                    this.lowerBounds = new ArrayList<RelOptCost>(this.childCount);
                    for (RelNode input : this.mExpr.getInputs()) {
                        RelOptCost lb = TopDownRuleDriver.this.planner.getLowerBound(input);
                        this.lowerBounds.add(lb);
                        this.lowerBoundSum = this.lowerBoundSum == null ? lb : this.lowerBoundSum.plus(lb);
                    }
                }
                if (this.upperForInput.isLt(this.lowerBoundSum)) {
                    LOGGER.debug("Skip O_INPUT because of lower bound. LB = {}, UP = {}", (Object)this.lowerBoundSum, (Object)this.upperForInput);
                    return;
                }
            }
            if (this.lowerBoundSum != null && this.lowerBoundSum.isInfinite()) {
                LOGGER.debug("Skip O_INPUT as one of the inputs fail to optimize");
                return;
            }
            if (this.processingChild == 0) {
                TopDownRuleDriver.this.tasks.push(new DeriveTrait(this.mExpr, this.group));
            }
            while (this.processingChild < this.childCount) {
                RelSubset input = (RelSubset)this.mExpr.getInput(this.processingChild);
                RelOptCost winner = input.getWinnerCost();
                if (winner != null) {
                    ++this.processingChild;
                    continue;
                }
                RelOptCost upper = this.upperForInput;
                if (!upper.isInfinite()) {
                    upper = this.upperForInput.minus(this.lowerBoundSum).plus(this.lowerBounds.get(this.processingChild));
                }
                if (input.taskState != null && upper.isLe(input.upperBound)) {
                    LOGGER.debug("Failed to optimize because of upper bound. LB = {}, UP = {}", (Object)this.lowerBoundSum, (Object)this.upperForInput);
                    return;
                }
                if (this.processingChild != this.childCount - 1) {
                    TopDownRuleDriver.this.tasks.push(this);
                }
                TopDownRuleDriver.this.tasks.push(new CheckInput(this, this.mExpr, input, this.processingChild, upper));
                TopDownRuleDriver.this.tasks.push(new OptimizeGroup(input, upper));
                ++this.processingChild;
                break;
            }
        }
    }

    private class OptimizeInput1
    implements Task {
        private final RelNode mExpr;
        private final RelSubset group;

        OptimizeInput1(RelNode mExpr, RelSubset group) {
            this.mExpr = mExpr;
            this.group = group;
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("mExpr", this.mExpr).item("upperBound", this.group.upperBound);
        }

        @Override
        public void perform() {
            RelOptCost upperBound = this.group.upperBound;
            RelOptCost upperForInput = TopDownRuleDriver.this.planner.upperBoundForInputs(this.mExpr, upperBound);
            if (upperForInput.isLe(((TopDownRuleDriver)TopDownRuleDriver.this).planner.zeroCost)) {
                LOGGER.debug("Skip O_INPUT because of lower bound. UB4Inputs = {}, UB = {}", (Object)upperForInput, (Object)upperBound);
                return;
            }
            RelSubset input = (RelSubset)this.mExpr.getInput(0);
            TopDownRuleDriver.this.tasks.push(new DeriveTrait(this.mExpr, this.group));
            TopDownRuleDriver.this.tasks.push(new CheckInput(null, this.mExpr, input, 0, upperForInput));
            TopDownRuleDriver.this.tasks.push(new OptimizeGroup(input, upperForInput));
        }
    }

    private class ApplyRule
    implements GeneratorTask {
        private final VolcanoRuleMatch match;
        private final RelSubset group;
        private final boolean exploring;

        ApplyRule(VolcanoRuleMatch match, RelSubset group, boolean exploring) {
            this.match = match;
            this.group = group;
            this.exploring = exploring;
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("match", this.match).item("exploring", this.exploring);
        }

        @Override
        public void perform() {
            TopDownRuleDriver.this.applyGenerator(this, this.match::onMatch);
        }

        @Override
        public RelSubset group() {
            return this.group;
        }

        @Override
        public boolean exploring() {
            return this.exploring;
        }
    }

    private class ApplyRules
    implements Task {
        private final RelNode mExpr;
        private final RelSubset group;
        private final boolean exploring;

        ApplyRules(RelNode mExpr, RelSubset group, boolean exploring) {
            this.mExpr = mExpr;
            this.group = group;
            this.exploring = exploring;
        }

        @Override
        public void perform() {
            Pair<RelNode, Predicate<VolcanoRuleMatch>> category = this.exploring ? Pair.of(this.mExpr, TopDownRuleDriver.this.planner::isTransformationRule) : Pair.of(this.mExpr, m -> true);
            VolcanoRuleMatch match = TopDownRuleDriver.this.ruleQueue.popMatch(category);
            while (match != null) {
                TopDownRuleDriver.this.tasks.push(new ApplyRule(match, this.group, this.exploring));
                match = TopDownRuleDriver.this.ruleQueue.popMatch(category);
            }
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("mExpr", this.mExpr).item("exploring", this.exploring);
        }
    }

    private class ExploreInput
    implements Task {
        private final RelSubset group;
        private final RelNode parent;
        private final int inputOrdinal;

        ExploreInput(RelNode parent, int inputOrdinal) {
            this.group = (RelSubset)parent.getInput(inputOrdinal);
            this.parent = parent;
            this.inputOrdinal = inputOrdinal;
        }

        @Override
        public void perform() {
            if (!this.group.explore()) {
                return;
            }
            TopDownRuleDriver.this.tasks.push(new EnsureGroupExplored(this.group, this.parent, this.inputOrdinal));
            for (RelNode rel : this.group.set.rels) {
                if (!TopDownRuleDriver.this.planner.isLogical(rel)) continue;
                TopDownRuleDriver.this.tasks.push(new OptimizeMExpr(rel, this.group, true));
            }
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("group", this.group);
        }
    }

    private class EnsureGroupExplored
    implements Task {
        private final RelSubset input;
        private final RelNode parent;
        private final int inputOrdinal;

        EnsureGroupExplored(RelSubset input, RelNode parent, int inputOrdinal) {
            this.input = input;
            this.parent = parent;
            this.inputOrdinal = inputOrdinal;
        }

        @Override
        public void perform() {
            if (this.parent.getInput(this.inputOrdinal) != this.input) {
                TopDownRuleDriver.this.tasks.push(new ExploreInput(this.parent, this.inputOrdinal));
                return;
            }
            this.input.setExplored();
            for (RelSubset subset : this.input.getSet().subsets) {
                this.input.getCluster().getMetadataQuery().clearCache(subset);
            }
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("mExpr", this.parent).item("i", this.inputOrdinal);
        }
    }

    private class OptimizeMExpr
    implements Task {
        private final RelNode mExpr;
        private final RelSubset group;
        private final boolean explore;

        OptimizeMExpr(RelNode mExpr, RelSubset group, boolean explore) {
            this.mExpr = mExpr;
            this.group = group;
            this.explore = explore;
        }

        @Override
        public void perform() {
            if (this.explore && this.group.isExplored()) {
                return;
            }
            TopDownRuleDriver.this.tasks.push(new ApplyRules(this.mExpr, this.group, this.explore));
            for (int i = this.mExpr.getInputs().size() - 1; i >= 0; --i) {
                TopDownRuleDriver.this.tasks.push(new ExploreInput(this.mExpr, i));
            }
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("mExpr", this.mExpr).item("explore", this.explore);
        }
    }

    private static class GroupOptimized
    implements Task {
        private final RelSubset group;

        GroupOptimized(RelSubset group) {
            this.group = group;
        }

        @Override
        public void perform() {
            this.group.setOptimized();
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("group", this.group);
        }
    }

    private class OptimizeGroup
    implements Task {
        private final RelSubset group;
        private RelOptCost upperBound;

        OptimizeGroup(RelSubset group, RelOptCost upperBound) {
            this.group = group;
            this.upperBound = upperBound;
        }

        @Override
        public void perform() {
            RelOptCost winner = this.group.getWinnerCost();
            if (winner != null) {
                return;
            }
            if (this.group.taskState != null && this.upperBound.isLe(this.group.upperBound)) {
                return;
            }
            this.group.startOptimize(this.upperBound);
            TopDownRuleDriver.this.tasks.push(new GroupOptimized(this.group));
            ArrayList<RelNode> physicals = new ArrayList<RelNode>();
            for (RelNode rel : this.group.set.rels) {
                if (TopDownRuleDriver.this.planner.isLogical(rel)) {
                    TopDownRuleDriver.this.tasks.push(new OptimizeMExpr(rel, this.group, false));
                    continue;
                }
                if (rel.isEnforcer()) {
                    physicals.add(0, rel);
                    continue;
                }
                physicals.add(rel);
            }
            for (RelNode rel : physicals) {
                Task task = TopDownRuleDriver.this.getOptimizeInputTask(rel, this.group);
                if (task == null) continue;
                TopDownRuleDriver.this.tasks.add(task);
            }
        }

        @Override
        public void describe(TaskDescriptor desc) {
            desc.item("group", this.group).item("upperBound", this.upperBound);
        }
    }

    private static interface GeneratorTask
    extends Task {
        public RelSubset group();

        public boolean exploring();

        default public boolean onProduce(RelNode node) {
            return true;
        }
    }

    private static class TaskDescriptor {
        private boolean first = true;
        private StringBuilder builder = new StringBuilder();

        private TaskDescriptor() {
        }

        void log(Task task) {
            if (!LOGGER.isDebugEnabled()) {
                return;
            }
            this.first = true;
            this.builder.setLength(0);
            this.builder.append("Execute task: ").append(task.getClass().getSimpleName());
            task.describe(this);
            if (!this.first) {
                this.builder.append(")");
            }
            LOGGER.info(this.builder.toString());
        }

        TaskDescriptor item(String name, Object value) {
            if (this.first) {
                this.first = false;
                this.builder.append("(");
            } else {
                this.builder.append(", ");
            }
            this.builder.append(name).append("=").append(value);
            return this;
        }
    }

    private static interface Task {
        public void perform();

        public void describe(TaskDescriptor var1);
    }

    private static interface Procedure {
        public void exec();
    }
}

