/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.common;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel$class;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0003\u0003)\"AF\"p[6|g\u000e\u00155zg&\u001c\u0017\r\\#yG\"\fgnZ3\u000b\u0005\r!\u0011AB2p[6|gN\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001Y\u0001\u0003CA\f\u001f\u001b\u0005A\"BA\r\u001b\u0003\u0011\u0019wN]3\u000b\u0005ma\u0012a\u0001:fY*\u0011Q\u0004E\u0001\bG\u0006d7-\u001b;f\u0013\ty\u0002D\u0001\u0005Fq\u000eD\u0017M\\4f!\t\t#%D\u0001\u0005\u0013\t\u0019CA\u0001\tGY&t7\u000e\u00155zg&\u001c\u0017\r\u001c*fY\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0004dYV\u001cH/\u001a:\u0011\u0005\u001dJS\"\u0001\u0015\u000b\u0005%a\u0012B\u0001\u0016)\u00055\u0011V\r\\(qi\u000ecWo\u001d;fe\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0005ue\u0006LGoU3u!\t9c&\u0003\u00020Q\tY!+\u001a7Ue\u0006LGoU3u\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001C5oaV$(+\u001a7\u0011\u0005M\"T\"\u0001\u000e\n\u0005UR\"a\u0002*fY:{G-\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005y!/\u001a7ESN$(/\u001b2vi&|g\u000e\u0005\u00024s%\u0011!H\u0007\u0002\u0010%\u0016dG)[:ue&\u0014W\u000f^5p]\")A\b\u0001C\u0001{\u00051A(\u001b8jiz\"RA\u0010!B\u0005\u000e\u0003\"a\u0010\u0001\u000e\u0003\tAQ!J\u001eA\u0002\u0019BQ\u0001L\u001eA\u00025BQ!M\u001eA\u0002IBQaN\u001eA\u0002aBQ!\u0012\u0001\u0005B\u0019\u000bqbY8naV$XmU3mM\u000e{7\u000f\u001e\u000b\u0004\u000f*s\u0005CA\u0014I\u0013\tI\u0005F\u0001\u0006SK2|\u0005\u000f^\"pgRDQa\u0003#A\u0002-\u0003\"a\n'\n\u00055C#!\u0004*fY>\u0003H\u000f\u00157b]:,'\u000fC\u0003P\t\u0002\u0007\u0001+\u0001\u0002ncB\u0011\u0011\u000bV\u0007\u0002%*\u00111KG\u0001\t[\u0016$\u0018\rZ1uC&\u0011QK\u0015\u0002\u0011%\u0016dW*\u001a;bI\u0006$\u0018-U;fefDQa\u0016\u0001\u0005Ba\u000bA\"\u001a=qY\u0006Lg\u000eV3s[N$\"!\u0017/\u0011\u0005MR\u0016BA.\u001b\u0005%\u0011V\r\\,sSR,'\u000fC\u0003^-\u0002\u0007\u0011,\u0001\u0002qo\")q\f\u0001C\u0005A\u0006!B-[:ue&\u0014W\u000f^5p]R{7\u000b\u001e:j]\u001e$\u0012!\u0019\t\u0003E\"t!a\u00194\u000e\u0003\u0011T\u0011!Z\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0012\fa\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q\r\u001a\u0005\u0006Y\u0002!\t\"\\\u0001\u0018O\u0016$(+Z9vSJ,G\rR5tiJL'-\u001e;j_:,\u0012A\u001c\t\u0004_\u0006=ab\u00019\u0002\n9\u0019\u0011/!\u0002\u000f\u0007I\f\u0019AD\u0002t\u0003\u0003q!\u0001^@\u000f\u0005UthB\u0001<~\u001d\t9HP\u0004\u0002yw6\t\u0011P\u0003\u0002{)\u00051AH]8pizJ\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0019\u0011q\u0001\u0004\u0002\t\u0015DXmY\u0005\u0005\u0003\u0017\ti!A\u0007J]B,H\u000f\u0015:pa\u0016\u0014H/\u001f\u0006\u0004\u0003\u000f1\u0011\u0002BA\t\u0003'\u0011ACU3rk&\u0014X\r\u001a#jgR\u0014\u0018NY;uS>t'\u0002BA\u0006\u0003\u001b\u0001")
public abstract class CommonPhysicalExchange
extends Exchange
implements FlinkPhysicalRel {
    private final RelDistribution relDistribution;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel$class.satisfyTraits(this, requiredTraitSet);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode$class.getRelDetailedDescription(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable, expressionFormat);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        block10: {
            RelOptCost relOptCost;
            block5: {
                RelDistribution.Type type;
                FlinkCostFactory costFactory;
                double inputSize;
                Double inputRows;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    inputRows = mq.getRowCount(this.input);
                                    if (inputRows == null) {
                                        return null;
                                    }
                                    inputSize = Predef$.MODULE$.Double2double(mq.getAverageRowSize(this.input)) * Predef$.MODULE$.Double2double(inputRows);
                                    costFactory = (FlinkCostFactory)planner.getCostFactory();
                                    type = this.relDistribution.getType();
                                    if (!((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) break block4;
                                    double cpuCost = (double)(FlinkCost$.MODULE$.SINGLETON_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                                    relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
                                    break block5;
                                }
                                if (!((Object)((Object)RelDistribution.Type.RANDOM_DISTRIBUTED)).equals((Object)type)) break block6;
                                double cpuCost = (double)(FlinkCost$.MODULE$.RANDOM_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                                relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
                                break block5;
                            }
                            if (!((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type)) break block7;
                            double cpuCost = (double)(FlinkCost$.MODULE$.RANGE_PARTITION_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                            double diskIoCost = inputSize;
                            double networkCost = (double)2 * inputSize;
                            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, diskIoCost, networkCost, 0.0);
                            break block5;
                        }
                        if (!((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) break block8;
                        int nParallelism = Math.max(1, (int)(inputSize / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
                        double cpuCost = (double)nParallelism * Predef$.MODULE$.Double2double(inputRows) * (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST();
                        double networkCost = (double)nParallelism * inputSize;
                        relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, networkCost, 0.0);
                        break block5;
                    }
                    if (!((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) break block9;
                    double cpuCost = (double)(FlinkCost$.MODULE$.HASH_CPU_COST() * this.relDistribution.getKeys().size() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
                    relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
                    break block5;
                }
                if (!((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) break block10;
                relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST() * Predef$.MODULE$.Double2double(inputRows), 0.0, inputSize, 0.0);
            }
            return relOptCost;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not support RelDistribution: ", " now!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.relDistribution.getType()})));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("distribution", this.distributionToString());
    }

    private String distributionToString() {
        FlinkRelDistribution flinkRelDistribution = (FlinkRelDistribution)this.relDistribution;
        java.util.List<String> inputFieldNames = this.getInput().getRowType().getFieldNames();
        String exchangeName = this.relDistribution.getType().shortName;
        RelDistribution.Type type = this.relDistribution.getType();
        java.util.List list = ((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type) ? (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getFieldCollations().get()).asScala()).map((Function1)new Serializable(this, inputFieldNames){
            public static final long serialVersionUID = 0L;
            private final java.util.List inputFieldNames$1;

            public final String apply(RelFieldCollation fieldCollation) {
                String name = (String)this.inputFieldNames$1.get(fieldCollation.getFieldIndex());
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, fieldCollation.getDirection().shortString}));
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava() : (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getKeys()).asScala()).map((Function1)new Serializable(this, inputFieldNames){
            public static final long serialVersionUID = 0L;
            private final java.util.List inputFieldNames$1;

            public final String apply(Integer x$1) {
                return (String)this.inputFieldNames$1.get(Predef$.MODULE$.Integer2int(x$1));
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
        java.util.List fieldNames = list;
        return fieldNames.isEmpty() ? exchangeName : new StringBuilder().append((Object)exchangeName).append((Object)fieldNames).toString();
    }

    public InputProperty.RequiredDistribution getRequiredDistribution() {
        block6: {
            InputProperty.RequiredDistribution requiredDistribution;
            block3: {
                RelDistribution.Type type;
                block5: {
                    block4: {
                        block2: {
                            type = this.relDistribution.getType();
                            if (!((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) break block2;
                            requiredDistribution = InputProperty.ANY_DISTRIBUTION;
                            break block3;
                        }
                        if (!((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) break block4;
                        requiredDistribution = InputProperty.BROADCAST_DISTRIBUTION;
                        break block3;
                    }
                    if (!((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) break block5;
                    requiredDistribution = InputProperty.SINGLETON_DISTRIBUTION;
                    break block3;
                }
                if (!((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) break block6;
                int[] keys = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.relDistribution.getKeys()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Integer x$2) {
                        return x$2;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                requiredDistribution = Predef$.MODULE$.intArrayOps(keys).isEmpty() ? InputProperty.SINGLETON_DISTRIBUTION : InputProperty.hashDistribution(keys);
            }
            return requiredDistribution;
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported distribution type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.relDistribution.getType()})));
    }

    public CommonPhysicalExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDistribution relDistribution) {
        this.relDistribution = relDistribution;
        super(cluster, traitSet, inputRel, relDistribution);
        FlinkRelNode$class.$init$(this);
        FlinkPhysicalRel$class.$init$(this);
    }
}

