/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.OutputTag;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.function.AllWindowFunction;
import org.apache.flink.streaming.api.scala.function.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.scala.function.util.ScalaAllWindowFunction;
import org.apache.flink.streaming.api.scala.function.util.ScalaAllWindowFunctionWrapper;
import org.apache.flink.streaming.api.scala.function.util.ScalaProcessAllWindowFunctionWrapper;
import org.apache.flink.streaming.api.scala.function.util.ScalaReduceFunction;
import org.apache.flink.streaming.api.scala.package$;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Public
@ScalaSignature(bytes="\u0006\u0001\u0011\rb\u0001B\u0001\u0003\u0001=\u0011\u0011#\u00117m/&tGm\\<fIN#(/Z1n\u0015\t\u0019A!A\u0003tG\u0006d\u0017M\u0003\u0002\u0006\r\u0005\u0019\u0011\r]5\u000b\u0005\u001dA\u0011!C:ue\u0016\fW.\u001b8h\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0004!}I3C\u0001\u0001\u0012!\t\u0011B#D\u0001\u0014\u0015\u0005\u0019\u0011BA\u000b\u0014\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0006kCZ\f7\u000b\u001e:fC6\u0004B!\u0007\u000f\u001eQ5\t!D\u0003\u0002\u001c\t\u0005QA-\u0019;bgR\u0014X-Y7\n\u0005\u0005Q\u0002C\u0001\u0010 \u0019\u0001!Q\u0001\t\u0001C\u0002\u0005\u0012\u0011\u0001V\t\u0003E\u0015\u0002\"AE\u0012\n\u0005\u0011\u001a\"a\u0002(pi\"Lgn\u001a\t\u0003%\u0019J!aJ\n\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u001fS\u0011)!\u0006\u0001b\u0001W\t\tq+\u0005\u0002#YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\bo&tGm\\<t\u0015\t\tD!A\u0005xS:$wn^5oO&\u00111G\f\u0002\u0007/&tGm\\<\t\u000bU\u0002A\u0011\u0001\u001c\u0002\rqJg.\u001b;?)\t9\u0014\b\u0005\u00039\u0001uAS\"\u0001\u0002\t\u000b]!\u0004\u0019\u0001\r\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u001f\u0005dGn\\<fI2\u000bG/\u001a8fgN$\"aN\u001f\t\u000byR\u0004\u0019A \u0002\u00111\fG/\u001a8fgN\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0019\u0002\tQLW.Z\u0005\u0003\t\u0006\u0013A\u0001V5nK\"\u0012!H\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\"\t!\"\u00198o_R\fG/[8o\u0013\tY\u0005J\u0001\bQk\nd\u0017nY#w_24\u0018N\\4\t\u000b5\u0003A\u0011\u0001(\u0002%MLG-Z(viB,H\u000fT1uK\u0012\u000bG/\u0019\u000b\u0003o=CQ\u0001\u0015'A\u0002E\u000b\u0011b\\;uaV$H+Y4\u0011\u0007a\u0012V$\u0003\u0002T\u0005\tIq*\u001e;qkR$\u0016m\u001a\u0015\u0003\u0019\u001aCQA\u0016\u0001\u0005\u0002]\u000bq\u0001\u001e:jO\u001e,'\u000f\u0006\u000281\")a+\u0016a\u00013B\u001a!,Y3\u0011\tms\u0006\rZ\u0007\u00029*\u0011Q\fM\u0001\tiJLwmZ3sg&\u0011q\f\u0018\u0002\b)JLwmZ3s!\tq\u0012\rB\u0005c1\u0006\u0005\t\u0011!B\u0001G\n\u0019q\fJ\u0019\u0012\u0005u)\u0003C\u0001\u0010f\t%1\u0007,!A\u0001\u0002\u000b\u0005qMA\u0002`II\n\"\u0001K\u0013)\u0005U3\u0005\"\u00026\u0001\t\u0003Y\u0017aB3wS\u000e$xN\u001d\u000b\u0003o1DQA[5A\u00025\u00044A\\;y!\u0011y'\u000f^<\u000e\u0003AT!!\u001d\u0019\u0002\u0011\u00154\u0018n\u0019;peNL!a\u001d9\u0003\u000f\u00153\u0018n\u0019;peB\u0011a$\u001e\u0003\nm2\f\t\u0011!A\u0003\u0002\r\u00141a\u0018\u00134!\tq\u0002\u0010B\u0005zY\u0006\u0005\t\u0011!B\u0001O\n\u0019q\f\n\u001b)\u0005%4\u0005\"\u0002?\u0001\t\u0003i\u0018A\u0002:fIV\u001cW\rF\u0002\u007f\u0003\u0007\u00012\u0001O@\u001e\u0013\r\t\tA\u0001\u0002\u000b\t\u0006$\u0018m\u0015;sK\u0006l\u0007bBA\u0003w\u0002\u0007\u0011qA\u0001\tMVt7\r^5p]B)\u0011\u0011BA\u000b;5\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005gk:\u001cG/[8og*!\u0011\u0011CA\n\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001C\u0005\u0005\u0003/\tYA\u0001\bSK\u0012,8-\u001a$v]\u000e$\u0018n\u001c8\t\rq\u0004A\u0011AA\u000e)\rq\u0018Q\u0004\u0005\t\u0003\u000b\tI\u00021\u0001\u0002 A1!#!\t\u001e;uI1!a\t\u0014\u0005%1UO\\2uS>t'\u0007\u0003\u0004}\u0001\u0011\u0005\u0011qE\u000b\u0005\u0003S\t\t\u0004\u0006\u0004\u0002,\u0005\u0015\u0013\u0011\n\u000b\u0005\u0003[\t)\u0004\u0005\u00039\u007f\u0006=\u0002c\u0001\u0010\u00022\u00119\u00111GA\u0013\u0005\u0004\t#!\u0001*\t\u0015\u0005]\u0012QEA\u0001\u0002\b\tI$\u0001\u0006fm&$WM\\2fIE\u0002b!a\u000f\u0002B\u0005=RBAA\u001f\u0015\u0011\ty$a\u0004\u0002\u0011QL\b/Z5oM>LA!a\u0011\u0002>\tyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0003\u0005\u0002H\u0005\u0015\u0002\u0019AA\u0004\u00035\u0001(/Z!hOJ,w-\u0019;pe\"A\u00111JA\u0013\u0001\u0004\ti%\u0001\bxS:$wn\u001e$v]\u000e$\u0018n\u001c8\u0011\u0011\u0005=\u00131K\u000f\u00020!j!!!\u0015\u000b\u0007\u0005\u0015!!\u0003\u0003\u0002V\u0005E#!E!mY^Kg\u000eZ8x\rVt7\r^5p]\"1A\u0010\u0001C\u0001\u00033*B!a\u0017\u0002dQ1\u0011QLA6\u0003[\"B!a\u0018\u0002fA!\u0001h`A1!\rq\u00121\r\u0003\b\u0003g\t9F1\u0001\"\u0011)\t9'a\u0016\u0002\u0002\u0003\u000f\u0011\u0011N\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBA\u001e\u0003\u0003\n\t\u0007\u0003\u0005\u0002H\u0005]\u0003\u0019AA\u0010\u0011!\tY%a\u0016A\u0002\u0005=\u0004C\u0003\n\u0002r!\n)(!$\u0002\u001a&\u0019\u00111O\n\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004#BA<\u0003\u000fkb\u0002BA=\u0003\u0007sA!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fr\u0011A\u0002\u001fs_>$h(C\u0001\u0004\u0013\r\t)iE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI)a#\u0003\u0011%#XM]1cY\u0016T1!!\"\u0014!\u0019\ty)!&\u0002b5\u0011\u0011\u0011\u0013\u0006\u0004\u0003'C\u0011\u0001B;uS2LA!a&\u0002\u0012\nI1i\u001c7mK\u000e$xN\u001d\t\u0004%\u0005m\u0015bAAO'\t!QK\\5u\u0011\u0019a\b\u0001\"\u0001\u0002\"V!\u00111UAV)\u0019\t)+a-\u00026R!\u0011qUAW!\u0011At0!+\u0011\u0007y\tY\u000bB\u0004\u00024\u0005}%\u0019A\u0011\t\u0015\u0005=\u0016qTA\u0001\u0002\b\t\t,\u0001\u0006fm&$WM\\2fIM\u0002b!a\u000f\u0002B\u0005%\u0006\u0002CA$\u0003?\u0003\r!a\u0002\t\u0011\u0005-\u0013q\u0014a\u0001\u0003o\u0003\u0002\"a\u0014\u0002:v\tI\u000bK\u0005\u0005\u0003w\u000b\tF\u0001\rQe>\u001cWm]:BY2<\u0016N\u001c3po\u001a+hn\u0019;j_:D3!a(G\u0011\u0019a\b\u0001\"\u0001\u0002BV!\u00111YAf)\u0019\t)-a5\u0002VR!\u0011qYAg!\u0011At0!3\u0011\u0007y\tY\rB\u0004\u00024\u0005}&\u0019A\u0011\t\u0015\u0005=\u0017qXA\u0001\u0002\b\t\t.\u0001\u0006fm&$WM\\2fIQ\u0002b!a\u000f\u0002B\u0005%\u0007\u0002CA$\u0003\u007f\u0003\r!a\b\t\u0011\u0005-\u0013q\u0018a\u0001\u0003/\u0004\u0002\"a\u0014\u0002:v\tI\r\u000b\u0015\u0004\u0003\u007f3\u0005bBAo\u0001\u0011\u0005\u0011q\\\u0001\nC\u001e<'/Z4bi\u0016,b!!9\u0002t\u0006%H\u0003BAr\u0003{$b!!:\u0002l\u0006]\b\u0003\u0002\u001d\u0000\u0003O\u00042AHAu\t\u001d\t\u0019$a7C\u0002\u0005B!\"!<\u0002\\\u0006\u0005\t9AAx\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0007\u0003w\t\t%!=\u0011\u0007y\t\u0019\u0010B\u0004\u0002v\u0006m'\u0019A\u0011\u0003\u0007\u0005\u001b5\t\u0003\u0006\u0002z\u0006m\u0017\u0011!a\u0002\u0003w\f!\"\u001a<jI\u0016t7-\u001a\u00137!\u0019\tY$!\u0011\u0002h\"A\u0011q`An\u0001\u0004\u0011\t!A\tbO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u0004\u0012\"!\u0003\u0003\u0004u\t\t0a:\n\t\t\u0015\u00111\u0002\u0002\u0012\u0003\u001e<'/Z4bi\u00164UO\\2uS>t\u0007fAAn\r\"9\u0011Q\u001c\u0001\u0005\u0002\t-Q\u0003\u0003B\u0007\u0005?\u0011IC!\u0006\u0015\r\t=!1\u0007B\u001c)!\u0011\tBa\u0006\u0003\"\t5\u0002\u0003\u0002\u001d\u0000\u0005'\u00012A\bB\u000b\t\u001d\t\u0019D!\u0003C\u0002\u0005B!B!\u0007\u0003\n\u0005\u0005\t9\u0001B\u000e\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0007\u0003w\t\tE!\b\u0011\u0007y\u0011y\u0002B\u0004\u0002v\n%!\u0019A\u0011\t\u0015\t\r\"\u0011BA\u0001\u0002\b\u0011)#\u0001\u0006fm&$WM\\2fIa\u0002b!a\u000f\u0002B\t\u001d\u0002c\u0001\u0010\u0003*\u00119!1\u0006B\u0005\u0005\u0004\t#!\u0001,\t\u0015\t=\"\u0011BA\u0001\u0002\b\u0011\t$\u0001\u0006fm&$WM\\2fIe\u0002b!a\u000f\u0002B\tM\u0001\u0002CA$\u0005\u0013\u0001\rA!\u000e\u0011\u0013\u0005%!1A\u000f\u0003\u001e\t\u001d\u0002\u0002CA&\u0005\u0013\u0001\rA!\u000f\u0011\u0013\u0005=\u00131\u000bB\u0014\u0005'A\u0003f\u0001B\u0005\r\"9\u0011Q\u001c\u0001\u0005\u0002\t}R\u0003\u0003B!\u0005'\u0012iF!\u0013\u0015\r\t\r#Q\rB5)!\u0011)Ea\u0013\u0003V\t}\u0003\u0003\u0002\u001d\u0000\u0005\u000f\u00022A\bB%\t\u001d\t\u0019D!\u0010C\u0002\u0005B!B!\u0014\u0003>\u0005\u0005\t9\u0001B(\u0003-)g/\u001b3f]\u000e,G%\r\u0019\u0011\r\u0005m\u0012\u0011\tB)!\rq\"1\u000b\u0003\b\u0003k\u0014iD1\u0001\"\u0011)\u00119F!\u0010\u0002\u0002\u0003\u000f!\u0011L\u0001\fKZLG-\u001a8dK\u0012\n\u0014\u0007\u0005\u0004\u0002<\u0005\u0005#1\f\t\u0004=\tuCa\u0002B\u0016\u0005{\u0011\r!\t\u0005\u000b\u0005C\u0012i$!AA\u0004\t\r\u0014aC3wS\u0012,gnY3%cI\u0002b!a\u000f\u0002B\t\u001d\u0003\u0002CA$\u0005{\u0001\rAa\u001a\u0011\u0013\u0005%!1A\u000f\u0003R\tm\u0003\u0002CA&\u0005{\u0001\rAa\u001b\u0011\u0013\u0005=\u0013\u0011\u0018B.\u0005\u000fB\u0003f\u0001B\u001f\r\"9\u0011Q\u001c\u0001\u0005\u0002\tET\u0003\u0003B:\u0005\u000b\u0013yIa\u001f\u0015\r\tU$q\u0013BN)!\u00119H! \u0003\b\nE\u0005\u0003\u0002\u001d\u0000\u0005s\u00022A\bB>\t\u001d\t\u0019Da\u001cC\u0002\u0005B!Ba \u0003p\u0005\u0005\t9\u0001BA\u0003-)g/\u001b3f]\u000e,G%M\u001a\u0011\r\u0005m\u0012\u0011\tBB!\rq\"Q\u0011\u0003\b\u0003k\u0014yG1\u0001\"\u0011)\u0011IIa\u001c\u0002\u0002\u0003\u000f!1R\u0001\fKZLG-\u001a8dK\u0012\nD\u0007\u0005\u0004\u0002<\u0005\u0005#Q\u0012\t\u0004=\t=Ea\u0002B\u0016\u0005_\u0012\r!\t\u0005\u000b\u0005'\u0013y'!AA\u0004\tU\u0015aC3wS\u0012,gnY3%cU\u0002b!a\u000f\u0002B\te\u0004\u0002CA$\u0005_\u0002\rA!'\u0011\u0013\u0005%!1A\u000f\u0003\u0004\n5\u0005\u0002CA&\u0005_\u0002\rA!(\u0011\u0015I\t\t\b\u000bBP\u0005C\u000bI\n\u0005\u0004\u0002x\u0005\u001d%Q\u0012\t\u0007\u0003\u001f\u000b)J!\u001f)\u0007\t=d\tC\u0004\u0003(\u0002!\tA!+\u0002\u000fA\u0014xnY3tgV!!1\u0016BZ)\u0011\u0011iKa/\u0015\t\t=&Q\u0017\t\u0005q}\u0014\t\fE\u0002\u001f\u0005g#q!a\r\u0003&\n\u0007\u0011\u0005\u0003\u0006\u00038\n\u0015\u0016\u0011!a\u0002\u0005s\u000b1\"\u001a<jI\u0016t7-\u001a\u00132mA1\u00111HA!\u0005cC\u0001\"!\u0002\u0003&\u0002\u0007!Q\u0018\t\t\u0003\u001f\nI,\bBYQ!\u001a!Q\u0015$\t\u000f\t\r\u0007\u0001\"\u0001\u0003F\u0006)\u0011\r\u001d9msV!!q\u0019Bh)\u0011\u0011IMa6\u0015\t\t-'\u0011\u001b\t\u0005q}\u0014i\rE\u0002\u001f\u0005\u001f$q!a\r\u0003B\n\u0007\u0011\u0005\u0003\u0006\u0003T\n\u0005\u0017\u0011!a\u0002\u0005+\f1\"\u001a<jI\u0016t7-\u001a\u00132oA1\u00111HA!\u0005\u001bD\u0001\"!\u0002\u0003B\u0002\u0007!\u0011\u001c\t\t\u0003\u001f\n\u0019&\bBgQ!9!1\u0019\u0001\u0005\u0002\tuW\u0003\u0002Bp\u0005O$BA!9\u0003pR!!1\u001dBu!\u0011AtP!:\u0011\u0007y\u00119\u000fB\u0004\u00024\tm'\u0019A\u0011\t\u0015\t-(1\\A\u0001\u0002\b\u0011i/A\u0006fm&$WM\\2fIEB\u0004CBA\u001e\u0003\u0003\u0012)\u000f\u0003\u0005\u0002\u0006\tm\u0007\u0019\u0001By!)\u0011\u0012\u0011\u000f\u0015\u0002v\tM\u0018\u0011\u0014\t\u0007\u0003\u001f\u000b)J!:\t\u000f\t\r\u0007\u0001\"\u0001\u0003xV!!\u0011`B\u0001)\u0019\u0011Yp!\u0003\u0004\fQ!!Q`B\u0002!\u0011AtPa@\u0011\u0007y\u0019\t\u0001B\u0004\u00024\tU(\u0019A\u0011\t\u0015\r\u0015!Q_A\u0001\u0002\b\u00199!A\u0006fm&$WM\\2fIEJ\u0004CBA\u001e\u0003\u0003\u0012y\u0010\u0003\u0005\u0002H\tU\b\u0019AA\u0004\u0011!\tYE!>A\u0002\r5\u0001\u0003CA(\u0003'j\"q \u0015)\u0011\tU8\u0011CB\f\u0007s\u00012AEB\n\u0013\r\u0019)b\u0005\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0004\u001a\r\u001d2qFB\u0015!\u0011\u0019Yb!\t\u000f\u0007I\u0019i\"C\u0002\u0004 M\ta\u0001\u0015:fI\u00164\u0017\u0002BB\u0012\u0007K\u0011aa\u0015;sS:<'bAB\u0010'%!1\u0011FB\u0016\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u00191QF\n\u0002\u0015\u0011,\u0007O]3dCR,G-M\u0005$\u0007c\u0019\u0019d!\u000e\u0004.9\u0019!ca\r\n\u0007\r52#M\u0003#%M\u00199DA\u0003tG\u0006d\u0017-M\u0005$\u00073\u0019Yda\u0010\u0004>%!1QHB\u0016\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eEJ1e!\r\u00044\r\u00053QF\u0019\u0006EI\u00192q\u0007\u0005\b\u0005\u0007\u0004A\u0011AB#+\u0011\u00199ea\u0014\u0015\r\r%3qKB-)\u0011\u0019Ye!\u0015\u0011\taz8Q\n\t\u0004=\r=CaBA\u001a\u0007\u0007\u0012\r!\t\u0005\u000b\u0007'\u001a\u0019%!AA\u0004\rU\u0013aC3wS\u0012,gnY3%eA\u0002b!a\u000f\u0002B\r5\u0003\u0002CA$\u0007\u0007\u0002\r!a\b\t\u0011\u0005-31\ta\u0001\u00077\u0002\"BEA9Q\u0005U4QLAM!\u0019\ty)!&\u0004N!B11IB\t\u0007C\u001a9'M\u0005$\u00073\u00199ca\u0019\u0004*EJ1e!\r\u00044\r\u00154QF\u0019\u0006EI\u00192qG\u0019\nG\re11HB5\u0007{\t\u0014bIB\u0019\u0007g\u0019Yg!\f2\u000b\t\u00122ca\u000e\t\u000f\r=\u0004\u0001\"\u0001\u0004r\u0005\u0019Q.\u0019=\u0015\u0007y\u001c\u0019\b\u0003\u0005\u0004v\r5\u0004\u0019AB<\u0003!\u0001xn]5uS>t\u0007c\u0001\n\u0004z%\u001911P\n\u0003\u0007%sG\u000fC\u0004\u0004p\u0001!\taa \u0015\u0007y\u001c\t\t\u0003\u0005\u0004\u0004\u000eu\u0004\u0019AB\r\u0003\u00151\u0017.\u001a7e\u0011\u001d\u00199\t\u0001C\u0001\u0007\u0013\u000b1!\\5o)\rq81\u0012\u0005\t\u0007k\u001a)\t1\u0001\u0004x!91q\u0011\u0001\u0005\u0002\r=Ec\u0001@\u0004\u0012\"A11QBG\u0001\u0004\u0019I\u0002C\u0004\u0004\u0016\u0002!\taa&\u0002\u0007M,X\u000eF\u0002\u007f\u00073C\u0001b!\u001e\u0004\u0014\u0002\u00071q\u000f\u0005\b\u0007+\u0003A\u0011ABO)\rq8q\u0014\u0005\t\u0007\u0007\u001bY\n1\u0001\u0004\u001a!911\u0015\u0001\u0005\u0002\r\u0015\u0016!B7bq\nKHc\u0001@\u0004(\"A1QOBQ\u0001\u0004\u00199\bC\u0004\u0004$\u0002!\taa+\u0015\u0007y\u001ci\u000b\u0003\u0005\u0004\u0004\u000e%\u0006\u0019AB\r\u0011\u001d\u0019\t\f\u0001C\u0001\u0007g\u000bQ!\\5o\u0005f$2A`B[\u0011!\u0019)ha,A\u0002\r]\u0004bBBY\u0001\u0011\u00051\u0011\u0018\u000b\u0004}\u000em\u0006\u0002CBB\u0007o\u0003\ra!\u0007\t\u000f\u0005u\u0007\u0001\"\u0003\u0004@R)ap!1\u0004v\"A11YB_\u0001\u0004\u0019)-A\bbO\u001e\u0014XmZ1uS>tG+\u001f9f!\u0011\u00199ma<\u000f\t\r%7\u0011\u001e\b\u0005\u0007\u0017\u001c\u0019O\u0004\u0003\u0004N\u000e\u0005h\u0002BBh\u0007?tAa!5\u0004^:!11[Bn\u001d\u0011\u0019)n!7\u000f\t\u0005m4q[\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011bAA\u0007\t%!1Q]Bt\u0003-\twm\u001a:fO\u0006$\u0018n\u001c8\u000b\u0007\u00055A!\u0003\u0003\u0004l\u000e5\u0018aE!hOJ,w-\u0019;j_:4UO\\2uS>t'\u0002BBs\u0007OLAa!=\u0004t\ny\u0011iZ4sK\u001e\fG/[8o)f\u0004XM\u0003\u0003\u0004l\u000e5\b\u0002CBB\u0007{\u0003\ra!\u0007\t\u000f\u0005u\u0007\u0001\"\u0001\u0004zR)apa?\u0004~\"A11YB|\u0001\u0004\u0019)\r\u0003\u0005\u0004v\r]\b\u0019AB<\u0011!!\t\u0001\u0001C\u0001\u0011\u0011\r\u0011!B2mK\u0006tW\u0003\u0002C\u0003\t\u0013!B\u0001b\u0002\u0005\u0010A\u0019a\u0004\"\u0003\u0005\u0011\u0011-1q b\u0001\t\u001b\u0011\u0011AR\t\u0003EEA\u0001\u0002\"\u0005\u0004\u0000\u0002\u0007AqA\u0001\u0002M\"9AQ\u0003\u0001\u0005\n\u0011]\u0011\u0001D4fi&s\u0007/\u001e;UsB,GC\u0001C\r!\u0015\tY$!\u0011\u001eQ\r\u0001AQ\u0004\t\u0004\u000f\u0012}\u0011b\u0001C\u0011\u0011\n1\u0001+\u001e2mS\u000e\u0004")
public class AllWindowedStream<T, W extends Window> {
    private final org.apache.flink.streaming.api.datastream.AllWindowedStream<T, W> javaStream;

    @PublicEvolving
    public AllWindowedStream<T, W> allowedLateness(Time lateness) {
        this.javaStream.allowedLateness(lateness);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> sideOutputLateData(OutputTag<T> outputTag) {
        this.javaStream.sideOutputLateData(outputTag);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.javaStream.trigger(trigger);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.javaStream.evictor(evictor);
        return this;
    }

    public DataStream<T> reduce(ReduceFunction<T> function) {
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(this.clean(function)));
    }

    public DataStream<T> reduce(Function2<T, T, T> function) {
        if (function == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        Function2<T, T, T> cleanFun = this.clean(function);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanFun);
        return this.reduce(reducer);
    }

    public <R> DataStream<R> reduce(ReduceFunction<T> preAggregator, AllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$1) {
        ReduceFunction<T> cleanedReducer = this.clean(preAggregator);
        AllWindowFunction<T, R, W> cleanedWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaAllWindowFunctionWrapper<T, R, W>(cleanedWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(cleanedReducer, applyFunction, returnType));
    }

    public <R> DataStream<R> reduce(Function2<T, T, T> preAggregator, Function3<W, Iterable<T>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<R> evidence$2) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        Function3<W, Iterable<T>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaAllWindowFunction<T, R, W> applyFunction = new ScalaAllWindowFunction<T, R, W>(cleanWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$2);
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(reducer, applyFunction, returnType));
    }

    @PublicEvolving
    public <R> DataStream<R> reduce(ReduceFunction<T> preAggregator, ProcessAllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$3) {
        ReduceFunction<T> cleanedReducer = this.clean(preAggregator);
        ProcessAllWindowFunction<T, R, W> cleanedWindowFunction = this.clean((Object)windowFunction);
        ScalaProcessAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaProcessAllWindowFunctionWrapper<T, R, W>(cleanedWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$3);
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(cleanedReducer, applyFunction, returnType));
    }

    @PublicEvolving
    public <R> DataStream<R> reduce(Function2<T, T, T> preAggregator, ProcessAllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$4) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        ProcessAllWindowFunction<T, R, W> cleanWindowFunction = this.clean((Object)windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaProcessAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaProcessAllWindowFunctionWrapper<T, R, W>(cleanWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$4);
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(reducer, applyFunction, returnType));
    }

    @PublicEvolving
    public <ACC, R> DataStream<R> aggregate(AggregateFunction<T, ACC, R> aggregateFunction, TypeInformation<ACC> evidence$5, TypeInformation<R> evidence$6) {
        Preconditions.checkNotNull(aggregateFunction, (String)"AggregationFunction must not be null");
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$5);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$6);
        return package$.MODULE$.asScalaStream(this.javaStream.aggregate(this.clean(aggregateFunction), accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, AllWindowFunction<V, R, W> windowFunction, TypeInformation<ACC> evidence$7, TypeInformation<V> evidence$8, TypeInformation<R> evidence$9) {
        Preconditions.checkNotNull(preAggregator, (String)"AggregationFunction must not be null");
        Preconditions.checkNotNull(windowFunction, (String)"Window function must not be null");
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        AllWindowFunction<V, R, W> cleanedWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunctionWrapper<V, R, W> applyFunction = new ScalaAllWindowFunctionWrapper<V, R, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$7);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$9);
        return package$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, ProcessAllWindowFunction<V, R, W> windowFunction, TypeInformation<ACC> evidence$10, TypeInformation<V> evidence$11, TypeInformation<R> evidence$12) {
        Preconditions.checkNotNull(preAggregator, (String)"AggregationFunction must not be null");
        Preconditions.checkNotNull(windowFunction, (String)"Window function must not be null");
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        ProcessAllWindowFunction<V, R, W> cleanedWindowFunction = this.clean((Object)windowFunction);
        ScalaProcessAllWindowFunctionWrapper<V, R, W> applyFunction = new ScalaProcessAllWindowFunctionWrapper<V, R, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$10);
        TypeInformation aggregationResultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$11);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$12);
        return package$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, aggregationResultType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, Function3<W, Iterable<V>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<ACC> evidence$13, TypeInformation<V> evidence$14, TypeInformation<R> evidence$15) {
        Preconditions.checkNotNull(preAggregator, (String)"AggregationFunction must not be null");
        Preconditions.checkNotNull(windowFunction, (String)"Window function must not be null");
        AggregateFunction<T, ACC, V> cleanPreAggregator = this.clean(preAggregator);
        Function3<W, Iterable<V>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunction<V, R, W> applyFunction = new ScalaAllWindowFunction<V, R, W>(cleanWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$13);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$15);
        return package$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanPreAggregator, applyFunction, accumulatorType, resultType));
    }

    @PublicEvolving
    public <R> DataStream<R> process(ProcessAllWindowFunction<T, R, W> function, TypeInformation<R> evidence$16) {
        ProcessAllWindowFunction<T, R, W> cleanedFunction = this.clean((Object)function);
        ScalaProcessAllWindowFunctionWrapper<T, R, W> javaFunction = new ScalaProcessAllWindowFunctionWrapper<T, R, W>(cleanedFunction);
        return package$.MODULE$.asScalaStream(this.javaStream.process(javaFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$16)));
    }

    public <R> DataStream<R> apply(AllWindowFunction<T, R, W> function, TypeInformation<R> evidence$17) {
        AllWindowFunction<T, R, W> cleanedFunction = this.clean(function);
        ScalaAllWindowFunctionWrapper<T, R, W> javaFunction = new ScalaAllWindowFunctionWrapper<T, R, W>(cleanedFunction);
        return package$.MODULE$.asScalaStream(this.javaStream.apply(javaFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$17)));
    }

    public <R> DataStream<R> apply(Function3<W, Iterable<T>, Collector<R>, BoxedUnit> function, TypeInformation<R> evidence$18) {
        Function3<W, Iterable<T>, Collector<R>, BoxedUnit> cleanedFunction = this.clean(function);
        ScalaAllWindowFunction<T, R, W> applyFunction = new ScalaAllWindowFunction<T, R, W>(cleanedFunction);
        return package$.MODULE$.asScalaStream(this.javaStream.apply(applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$18)));
    }

    public <R> DataStream<R> apply(ReduceFunction<T> preAggregator, AllWindowFunction<T, R, W> windowFunction, TypeInformation<R> evidence$19) {
        ReduceFunction<T> cleanedReducer = this.clean(preAggregator);
        AllWindowFunction<T, R, W> cleanedWindowFunction = this.clean(windowFunction);
        ScalaAllWindowFunctionWrapper<T, R, W> applyFunction = new ScalaAllWindowFunctionWrapper<T, R, W>(cleanedWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$19);
        return package$.MODULE$.asScalaStream(this.javaStream.apply(cleanedReducer, applyFunction, returnType));
    }

    public <R> DataStream<R> apply(Function2<T, T, T> preAggregator, Function3<W, Iterable<T>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<R> evidence$20) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        Function3<W, Iterable<T>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaAllWindowFunction<T, R, W> applyFunction = new ScalaAllWindowFunction<T, R, W>(cleanWindowFunction);
        TypeInformation returnType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$20);
        return package$.MODULE$.asScalaStream(this.javaStream.apply(reducer, applyFunction, returnType));
    }

    public DataStream<T> max(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, position);
    }

    public DataStream<T> max(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, field);
    }

    public DataStream<T> min(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, position);
    }

    public DataStream<T> min(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, field);
    }

    public DataStream<T> sum(int position) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, position);
    }

    public DataStream<T> sum(String field) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, field);
    }

    public DataStream<T> maxBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, position);
    }

    public DataStream<T> maxBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, field);
    }

    public DataStream<T> minBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, position);
    }

    public DataStream<T> minBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, field);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, String field) {
        int position = package$.MODULE$.fieldNames2Indices(this.getInputType(), (String[])((Object[])new String[]{field}))[0];
        return this.aggregate(aggregationType, position);
    }

    public DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, int position) {
        org.apache.flink.streaming.api.datastream.AllWindowedStream<T, W> jStream = this.javaStream;
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        Object object = AggregationFunction.AggregationType.SUM.equals(aggregationType2) ? new SumAggregator(position, jStream.getInputType(), jStream.getExecutionEnvironment().getConfig()) : new ComparableAggregator(position, jStream.getInputType(), aggregationType, true, jStream.getExecutionEnvironment().getConfig());
        SumAggregator reducer = object;
        return new DataStream(jStream.reduce((ReduceFunction)reducer));
    }

    public <F> F clean(F f) {
        return new StreamExecutionEnvironment(this.javaStream.getExecutionEnvironment()).scalaClean(f);
    }

    private TypeInformation<T> getInputType() {
        return this.javaStream.getInputType();
    }

    public AllWindowedStream(org.apache.flink.streaming.api.datastream.AllWindowedStream<T, W> javaStream) {
        this.javaStream = javaStream;
    }
}

