/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;

public abstract class AbstractJobVertexRequestHandler
extends AbstractExecutionGraphRequestHandler {
    public AbstractJobVertexRequestHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public final CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        JobVertexID vid = AbstractJobVertexRequestHandler.parseJobVertexId(params);
        AccessExecutionJobVertex jobVertex = graph.getJobVertex(vid);
        if (jobVertex == null) {
            throw new IllegalArgumentException("No vertex with ID '" + (Object)((Object)vid) + "' exists.");
        }
        return this.handleRequest(jobVertex, params);
    }

    public static JobVertexID parseJobVertexId(Map<String, String> params) {
        String jobVertexIdParam = params.get("vertexid");
        if (jobVertexIdParam == null) {
            return null;
        }
        try {
            return JobVertexID.fromHexString(jobVertexIdParam);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public abstract CompletableFuture<String> handleRequest(AccessExecutionJobVertex var1, Map<String, String> var2);
}

