/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.async;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.flink.runtime.io.async.StoppableCallbackCallable;
import org.apache.flink.util.Preconditions;

public class AsyncStoppableTaskWithCallback<V>
extends FutureTask<V> {
    protected final StoppableCallbackCallable<V> stoppableCallbackCallable;

    public AsyncStoppableTaskWithCallback(StoppableCallbackCallable<V> callable) {
        super((Callable)Preconditions.checkNotNull(callable));
        this.stoppableCallbackCallable = callable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancel = super.cancel(mayInterruptIfRunning);
        if (cancel) {
            this.stoppableCallbackCallable.stop();
            this.stoppableCallbackCallable.done(true);
        }
        return cancel;
    }

    @Override
    protected void done() {
        if (!this.isCancelled()) {
            this.stoppableCallbackCallable.done(false);
        }
    }

    public static <V> AsyncStoppableTaskWithCallback<V> from(StoppableCallbackCallable<V> callable) {
        return new AsyncStoppableTaskWithCallback<V>(callable);
    }
}

