/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.representation.Form;
import com.sun.jersey.api.view.Viewable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.HasId;
import org.apache.camel.web.model.EndpointLink;
import org.apache.camel.web.model.Endpoints;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.EndpointResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointsResource
extends CamelChildResourceSupport {
    private static final transient Log LOG = LogFactory.getLog(EndpointsResource.class);
    private String error = "";
    private String newUri = "mock:someName";

    public EndpointsResource(CamelContextResource contextResource) {
        super(contextResource);
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Endpoints getDTO() {
        return new Endpoints(this.getCamelContext());
    }

    @Path(value="{id}")
    public EndpointResource getEndpoint(@PathParam(value="id") String id) {
        Endpoint endpoint = null;
        if (id != null && (id = id.trim()).length() > 0) {
            endpoint = this.getCamelContext().getEndpoint(id);
        }
        if (endpoint == null) {
            for (Endpoint e : this.getCamelContext().getEndpoints()) {
                HasId hasId;
                String value;
                if (!(e instanceof HasId) || (value = (hasId = (HasId)e).getId()) == null || !value.equals(id)) continue;
                endpoint = e;
                break;
            }
        }
        if (endpoint != null) {
            return new EndpointResource(this.getContextResource(), id, endpoint);
        }
        LOG.warn((Object)("No endpoint found for id: " + id));
        return null;
    }

    @POST
    @Consumes(value={"text/plain"})
    public Response postUri(String uri) throws URISyntaxException {
        EndpointResource endpoint = this.getEndpoint(uri);
        if (endpoint != null) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postUriForm(@Context UriInfo uriInfo, Form formData) throws URISyntaxException {
        System.out.println("Received form! " + formData);
        this.newUri = (String)formData.getFirst("uri", String.class);
        EndpointResource endpoint = this.getEndpoint(this.newUri);
        if (endpoint != null) {
            String href = endpoint.getHref();
            System.out.println("Created endpoint so redirecting to " + href);
            return Response.seeOther((URI)new URI(href)).build();
        }
        this.error = "Could not find a component to resolve that URI";
        System.out.println("Failed to create new endpoint!");
        return Response.ok((Object)new Viewable("index", (Object)this)).build();
    }

    public List<EndpointLink> getEndpoints() {
        return this.getDTO().getEndpoints();
    }

    public String getError() {
        return this.error;
    }

    public String getNewUri() {
        return this.newUri;
    }
}

