/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Iterator;
import net.java.truecommons.shed.Option;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class OptionSomeTest {
    private final String string = "Hello world!";
    private final Option<String> option = Option.apply((Object)"Hello world!");

    @Test
    public void testImmutableIteratorWithOneElement() {
        Iterator it = this.option.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertThat(it.next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)"Hello world!")));
        try {
            it.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSizeIsOne() {
        Assert.assertThat((Object)this.option.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertFalse((boolean)this.option.isEmpty());
    }

    @Test
    public void testGet() {
        Assert.assertSame((Object)"Hello world!", (Object)this.option.get());
    }

    @Test
    public void testGetOrElse() {
        Assert.assertSame((Object)"Hello world!", (Object)this.option.getOrElse((Object)"foo"));
    }

    @Test
    public void testOrNull() {
        Assert.assertSame((Object)"Hello world!", (Object)this.option.orNull());
    }

    @Test
    public void testEquals() {
        Option<String> o1 = this.option;
        Option o2 = Option.apply((Object)new String("Hello world!"));
        Assert.assertEquals(o1, (Object)o2);
        Assert.assertEquals((Object)o2, o1);
        Assert.assertFalse((boolean)o1.equals((Object)Option.apply(null)));
        Assert.assertFalse((boolean)Option.apply(null).equals(o1));
    }
}

