/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx;

import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.macosx.OsxKeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.AbstractPromptingPbeParameters;

@ThreadSafe
final class OsxKeyProvider<P extends AbstractPromptingPbeParameters<P, ?>>
implements KeyProvider<P> {
    private final OsxKeyManager<P> manager;
    private final URI resource;
    private final KeyProvider<P> provider;
    @CheckForNull
    private volatile P param;

    OsxKeyProvider(OsxKeyManager<P> manager, URI resource, KeyProvider<P> provider) {
        assert (null != manager);
        assert (null != resource);
        assert (null != provider);
        this.manager = manager;
        this.resource = resource;
        this.provider = provider;
    }

    public P getKeyForWriting() throws UnknownKeyException {
        P op = this.param;
        if (null == op) {
            op = this.manager.getKey(this.resource);
        }
        if (null != op && !op.isChangeRequested()) {
            return (P)((AbstractPromptingPbeParameters)op.clone());
        }
        AbstractPromptingPbeParameters np = (AbstractPromptingPbeParameters)this.provider.getKeyForWriting();
        if (!np.equals(op)) {
            this.manager.setKey(this.resource, np);
        }
        this.param = np;
        return this.param;
    }

    public P getKeyForReading(boolean invalid) throws UnknownKeyException {
        if (!invalid) {
            P op = this.param;
            if (null == op) {
                op = this.manager.getKey(this.resource);
            }
            if (null != op) {
                return (P)((AbstractPromptingPbeParameters)op.clone());
            }
        }
        return (P)((AbstractPromptingPbeParameters)this.provider.getKeyForReading(invalid));
    }

    public void setKey(@CheckForNull P np) {
        P op = this.param;
        this.provider.setKey(np);
        if (!Objects.equals(np, op)) {
            this.manager.setKey(this.resource, np);
        }
        this.param = np;
    }
}

