/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import sun.misc.Unsafe;

final class UnsafeUtils {
    static final Unsafe U;
    static final int ARRAY_OBJECT_INDEX_SHIFT;
    static final long ARRAY_OBJECT_BASE_OFFSET_AS_LONG;
    static final long ARRAY_OBJECT_INDEX_SCALE_AS_LONG;
    static final long ARRAY_INT_BASE_OFFSET_AS_LONG;
    static final long ARRAY_INT_INDEX_SCALE_AS_LONG = 4L;

    static long minInstanceFieldOffset(Class<?> objectClass) {
        return Stream.of(objectClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).mapToLong(field -> U.objectFieldOffset((Field)field)).min().getAsLong();
    }

    static long getFieldOffset(Class<?> objectClass, String fieldName) {
        try {
            Field field = objectClass.getDeclaredField(fieldName);
            return U.objectFieldOffset(field);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static void releaseFence() {
        U.storeFence();
    }

    static void storeStoreFence() {
        U.storeFence();
    }

    static void acquireFence() {
        U.loadFence();
    }

    private UnsafeUtils() {
    }

    static {
        ARRAY_OBJECT_INDEX_SHIFT = Integer.numberOfTrailingZeros(Unsafe.ARRAY_OBJECT_INDEX_SCALE);
        ARRAY_OBJECT_BASE_OFFSET_AS_LONG = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
        ARRAY_OBJECT_INDEX_SCALE_AS_LONG = Unsafe.ARRAY_OBJECT_INDEX_SCALE;
        ARRAY_INT_BASE_OFFSET_AS_LONG = Unsafe.ARRAY_INT_BASE_OFFSET;
        Utils.verifyEqual(4L, (long)Unsafe.ARRAY_INT_INDEX_SCALE);
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            U = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

