/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.Utils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> delegate;
    private final Predicate<T> filter;
    private State state = State.NOT_READY;
    private boolean couldRemovePreviousElement = false;
    private @Nullable T next;

    FilteringIterator(Iterator<? extends T> delegate, Predicate<T> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.state == State.FAILED) {
            throw new IllegalStateException();
        }
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        T next;
        this.state = State.FAILED;
        this.couldRemovePreviousElement = false;
        do {
            if (this.delegate.hasNext()) continue;
            this.state = State.DONE;
            return false;
        } while (!this.filter.test(next = Utils.verifyNonNull(this.delegate.next())));
        this.state = State.READY;
        this.next = next;
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = Utils.verifyNonNull(this.next);
        this.state = State.NOT_READY;
        this.couldRemovePreviousElement = true;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        if (!this.couldRemovePreviousElement) {
            if (this.state != State.NOT_READY) {
                throw new IllegalStateException("This iterator doesn't support remove after hasNext() has been called since the last call to next()");
            }
            throw new IllegalStateException("Could not remove because next() has not been yet called on this iterator or remove() has already been called after the last call to next()");
        }
        this.couldRemovePreviousElement = false;
        this.delegate.remove();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

