/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.CheckingMatcher;
import io.timeandspace.jpsg.CheckingPattern;
import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.TemplateProcessor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J,\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lio/timeandspace/jpsg/PrintProcessor;", "Lio/timeandspace/jpsg/TemplateProcessor;", "()V", "priority", "", "process", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "source", "Lio/timeandspace/jpsg/Context;", "target", "template", "", "Companion", "core"})
public final class PrintProcessor
extends TemplateProcessor {
    private static final int PRIORITY = 0;
    private static final String PREFIX = "/[*/]\\s*print\\s+(?<dim>\\w+)";
    private static final CheckingPattern PRINT_PATTERN;
    public static final Companion Companion;

    @Override
    protected int priority() {
        return PRIORITY;
    }

    @Override
    protected void process(@NotNull StringBuilder builder, @NotNull Context source, @NotNull Context target, @NotNull String template) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        CheckingMatcher valueM = PRINT_PATTERN.matcher(template);
        StringBuilder sb = new StringBuilder();
        while (valueM.find()) {
            String dim = valueM.group("dim");
            Option option = target.getOption(dim);
            if (option != null) {
                valueM.appendSimpleReplacement(sb, option.toString());
                continue;
            }
            throw (Throwable)MalformedTemplateException.Companion.near(template, valueM.start(), "Nonexistent dimension: " + dim + ", available dims: " + target);
        }
        valueM.appendTail(sb);
        this.postProcess(builder, source, target, sb.toString());
    }

    static {
        Companion = new Companion(null);
        PRINT_PATTERN = CheckingPattern.compile(PREFIX, "/[*/]\\s*print\\s+(?<dim>\\w+)\\s*[*/]/[^/]*?/[*/]\\s*endprint\\s*[*/]/");
    }

    public static final int getPRIORITY() {
        Companion companion = Companion;
        return PRIORITY;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/timeandspace/jpsg/PrintProcessor$Companion;", "", "()V", "PREFIX", "", "PRINT_PATTERN", "Lio/timeandspace/jpsg/CheckingPattern;", "kotlin.jvm.PlatformType", "PRIORITY", "", "PRIORITY$annotations", "getPRIORITY", "()I", "core"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void PRIORITY$annotations() {
        }

        public final int getPRIORITY() {
            return PRIORITY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

