/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.IntermediateOption;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.StringLengthComparator;
import io.timeandspace.jpsg.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public enum PrimitiveType implements Option
{
    BOOL("boolean", "Boolean", "bool", false),
    BOOLEAN("boolean", "Boolean", "boolean", false),
    BYTE("byte", "Byte"),
    CHAR("char", "Character"),
    CHARACTER("char", "Character", "character", true),
    SHORT("short", "Short"),
    INT("int", "Integer"){

        @Override
        public String formatValue(String value) {
            return value;
        }
    }
    ,
    INTEGER("int", "Integer", "integer", true){

        @Override
        public String formatValue(String value) {
            return value;
        }
    }
    ,
    LONG("long", "Long"){

        @Override
        public String formatValue(String value) {
            return value + "L";
        }
    }
    ,
    FLOAT("float", "Float"){

        @Override
        public String intermediateReplace(String content, String dim) {
            content = super.intermediateReplace(content, dim);
            content = INT.intermediateReplace(content, dim + ".bits");
            return content;
        }

        @Override
        public String finalReplace(String content, String dim) {
            content = INT.finalReplace(content, dim + ".bits");
            content = super.finalReplace(content, dim);
            return content;
        }

        @Override
        public String formatValue(String value) {
            return value + ".0f";
        }

        @Override
        String minValue() {
            return "Float.NEGATIVE_INFINITY";
        }

        @Override
        String maxValue() {
            return "Float.POSITIVE_INFINITY";
        }

        @Override
        public PrimitiveType bitsType() {
            return INT;
        }
    }
    ,
    DOUBLE("double", "Double"){

        @Override
        public String intermediateReplace(String content, String dim) {
            content = super.intermediateReplace(content, dim);
            content = LONG.intermediateReplace(content, dim + ".bits");
            return content;
        }

        @Override
        public String finalReplace(String content, String dim) {
            content = LONG.finalReplace(content, dim + ".bits");
            content = super.finalReplace(content, dim);
            return content;
        }

        @Override
        public String formatValue(String value) {
            return value + ".0";
        }

        @Override
        String minValue() {
            return "Double.NEGATIVE_INFINITY";
        }

        @Override
        String maxValue() {
            return "Double.POSITIVE_INFINITY";
        }

        @Override
        public PrimitiveType bitsType() {
            return LONG;
        }
    };

    public static final List<PrimitiveType> NUMERIC_TYPES_WITH_SHORT_IDS;
    public static final Map<String, PrimitiveType> UPPER_CASE_NAME_TO_TYPE;
    public final boolean isNumeric;
    public final String className;
    private final String fullyQualifiedClassName;
    final Pattern classNameP;
    public final String standalone;
    final Pattern standaloneP;
    public final IdReplacement neutralIdReplacement;
    public final IdReplacement shortIdReplacement;
    public final IdReplacement longIdReplacement;

    private PrimitiveType(String prim, String className) {
        this(prim, className, prim, true);
    }

    private PrimitiveType(String prim, String className, String lowerId, boolean isNumeric) {
        this.isNumeric = isNumeric;
        this.className = className;
        this.fullyQualifiedClassName = "java.lang." + className;
        this.classNameP = Pattern.compile("(?<![\\w$#.])" + className + "(?![\\w$])");
        this.standalone = prim;
        this.standaloneP = Pattern.compile("(?<![\\w$#])" + prim + "(?![\\w$#])");
        this.neutralIdReplacement = new IdReplacement(lowerId);
        String classNameBasedId = StringUtils.uncapitalize(className);
        List<String> ids = Arrays.asList(prim, lowerId, classNameBasedId);
        String shortestId = Collections.min(ids, StringLengthComparator.INSTANCE);
        this.shortIdReplacement = shortestId.length() < lowerId.length() ? new IdReplacement(shortestId) : this.neutralIdReplacement;
        String longestId = Collections.max(ids, StringLengthComparator.INSTANCE);
        this.longIdReplacement = longestId.length() > lowerId.length() ? new IdReplacement(longestId) : this.neutralIdReplacement;
    }

    String minValue() {
        return this.className + ".MIN_VALUE";
    }

    String maxValue() {
        return this.className + ".MAX_VALUE";
    }

    @Override
    public String defaultValue() {
        if ("Boolean".equals(this.className)) {
            return "false";
        }
        return this.formatValue("0");
    }

    public String formatValue(String value) {
        return String.format("(%s) %s", this.standalone, value);
    }

    public PrimitiveType bitsType() {
        return this;
    }

    @Override
    public String intermediateReplace(String content, String dim) {
        IntermediateOption intermediate = IntermediateOption.of(dim);
        content = content.replace(this.fullyQualifiedClassName, intermediate.className);
        content = this.classNameP.matcher(content).replaceAll(intermediate.className);
        content = this.standaloneP.matcher(content).replaceAll(intermediate.standalone);
        content = PrimitiveType.intermediateReplaceId(content, this.neutralIdReplacement, intermediate.neutralIdVariant);
        if (this.shortIdReplacement != this.neutralIdReplacement) {
            content = PrimitiveType.intermediateReplaceId(content, this.shortIdReplacement, intermediate.shortIdVariant);
        }
        if (this.longIdReplacement != this.neutralIdReplacement) {
            content = PrimitiveType.intermediateReplaceId(content, this.longIdReplacement, intermediate.longIdVariant);
        }
        return content;
    }

    private static String intermediateReplaceId(String content, IdReplacement idReplacement, IntermediateOption.IdVariant idVariant) {
        content = idReplacement.lowerP.matcher(content).replaceAll(idVariant.lower);
        content = idReplacement.titleP.matcher(content).replaceAll(idVariant.title);
        content = idReplacement.upperP.matcher(content).replaceAll(idVariant.upper);
        return content;
    }

    @Override
    public String finalReplace(String content, String dim) {
        IntermediateOption intermediate = IntermediateOption.of(dim);
        content = intermediate.classNameP.matcher(content).replaceAll(this.className);
        content = intermediate.standaloneP.matcher(content).replaceAll(this.standalone);
        content = PrimitiveType.finalReplaceId(content, intermediate.neutralIdVariant, this.neutralIdReplacement);
        content = PrimitiveType.finalReplaceId(content, intermediate.shortIdVariant, this.shortIdReplacement);
        content = PrimitiveType.finalReplaceId(content, intermediate.longIdVariant, this.longIdReplacement);
        return content;
    }

    private static String finalReplaceId(String content, IntermediateOption.IdVariant idVariant, IdReplacement idReplacement) {
        content = idVariant.lowerP.matcher(content).replaceAll(idReplacement.lower);
        content = idVariant.titleP.matcher(content).replaceAll(idReplacement.title);
        content = idVariant.upperP.matcher(content).replaceAll(idReplacement.upper);
        return content;
    }

    public String toString() {
        return this.neutralIdReplacement.title;
    }

    static {
        NUMERIC_TYPES_WITH_SHORT_IDS = Arrays.asList(BYTE, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE);
        UPPER_CASE_NAME_TO_TYPE = new HashMap<String, PrimitiveType>();
        for (PrimitiveType option : PrimitiveType.values()) {
            UPPER_CASE_NAME_TO_TYPE.put(option.name(), option);
        }
    }

    public static class IdReplacement {
        public final String lower;
        final Pattern lowerP;
        public final String title;
        final Pattern titleP;
        public final String upper;
        final Pattern upperP;

        IdReplacement(String lowerId) {
            this.lower = lowerId;
            this.lowerP = Pattern.compile("(?<![A-Za-z])" + lowerId + "(?![a-rt-z].|s[a-z])");
            this.title = StringUtils.capitalize(lowerId);
            this.titleP = Pattern.compile("\\$?" + this.title + "(?![a-rt-z].|s[a-z])");
            this.upper = lowerId.toUpperCase();
            this.upperP = Pattern.compile("(?<![A-Z])" + this.upper + "(?![A-RT-Z].|S[A-Z])");
        }
    }
}

