/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.IntermediateOption;
import io.timeandspace.jpsg.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectType
implements Option {
    private static final Logger log = LoggerFactory.getLogger(ObjectType.class);
    final IdStyle neutralIdStyle;

    static ObjectType get(IdStyle idStyle) {
        return idStyle.typeForThisStyle;
    }

    private ObjectType(IdStyle neutralIdStyle) {
        this.neutralIdStyle = neutralIdStyle;
    }

    @Override
    public String intermediateReplace(String content, String dim) {
        log.info("Object type can't be template source");
        return content;
    }

    private static String genericParamName(String dim) {
        return dim.substring(0, 1).toUpperCase();
    }

    @Override
    public String finalReplace(String content, String dim) {
        IntermediateOption intermediate = IntermediateOption.of(dim);
        String genericParamName = ObjectType.genericParamName(dim);
        content = intermediate.classNameP.matcher(content).replaceAll(genericParamName);
        content = intermediate.standaloneP.matcher(content).replaceAll(genericParamName);
        content = ObjectType.finalReplaceId(content, intermediate.neutralIdVariant, this.neutralIdStyle);
        content = ObjectType.finalReplaceId(content, intermediate.shortIdVariant, IdStyle.OBJ);
        content = ObjectType.finalReplaceId(content, intermediate.longIdVariant, IdStyle.OBJECT);
        return content;
    }

    private static String finalReplaceId(String content, IntermediateOption.IdVariant idVariant, IdStyle idStyle) {
        content = idVariant.lowerP.matcher(content).replaceAll(idStyle.lower);
        content = idVariant.titleP.matcher(content).replaceAll(idStyle.title);
        content = idVariant.upperP.matcher(content).replaceAll(idStyle.upper);
        return content;
    }

    @Override
    public String defaultValue() {
        return "null";
    }

    public String toString() {
        return "Object";
    }

    public static enum IdStyle {
        OBJECT("object", "Object", "OBJECT"),
        OBJ("obj", "Obj", "OBJ");

        final String lower;
        final String title;
        final String upper;
        private final ObjectType typeForThisStyle;

        private IdStyle(String lower, String title, String upper) {
            this.lower = lower;
            this.title = title;
            this.upper = upper;
            this.typeForThisStyle = new ObjectType(this);
        }
    }
}

