/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.Generator;
import io.timeandspace.jpsg.SimpleOption;
import io.timeandspace.jpsg.TemplateProcessor;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.io.FilesKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jdk8FunctionReplacer
extends TemplateProcessor {
    private static final Logger log = LoggerFactory.getLogger(Jdk8FunctionReplacer.class);
    public static final int PRIORITY = -10000;
    private static final SimpleOption JDK8 = new SimpleOption("JDK8");
    private static final List<String> JDK8_INTERFACES = Arrays.asList("BiConsumer", "BiFunction", "BinaryOperator", "BiPredicate", "BooleanSupplier", "Consumer", "DoubleBinaryOperator", "DoubleConsumer", "DoubleFunction", "DoublePredicate", "DoubleSupplier", "DoubleToIntFunction", "DoubleToLongFunction", "DoubleUnaryOperator", "Function", "IntBinaryOperator", "IntConsumer", "IntFunction", "IntPredicate", "IntSupplier", "IntToDoubleFunction", "IntToLongFunction", "IntUnaryOperator", "LongBinaryOperator", "LongConsumer", "LongFunction", "LongPredicate", "LongSupplier", "LongToDoubleFunction", "LongToIntFunction", "LongUnaryOperator", "ObjDoubleConsumer", "ObjIntConsumer", "ObjLongConsumer", "Predicate", "Supplier", "ToDoubleBiFunction", "ToDoubleFunction", "ToIntBiFunction", "ToIntFunction", "ToLongBiFunction", "ToLongFunction", "UnaryOperator");

    @Override
    public int priority() {
        return -10000;
    }

    @Override
    protected void process(StringBuilder sb, Context source, Context target, String template) {
        boolean packageInfo;
        File currentSourceFile = Generator.Companion.currentSourceFile();
        boolean bl = packageInfo = FilesKt.endsWith((File)currentSourceFile, (File)new File("package-info.java")) || currentSourceFile.getName().endsWith("html");
        if (JDK8.equals(target.getOption("jdk")) && (template.trim().endsWith("}") || packageInfo)) {
            template = sb.toString() + template;
            String prefix = packageInfo ? "" : "import ";
            for (String jdk8Interface : JDK8_INTERFACES) {
                template = template.replace(prefix + "com.koloboke.function." + jdk8Interface, prefix + "java.util.function." + jdk8Interface);
            }
            sb.setLength(0);
            sb.append(template);
        } else {
            this.postProcess(sb, source, target, template);
        }
    }
}

