/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.CheckingPattern;
import io.timeandspace.jpsg.Condition;
import io.timeandspace.jpsg.Generator;
import java.util.regex.Pattern;

public class GeneratorConstants {
    static final String COND_START = String.format("if\\s*(?<condition>%s)", Condition.CONDITION);
    static final Pattern COND_START_BLOCK_P = Generator.wrapBlock(COND_START);
    static final CheckingPattern COND_START_P = Generator.compileBlock(COND_START, "if");
    static final String COND_END = "endif";
    static final CheckingPattern COND_END_P = Generator.compileBlock("endif", "endif");
    static final String COND_PART = String.format("((el)?if\\s*(?<condition>%s)|%s)", Condition.CONDITION, "endif");
    static final Pattern COND_PART_BLOCK_P = Generator.wrapBlock(COND_PART);
    static final CheckingPattern COND_PART_P = Generator.compileBlock(COND_PART, "(el|end)?if");
    static final String CONTEXT_START = String.format("with%s", "(?<dimensions>(\\s*(?<options>([\\w]+)((\\|[\\w]+)+)?)\\s+(?<dim>\\w+)\\s*)+)");
    static final Pattern CONTEXT_START_BLOCK_P = Generator.wrapBlock(CONTEXT_START);
    static final CheckingPattern CONTEXT_START_P = Generator.compileBlock(CONTEXT_START, "with");
    static final String CONTEXT_END = "endwith";
    static final CheckingPattern CONTEXT_END_P = Generator.compileBlock("endwith", "endwith");
    static final String CONTEXT_PART = String.format("(%s|%s)", CONTEXT_START, "endwith");
    static final CheckingPattern CONTEXT_PART_P = Generator.compileBlock(CONTEXT_PART, "(end)?with");
    static final String ANY_BLOCK_PART = String.format("(%s|%s)", COND_PART, CONTEXT_PART);
    static final CheckingPattern ANY_BLOCK_PART_P = Generator.compileBlock(ANY_BLOCK_PART, "((el|end)?if|(end)?with)");
}

