/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.AAnProcessor;
import io.timeandspace.jpsg.BitsModifierPostProcessor;
import io.timeandspace.jpsg.BitsModifierPreProcessor;
import io.timeandspace.jpsg.CheckingMatcher;
import io.timeandspace.jpsg.CheckingPattern;
import io.timeandspace.jpsg.Condition;
import io.timeandspace.jpsg.ConstProcessor;
import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.DefinitionProcessor;
import io.timeandspace.jpsg.Dimensions;
import io.timeandspace.jpsg.FloatingWrappingProcessor;
import io.timeandspace.jpsg.Generator;
import io.timeandspace.jpsg.GeneratorConstants;
import io.timeandspace.jpsg.GenericsProcessor;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.OptionProcessor;
import io.timeandspace.jpsg.OverviewProcessor;
import io.timeandspace.jpsg.PrimitiveType;
import io.timeandspace.jpsg.PrimitiveTypeModifierPostProcessor;
import io.timeandspace.jpsg.PrimitiveTypeModifierPreProcessor;
import io.timeandspace.jpsg.PrintProcessor;
import io.timeandspace.jpsg.RawModifierProcessor;
import io.timeandspace.jpsg.RegexpUtils;
import io.timeandspace.jpsg.SimpleOption;
import io.timeandspace.jpsg.TemplateProcessor;
import io.timeandspace.jpsg.concurrent.ForkJoinTaskShim;
import io.timeandspace.jpsg.concurrent.ForkJoinTasks;
import io.timeandspace.jpsg.function.Predicate;
import io.timeandspace.jpsg.function.UnaryOperator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u001a\u0018\u0000 P2\u00020\u0001:\u0003OPQB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0010J\u0016\u0010)\u001a\u00020\u00002\u000e\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100,J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0015J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001bH\u0002J\u001f\u00104\u001a\u00020\u00002\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001506\"\u00020\u0015\u00a2\u0006\u0002\u00107J\u0014\u00104\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001508J\u0014\u00109\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001508J\u0006\u0010:\u001a\u000201J\u001e\u0010:\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0015J\u0006\u0010<\u001a\u00020\u001bJ\u0006\u0010=\u001a\u00020\u001bJ\u001f\u0010>\u001a\u00020\u00002\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001506\"\u00020\u0015\u00a2\u0006\u0002\u00107J\u0014\u0010>\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001508J\u0014\u0010?\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001508J\u0006\u0010@\u001a\u000201J\b\u0010A\u001a\u000201H\u0002J\u001f\u0010\u0014\u001a\u00020\u00002\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001506\"\u00020\u0015\u00a2\u0006\u0002\u00107J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001508J\u0018\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u001bH\u0002J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0015J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010G\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0015J\u001f\u0010!\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001506\"\u00020\u0015\u00a2\u0006\u0002\u00107J\u0014\u0010!\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u001508J\u0014\u0010H\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u001508J\u001d\u0010I\u001a\u0002012\u0006\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bLJ\u0014\u0010M\u001a\u00020\u0017*\u00020\t2\u0006\u0010N\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lio/timeandspace/jpsg/Generator;", "", "()V", "defaultContext", "Lio/timeandspace/jpsg/Context;", "defaultTypes", "", "Lio/timeandspace/jpsg/Option;", "dimensionsParser", "Lio/timeandspace/jpsg/Dimensions$Parser;", "excluded", "Ljava/util/ArrayList;", "Lio/timeandspace/jpsg/Generator$UnparsedDimensions;", "excludedTypes", "", "firstProcessor", "Lio/timeandspace/jpsg/TemplateProcessor;", "included", "isInit", "", "never", "", "permissiveConditions", "Lio/timeandspace/jpsg/Dimensions;", "processors", "prohibitingConditions", "source", "Ljava/io/File;", "target", "getTarget$core", "()Ljava/io/File;", "setTarget$core", "(Ljava/io/File;)V", "with", "addPrimitiveTypeModifierProcessors", "keyword", "typeMapper", "Lio/timeandspace/jpsg/function/UnaryOperator;", "Lio/timeandspace/jpsg/PrimitiveType;", "dimFilter", "Lio/timeandspace/jpsg/function/Predicate;", "addProcessor", "processor", "processorClass", "Ljava/lang/Class;", "processorClassName", "checkContext", "checkPermissive", "doGenerate", "", "sourceFile", "targetDir", "exclude", "conditions", "", "([Ljava/lang/String;)Lio/timeandspace/jpsg/Generator;", "", "excludeCLI", "generate", "template", "getSource", "getTarget", "include", "includeCLI", "init", "initProcessors", "options", "parseAndCheckExplicitContext", "explicitContext", "setDefaultTypes", "setSource", "setTarget", "withCLI", "writeFile", "file", "content", "writeFile$core", "parse", "unparsedDimensions", "BlocksProcessor", "Companion", "UnparsedDimensions", "core"})
public final class Generator {
    private boolean isInit;
    private File source;
    @Nullable
    private File target;
    private List<Option> defaultTypes = new ArrayList(PrimitiveType.NUMERIC_TYPES_WITH_SHORT_IDS);
    private Dimensions.Parser dimensionsParser;
    private final List<TemplateProcessor> processors = CollectionsKt.mutableListOf((Object[])new TemplateProcessor[]{new OptionProcessor(), new ConstProcessor(), new BlocksProcessor(), new GenericsProcessor(), new DefinitionProcessor(), new FloatingWrappingProcessor(), new RawModifierProcessor(), new BitsModifierPreProcessor(), new BitsModifierPostProcessor(), new AAnProcessor(), new OverviewProcessor(), new PrintProcessor()});
    private final ArrayList<UnparsedDimensions> with = new ArrayList();
    private Context defaultContext;
    private final ArrayList<String> never = new ArrayList();
    private List<? extends Option> excludedTypes;
    private final ArrayList<UnparsedDimensions> included = new ArrayList();
    private List<Dimensions> permissiveConditions;
    private final ArrayList<UnparsedDimensions> excluded = new ArrayList();
    private List<Dimensions> prohibitingConditions;
    private TemplateProcessor firstProcessor;
    private static final Logger log;
    private static final Dimensions.Parser checkingDimensionsParser;
    private static final ThreadLocal<File> currentSource;
    private static final ThreadLocal<Generator> currentGenerator;
    private static final ThreadLocal<String> redefinedClassName;
    public static final int BLOCKS_PROCESSOR_PRIORITY = 100;
    public static final Companion Companion;

    @Nullable
    public final File getTarget$core() {
        return this.target;
    }

    public final void setTarget$core(@Nullable File file) {
        this.target = file;
    }

    private final Dimensions parse(@NotNull Dimensions.Parser $this$parse, UnparsedDimensions unparsedDimensions) {
        return (Dimensions)unparsedDimensions.getParse().invoke((Object)$this$parse, (Object)unparsedDimensions.getDimensions());
    }

    @NotNull
    public final Generator setDefaultTypes(@NotNull String defaultTypes) {
        Intrinsics.checkParameterIsNotNull((Object)defaultTypes, (String)"defaultTypes");
        ArrayList defaultTypes2 = new ArrayList(Dimensions.Parser.Companion.parseOptions$core(defaultTypes));
        for (Option option : defaultTypes2) {
            if (!(option instanceof SimpleOption)) continue;
            throw (Throwable)new IllegalArgumentException("Simple options like " + option + " are not allowed in defaultTypes configuration");
        }
        this.defaultTypes = defaultTypes2;
        return this;
    }

    @NotNull
    public final Generator withCLI(@NotNull Iterable<String> defaultContext) {
        Intrinsics.checkParameterIsNotNull(defaultContext, (String)"defaultContext");
        for (String cxt : defaultContext) {
            this.with.add(new UnparsedDimensions(cxt, (Function2<? super Dimensions.Parser, ? super String, Dimensions>)((Function2)withCLI.1.INSTANCE)));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Generator with(@NotNull Iterable<String> defaultContext) {
        Intrinsics.checkParameterIsNotNull(defaultContext, (String)"defaultContext");
        for (String cxt : defaultContext) {
            Dimensions withDimensions = checkingDimensionsParser.parseForContext(cxt);
            Object object = withDimensions.getDimensions$core();
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void dim;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                List options = (List)entry2.getValue();
                if (options.size() <= 1) continue;
                throw (Throwable)new IllegalArgumentException("with() accepts only dimensions with a single option, " + (String)dim + " has " + options);
            }
            this.with.add(new UnparsedDimensions(cxt, (Function2<? super Dimensions.Parser, ? super String, Dimensions>)((Function2)with.1.INSTANCE)));
        }
        return this;
    }

    @NotNull
    public final Generator with(String ... defaultContext) {
        Intrinsics.checkParameterIsNotNull((Object)defaultContext, (String)"defaultContext");
        List<String> list = Arrays.asList(Arrays.copyOf(defaultContext, defaultContext.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*defaultContext)");
        return this.with((Iterable<String>)list);
    }

    @NotNull
    public final Generator addProcessor(@NotNull TemplateProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        this.processors.add(processor);
        return this;
    }

    @NotNull
    public final Generator addPrimitiveTypeModifierProcessors(@NotNull String keyword, @NotNull UnaryOperator<PrimitiveType> typeMapper, @NotNull Predicate<String> dimFilter) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
        Intrinsics.checkParameterIsNotNull(typeMapper, (String)"typeMapper");
        Intrinsics.checkParameterIsNotNull(dimFilter, (String)"dimFilter");
        this.addProcessor(new PrimitiveTypeModifierPreProcessor(keyword, typeMapper, dimFilter));
        this.addProcessor(new PrimitiveTypeModifierPostProcessor(keyword, typeMapper, dimFilter));
        return this;
    }

    @NotNull
    public final Generator addProcessor(@NotNull Class<? extends TemplateProcessor> processorClass) {
        Intrinsics.checkParameterIsNotNull(processorClass, (String)"processorClass");
        try {
            TemplateProcessor templateProcessor = processorClass.newInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)templateProcessor, (String)"processorClass.newInstance()");
            return this.addProcessor(templateProcessor);
        }
        catch (InstantiationException e) {
            throw (Throwable)new IllegalArgumentException(processorClass + " template processor class should have public no-arg constructor");
        }
        catch (IllegalAccessException e) {
            throw (Throwable)new IllegalArgumentException(processorClass + " template processor class should have public no-arg constructor");
        }
    }

    @NotNull
    public final Generator addProcessor(@NotNull String processorClassName) {
        Intrinsics.checkParameterIsNotNull((Object)processorClassName, (String)"processorClassName");
        try {
            Class<?> clazz = Class.forName(processorClassName);
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out io.timeandspace.jpsg.TemplateProcessor>");
            }
            return this.addProcessor(clazz);
        }
        catch (ClassNotFoundException e) {
            throw (Throwable)new IllegalArgumentException("Template processor class with " + processorClassName + " name is not found");
        }
    }

    @NotNull
    public final Generator never(@NotNull Iterable<String> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        for (String opts : options) {
            this.never.add(opts);
        }
        return this;
    }

    @NotNull
    public final Generator never(String ... options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        List<String> list = Arrays.asList(Arrays.copyOf(options, options.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*options)");
        return this.never((Iterable<String>)list);
    }

    @NotNull
    public final Generator includeCLI(@NotNull Iterable<String> conditions) {
        Intrinsics.checkParameterIsNotNull(conditions, (String)"conditions");
        for (String condition : conditions) {
            this.included.add(new UnparsedDimensions(condition, (Function2<? super Dimensions.Parser, ? super String, Dimensions>)((Function2)includeCLI.1.INSTANCE)));
        }
        return this;
    }

    @NotNull
    public final Generator include(@NotNull Iterable<String> conditions) {
        Intrinsics.checkParameterIsNotNull(conditions, (String)"conditions");
        for (String condition : conditions) {
            this.included.add(new UnparsedDimensions(condition, (Function2<? super Dimensions.Parser, ? super String, Dimensions>)((Function2)include.1.INSTANCE)));
        }
        return this;
    }

    @NotNull
    public final Generator include(String ... conditions) {
        Intrinsics.checkParameterIsNotNull((Object)conditions, (String)"conditions");
        List<String> list = Arrays.asList(Arrays.copyOf(conditions, conditions.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*conditions)");
        return this.include((Iterable<String>)list);
    }

    @NotNull
    public final Generator excludeCLI(@NotNull Iterable<String> conditions) {
        Intrinsics.checkParameterIsNotNull(conditions, (String)"conditions");
        for (String condition : conditions) {
            this.excluded.add(new UnparsedDimensions(condition, (Function2<? super Dimensions.Parser, ? super String, Dimensions>)((Function2)excludeCLI.1.INSTANCE)));
        }
        return this;
    }

    @NotNull
    public final Generator exclude(@NotNull Iterable<String> conditions) {
        Intrinsics.checkParameterIsNotNull(conditions, (String)"conditions");
        for (String condition : conditions) {
            this.excluded.add(new UnparsedDimensions(condition, (Function2<? super Dimensions.Parser, ? super String, Dimensions>)((Function2)exclude.1.INSTANCE)));
        }
        return this;
    }

    @NotNull
    public final Generator exclude(String ... conditions) {
        Intrinsics.checkParameterIsNotNull((Object)conditions, (String)"conditions");
        List<String> list = Arrays.asList(Arrays.copyOf(conditions, conditions.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*conditions)");
        return this.exclude((Iterable<String>)list);
    }

    @NotNull
    public final Generator setSource(@NotNull File source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        return this;
    }

    @NotNull
    public final Generator setSource(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = new File(source);
        return this;
    }

    @NotNull
    public final File getSource() {
        File file = this.source;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        return file;
    }

    @NotNull
    public final Generator setTarget(@NotNull File target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        return this;
    }

    @NotNull
    public final Generator setTarget(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = new File(target);
        return this;
    }

    @NotNull
    public final File getTarget() {
        File file = this.target;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        return file;
    }

    public final void generate() throws IOException {
        log.debug("Generator source: {}", (Object)this.source);
        log.debug("Generator target: {}", (Object)this.target);
        File file = this.source;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        if (!file.exists()) {
            return;
        }
        File file2 = this.target;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        if (!file2.exists()) {
            File file3 = this.target;
            if (file3 == null) {
                Intrinsics.throwNpe();
            }
            file3.mkdirs();
        } else {
            File file4 = this.target;
            if (file4 == null) {
                Intrinsics.throwNpe();
            }
            if (!file4.isDirectory()) {
                log.error("Target {} should be a dir", (Object)this.target);
                throw (Throwable)new IllegalArgumentException(this.target + " generation destination should be a dir");
            }
        }
        this.init();
        File file5 = this.source;
        if (file5 == null) {
            Intrinsics.throwNpe();
        }
        if (file5.isDirectory()) {
            File file6 = this.source;
            if (file6 == null) {
                Intrinsics.throwNpe();
            }
            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"io/timeandspace/jpsg/Generator$generate$DirGeneration", "Ljava/util/concurrent/Callable;", "", "dir", "Ljava/io/File;", "(Lio/timeandspace/jpsg/Generator;Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "call", "core"})
            public final class DirGeneration
            implements Callable<Unit> {
                @NotNull
                private final File dir;
                final /* synthetic */ Generator this$0;

                public void call() {
                    try {
                        ArrayList<ForkJoinTaskShim<V>> subTasks;
                        block10: {
                            subTasks = new ArrayList<ForkJoinTaskShim<V>>();
                            File file = this.this$0.getTarget$core();
                            if (file == null) {
                                Intrinsics.throwNpe();
                            }
                            File file2 = Generator.access$getSource$p(this.this$0);
                            if (file2 == null) {
                                Intrinsics.throwNpe();
                            }
                            File targetDir = FilesKt.resolve((File)file, (File)FilesKt.relativeTo((File)this.dir, (File)file2));
                            try {
                                FilesKt.copyTo$default((File)this.dir, (File)targetDir, (boolean)false, (int)0, (int)6, null);
                            }
                            catch (IOException e) {
                                if (targetDir.isDirectory()) break block10;
                                throw (Throwable)e;
                            }
                        }
                        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.dir).onEnter((Function1)new Function1<File, Boolean>(this, subTasks){
                            final /* synthetic */ DirGeneration this$0;
                            final /* synthetic */ ArrayList $subTasks;

                            public final boolean invoke(@NotNull File d) {
                                boolean bl;
                                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                                if (Intrinsics.areEqual((Object)this.this$0.getDir(), (Object)d) ^ true) {
                                    this.$subTasks.add(ForkJoinTasks.Companion.adapt(new DirGeneration(this.this$0.this$0, d)));
                                    bl = false;
                                } else {
                                    bl = true;
                                }
                                return bl;
                            }
                            {
                                this.this$0 = dirGeneration;
                                this.$subTasks = arrayList;
                                super(1);
                            }
                        })), (Function1)generate.DirGeneration.call.2.INSTANCE);
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            File f = (File)element$iv;
                            boolean bl = false;
                            File file = this.this$0.getTarget$core();
                            if (file == null) {
                                Intrinsics.throwNpe();
                            }
                            File file3 = Generator.access$getSource$p(this.this$0);
                            if (file3 == null) {
                                Intrinsics.throwNpe();
                            }
                            File targetFile = FilesKt.resolve((File)file, (File)FilesKt.relativeTo((File)f, (File)file3));
                            if (f.lastModified() < targetFile.lastModified()) {
                                Generator.access$getLog$cp().info("File {} is up to date, not processing source", (Object)targetFile);
                            }
                            subTasks.add(ForkJoinTasks.Companion.adapt((Callable)new Callable<Unit>(f, targetFile, this, subTasks){
                                final /* synthetic */ File $f;
                                final /* synthetic */ File $targetFile;
                                final /* synthetic */ DirGeneration this$0;
                                final /* synthetic */ ArrayList $subTasks$inlined;
                                {
                                    this.$f = file;
                                    this.$targetFile = file2;
                                    this.this$0 = dirGeneration;
                                    this.$subTasks$inlined = arrayList;
                                }

                                public final void call() {
                                    Generator.access$doGenerate(this.this$0.this$0, this.$f, new File(this.$targetFile.getParent()));
                                }
                            }));
                        }
                        ForkJoinTasks.Companion.invokeAll((Iterable)subTasks);
                    }
                    catch (IOException e) {
                        throw (Throwable)new RuntimeException(e);
                    }
                }

                @NotNull
                public final File getDir() {
                    return this.dir;
                }

                public DirGeneration(@NotNull Generator $outer, File dir) {
                    Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                    this.this$0 = $outer;
                    this.dir = dir;
                }
            }
            ForkJoinTasks.Companion.adapt(new DirGeneration(this, file6)).forkAndGet();
        } else {
            ForkJoinTasks.Companion.adapt((Callable)new Callable<Unit>(this){
                final /* synthetic */ Generator this$0;

                public final void call() {
                    File file = Generator.access$getSource$p(this.this$0);
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    File file2 = this.this$0.getTarget$core();
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Generator.access$doGenerate(this.this$0, file, file2);
                }
                {
                    this.this$0 = generator;
                }
            }).forkAndGet();
        }
    }

    public final synchronized void init() {
        Dimensions dimensions;
        UnparsedDimensions it;
        Iterable $this$mapTo$iv$iv;
        Object list$iv$iv;
        boolean bl;
        Iterable $this$flatMapTo$iv$iv;
        List<Context> contexts;
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.dimensionsParser = new Dimensions.Parser(this.defaultTypes);
        this.defaultContext = new Context.Builder().makeContext();
        for (UnparsedDimensions unparsedDimensions : this.with) {
            Dimensions.Parser parser = this.dimensionsParser;
            if (parser == null) {
                Intrinsics.throwNpe();
            }
            UnparsedDimensions unparsedDimensions2 = unparsedDimensions;
            Intrinsics.checkExpressionValueIsNotNull((Object)unparsedDimensions2, (String)"context");
            contexts = this.parse(parser, unparsedDimensions2).generateContexts();
            if (contexts.size() > 1) {
                throw (Throwable)new IllegalArgumentException("Default context should have only trivial dimensions");
            }
            Context context = this.defaultContext;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            this.defaultContext = context.join(contexts.get(0));
        }
        List<Context> list = (List<Context>)this.never;
        Generator generator = this;
        boolean $i$f$flatMap = false;
        contexts = list;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String options = (String)element$iv$iv;
            bl = false;
            list$iv$iv = Dimensions.Parser.Companion.parseOptions$core(options);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection<Dimensions> collection = (List)destination$iv$iv;
        generator.excludedTypes = CollectionsKt.toList((Iterable)collection);
        Iterable iterable = this.included;
        generator = this;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = iterable;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (UnparsedDimensions)item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            Dimensions.Parser parser = this.dimensionsParser;
            if (parser == null) {
                Intrinsics.throwNpe();
            }
            dimensions = this.parse(parser, it);
            collection.add(dimensions);
        }
        collection = (List)destination$iv$iv;
        generator.permissiveConditions = CollectionsKt.toList((Iterable)collection);
        Iterable iterable2 = this.excluded;
        generator = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = iterable2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UnparsedDimensions)item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            Dimensions.Parser parser = this.dimensionsParser;
            if (parser == null) {
                Intrinsics.throwNpe();
            }
            dimensions = this.parse(parser, it);
            collection.add(dimensions);
        }
        collection = (List)destination$iv$iv;
        generator.prohibitingConditions = CollectionsKt.toList((Iterable)collection);
        this.initProcessors();
    }

    private final void initProcessors() {
        List<TemplateProcessor> list = this.processors;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TemplateProcessor p1 = (TemplateProcessor)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(p1.priority());
                p1 = (TemplateProcessor)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = p1.priority();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        CollectionsKt.sortWith(list, (Comparator)comparator);
        TemplateProcessor prev = null;
        for (TemplateProcessor processor : this.processors) {
            processor.setDimensionsParser(this.dimensionsParser);
            processor.setNext(prev);
            prev = processor;
        }
        this.firstProcessor = this.processors.get(this.processors.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final void doGenerate(File sourceFile, File targetDir) throws IOException {
        int endIndex$iv$iv;
        int startIndex$iv$iv;
        String string;
        StringBuilder stringBuilder;
        Generator.Companion.setCurrentGenerator(this);
        Companion.setCurrentSourceFile(sourceFile);
        log.info("Processing file: {}", (Object)sourceFile);
        String sourceFileName = sourceFile.getName();
        Dimensions.Parser parser = this.dimensionsParser;
        if (parser == null) {
            Intrinsics.throwNpe();
        }
        String string2 = sourceFileName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceFileName");
        Dimensions targetDims = parser.parseClassName$core(string2);
        String rawContent = FilesKt.readText$default((File)sourceFile, null, (int)1, null);
        CheckingMatcher fileDimsM = GeneratorConstants.CONTEXT_START_P.matcher(rawContent);
        if (fileDimsM.find() && fileDimsM.start() == 0) {
            void $this$trim$iv;
            String explicitContext = fileDimsM.group();
            targetDims = this.parseAndCheckExplicitContext(explicitContext, sourceFile);
            String string3 = rawContent;
            int n = fileDimsM.end();
            stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string = string5;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            rawContent = stringBuilder.append(string).append("\n").toString();
        }
        log.info("Target dimensions: {}", (Object)targetDims);
        List<Context> targetContexts = targetDims.generateContexts();
        Context context = this.defaultContext;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        Context mainContext = context.join(targetContexts.get(0));
        CheckingMatcher fileCondM = GeneratorConstants.COND_START_P.matcher(rawContent);
        Condition fileCond = null;
        if (fileCondM.find() && fileCondM.start() == 0) {
            void $this$trim$iv;
            String string6 = fileCondM.group();
            Pattern pattern = GeneratorConstants.COND_START_BLOCK_P;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"COND_START_BLOCK_P");
            String string7 = Generator.Companion.getBlockGroup(string6, pattern, "condition");
            Dimensions.Parser parser2 = this.dimensionsParser;
            if (parser2 == null) {
                Intrinsics.throwNpe();
            }
            fileCond = Condition.parseCheckedCondition(string7, parser2, mainContext, rawContent, fileCondM.start());
            String $i$f$trim2 = rawContent;
            startIndex$iv$iv = fileCondM.end();
            stringBuilder = new StringBuilder();
            endIndex$iv$iv = 0;
            String string8 = $i$f$trim2;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(startIndex$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            $i$f$trim2 = string = string9;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl4 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            rawContent = stringBuilder.append(string).append("\n").toString();
        }
        String content = rawContent;
        ArrayList contextGenerationTasks = new ArrayList();
        for (Context tc : targetContexts) {
            void generatedFile;
            void generatedFileName;
            if (!this.checkContext(tc)) {
                log.debug("Context filtered by generator: {}", (Object)tc);
                continue;
            }
            Context context2 = this.defaultContext;
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            Context target = context2.join(tc);
            if (fileCond != null && !fileCond.check(target)) {
                log.debug("Context filtered by file condition: {}", (Object)target);
                continue;
            }
            Ref.ObjectRef endIndex$iv$iv2 = new Ref.ObjectRef();
            Context context3 = mainContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"mainContext");
            Context context4 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"target");
            endIndex$iv$iv2.element = this.generate(context3, context4, sourceFileName);
            Ref.ObjectRef startFound$iv$iv = new Ref.ObjectRef();
            startFound$iv$iv.element = FilesKt.resolve((File)targetDir, (String)((String)generatedFileName.element));
            contextGenerationTasks.add(ForkJoinTasks.Companion.adapt((Callable)new Callable<Unit>(this, sourceFile, mainContext, target, content, (Ref.ObjectRef)generatedFileName, (Ref.ObjectRef)generatedFile, targetDir, sourceFileName){
                final /* synthetic */ Generator this$0;
                final /* synthetic */ File $sourceFile;
                final /* synthetic */ Context $mainContext;
                final /* synthetic */ Context $target;
                final /* synthetic */ String $content;
                final /* synthetic */ Ref.ObjectRef $generatedFileName;
                final /* synthetic */ Ref.ObjectRef $generatedFile;
                final /* synthetic */ File $targetDir;
                final /* synthetic */ String $sourceFileName;

                public final void call() {
                    io.timeandspace.jpsg.Generator$Companion.access$setCurrentGenerator(Generator.Companion, this.this$0);
                    Generator.Companion.setCurrentSourceFile(this.$sourceFile);
                    Generator.Companion.setRedefinedClassName(null);
                    Context context = this.$mainContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mainContext");
                    Context context2 = this.$target;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"target");
                    String generatedContent = this.this$0.generate(context, context2, this.$content);
                    String redefinedClassName = io.timeandspace.jpsg.Generator$Companion.access$getRedefinedClassName(Generator.Companion);
                    String generatedClassName = StringsKt.substringAfterLast$default((String)StringsKt.removeSuffix((String)((String)this.$generatedFileName.element), (CharSequence)".java"), (char)'.', null, (int)2, null);
                    if (redefinedClassName != null && Intrinsics.areEqual((Object)generatedClassName, (Object)redefinedClassName) ^ true) {
                        Generator.access$getLog$cp().info("Class name redefined: {} -> {}", (Object)generatedClassName, (Object)redefinedClassName);
                        this.$generatedFileName.element = StringsKt.replace$default((String)((String)this.$generatedFileName.element), (String)generatedClassName, (String)redefinedClassName, (boolean)false, (int)4, null);
                        this.$generatedFile.element = FilesKt.resolve((File)this.$targetDir, (String)((String)this.$generatedFileName.element));
                    }
                    if (((File)this.$generatedFile.element).exists()) {
                        if (((File)this.$generatedFile.element).isDirectory()) {
                            throw (Throwable)new IllegalStateException((String)this.$generatedFileName.element + " in " + this.$targetDir + " is a directory, " + this.$mainContext + ", " + this.$target + ", " + this.$sourceFileName);
                        }
                        String targetContent = FilesKt.readText$default((File)((File)this.$generatedFile.element), null, (int)1, null);
                        if (Intrinsics.areEqual((Object)generatedContent, (Object)targetContent)) {
                            Generator.access$getLog$cp().warn("Already generated: {}", (Object)((String)this.$generatedFileName.element));
                            return;
                        }
                    }
                    this.this$0.writeFile$core((File)this.$generatedFile.element, generatedContent);
                    Generator.access$getLog$cp().info("Wrote: {}", (Object)((String)this.$generatedFileName.element));
                }
                {
                    this.this$0 = generator;
                    this.$sourceFile = file;
                    this.$mainContext = context;
                    this.$target = context2;
                    this.$content = string;
                    this.$generatedFileName = objectRef;
                    this.$generatedFile = objectRef2;
                    this.$targetDir = file2;
                    this.$sourceFileName = string2;
                }
            }));
        }
        ForkJoinTasks.Companion.invokeAll(contextGenerationTasks);
    }

    /*
     * WARNING - void declaration
     */
    private final Dimensions parseAndCheckExplicitContext(String explicitContext, File sourceFile) {
        Dimensions.Parser parser = this.dimensionsParser;
        if (parser == null) {
            Intrinsics.throwNpe();
        }
        Pattern pattern = GeneratorConstants.CONTEXT_START_BLOCK_P;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"CONTEXT_START_BLOCK_P");
        Dimensions targetDims = parser.parseForContext(Generator.Companion.getBlockGroup(explicitContext, pattern, "dimensions"));
        Context mainExplicitContext = targetDims.generateContexts().get(0);
        Iterator<Map.Entry<String, Option>> iterator = mainExplicitContext.iterator();
        while (iterator.hasNext()) {
            void dim;
            Map.Entry<String, Option> entry;
            Map.Entry<String, Option> entry2 = entry = iterator.next();
            boolean bl = false;
            String string = entry2.getKey();
            entry2 = entry;
            bl = false;
            Option option = entry2.getValue();
            if (Context.stringIncludesOption(sourceFile.getName(), option)) continue;
            throw (Throwable)new RuntimeException("Dimension " + (String)dim + " with options " + targetDims.getDimensions$core().get(dim) + " specified " + "explicitly in " + sourceFile + " is not found in the file name");
        }
        return targetDims;
    }

    public final void writeFile$core(@NotNull File file, @NotNull String content) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        FilesKt.writeText$default((File)file, (String)content, null, (int)2, null);
    }

    @NotNull
    public final String generate(@NotNull Context source, @NotNull Context target, @NotNull String template) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        TemplateProcessor templateProcessor = this.firstProcessor;
        if (templateProcessor == null) {
            Intrinsics.throwNpe();
        }
        String string = templateProcessor.generate(source, target, template);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"firstProcessor!!.generat\u2026source, target, template)");
        return string;
    }

    private final boolean checkContext(Context target) {
        Object object2;
        for (Object object2 : target) {
            Map.Entry<String, Option> entry = object2;
            boolean bl = false;
            Option option = entry.getValue();
            List<? extends Option> list = this.excludedTypes;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (!list.contains(option)) continue;
            return false;
        }
        if (!this.checkPermissive(target)) {
            return false;
        }
        List<Dimensions> list = this.prohibitingConditions;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        object2 = list;
        boolean bl = false;
        if (!object2.isEmpty()) {
            List<Dimensions> list2 = this.prohibitingConditions;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            for (Dimensions prohibitingCondition : list2) {
                if (!prohibitingCondition.checkAsCondition(target)) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean checkPermissive(Context target) {
        List<Dimensions> list = this.permissiveConditions;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            List<Dimensions> list2 = this.permissiveConditions;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            for (Dimensions permissiveCondition : list2) {
                if (!permissiveCondition.checkAsCondition(target)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(Generator.class);
        checkingDimensionsParser = new Dimensions.Parser(CollectionsKt.emptyList());
        currentSource = new ThreadLocal();
        currentGenerator = new ThreadLocal();
        redefinedClassName = new ThreadLocal();
    }

    public static final /* synthetic */ File access$getSource$p(Generator $this) {
        return $this.source;
    }

    public static final /* synthetic */ void access$setSource$p(Generator $this, File file) {
        $this.source = file;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$doGenerate(Generator $this, File sourceFile, File targetDir) {
        $this.doGenerate(sourceFile, targetDir);
    }

    @JvmStatic
    @Nullable
    public static final File currentSourceFile() {
        return Companion.currentSourceFile();
    }

    @JvmStatic
    @NotNull
    public static final Generator currentGenerator() {
        return Companion.currentGenerator();
    }

    @JvmStatic
    public static final void setRedefinedClassName(@Nullable String className) {
        Companion.setRedefinedClassName(className);
    }

    @JvmStatic
    @NotNull
    public static final CheckingPattern compileBlock(@NotNull String insideBlockRegex, @NotNull String keyword) {
        return Companion.compileBlock(insideBlockRegex, keyword);
    }

    @JvmStatic
    @NotNull
    public static final Pattern wrapBlock(@NotNull String insideBlockRegex) {
        return Companion.wrapBlock(insideBlockRegex);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/timeandspace/jpsg/Generator$UnparsedDimensions;", "", "dimensions", "", "parse", "Lkotlin/Function2;", "Lio/timeandspace/jpsg/Dimensions$Parser;", "Lio/timeandspace/jpsg/Dimensions;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getDimensions", "()Ljava/lang/String;", "getParse", "()Lkotlin/jvm/functions/Function2;", "core"})
    private static final class UnparsedDimensions {
        @NotNull
        private final String dimensions;
        @NotNull
        private final Function2<Dimensions.Parser, String, Dimensions> parse;

        @NotNull
        public final String getDimensions() {
            return this.dimensions;
        }

        @NotNull
        public final Function2<Dimensions.Parser, String, Dimensions> getParse() {
            return this.parse;
        }

        public UnparsedDimensions(@NotNull String dimensions, @NotNull Function2<? super Dimensions.Parser, ? super String, Dimensions> parse) {
            Intrinsics.checkParameterIsNotNull((Object)dimensions, (String)"dimensions");
            Intrinsics.checkParameterIsNotNull(parse, (String)"parse");
            this.dimensions = dimensions;
            this.parse = parse;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J,\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lio/timeandspace/jpsg/Generator$BlocksProcessor;", "Lio/timeandspace/jpsg/TemplateProcessor;", "(Lio/timeandspace/jpsg/Generator;)V", "priority", "", "process", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "source", "Lio/timeandspace/jpsg/Context;", "target", "template", "", "core"})
    public final class BlocksProcessor
    extends TemplateProcessor {
        @Override
        protected int priority() {
            return 100;
        }

        @Override
        protected void process(@NotNull StringBuilder sb, @NotNull Context source, @NotNull Context target, @NotNull String template) {
            Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
            CheckingMatcher blockStartMatcher = GeneratorConstants.ANY_BLOCK_PART_P.matcher(template);
            int prevBlockEndPos = 0;
            block0: while (blockStartMatcher.find()) {
                String linearBlock;
                int blockDefPos = blockStartMatcher.start();
                String string = template;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(prevBlockEndPos, blockDefPos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.postProcess(sb, source, target, linearBlock);
                String blockStart = blockStartMatcher.group();
                CheckingMatcher condM = GeneratorConstants.COND_START_P.matcher(blockStart);
                if (condM.matches()) {
                    String string2 = condM.group();
                    Pattern pattern = GeneratorConstants.COND_PART_BLOCK_P;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"COND_PART_BLOCK_P");
                    String string3 = Companion.getBlockGroup(string2, pattern, "condition");
                    Dimensions.Parser parser = this.getDimensionsParser();
                    if (parser == null) {
                        Intrinsics.throwNpe();
                    }
                    Condition prevBranchCond = Condition.parseCheckedCondition(string3, parser, source, template, blockStartMatcher.start());
                    int branchStartPos = blockStartMatcher.end();
                    int nest = 0;
                    condM = GeneratorConstants.COND_PART_P.matcher(template);
                    condM.region(branchStartPos, template.length());
                    while (condM.find()) {
                        String condPart = condM.group();
                        if (GeneratorConstants.COND_START_P.matcher(condPart).matches()) {
                            ++nest;
                            continue;
                        }
                        if (nest != 0) {
                            if (!GeneratorConstants.COND_END_P.matcher(condPart).matches()) continue;
                            --nest;
                            continue;
                        }
                        if (prevBranchCond.check(target)) {
                            String block;
                            int branchEndPos = condM.start();
                            String string4 = template;
                            boolean bl2 = false;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(branchStartPos, branchEndPos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            this.process(sb, source, target, block);
                            if (GeneratorConstants.COND_END_P.matcher(condPart).matches()) {
                                prevBlockEndPos = condM.end();
                                blockStartMatcher.region(prevBlockEndPos, template.length());
                                continue block0;
                            }
                            while (condM.find()) {
                                condPart = condM.group();
                                if (GeneratorConstants.COND_END_P.matcher(condPart).matches()) {
                                    if (nest == 0) {
                                        prevBlockEndPos = condM.end();
                                        blockStartMatcher.region(prevBlockEndPos, template.length());
                                        continue block0;
                                    }
                                    --nest;
                                    continue;
                                }
                                if (!GeneratorConstants.COND_START_P.matcher(condPart).matches()) continue;
                                ++nest;
                            }
                            throw (Throwable)MalformedTemplateException.Companion.near(template, blockDefPos, "`if` block is not closed");
                        }
                        if (GeneratorConstants.COND_END_P.matcher(condPart).matches()) {
                            prevBlockEndPos = condM.end();
                            blockStartMatcher.region(prevBlockEndPos, template.length());
                            continue block0;
                        }
                        String string5 = condM.group();
                        Pattern pattern2 = GeneratorConstants.COND_PART_BLOCK_P;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"COND_PART_BLOCK_P");
                        String string6 = Companion.getBlockGroup(string5, pattern2, "condition");
                        Dimensions.Parser parser2 = this.getDimensionsParser();
                        if (parser2 == null) {
                            Intrinsics.throwNpe();
                        }
                        prevBranchCond = Condition.parseCheckedCondition(string6, parser2, source, template, condM.start());
                        branchStartPos = condM.end();
                    }
                    throw (Throwable)MalformedTemplateException.Companion.near(template, blockDefPos, "`if` block is not closed");
                }
                CheckingMatcher contextM = GeneratorConstants.CONTEXT_START_P.matcher(blockStart);
                if (contextM.matches()) {
                    Dimensions.Parser parser = this.getDimensionsParser();
                    if (parser == null) {
                        Intrinsics.throwNpe();
                    }
                    String string7 = contextM.group();
                    Pattern pattern = GeneratorConstants.CONTEXT_START_BLOCK_P;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"CONTEXT_START_BLOCK_P");
                    Dimensions additionalDims = parser.parseForContext(Companion.getBlockGroup(string7, pattern, "dimensions"));
                    int blockStartPos = blockStartMatcher.end();
                    int nest = 0;
                    contextM = GeneratorConstants.CONTEXT_PART_P.matcher(template);
                    contextM.region(blockStartPos, template.length());
                    while (contextM.find()) {
                        String contextPart = contextM.group();
                        if (GeneratorConstants.CONTEXT_END_P.matcher(contextPart).matches()) {
                            if (nest == 0) {
                                int blockEndPos = contextM.start();
                                String string8 = template;
                                boolean bl3 = false;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string8.substring(blockStartPos, blockEndPos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                List<Context> addContexts = additionalDims.generateContexts();
                                Context newSource = source.join(addContexts.get(0));
                                for (Context addCxt : addContexts) {
                                    String block;
                                    Context newTarget = target.join(addCxt);
                                    if (addContexts.size() != 1) {
                                        Context context = newTarget;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"newTarget");
                                        if (!Generator.this.checkContext(context)) continue;
                                    }
                                    Context context = newSource;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"newSource");
                                    Context context2 = newTarget;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"newTarget");
                                    this.process(sb, context, context2, block);
                                }
                                prevBlockEndPos = contextM.end();
                                blockStartMatcher.region(prevBlockEndPos, template.length());
                                continue block0;
                            }
                            --nest;
                            continue;
                        }
                        ++nest;
                    }
                    continue;
                }
                throw (Throwable)MalformedTemplateException.Companion.near(template, blockDefPos, "Block end or `elif` branch without start");
            }
            String string = template;
            boolean bl = false;
            String string9 = string.substring(prevBlockEndPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            String tail = string9;
            this.postProcess(sb, source, target, tail);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0007J\b\u0010\b\u001a\u00020\nH\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0002J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\fJ\u0012\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/timeandspace/jpsg/Generator$Companion;", "", "()V", "BLOCKS_PROCESSOR_PRIORITY", "", "checkingDimensionsParser", "Lio/timeandspace/jpsg/Dimensions$Parser;", "checkingDimensionsParser$annotations", "currentGenerator", "Ljava/lang/ThreadLocal;", "Lio/timeandspace/jpsg/Generator;", "currentSource", "Ljava/io/File;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "redefinedClassName", "", "compileBlock", "Lio/timeandspace/jpsg/CheckingPattern;", "insideBlockRegex", "keyword", "currentSourceFile", "getBlockGroup", "block", "pattern", "Ljava/util/regex/Pattern;", "group", "getRedefinedClassName", "justBlockOrWholeLine", "setCurrentGenerator", "", "generator", "setCurrentSourceFile", "source", "setRedefinedClassName", "className", "wrapBlock", "core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void checkingDimensionsParser$annotations() {
        }

        public final void setCurrentSourceFile(@NotNull File source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            currentSource.set(source);
        }

        @JvmStatic
        @Nullable
        public final File currentSourceFile() {
            return (File)currentSource.get();
        }

        private final void setCurrentGenerator(Generator generator) {
            currentGenerator.set(generator);
        }

        @JvmStatic
        @NotNull
        public final Generator currentGenerator() {
            Object t = currentGenerator.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"currentGenerator.get()");
            return (Generator)t;
        }

        @JvmStatic
        public final void setRedefinedClassName(@Nullable String className) {
            redefinedClassName.set(className);
        }

        private final String getRedefinedClassName() {
            return (String)redefinedClassName.get();
        }

        @JvmStatic
        @NotNull
        public final CheckingPattern compileBlock(@NotNull String insideBlockRegex, @NotNull String keyword) {
            Intrinsics.checkParameterIsNotNull((Object)insideBlockRegex, (String)"insideBlockRegex");
            Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
            String checkingBlockBlockCommentOpening = "/\\*\\s*" + keyword + "[^/*]*+[*/]/";
            String checkingBlockDoubleSlash = "//\\s*" + keyword + "[^/*\\n]*+[*/]/";
            String checkingBlock = '(' + checkingBlockBlockCommentOpening + '|' + checkingBlockDoubleSlash + ')';
            String block = "/[*/]\\s*" + RegexpUtils.removeSubGroupNames(insideBlockRegex) + "\\s*[*/]/";
            CheckingPattern checkingPattern = CheckingPattern.compile(this.justBlockOrWholeLine(checkingBlock), this.justBlockOrWholeLine(block));
            Intrinsics.checkExpressionValueIsNotNull((Object)checkingPattern, (String)"compile(justBlockOrWhole\u2026tBlockOrWholeLine(block))");
            return checkingPattern;
        }

        private final String justBlockOrWholeLine(String block) {
            String string = String.format("^[^\\S\\r\\n]*%s[^\\S\\n]*?\\n|%s", block, block);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"^[^\\\\S\\\\r\\\\n]*%s\u2026]*?\\\\n|%s\", block, block)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final Pattern wrapBlock(@NotNull String insideBlockRegex) {
            Intrinsics.checkParameterIsNotNull((Object)insideBlockRegex, (String)"insideBlockRegex");
            Pattern pattern = RegexpUtils.compile("\\s*/[*/]\\s*" + insideBlockRegex + "\\s*[*/]/\\s*");
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"RegexpUtils.compile(\"\\\\s\u2026BlockRegex\\\\s*[*/]/\\\\s*\")");
            return pattern;
        }

        private final String getBlockGroup(String block, Pattern pattern, String group) {
            Matcher m = pattern.matcher(block);
            if (m.matches()) {
                String string = m.group(group);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(group)");
                return string;
            }
            throw (Throwable)((Object)new AssertionError());
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getRedefinedClassName(Companion $this) {
            return $this.getRedefinedClassName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

