/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Option;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Context
implements Iterable<Map.Entry<String, Option>> {
    private final LinkedHashMap<String, Option> options;

    static boolean stringIncludesOption(String s, Option option) {
        String replacedString = option.intermediateReplace(s, "dummy");
        return !s.equals(replacedString);
    }

    static Builder builder() {
        return new Builder();
    }

    private Context(LinkedHashMap<String, Option> options) {
        this.options = options;
    }

    @Override
    public Iterator<Map.Entry<String, Option>> iterator() {
        return Collections.unmodifiableMap(this.options).entrySet().iterator();
    }

    public Context join(Context additionalContext) {
        LinkedHashMap<String, Option> newOptions = new LinkedHashMap<String, Option>(this.options);
        for (Map.Entry<String, Option> e : additionalContext.options.entrySet()) {
            newOptions.put(e.getKey(), e.getValue());
        }
        return new Context(newOptions);
    }

    public Option getOption(String dim) {
        return this.options.get(dim);
    }

    public String toString() {
        return this.options.toString();
    }

    static class Builder {
        private final LinkedHashMap<String, Option> options = new LinkedHashMap();

        Builder() {
        }

        Builder put(String dim, Option option) {
            this.options.put(dim, option);
            return this;
        }

        Context makeContext() {
            return new Context(new LinkedHashMap<String, Option>(this.options));
        }
    }
}

