/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.dialect.mysql.clause;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Keyword;
import io.shardingjdbc.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.rule.ShardingRule;

public final class MySQLTableReferencesClauseParser
extends TableReferencesClauseParser {
    public MySQLTableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
    }

    @Override
    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
        this.parsePartition();
        this.parseIndexHint(sqlStatement);
    }

    private void parsePartition() {
        this.getLexerEngine().unsupportedIfEqual(MySQLKeyword.PARTITION);
    }

    private void parseIndexHint(SQLStatement sqlStatement) {
        if (this.getLexerEngine().skipIfEqual(DefaultKeyword.USE, MySQLKeyword.IGNORE, MySQLKeyword.FORCE)) {
            this.getLexerEngine().skipAll(DefaultKeyword.INDEX, DefaultKeyword.KEY, DefaultKeyword.FOR, DefaultKeyword.JOIN, DefaultKeyword.ORDER, DefaultKeyword.GROUP, DefaultKeyword.BY);
            this.getLexerEngine().skipParentheses(sqlStatement);
        }
    }

    @Override
    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[]{MySQLKeyword.STRAIGHT_JOIN};
    }
}

