/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.FailingClientCall;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelBuilder
extends ForwardingChannelBuilder<AltsChannelBuilder> {
    private static final Logger logger = Logger.getLogger(AltsChannelBuilder.class.getName());
    private final NettyChannelBuilder delegate;
    private final ImmutableList.Builder<String> targetServiceAccountsBuilder = ImmutableList.builder();
    private ObjectPool<ManagedChannel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
    private boolean enableUntrustedAlts;
    private AltsProtocolNegotiator negotiatorForTest;

    public static final AltsChannelBuilder forTarget(String target) {
        return new AltsChannelBuilder(target);
    }

    public static AltsChannelBuilder forAddress(String name, int port) {
        return AltsChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    private AltsChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget((String)target).keepAliveTime(20L, TimeUnit.SECONDS).keepAliveTimeout(10L, TimeUnit.SECONDS).keepAliveWithoutCalls(true);
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate(), (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)new ProtocolNegotiatorFactory());
    }

    public AltsChannelBuilder addTargetServiceAccount(String targetServiceAccount) {
        this.targetServiceAccountsBuilder.add((Object)targetServiceAccount);
        return this;
    }

    public AltsChannelBuilder enableUntrustedAltsForTesting() {
        this.enableUntrustedAlts = true;
        return this;
    }

    public AltsChannelBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.handshakerChannelPool = HandshakerServiceChannel.getHandshakerChannelPoolForTesting(handshakerAddress);
        return this;
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    public ManagedChannel build() {
        if (!CheckGcpEnvironment.isOnGcp()) {
            if (this.enableUntrustedAlts) {
                logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
            } else {
                Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                this.delegate().intercept(new ClientInterceptor[]{new FailingClientInterceptor(status)});
            }
        }
        return this.delegate().build();
    }

    @Nullable
    @VisibleForTesting
    AltsProtocolNegotiator getProtocolNegotiatorForTest() {
        return this.negotiatorForTest;
    }

    static final class FailingClientInterceptor
    implements ClientInterceptor {
        private final Status status;

        public FailingClientInterceptor(Status status) {
            this.status = status;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new FailingClientCall(this.status);
        }
    }

    private final class ProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private ProtocolNegotiatorFactory() {
        }

        public AltsProtocolNegotiator buildProtocolNegotiator() {
            final ImmutableList targetServiceAccounts = AltsChannelBuilder.this.targetServiceAccountsBuilder.build();
            TsiHandshakerFactory altsHandshakerFactory = new TsiHandshakerFactory(){

                @Override
                public TsiHandshaker newHandshaker(String authority) {
                    AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetServiceAccounts((ImmutableList<String>)targetServiceAccounts).setTargetName(authority).build();
                    return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub((Channel)AltsChannelBuilder.this.handshakerChannelPool.getObject()), handshakerOptions);
                }
            };
            return AltsChannelBuilder.this.negotiatorForTest = AltsProtocolNegotiator.createClientNegotiator(altsHandshakerFactory);
        }
    }
}

