/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import io.github.robwin.markup.builder.MarkupDocBuilder;
import io.github.robwin.markup.builder.MarkupDocBuilders;
import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.config.Swagger2MarkupConfig;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupDocument {
    protected static final String DELIMITER = "|";
    protected final String DEFAULT_COLUMN;
    protected final String REQUIRED_COLUMN;
    protected final String SCHEMA_COLUMN;
    protected final String NAME_COLUMN;
    protected final String DESCRIPTION_COLUMN;
    protected final String DESCRIPTION;
    protected final String PRODUCES;
    protected final String CONSUMES;
    protected final String TAGS;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Swagger swagger;
    protected MarkupLanguage markupLanguage;
    protected MarkupDocBuilder markupDocBuilder;

    MarkupDocument(Swagger2MarkupConfig swagger2MarkupConfig) {
        this.swagger = swagger2MarkupConfig.getSwagger();
        this.markupLanguage = swagger2MarkupConfig.getMarkupLanguage();
        this.markupDocBuilder = MarkupDocBuilders.documentBuilder((MarkupLanguage)this.markupLanguage);
        ResourceBundle labels = ResourceBundle.getBundle("lang/labels", swagger2MarkupConfig.getOutputLanguage().toLocale());
        this.DEFAULT_COLUMN = labels.getString("default_column");
        this.REQUIRED_COLUMN = labels.getString("required_column");
        this.SCHEMA_COLUMN = labels.getString("schema_column");
        this.NAME_COLUMN = labels.getString("name_column");
        this.DESCRIPTION = this.DESCRIPTION_COLUMN = labels.getString("description_column");
        this.PRODUCES = labels.getString("produces");
        this.CONSUMES = labels.getString("consumes");
        this.TAGS = labels.getString("tags");
    }

    public abstract MarkupDocument build() throws IOException;

    public String toString() {
        return this.markupDocBuilder.toString();
    }

    public void writeToFile(String directory, String fileName, Charset charset) throws IOException {
        this.markupDocBuilder.writeToFile(directory, fileName, charset);
    }
}

