/*
 * Decompiled with CFR 0.152.
 */
package com.ttk.agg.openapi.sdk;

import com.ttk.agg.openapi.sdk.AggOpenAPI;
import com.ttk.agg.openapi.sdk.NoopTrustManager;
import com.ttk.agg.openapi.sdk.StringUtil;
import com.ttk.agg.openapi.sdk.dto.OpenApiBusinessException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.ThreadContext;

public class HttpUtil {
    private static String sdkVersion = null;

    public static String post(String url, String requestBody) throws NoSuchAlgorithmException, KeyManagementException {
        return HttpUtil.post(url, requestBody, null);
    }

    public static String post(String url, String requestBody, Map<String, String> headerMap) throws NoSuchAlgorithmException, KeyManagementException {
        String logId;
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(requestBody)) {
            throw new OpenApiBusinessException("", "requestBody\u4e0d\u80fd\u4e3anull");
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new NoopTrustManager()}, null);
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        if (sdkVersion == null) {
            sdkVersion = "";
        }
        httpPost.setHeader("sdkVersion", sdkVersion);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((logId = ThreadContext.get((String)"logId")) != null) {
            httpPost.setHeader("logId", logId.toString());
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(requestBody, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseStr;
                HttpEntity httpEntity = httpResponse.getEntity();
                String string = responseStr = EntityUtils.toString((HttpEntity)httpEntity, (String)charSet);
                return string;
            }
            try {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u5931\u8d25\uff0c(" + url + ")\u72b6\u6001\u7801\uff1a" + statusCode);
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "http\u5173\u95ed\u65f6\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
    }

    public static String post(String url, String requestBody, Map<String, String> headerMap, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) throws NoSuchAlgorithmException, KeyManagementException {
        String logId;
        RequestConfig requestConfig;
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(requestBody)) {
            throw new OpenApiBusinessException("", "requestBody\u4e0d\u80fd\u4e3anull");
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new NoopTrustManager()}, null);
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        if (!StringUtil.isNullOrEmpty(proxyUser)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        }
        HttpPost httpPost = new HttpPost(url);
        if (!StringUtil.isNullOrEmpty(proxyHost) && (requestConfig = httpPost.getConfig()) == null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            requestConfig = RequestConfig.custom().setProxy(proxy).build();
            httpPost.setConfig(requestConfig);
        }
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        if (sdkVersion == null) {
            sdkVersion = "";
        }
        httpPost.setHeader("sdkVersion", sdkVersion);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((logId = ThreadContext.get((String)"logId")) != null) {
            httpPost.setHeader("logId", logId.toString());
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(requestBody, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseStr;
                HttpEntity httpEntity = httpResponse.getEntity();
                String string = responseStr = EntityUtils.toString((HttpEntity)httpEntity, (String)charSet);
                return string;
            }
            try {
                HttpEntity httpEntity = httpResponse.getEntity();
                String responseStr = EntityUtils.toString((HttpEntity)httpEntity, (String)charSet);
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u5931\u8d25\uff0c(" + url + ")\u72b6\u6001\u7801\uff1a" + statusCode + " responseStr=" + responseStr);
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "http\u5173\u95ed\u65f6\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
    }

    public static String post(String url, String requestBody, Map<String, String> headerMap, int timeout, int connectTimeout, int connectionRequestTimeout) throws NoSuchAlgorithmException, KeyManagementException {
        String logId;
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(requestBody)) {
            throw new OpenApiBusinessException("", "requestBody\u4e0d\u80fd\u4e3anull");
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new NoopTrustManager()}, null);
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (timeout > -1) {
            customReqConf.setSocketTimeout(timeout);
            httpPost.setHeader("socketTimeout", String.valueOf(timeout));
        }
        if (connectTimeout > -1) {
            customReqConf.setConnectTimeout(connectTimeout);
            httpPost.setHeader("connectTimeout", String.valueOf(connectTimeout));
        }
        if (connectionRequestTimeout > -1) {
            customReqConf.setConnectionRequestTimeout(connectionRequestTimeout);
            httpPost.setHeader("connectionRequestTimeout", String.valueOf(connectionRequestTimeout));
        }
        RequestConfig requestConfig = customReqConf.build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        if (sdkVersion == null) {
            sdkVersion = "";
        }
        httpPost.setHeader("sdkVersion", sdkVersion);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((logId = ThreadContext.get((String)"logId")) != null) {
            httpPost.setHeader("logId", logId.toString());
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(requestBody, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseStr;
                HttpEntity httpEntity = httpResponse.getEntity();
                String string = responseStr = EntityUtils.toString((HttpEntity)httpEntity, (String)charSet);
                return string;
            }
            try {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u5931\u8d25\uff0c(" + url + ")\u72b6\u6001\u7801\uff1a" + statusCode);
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "http\u5173\u95ed\u65f6\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
    }

    public static String post(String url, String requestBody, Map<String, String> headerMap, int timeout, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, int connectTimeout, int connectionRequestTimeout) throws NoSuchAlgorithmException, KeyManagementException {
        String logId;
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(requestBody)) {
            throw new OpenApiBusinessException("", "requestBody\u4e0d\u80fd\u4e3anull");
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new NoopTrustManager()}, null);
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        if (!StringUtil.isNullOrEmpty(proxyUser)) {
            BasicCredentialsProvider cdtProvider = new BasicCredentialsProvider();
            cdtProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider((CredentialsProvider)cdtProvider).build();
        }
        HttpPost httpPost = new HttpPost(url);
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (timeout > -1) {
            customReqConf.setSocketTimeout(timeout);
            httpPost.setHeader("socketTimeout", String.valueOf(timeout));
        }
        if (connectTimeout > -1) {
            customReqConf.setConnectTimeout(connectTimeout);
            httpPost.setHeader("connectTimeout", String.valueOf(connectTimeout));
        }
        if (connectionRequestTimeout > -1) {
            customReqConf.setConnectionRequestTimeout(connectionRequestTimeout);
            httpPost.setHeader("connectionRequestTimeout", String.valueOf(connectionRequestTimeout));
        }
        if (!StringUtil.isNullOrEmpty(proxyHost)) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            customReqConf.setProxy(proxy);
        }
        RequestConfig requestConfig = customReqConf.build();
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        if (sdkVersion == null) {
            sdkVersion = "";
        }
        httpPost.setHeader("sdkVersion", sdkVersion);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((logId = ThreadContext.get((String)"logId")) != null) {
            httpPost.setHeader("logId", logId.toString());
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(requestBody, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseStr;
                HttpEntity httpEntity = httpResponse.getEntity();
                String string = responseStr = EntityUtils.toString((HttpEntity)httpEntity, (String)charSet);
                return string;
            }
            try {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u5931\u8d25\uff0c(" + url + ")\u72b6\u6001\u7801\uff1a" + statusCode);
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "rest\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                throw new OpenApiBusinessException("", "http\u5173\u95ed\u65f6\u6709\u5f02\u5e38\u53d1\u751f\uff1a" + e.getMessage());
            }
        }
    }

    public static String postRestfulRequest(AggOpenAPI aggOpenAPI, String url, String requestBody) throws NoSuchAlgorithmException, KeyManagementException {
        return HttpUtil.postRestfulRequest(aggOpenAPI, url, requestBody, null);
    }

    public static String postRestfulRequest(AggOpenAPI aggOpenAPI, String url, String requestBody, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) throws NoSuchAlgorithmException, KeyManagementException {
        return HttpUtil.postRestfulRequest(aggOpenAPI, url, requestBody, null, proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public static String postRestfulRequest(AggOpenAPI aggOpenAPI, String url, String requestBody, Map<String, String> headerMap) throws NoSuchAlgorithmException, KeyManagementException {
        String appKey = aggOpenAPI.getAppKey();
        String appSecret = aggOpenAPI.getAppSecret();
        String access_token = aggOpenAPI.getAccessToken();
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(access_token)) {
            throw new OpenApiBusinessException("", "access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(appSecret)) {
            throw new OpenApiBusinessException("", "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String apiHost = aggOpenAPI.getApiHost();
        url = apiHost + url;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        long timestamp = System.currentTimeMillis();
        String before = "POST_" + HttpUtil.MD5(requestBody) + "_" + timestamp + "_" + access_token + "_" + appSecret;
        String sign = "API-SV1:" + appKey + ":" + Base64.encodeBase64String((byte[])HttpUtil.MD5(before).getBytes());
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("access_token", access_token);
        headerMap.put("req_date", String.valueOf(timestamp));
        headerMap.put("req_sign", sign);
        String responseStr = HttpUtil.post(url, requestBody, headerMap);
        return responseStr;
    }

    public static String postRestfulRequest(AggOpenAPI aggOpenAPI, String url, String requestBody, Map<String, String> headerMap, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) throws NoSuchAlgorithmException, KeyManagementException {
        String appKey = aggOpenAPI.getAppKey();
        String appSecret = aggOpenAPI.getAppSecret();
        String access_token = aggOpenAPI.getAccessToken();
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(access_token)) {
            throw new OpenApiBusinessException("", "access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(appSecret)) {
            throw new OpenApiBusinessException("", "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String apiHost = aggOpenAPI.getApiHost();
        url = apiHost + url;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        long timestamp = System.currentTimeMillis();
        String before = "POST_" + HttpUtil.MD5(requestBody) + "_" + timestamp + "_" + access_token + "_" + appSecret;
        String sign = "API-SV1:" + appKey + ":" + Base64.encodeBase64String((byte[])HttpUtil.MD5(before).getBytes());
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("access_token", access_token);
        headerMap.put("req_date", String.valueOf(timestamp));
        headerMap.put("req_sign", sign);
        String responseStr = HttpUtil.post(url, requestBody, headerMap, proxyHost, proxyPort, proxyUser, proxyPassword);
        return responseStr;
    }

    public static String postRestfulRequest(AggOpenAPI aggOpenAPI, String url, String requestBody, Map<String, String> headerMap, int timeout, int connectTimeout, int connectionRequestTimeout) throws NoSuchAlgorithmException, KeyManagementException {
        String appKey = aggOpenAPI.getAppKey();
        String appSecret = aggOpenAPI.getAppSecret();
        String access_token = aggOpenAPI.getAccessToken();
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(access_token)) {
            throw new OpenApiBusinessException("", "access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(appSecret)) {
            throw new OpenApiBusinessException("", "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String apiHost = aggOpenAPI.getApiHost();
        url = apiHost + url;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        long timestamp = System.currentTimeMillis();
        String before = "POST_" + HttpUtil.MD5(requestBody) + "_" + timestamp + "_" + access_token + "_" + appSecret;
        String sign = "API-SV1:" + appKey + ":" + Base64.encodeBase64String((byte[])HttpUtil.MD5(before).getBytes());
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("access_token", access_token);
        headerMap.put("req_date", String.valueOf(timestamp));
        headerMap.put("req_sign", sign);
        String responseStr = HttpUtil.post(url, requestBody, headerMap, timeout, connectTimeout, connectionRequestTimeout);
        return responseStr;
    }

    public static String postRestfulRequest(AggOpenAPI aggOpenAPI, String url, String requestBody, Map<String, String> headerMap, int timeout, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, int connectTimeout, int connectionRequestTimeout) throws NoSuchAlgorithmException, KeyManagementException {
        String appKey = aggOpenAPI.getAppKey();
        String appSecret = aggOpenAPI.getAppSecret();
        String access_token = aggOpenAPI.getAccessToken();
        if (StringUtil.isNullOrEmpty(url)) {
            throw new OpenApiBusinessException("", "url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(access_token)) {
            throw new OpenApiBusinessException("", "access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNullOrEmpty(appSecret)) {
            throw new OpenApiBusinessException("", "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String apiHost = aggOpenAPI.getApiHost();
        url = apiHost + url;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        long timestamp = System.currentTimeMillis();
        String before = "POST_" + HttpUtil.MD5(requestBody) + "_" + timestamp + "_" + access_token + "_" + appSecret;
        String sign = "API-SV1:" + appKey + ":" + Base64.encodeBase64String((byte[])HttpUtil.MD5(before).getBytes());
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("access_token", access_token);
        headerMap.put("req_date", String.valueOf(timestamp));
        headerMap.put("req_sign", sign);
        String responseStr = HttpUtil.post(url, requestBody, headerMap, timeout, proxyHost, proxyPort, proxyUser, proxyPassword, connectTimeout, connectionRequestTimeout);
        return responseStr;
    }

    public static String MD5(String sourceStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sourceStr.getBytes("UTF-8"));
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new OpenApiBusinessException("", e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenApiBusinessException("", e.getMessage());
        }
        return result;
    }

    static {
        try {
            ResourceBundle resource = ResourceBundle.getBundle("sdk");
            if (resource != null) {
                sdkVersion = resource.getString("sdkVersion");
            }
        }
        catch (Exception e) {
            sdkVersion = "";
        }
    }
}

