/*
 * Decompiled with CFR 0.152.
 */
package com.ttk.agg.openapi.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ttk.agg.openapi.sdk.HttpUtil;
import com.ttk.agg.openapi.sdk.StringUtil;
import com.ttk.agg.openapi.sdk.dto.CallResult;
import com.ttk.agg.openapi.sdk.dto.ExceptionResult;
import com.ttk.agg.openapi.sdk.dto.InvoiceInspectionParamBody;
import com.ttk.agg.openapi.sdk.dto.OpenApiBusinessException;
import com.ttk.agg.openapi.sdk.enums.InspectReturnMappingEnum;
import com.ttk.agg.openapi.sdk.inspect.BaseInvoice;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.logging.log4j.ThreadContext;

public class AggOpenAPI {
    private String apiHost;
    private String appKey;
    private String appSecret;
    private volatile String token;
    private volatile Long expiresIn;
    private volatile String refreshToken;
    private Long lastTokenTime;
    private String apiVersion = "v1";
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private int socketTimeout = -1;
    private int connectTimeout = -1;
    private int connectionRequestTimeout = -1;

    public AggOpenAPI(String apiHost, String appKey, String appSecret) {
        if (StringUtil.isNullOrEmpty(apiHost)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570apiHost\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isNullOrEmpty(appKey)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570appKey\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isNullOrEmpty(appSecret)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570appSecret\u4e0d\u6b63\u786e");
        }
        if (apiHost.endsWith("/")) {
            apiHost = apiHost.substring(0, apiHost.length() - 1);
        }
        this.apiHost = apiHost;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public AggOpenAPI(String apiHost, String appKey, String appSecret, String webHost) {
        this(apiHost, appKey, appSecret);
    }

    public String restStr(String path, String jsonParameter) {
        if (path == null) {
            throw new OpenApiBusinessException("", "path\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (jsonParameter == null) {
            throw new OpenApiBusinessException("", "jsonParameter\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (path.toLowerCase().startsWith("/v")) {
                this.setApiVersion(path.substring(1, 3));
            }
            if (StringUtil.isNullOrEmpty(this.proxyHost)) {
                return HttpUtil.postRestfulRequest(this, path.trim(), jsonParameter, null, this.socketTimeout, this.connectTimeout, this.connectionRequestTimeout);
            }
            return HttpUtil.postRestfulRequest(this, path.trim(), jsonParameter, null, this.socketTimeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword, this.connectTimeout, this.connectionRequestTimeout);
        }
        catch (Exception e) {
            throw new OpenApiBusinessException("", e.getMessage());
        }
    }

    public String restStr(String path, String jsonParameter, int timeout) {
        if (path == null) {
            throw new OpenApiBusinessException("", "path\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (jsonParameter == null) {
            throw new OpenApiBusinessException("", "jsonParameter\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.socketTimeout > -1) {
            timeout = this.socketTimeout;
        }
        try {
            if (path.toLowerCase().startsWith("/v")) {
                this.setApiVersion(path.substring(1, 3));
            }
            if (StringUtil.isNullOrEmpty(this.proxyHost)) {
                return HttpUtil.postRestfulRequest(this, path.trim(), jsonParameter, null, timeout, this.connectTimeout, this.connectionRequestTimeout);
            }
            return HttpUtil.postRestfulRequest(this, path.trim(), jsonParameter, null, timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword, this.connectTimeout, this.connectionRequestTimeout);
        }
        catch (Exception e) {
            throw new OpenApiBusinessException("", e.getMessage());
        }
    }

    public JSONObject rest(String path, String jsonParameter) {
        JSONObject resultObj;
        String result = this.restStr(path, jsonParameter);
        try {
            resultObj = JSONObject.parseObject((String)result, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        }
        catch (Exception ex) {
            throw new OpenApiBusinessException("", "\u8fd4\u56de\u503c\u4e0d\u662f\u6b63\u786e\u7684 json \u683c\u5f0f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return resultObj;
    }

    public JSONObject rest(String path, String jsonParameter, int timeout) {
        JSONObject resultObj;
        String result = this.restStr(path, jsonParameter, timeout);
        try {
            resultObj = JSONObject.parseObject((String)result, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        }
        catch (Exception ex) {
            throw new OpenApiBusinessException("", "\u8fd4\u56de\u503c\u4e0d\u662f\u6b63\u786e\u7684 json \u683c\u5f0f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return resultObj;
    }

    public CallResult<BaseInvoice> check(InvoiceInspectionParamBody invoiceInspectionParamBody) {
        String path = "/v2/invoice/customizedCheck";
        try {
            JSONObject jsonObject = this.rest(path, JSONObject.toJSONString((Object)invoiceInspectionParamBody));
            if (!jsonObject.getBoolean("success").booleanValue()) {
                JSONObject errorJson = jsonObject.getJSONObject("exceptionResult");
                errorJson.put("requestId", (Object)jsonObject.getString("requestId"));
                return CallResult.fail(AggOpenAPI.parse(errorJson.toJSONString(), this.apiHost + path));
            }
            JSONObject jsonData = jsonObject.getJSONObject("data");
            Class clazz = InspectReturnMappingEnum.of(jsonData.getString("invoiceType")).getClazz();
            return CallResult.success(JSON.parseObject((String)jsonData.toString(), (Class)clazz));
        }
        catch (Exception e) {
            ExceptionResult result = new ExceptionResult(UUID.randomUUID().toString(), this.apiHost + path, "CallException", e.getMessage());
            return CallResult.fail(result);
        }
    }

    private static ExceptionResult parse(String result, String url) {
        try {
            return (ExceptionResult)JSON.parseObject((String)result, ExceptionResult.class);
        }
        catch (Exception var3) {
            return new ExceptionResult(UUID.randomUUID().toString(), url, "CallException", "\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAccessToken() throws NoSuchAlgorithmException, KeyManagementException {
        if (StringUtil.isNullOrEmpty(this.token)) {
            AggOpenAPI aggOpenAPI = this;
            synchronized (aggOpenAPI) {
                if (StringUtil.isNullOrEmpty(this.token)) {
                    this.newToken();
                }
            }
        }
        Long currentTime = System.currentTimeMillis();
        Long holdingTime = currentTime - this.lastTokenTime;
        if (holdingTime >= this.expiresIn - 86400000L && holdingTime <= this.expiresIn - 0x6DDD00L) {
            AggOpenAPI aggOpenAPI = this;
            synchronized (aggOpenAPI) {
                this.refreshToken();
            }
        }
        if (holdingTime > this.expiresIn - 0x6DDD00L) {
            AggOpenAPI aggOpenAPI = this;
            synchronized (aggOpenAPI) {
                this.newToken();
            }
        }
        return this.token;
    }

    private void newToken() throws NoSuchAlgorithmException, KeyManagementException {
        JSONObject jsonObjectBody;
        JSONObject jsonObject;
        JSONObject requestBody = new JSONObject();
        requestBody.put("grant_type", (Object)"client_credentials");
        requestBody.put("client_appkey", (Object)this.appKey);
        requestBody.put("client_secret", (Object)HttpUtil.MD5(this.appSecret));
        String url = this.apiHost;
        if (this.apiHost.toLowerCase().indexOf("/v") > -1) {
            url = url.substring(0, url.indexOf("/v"));
        }
        url = "v1".equalsIgnoreCase(this.apiVersion) ? url + "/" + this.apiVersion + "/AGG/oauth2/login" : url + "/" + this.apiVersion + "/public/oauth2/login";
        String responseStr = HttpUtil.post(url, requestBody.toJSONString(), null, this.socketTimeout, this.connectTimeout, this.connectionRequestTimeout);
        try {
            jsonObject = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
            if (jsonObject == null) {
                throw new OpenApiBusinessException("", "\u83b7\u53d6token\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u7f51\u5740" + this.apiHost + " \u662f\u5426\u80fd\u6b63\u5e38\u8bbf\u95ee\uff01");
            }
        }
        catch (Exception ex) {
            if (ex instanceof OpenApiBusinessException) {
                throw ex;
            }
            throw new OpenApiBusinessException("", ex.getMessage());
        }
        if ("v1".equalsIgnoreCase(this.apiVersion)) {
            String logId;
            JSONObject jsonObjectResult = jsonObject.getJSONObject("result");
            if (jsonObjectResult != null && (logId = jsonObjectResult.getString("req_id")) != null) {
                ThreadContext.put((String)"logId", (String)logId);
            }
        } else {
            String logId = jsonObject.getString("reqId");
            if (logId != null) {
                ThreadContext.put((String)"logId", (String)logId);
            }
        }
        if ("v1".equalsIgnoreCase(this.apiVersion)) {
            jsonObjectBody = jsonObject.getJSONObject("value");
            if (jsonObjectBody.get((Object)"error_msg") != null) {
                throw new OpenApiBusinessException("", jsonObjectBody.get((Object)"error_msg").toString());
            }
        } else {
            if (!jsonObject.getBoolean("success").booleanValue()) {
                throw new OpenApiBusinessException(jsonObject.get((Object)"code").toString(), jsonObject.get((Object)"message").toString());
            }
            jsonObjectBody = jsonObject.getJSONObject("data");
        }
        this.token = jsonObjectBody.getString("access_token");
        this.expiresIn = jsonObjectBody.getLong("expires_in");
        this.lastTokenTime = System.currentTimeMillis();
        this.refreshToken = jsonObjectBody.getString("refresh_token");
        if (StringUtil.isNullOrEmpty(this.token)) {
            throw new OpenApiBusinessException("", "access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void refreshToken() throws NoSuchAlgorithmException, KeyManagementException {
        JSONObject jsonObjectBody;
        JSONObject jsonObject;
        JSONObject requestBody = new JSONObject();
        requestBody.put("grant_type", (Object)"refresh_token");
        requestBody.put("refresh_token", (Object)this.refreshToken);
        String url = this.apiHost;
        if (this.apiHost.toLowerCase().indexOf("/v") > -1) {
            url = url.substring(0, url.indexOf("/v"));
        }
        url = url + "/" + this.apiVersion + "/AGG/oauth2/login";
        String responseStr = HttpUtil.post(url, requestBody.toJSONString(), null, this.socketTimeout, this.connectTimeout, this.connectionRequestTimeout);
        try {
            jsonObject = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
            if (jsonObject == null) {
                throw new OpenApiBusinessException("", "\u5237\u65b0token\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u7f51\u5740" + this.apiHost + " \u662f\u5426\u80fd\u6b63\u5e38\u8bbf\u95ee\uff01");
            }
        }
        catch (Exception ex) {
            if (ex instanceof OpenApiBusinessException) {
                throw ex;
            }
            throw new OpenApiBusinessException("", ex.getMessage());
        }
        if ("v1".equalsIgnoreCase(this.apiVersion)) {
            String logId;
            JSONObject jsonObjectResult = jsonObject.getJSONObject("result");
            if (jsonObjectResult != null && (logId = jsonObjectResult.getString("req_id")) != null) {
                ThreadContext.put((String)"logId", (String)logId);
            }
        } else {
            String logId = jsonObject.getString("reqId");
            if (logId != null) {
                ThreadContext.put((String)"logId", (String)logId);
            }
        }
        if ("v1".equalsIgnoreCase(this.apiVersion)) {
            jsonObjectBody = jsonObject.getJSONObject("value");
            if (jsonObjectBody.get((Object)"info_msg") != null) {
                throw new OpenApiBusinessException("", jsonObjectBody.get((Object)"info_msg").toString());
            }
        } else {
            if (!jsonObject.getBoolean("success").booleanValue()) {
                throw new OpenApiBusinessException(jsonObject.get((Object)"code").toString(), jsonObject.get((Object)"message").toString());
            }
            jsonObjectBody = jsonObject.getJSONObject("data");
        }
        this.token = jsonObjectBody.getString("access_token");
        this.expiresIn = jsonObjectBody.getLong("expires_in");
        this.lastTokenTime = System.currentTimeMillis();
        this.refreshToken = jsonObjectBody.getString("refresh_token");
        if (StringUtil.isNullOrEmpty(this.token)) {
            throw new OpenApiBusinessException("", "access_token\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public JSONArray getFpxzStatus(String jsonParameter) throws OpenApiBusinessException {
        JSONArray fplxs;
        JSONArray jxxbzs;
        JSONArray kpyfs;
        JSONObject jsonObj;
        if (StringUtil.isNullOrEmpty(jsonParameter)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            jsonObj = JSONObject.parseObject((String)jsonParameter, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        }
        catch (Exception ex) {
            String msg = "\u83b7\u53d6\u53d1\u7968\u4e0b\u8f7d\u72b6\u6001\u5931\u8d25\uff0c\u63a5\u53e3\u53c2\u6570\u8f6c json \u5f02\u5e38\uff1a" + ex.getMessage();
            throw new OpenApiBusinessException("", msg);
        }
        ArrayList<String> invalidList = new ArrayList<String>();
        String nsrsbh = jsonObj.getString("nsrsbh");
        if (StringUtil.isNullOrEmpty(nsrsbh)) {
            invalidList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        }
        if ((kpyfs = jsonObj.getJSONArray("kpyfs")) == null || kpyfs.isEmpty()) {
            invalidList.add("\u5f00\u7968\u6708\u4efd\u5217\u8868");
        }
        if ((jxxbzs = jsonObj.getJSONArray("jxxbzs")) == null || jxxbzs.isEmpty()) {
            invalidList.add("\u8fdb\u9500\u9879\u6807\u8bc6\u5217\u8868");
        }
        if ((fplxs = jsonObj.getJSONArray("fplxs")) == null || fplxs.isEmpty()) {
            invalidList.add("\u53d1\u7968\u7c7b\u578b\u4ee3\u7801\u5217\u8868");
        }
        if (!invalidList.isEmpty()) {
            throw new OpenApiBusinessException("", StringUtil.join(invalidList, "\u3001") + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean addJob = false;
        if (jsonObj.containsKey((Object)"addJob")) {
            addJob = jsonObj.getBooleanValue("addJob");
        }
        jsonObj.put("addJob", (Object)addJob);
        jsonObj.remove((Object)"kpyfs");
        JSONArray result = new JSONArray();
        for (Object kpyf : kpyfs) {
            jsonObj.put("kpyf", kpyf);
            JSONObject fpxzObj = this.rest("/FP/getFpxzStatus", jsonObj.toJSONString());
            JSONObject fpxzResultObj = fpxzObj.getJSONObject("result");
            Boolean success = fpxzResultObj.getBoolean("success");
            if (success != null && success.booleanValue()) {
                result.addAll((Collection)fpxzObj.getJSONArray("value"));
                continue;
            }
            String msg = fpxzObj.getJSONObject("error").getString("message");
            Date date = new Date();
            for (Object jxxbz : jxxbzs) {
                for (Object fplx : fplxs) {
                    JSONObject error = new JSONObject();
                    error.put("jxxbz", jxxbz);
                    error.put("fplx", fplx);
                    error.put("kpyf", kpyf);
                    error.put("status", (Object)"failed");
                    error.put("msg", (Object)msg);
                    error.put("time", (Object)date);
                    result.add((Object)error);
                }
            }
        }
        return result;
    }

    public JSONObject cj(String jsonParameter) throws OpenApiBusinessException {
        JSONArray fplxs;
        JSONArray jxxbzs;
        JSONArray kpyfs;
        JSONObject jsonObj;
        if (StringUtil.isNullOrEmpty(jsonParameter)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            jsonObj = JSONObject.parseObject((String)jsonParameter, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        }
        catch (Exception ex) {
            String msg = "\u91c7\u96c6\u53d1\u7968\u5931\u8d25\uff0c\u63a5\u53e3\u53c2\u6570\u8f6c json \u5f02\u5e38\uff1a" + ex.getMessage();
            throw new OpenApiBusinessException("", msg);
        }
        ArrayList<String> invalidList = new ArrayList<String>();
        String nsrsbh = jsonObj.getString("nsrsbh");
        if (StringUtil.isNullOrEmpty(nsrsbh)) {
            invalidList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        }
        if ((kpyfs = jsonObj.getJSONArray("kpyfs")) == null || kpyfs.isEmpty()) {
            invalidList.add("\u5f00\u7968\u6708\u4efd\u5217\u8868");
        }
        if ((jxxbzs = jsonObj.getJSONArray("jxxbzs")) == null || jxxbzs.isEmpty()) {
            invalidList.add("\u8fdb\u9500\u9879\u6807\u8bc6\u5217\u8868");
        }
        if ((fplxs = jsonObj.getJSONArray("fplxs")) == null || fplxs.isEmpty()) {
            invalidList.add("\u53d1\u7968\u7c7b\u578b\u4ee3\u7801\u5217\u8868");
        }
        if (!invalidList.isEmpty()) {
            throw new OpenApiBusinessException("", StringUtil.join(invalidList, "\u3001") + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject result = new JSONObject();
        jsonObj.remove((Object)"kpyfs");
        jsonObj.remove((Object)"jxxbzs");
        jsonObj.remove((Object)"fplxs");
        for (Object kpyf : kpyfs) {
            jsonObj.put("kpyf", kpyf);
            for (Object jxxbz : jxxbzs) {
                jsonObj.put("jxxbz", jxxbz);
                for (Object fplx : fplxs) {
                    jsonObj.put("fplx", fplx);
                    String key = "" + kpyf + "_" + jxxbz + "_" + fplx;
                    JSONObject cjObj = this.rest("/FP/cj", jsonObj.toJSONString());
                    JSONObject cjResultObj = cjObj.getJSONObject("result");
                    Boolean success = cjResultObj.getBoolean("success");
                    JSONObject item = new JSONObject();
                    if (success != null && success.booleanValue()) {
                        JSONArray list = cjObj.getJSONObject("value").getJSONArray("list");
                        item.put("result", (Object)true);
                        item.put("list", (Object)list);
                    } else {
                        String msg = cjObj.getJSONObject("error").getString("message");
                        item.put("result", (Object)false);
                        item.put("msg", (Object)msg);
                    }
                    result.put(key, (Object)item);
                }
            }
        }
        return result;
    }

    public JSONArray getGxgxztStatus(String jsonParameter) throws OpenApiBusinessException {
        JSONArray skssqs;
        JSONObject jsonObj;
        if (StringUtil.isNullOrEmpty(jsonParameter)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            jsonObj = JSONObject.parseObject((String)jsonParameter, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        }
        catch (Exception ex) {
            String msg = "\u83b7\u53d6\u66f4\u65b0\u53d1\u7968\u52fe\u9009\u72b6\u6001\u5931\u8d25\uff0c\u63a5\u53e3\u53c2\u6570\u8f6c json \u5f02\u5e38\uff1a" + ex.getMessage();
            throw new OpenApiBusinessException("", msg);
        }
        ArrayList<String> invalidList = new ArrayList<String>();
        String nsrsbh = jsonObj.getString("nsrsbh");
        if (StringUtil.isNullOrEmpty(nsrsbh)) {
            invalidList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        }
        if ((skssqs = jsonObj.getJSONArray("skssqs")) == null || skssqs.isEmpty()) {
            invalidList.add("\u7a0e\u6b3e\u6240\u5c5e\u671f\u5217\u8868");
        }
        if (!invalidList.isEmpty()) {
            throw new OpenApiBusinessException("", StringUtil.join(invalidList, "\u3001") + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean addJob = false;
        if (jsonObj.containsKey((Object)"addJob")) {
            addJob = jsonObj.getBooleanValue("addJob");
        }
        jsonObj.put("addJob", (Object)addJob);
        jsonObj.remove((Object)"skssqs");
        JSONArray result = new JSONArray();
        for (Object skssq : skssqs) {
            jsonObj.put("skssq", skssq);
            JSONObject gxgxztObj = this.rest("/FP/getGxgxztStatus", jsonObj.toJSONString());
            JSONObject gxgxztResultObj = gxgxztObj.getJSONObject("result");
            Boolean success = gxgxztResultObj.getBoolean("success");
            if (success != null && success.booleanValue()) {
                JSONObject item = gxgxztObj.getJSONObject("value");
                result.add((Object)item);
                continue;
            }
            String msg = gxgxztObj.getJSONObject("error").getString("message");
            Date date = new Date();
            JSONObject error = new JSONObject();
            error.put("status", (Object)"failed");
            error.put("msg", (Object)msg);
            error.put("time", (Object)date);
            error.put("skssq", skssq);
            result.add((Object)error);
        }
        return result;
    }

    public JSONObject cjYgx(String jsonParameter) throws OpenApiBusinessException {
        JSONArray fplxs;
        JSONArray skssqs;
        JSONObject jsonObj;
        if (StringUtil.isNullOrEmpty(jsonParameter)) {
            throw new OpenApiBusinessException("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            jsonObj = JSONObject.parseObject((String)jsonParameter, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        }
        catch (Exception ex) {
            String msg = "\u91c7\u96c6\u53d1\u7968\u5931\u8d25\uff0c\u63a5\u53e3\u53c2\u6570\u8f6c json \u5f02\u5e38\uff1a" + ex.getMessage();
            throw new OpenApiBusinessException("", msg);
        }
        ArrayList<String> invalidList = new ArrayList<String>();
        String nsrsbh = jsonObj.getString("nsrsbh");
        if (StringUtil.isNullOrEmpty(nsrsbh)) {
            invalidList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
        }
        if ((skssqs = jsonObj.getJSONArray("skssqs")) == null || skssqs.isEmpty()) {
            invalidList.add("\u7a0e\u6b3e\u6240\u5c5e\u671f\u5217\u8868");
        }
        if ((fplxs = jsonObj.getJSONArray("fplxs")) == null || fplxs.isEmpty()) {
            invalidList.add("\u53d1\u7968\u7c7b\u578b\u4ee3\u7801\u5217\u8868");
        }
        if (!invalidList.isEmpty()) {
            throw new OpenApiBusinessException("", StringUtil.join(invalidList, "\u3001") + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        jsonObj.remove((Object)"skssqs");
        jsonObj.remove((Object)"fplxs");
        JSONObject result = new JSONObject();
        for (Object skssq : skssqs) {
            jsonObj.put("skssq", skssq);
            for (Object fplx : fplxs) {
                jsonObj.put("fplx", fplx);
                String key = "" + skssq + "_" + fplx;
                JSONObject item = new JSONObject();
                JSONObject cjObj = this.rest("/FP/cjYgx", jsonObj.toJSONString());
                JSONObject cjResultObj = cjObj.getJSONObject("result");
                Boolean success = cjResultObj.getBoolean("success");
                if (success != null && success.booleanValue()) {
                    JSONArray list = cjObj.getJSONObject("value").getJSONArray("list");
                    item.put("result", (Object)true);
                    item.put("list", (Object)list);
                } else {
                    String msg = cjObj.getJSONObject("error").getString("message");
                    item.put("result", (Object)false);
                    item.put("msg", (Object)msg);
                }
                result.put(key, (Object)item);
            }
        }
        return result;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }
}

