/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

class DistillPackages {
    private TreeSet<String> treeSet = new TreeSet();

    DistillPackages() {
    }

    DistillPackages add(Collection<String> packages) {
        if (packages != null) {
            this.treeSet.addAll(packages);
        }
        return this;
    }

    DistillPackages addRaw(String packages) {
        if (packages != null) {
            String[] split = packages.split(",|;| ");
            for (int i = 0; i < split.length; ++i) {
                String pkg = split[i].trim();
                if (pkg.isEmpty()) continue;
                this.treeSet.add(pkg);
            }
        }
        return this;
    }

    String[] distill() {
        return this.convertToArray(this.deriveTopLevel());
    }

    private List<String> deriveTopLevel() {
        ArrayList<String> distilled = new ArrayList<String>();
        for (String pack : this.treeSet) {
            if (!this.notAlreadyContained(distilled, pack)) continue;
            distilled.add(pack);
        }
        return distilled;
    }

    private String[] convertToArray(Collection<String> packages) {
        String[] asArray = packages.toArray(new String[packages.size()]);
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = this.convert(asArray[i]);
        }
        return asArray;
    }

    private String convert(String pkg) {
        if ((pkg = pkg.trim()).endsWith("*")) {
            pkg = pkg.substring(0, pkg.length() - 1);
        }
        return (pkg = pkg.replace('.', '/')).endsWith("/") ? pkg : pkg + "/";
    }

    private boolean notAlreadyContained(List<String> distilled, String pack) {
        for (String aDistilled : distilled) {
            if (!pack.startsWith(aDistilled)) continue;
            return false;
        }
        return true;
    }
}

