/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.SQLException;
import org.apache.hive.jdbc.Utils;

public class JdbcColumn {
    private final String columnName;
    private final String tableName;
    private final String tableCatalog;
    private final String type;
    private final String comment;
    private final int ordinalPos;

    JdbcColumn(String columnName, String tableName, String tableCatalog, String type, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableCatalog = tableCatalog;
        this.type = type;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getType() {
        return this.type;
    }

    public Integer getSqlType() throws SQLException {
        return Utils.hiveTypeToSqlType(this.type);
    }

    static int columnDisplaySize(int columnType) throws SQLException {
        switch (columnType) {
            case 16: {
                return JdbcColumn.columnPrecision(columnType);
            }
            case 12: {
                return Integer.MAX_VALUE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return JdbcColumn.columnPrecision(columnType) + 1;
            }
            case 93: {
                return JdbcColumn.columnPrecision(columnType);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnPrecision(int columnType) throws SQLException {
        switch (columnType) {
            case 16: {
                return 1;
            }
            case 12: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 29;
            }
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    static int columnScale(int columnType) throws SQLException {
        switch (columnType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 12: 
            case 16: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 9;
            }
            case 3: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid column type: " + columnType);
    }

    public Integer getColumnSize() throws SQLException {
        int precision = JdbcColumn.columnPrecision(Utils.hiveTypeToSqlType(this.type));
        return precision == 0 ? null : Integer.valueOf(precision);
    }

    public Integer getDecimalDigits() throws SQLException {
        return JdbcColumn.columnScale(Utils.hiveTypeToSqlType(this.type));
    }

    public Integer getNumPrecRadix() {
        if (this.type.equalsIgnoreCase("tinyint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("smallint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("int")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("bigint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("float")) {
            return 2;
        }
        if (this.type.equalsIgnoreCase("double")) {
            return 2;
        }
        if (this.type.equalsIgnoreCase("decimal")) {
            return 10;
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }
}

