/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.zone.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.LocationManager;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.zone.Log;
import com.threerings.whirled.zone.client.ZoneService;
import com.threerings.whirled.zone.data.ZoneMarshaller;
import com.threerings.whirled.zone.data.ZonedBodyObject;
import com.threerings.whirled.zone.server.ZoneManager;
import com.threerings.whirled.zone.server.ZoneMoveHandler;
import com.threerings.whirled.zone.server.ZoneProvider;
import com.threerings.whirled.zone.server.ZoneSender;
import com.threerings.whirled.zone.util.ZoneUtil;

@Singleton
public class ZoneRegistry
implements ZoneProvider {
    protected IntMap<ZoneManager> _managers = IntMaps.newHashIntMap();
    @Inject
    protected SceneRegistry _screg;
    @Inject
    protected LocationManager _locman;
    @Inject
    protected BodyLocator _locator;

    @Inject
    public ZoneRegistry(InvocationManager invmgr) {
        invmgr.registerProvider((InvocationProvider)this, ZoneMarshaller.class, "whirled");
    }

    public void registerZoneManager(byte zoneType, ZoneManager manager) {
        ZoneManager old = (ZoneManager)this._managers.get((int)zoneType);
        if (old != null) {
            Log.log.warning((Object)"Zone manager already registered with requested type", new Object[]{"type", zoneType, "old", old, "new", manager});
        } else {
            this._managers.put((int)zoneType, (Object)manager);
        }
    }

    public ZoneManager getZoneManager(int qualifiedZoneId) {
        return (ZoneManager)this._managers.get(ZoneUtil.zoneType(qualifiedZoneId));
    }

    public String moveBody(ZonedBodyObject source, int zoneId, int sceneId) {
        if (source.getZoneId() == zoneId) {
            this._screg.moveBody((BodyObject)source, sceneId);
        } else {
            String reason = this.leaveOccupiedZone(source);
            if (reason != null) {
                return reason;
            }
            ZoneSender.forcedMove((ClientObject)((BodyObject)source), zoneId, sceneId);
        }
        return null;
    }

    public String leaveOccupiedZone(ZonedBodyObject source) {
        String msg;
        ZoneManager zmgr = this.getZoneManager(source.getZoneId());
        if (zmgr != null && (msg = zmgr.ratifyBodyExit((BodyObject)source)) != null) {
            return msg;
        }
        this._screg.leaveOccupiedScene((BodyObject)source);
        source.setZoneId(-1);
        return null;
    }

    public void moveTo(ClientObject caller, int zoneId, int sceneId, int sceneVer, ZoneService.ZoneMoveListener listener) throws InvocationException {
        String msg;
        if (!(caller instanceof ZonedBodyObject)) {
            Log.log.warning((Object)"Request to switch zones by non-ZonedBodyObject", new Object[]{"clobj", caller.getClass()});
            throw new InvocationException("m.internal_error");
        }
        BodyObject body = this._locator.forClient(caller);
        ZoneManager ozmgr = this.getZoneManager(((ZonedBodyObject)caller).getZoneId());
        if (ozmgr != null && (msg = ozmgr.ratifyBodyExit(body)) != null) {
            throw new InvocationException(msg);
        }
        ZoneManager zmgr = this.getZoneManager(zoneId);
        if (zmgr == null) {
            Log.log.warning((Object)"Requested to enter a zone for which we have no manager", new Object[]{"user", body.who(), "zoneId", zoneId});
            throw new InvocationException("m.no_such_zone");
        }
        zmgr.resolveZone(zoneId, this.createZoneMoveHandler(zmgr, body, sceneId, sceneVer, listener));
    }

    protected ZoneMoveHandler createZoneMoveHandler(ZoneManager zmgr, BodyObject body, int sceneId, int sceneVer, ZoneService.ZoneMoveListener listener) {
        return new ZoneMoveHandler(this._locman, zmgr, this._screg, body, sceneId, sceneVer, listener);
    }
}

